/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexDebugEventVisitor;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.utils.Int2StructuralItemArrayMap;

public class DexDebugPositionState
implements DexDebugEventVisitor {
    private int currentPc = 0;
    private int currentLine;
    private DexString currentFile = null;
    private DexMethod currentMethod;
    private Position currentCallerPosition = null;
    private boolean isOutline;
    private DexMethod outlineCallee;
    private Int2StructuralItemArrayMap<Position> outlineCallerPositions;

    public DexDebugPositionState(int startLine, DexMethod method) {
        this.currentLine = startLine;
        this.currentMethod = method;
    }

    @Override
    public void visit(DexDebugEvent.AdvancePC advancePC) {
        assert (advancePC.delta >= 0);
        this.currentPc += advancePC.delta;
    }

    @Override
    public void visit(DexDebugEvent.AdvanceLine advanceLine) {
        this.currentLine += advanceLine.delta;
    }

    @Override
    public void visit(DexDebugEvent.SetInlineFrame setInlineFrame) {
        this.currentMethod = setInlineFrame.callee;
        this.currentCallerPosition = setInlineFrame.caller;
    }

    @Override
    public void visit(DexDebugEvent.SetOutlineFrame setOutlineFrame) {
        this.isOutline = true;
    }

    @Override
    public void visit(DexDebugEvent.SetOutlineCallerFrame setOutlineCallerFrame) {
        this.outlineCallee = setOutlineCallerFrame.getOutlineCallee();
        this.outlineCallerPositions = setOutlineCallerFrame.getOutlinePositions();
    }

    @Override
    public void visit(DexDebugEvent.Default defaultEvent) {
        assert (defaultEvent.getPCDelta() >= 0);
        this.currentPc += defaultEvent.getPCDelta();
        this.currentLine += defaultEvent.getLineDelta();
    }

    @Override
    public void visit(DexDebugEvent.SetFile setFile) {
        this.currentFile = setFile.fileName;
    }

    @Override
    public void visit(DexDebugEvent.SetPrologueEnd setPrologueEnd) {
    }

    @Override
    public void visit(DexDebugEvent.SetEpilogueBegin setEpilogueBegin) {
    }

    @Override
    public void visit(DexDebugEvent.StartLocal startLocal) {
    }

    @Override
    public void visit(DexDebugEvent.EndLocal endLocal) {
    }

    @Override
    public void visit(DexDebugEvent.RestartLocal restartLocal) {
    }

    public int getCurrentPc() {
        return this.currentPc;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public DexString getCurrentFile() {
        return this.currentFile;
    }

    public DexMethod getCurrentMethod() {
        return this.currentMethod;
    }

    public Position getCurrentCallerPosition() {
        return this.currentCallerPosition;
    }

    public boolean isOutline() {
        return this.isOutline;
    }

    public DexMethod getOutlineCallee() {
        return this.outlineCallee;
    }

    public Int2StructuralItemArrayMap<Position> getOutlineCallerPositions() {
        return this.outlineCallerPositions;
    }

    public void resetOutlineInformation() {
        this.isOutline = false;
        this.outlineCallee = null;
        this.outlineCallerPositions = null;
    }
}

