/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;

public class DexEncodedAnnotation
extends DexItem
implements StructuralItem<DexEncodedAnnotation> {
    private static final int UNSORTED = 0;
    public final DexType type;
    public final DexAnnotationElement[] elements;
    private int sorted = 0;

    private static void specify(StructuralSpecification<DexEncodedAnnotation, ?> spec) {
        ((StructuralSpecification)spec.withItem(a -> a.type)).withItemArray(a -> a.elements);
    }

    public DexEncodedAnnotation(DexType type, DexAnnotationElement[] elements) {
        this.type = type;
        this.elements = elements;
    }

    private int sortedHashCode() {
        int hashCode = this.hashCode();
        return hashCode == 0 ? 1 : hashCode;
    }

    @Override
    public DexEncodedAnnotation self() {
        return this;
    }

    @Override
    public StructuralMapping<DexEncodedAnnotation> getStructuralMapping() {
        return DexEncodedAnnotation::specify;
    }

    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        this.type.collectIndexedItems(indexedItems);
        for (DexAnnotationElement element : this.elements) {
            element.collectIndexedItems(indexedItems);
        }
    }

    public void forEachElement(Consumer<DexAnnotationElement> consumer) {
        for (DexAnnotationElement element : this.elements) {
            consumer.accept(element);
        }
    }

    public DexAnnotationElement getElement(int i) {
        return this.elements[i];
    }

    public int getNumberOfElements() {
        return this.elements.length;
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        assert (false);
    }

    public String toString() {
        return "Encoded annotation " + this.type + " " + Arrays.toString(this.elements);
    }

    @Override
    public int hashCode() {
        return this.type.hashCode() * 7 + Arrays.hashCode(this.elements);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DexEncodedAnnotation) {
            DexEncodedAnnotation that = (DexEncodedAnnotation)other;
            return that.type.equals(this.type) && Arrays.equals(that.elements, this.elements);
        }
        return false;
    }

    public void sort() {
        if (this.sorted != 0) {
            assert (this.sorted == this.sortedHashCode());
            return;
        }
        Arrays.sort(this.elements, (a, b) -> a.name.compareTo(b.name));
        for (DexAnnotationElement element : this.elements) {
            element.value.sort();
        }
        this.sorted = this.sortedHashCode();
    }

    public DexEncodedAnnotation rewrite(Function<DexType, DexType> typeRewriter, Function<DexAnnotationElement, DexAnnotationElement> elementRewriter) {
        DexType rewrittenType = typeRewriter.apply(this.type);
        DexAnnotationElement[] rewrittenElements = ArrayUtils.map(this.elements, elementRewriter, DexAnnotationElement.EMPTY_ARRAY);
        if (rewrittenType == this.type && rewrittenElements == this.elements) {
            return this;
        }
        return new DexEncodedAnnotation(rewrittenType, rewrittenElements);
    }
}

