/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.MixedSectionCollection;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Stream;

public abstract class DexItem {
    public static <T extends DexItem> void collectAll(MixedSectionCollection mixedItems, T[] items) {
        DexItem.consumeArray(items, (T item) -> item.collectMixedSectionItems(mixedItems));
    }

    public static <T extends DexItem> void collectAll(MixedSectionCollection mixedItems, Collection<T> items) {
        items.forEach(item -> item.collectMixedSectionItems(mixedItems));
    }

    private static <T extends DexItem> void consumeArray(T[] items, Consumer<T> consumer) {
        if (items == null) {
            return;
        }
        for (T item : items) {
            if (item == null) continue;
            consumer.accept(item);
        }
    }

    static <T extends DexItem> Stream<T> filter(Stream<DexItem> stream, Class<T> clazz) {
        return stream.filter(clazz::isInstance).map(clazz::cast);
    }

    abstract void collectMixedSectionItems(MixedSectionCollection var1);

    protected void flushCachedValues() {
    }

    public String toSmaliString() {
        return this.toString();
    }

    public String toSourceString() {
        return this.toString();
    }
}

