/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.base.Strings;
import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.ir.analysis.type.ArrayTypeElement;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.InterfaceCollection;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeElement;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.synthesis.SyntheticNaming;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.Int2StructuralItemArrayMap;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.LRUCacheTable;
import com.android.tools.r8.utils.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DexItemFactory {
    public static final String throwableDescriptorString = "Ljava/lang/Throwable;";
    public static final String dalvikAnnotationSignatureString = "Ldalvik/annotation/Signature;";
    public static final String recordTagDescriptorString = "Lcom/android/tools/r8/RecordTag;";
    public static final String recordDescriptorString = "Ljava/lang/Record;";
    public static final String dalvikAnnotationOptimizationPrefixString = "Ldalvik/annotation/optimization/";
    public static final DexType nullValueType = new DexType(new DexString("NULL"));
    public static final DexString unknownTypeName = new DexString("UNKNOWN");
    private static final IdentityHashMap<DexItem, DexItem> internalSentinels = new IdentityHashMap<DexString, DexString>(ImmutableMap.of(nullValueType, nullValueType, unknownTypeName, unknownTypeName));
    private static final String METAFACTORY_METHOD_NAME = "metafactory";
    private static final String METAFACTORY_ALT_METHOD_NAME = "altMetafactory";
    private final Set<DexType> possibleCompilerSynthesizedTypes = Sets.newIdentityHashSet();
    private final Map<DexString, DexString> strings = new ConcurrentHashMap<DexString, DexString>();
    private final Map<DexString, DexType> types = new ConcurrentHashMap<DexString, DexType>();
    private final Map<DexField, DexField> fields = new ConcurrentHashMap<DexField, DexField>();
    private final Map<DexProto, DexProto> protos = new ConcurrentHashMap<DexProto, DexProto>();
    private final Map<DexMethod, DexMethod> methods = new ConcurrentHashMap<DexMethod, DexMethod>();
    private final Map<DexMethodHandle, DexMethodHandle> methodHandles = new ConcurrentHashMap<DexMethodHandle, DexMethodHandle>();
    private final Int2ReferenceMap<DexDebugEvent.AdvanceLine> advanceLines = new Int2ReferenceOpenHashMap<DexDebugEvent.AdvanceLine>();
    private final Int2ReferenceMap<DexDebugEvent.AdvancePC> advancePCs = new Int2ReferenceOpenHashMap<DexDebugEvent.AdvancePC>();
    private final Int2ReferenceMap<DexDebugEvent.Default> defaults = new Int2ReferenceOpenHashMap<DexDebugEvent.Default>();
    private final Int2ReferenceMap<DexDebugEvent.EndLocal> endLocals = new Int2ReferenceOpenHashMap<DexDebugEvent.EndLocal>();
    private final Int2ReferenceMap<DexDebugEvent.RestartLocal> restartLocals = new Int2ReferenceOpenHashMap<DexDebugEvent.RestartLocal>();
    private final DexDebugEvent.SetEpilogueBegin setEpilogueBegin = new DexDebugEvent.SetEpilogueBegin();
    private final DexDebugEvent.SetPrologueEnd setPrologueEnd = new DexDebugEvent.SetPrologueEnd();
    private final Map<DexString, DexDebugEvent.SetFile> setFiles = new HashMap<DexString, DexDebugEvent.SetFile>();
    private final DexDebugEvent.SetOutlineFrame setOutlineFrame = new DexDebugEvent.SetOutlineFrame();
    private final Map<DexDebugEvent.SetInlineFrame, DexDebugEvent.SetInlineFrame> setInlineFrames = new HashMap<DexDebugEvent.SetInlineFrame, DexDebugEvent.SetInlineFrame>();
    public final DexDebugEvent.Default zeroChangeDefaultEvent = this.createDefault(0, 0);
    public final DexDebugEvent.Default oneChangeDefaultEvent = this.createDefault(1, 1);
    private final ConcurrentHashMap<DexType, ReferenceTypeElement> referenceTypes = new ConcurrentHashMap();
    private final ConcurrentHashMap<DexType, InterfaceCollection> classTypeInterfaces = new ConcurrentHashMap();
    public final LRUCacheTable<InterfaceCollection, InterfaceCollection, InterfaceCollection> leastUpperBoundOfInterfacesTable = LRUCacheTable.create(8, 8);
    boolean sorted = false;
    public final DexString booleanDescriptor = this.createString("Z");
    public final DexString byteDescriptor = this.createString("B");
    public final DexString charDescriptor = this.createString("C");
    public final DexString doubleDescriptor = this.createString("D");
    public final DexString floatDescriptor = this.createString("F");
    public final DexString intDescriptor = this.createString("I");
    public final DexString longDescriptor = this.createString("J");
    public final DexString shortDescriptor = this.createString("S");
    public final DexString voidDescriptor = this.createString("V");
    public final DexString descriptorSeparator = this.createString("/");
    private final DexString booleanArrayDescriptor = this.createString("[Z");
    private final DexString byteArrayDescriptor = this.createString("[B");
    private final DexString charArrayDescriptor = this.createString("[C");
    private final DexString doubleArrayDescriptor = this.createString("[D");
    private final DexString floatArrayDescriptor = this.createString("[F");
    private final DexString intArrayDescriptor = this.createString("[I");
    private final DexString longArrayDescriptor = this.createString("[J");
    private final DexString shortArrayDescriptor = this.createString("[S");
    public final DexString boxedBooleanDescriptor = this.createString("Ljava/lang/Boolean;");
    public final DexString boxedByteDescriptor = this.createString("Ljava/lang/Byte;");
    public final DexString boxedCharDescriptor = this.createString("Ljava/lang/Character;");
    public final DexString boxedDoubleDescriptor = this.createString("Ljava/lang/Double;");
    public final DexString boxedFloatDescriptor = this.createString("Ljava/lang/Float;");
    public final DexString boxedIntDescriptor = this.createString("Ljava/lang/Integer;");
    public final DexString boxedLongDescriptor = this.createString("Ljava/lang/Long;");
    public final DexString boxedShortDescriptor = this.createString("Ljava/lang/Short;");
    public final DexString boxedNumberDescriptor = this.createString("Ljava/lang/Number;");
    public final DexString boxedVoidDescriptor = this.createString("Ljava/lang/Void;");
    public final DexString waitMethodName = this.createString("wait");
    public final DexString notifyMethodName = this.createString("notify");
    public final DexString notifyAllMethodName = this.createString("notifyAll");
    public final DexString unboxBooleanMethodName = this.createString("booleanValue");
    public final DexString unboxByteMethodName = this.createString("byteValue");
    public final DexString unboxCharMethodName = this.createString("charValue");
    public final DexString unboxShortMethodName = this.createString("shortValue");
    public final DexString unboxIntMethodName = this.createString("intValue");
    public final DexString unboxLongMethodName = this.createString("longValue");
    public final DexString unboxFloatMethodName = this.createString("floatValue");
    public final DexString unboxDoubleMethodName = this.createString("doubleValue");
    public final DexString isEmptyMethodName = this.createString("isEmpty");
    public final DexString lengthMethodName = this.createString("length");
    public final DexString concatMethodName = this.createString("concat");
    public final DexString containsMethodName = this.createString("contains");
    public final DexString startsWithMethodName = this.createString("startsWith");
    public final DexString endsWithMethodName = this.createString("endsWith");
    public final DexString equalsMethodName = this.createString("equals");
    public final DexString hashCodeMethodName = this.createString("hashCode");
    public final DexString identityHashCodeName = this.createString("identityHashCode");
    public final DexString equalsIgnoreCaseMethodName = this.createString("equalsIgnoreCase");
    public final DexString contentEqualsMethodName = this.createString("contentEquals");
    public final DexString indexOfMethodName = this.createString("indexOf");
    public final DexString lastIndexOfMethodName = this.createString("lastIndexOf");
    public final DexString compareToMethodName = this.createString("compareTo");
    public final DexString compareToIgnoreCaseMethodName = this.createString("compareToIgnoreCase");
    public final DexString cloneMethodName = this.createString("clone");
    public final DexString substringName = this.createString("substring");
    public final DexString trimName = this.createString("trim");
    public final DexString valueOfMethodName = this.createString("valueOf");
    public final DexString valuesMethodName = this.createString("values");
    public final DexString toStringMethodName = this.createString("toString");
    public final DexString internMethodName = this.createString("intern");
    public final DexString convertMethodName = this.createString("convert");
    public final DexString wrapperFieldName = this.createString("wrappedValue");
    public final DexString getClassMethodName = this.createString("getClass");
    public final DexString finalizeMethodName = this.createString("finalize");
    public final DexString ordinalMethodName = this.createString("ordinal");
    public final DexString nameMethodName = this.createString("name");
    public final DexString desiredAssertionStatusMethodName = this.createString("desiredAssertionStatus");
    public final DexString forNameMethodName = this.createString("forName");
    public final DexString getNameName = this.createString("getName");
    public final DexString getCanonicalNameName = this.createString("getCanonicalName");
    public final DexString getSimpleNameName = this.createString("getSimpleName");
    public final DexString getTypeNameName = this.createString("getTypeName");
    public final DexString getDeclaredConstructorName = this.createString("getDeclaredConstructor");
    public final DexString getFieldName = this.createString("getField");
    public final DexString getDeclaredFieldName = this.createString("getDeclaredField");
    public final DexString getMethodName = this.createString("getMethod");
    public final DexString getDeclaredMethodName = this.createString("getDeclaredMethod");
    public final DexString newInstanceName = this.createString("newInstance");
    public final DexString assertionsDisabled = this.createString("$assertionsDisabled");
    public final DexString invokeMethodName = this.createString("invoke");
    public final DexString invokeExactMethodName = this.createString("invokeExact");
    public final DexString runtimeExceptionDescriptor = this.createString("Ljava/lang/RuntimeException;");
    public final DexString assertionErrorDescriptor = this.createString("Ljava/lang/AssertionError;");
    public final DexString charSequenceDescriptor = this.createString("Ljava/lang/CharSequence;");
    public final DexString charSequenceArrayDescriptor = this.createString("[Ljava/lang/CharSequence;");
    public final DexString stringDescriptor = this.createString("Ljava/lang/String;");
    public final DexString stringArrayDescriptor = this.createString("[Ljava/lang/String;");
    public final DexString objectDescriptor = this.createString("Ljava/lang/Object;");
    public final DexString recordDescriptor = this.createString("Ljava/lang/Record;");
    public final DexString recordTagDescriptor = this.createString("Lcom/android/tools/r8/RecordTag;");
    public final DexString objectArrayDescriptor = this.createString("[Ljava/lang/Object;");
    public final DexString classDescriptor = this.createString("Ljava/lang/Class;");
    public final DexString classLoaderDescriptor = this.createString("Ljava/lang/ClassLoader;");
    public final DexString autoCloseableDescriptor = this.createString("Ljava/lang/AutoCloseable;");
    public final DexString classArrayDescriptor = this.createString("[Ljava/lang/Class;");
    public final DexString constructorDescriptor = this.createString("Ljava/lang/reflect/Constructor;");
    public final DexString fieldDescriptor = this.createString("Ljava/lang/reflect/Field;");
    public final DexString methodDescriptor = this.createString("Ljava/lang/reflect/Method;");
    public final DexString enumDescriptor = this.createString("Ljava/lang/Enum;");
    public final DexString javaLangSystemDescriptor = this.createString("Ljava/lang/System;");
    public final DexString annotationDescriptor = this.createString("Ljava/lang/annotation/Annotation;");
    public final DexString objectsDescriptor = this.createString("Ljava/util/Objects;");
    public final DexString collectionsDescriptor = this.createString("Ljava/util/Collections;");
    public final DexString iterableDescriptor = this.createString("Ljava/lang/Iterable;");
    public final DexString mathDescriptor = this.createString("Ljava/lang/Math;");
    public final DexString strictMathDescriptor = this.createString("Ljava/lang/StrictMath;");
    public final DexString closeableDescriptor = this.createString("Ljava/io/Closeable;");
    public final DexString zipFileDescriptor = this.createString("Ljava/util/zip/ZipFile;");
    public final DexString bufferDescriptor = this.createString("Ljava/nio/Buffer;");
    public final DexString byteBufferDescriptor = this.createString("Ljava/nio/ByteBuffer;");
    public final DexString mappedByteBufferDescriptor = this.createString("Ljava/nio/MappedByteBuffer;");
    public final DexString charBufferDescriptor = this.createString("Ljava/nio/CharBuffer;");
    public final DexString shortBufferDescriptor = this.createString("Ljava/nio/ShortBuffer;");
    public final DexString intBufferDescriptor = this.createString("Ljava/nio/IntBuffer;");
    public final DexString longBufferDescriptor = this.createString("Ljava/nio/LongBuffer;");
    public final DexString floatBufferDescriptor = this.createString("Ljava/nio/FloatBuffer;");
    public final DexString doubleBufferDescriptor = this.createString("Ljava/nio/DoubleBuffer;");
    public final DexString stringBuilderDescriptor = this.createString("Ljava/lang/StringBuilder;");
    public final DexString stringBufferDescriptor = this.createString("Ljava/lang/StringBuffer;");
    public final DexString varHandleDescriptor = this.createString("Ljava/lang/invoke/VarHandle;");
    public final DexString methodHandleDescriptor = this.createString("Ljava/lang/invoke/MethodHandle;");
    public final DexString methodTypeDescriptor = this.createString("Ljava/lang/invoke/MethodType;");
    public final DexString invocationHandlerDescriptor = this.createString("Ljava/lang/reflect/InvocationHandler;");
    public final DexString proxyDescriptor = this.createString("Ljava/lang/reflect/Proxy;");
    public final DexString serviceLoaderDescriptor = this.createString("Ljava/util/ServiceLoader;");
    public final DexString serviceLoaderConfigurationErrorDescriptor = this.createString("Ljava/util/ServiceConfigurationError;");
    public final DexString listDescriptor = this.createString("Ljava/util/List;");
    public final DexString setDescriptor = this.createString("Ljava/util/Set;");
    public final DexString mapDescriptor = this.createString("Ljava/util/Map;");
    public final DexString mapEntryDescriptor = this.createString("Ljava/util/Map$Entry;");
    public final DexString collectionDescriptor = this.createString("Ljava/util/Collection;");
    public final DexString comparatorDescriptor = this.createString("Ljava/util/Comparator;");
    public final DexString callableDescriptor = this.createString("Ljava/util/concurrent/Callable;");
    public final DexString supplierDescriptor = this.createString("Ljava/util/function/Supplier;");
    public final DexString predicateDescriptor = this.createString("Ljava/util/function/Predicate;");
    public final DexString consumerDescriptor = this.createString("Ljava/util/function/Consumer;");
    public final DexString runnableDescriptor = this.createString("Ljava/lang/Runnable;");
    public final DexString optionalDescriptor = this.createString("Ljava/util/Optional;");
    public final DexString optionalDoubleDescriptor = this.createString("Ljava/util/OptionalDouble;");
    public final DexString optionalIntDescriptor = this.createString("Ljava/util/OptionalInt;");
    public final DexString optionalLongDescriptor = this.createString("Ljava/util/OptionalLong;");
    public final DexString streamDescriptor = this.createString("Ljava/util/stream/Stream;");
    public final DexString arraysDescriptor = this.createString("Ljava/util/Arrays;");
    public final DexString throwableDescriptor = this.createString("Ljava/lang/Throwable;");
    public final DexString illegalAccessErrorDescriptor = this.createString("Ljava/lang/IllegalAccessError;");
    public final DexString illegalArgumentExceptionDescriptor = this.createString("Ljava/lang/IllegalArgumentException;");
    public final DexString icceDescriptor = this.createString("Ljava/lang/IncompatibleClassChangeError;");
    public final DexString exceptionInInitializerErrorDescriptor = this.createString("Ljava/lang/ExceptionInInitializerError;");
    public final DexString noClassDefFoundErrorDescriptor = this.createString("Ljava/lang/NoClassDefFoundError;");
    public final DexString noSuchFieldErrorDescriptor = this.createString("Ljava/lang/NoSuchFieldError;");
    public final DexString npeDescriptor = this.createString("Ljava/lang/NullPointerException;");
    public final DexString reflectiveOperationExceptionDescriptor = this.createString("Ljava/lang/ReflectiveOperationException;");
    public final DexString kotlinMetadataDescriptor = this.createString("Lkotlin/Metadata;");
    public final DexString intFieldUpdaterDescriptor = this.createString("Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;");
    public final DexString longFieldUpdaterDescriptor = this.createString("Ljava/util/concurrent/atomic/AtomicLongFieldUpdater;");
    public final DexString referenceFieldUpdaterDescriptor = this.createString("Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;");
    public final DexString newUpdaterName = this.createString("newUpdater");
    public final DexString constructorMethodName = this.createString("<init>");
    public final DexString classConstructorMethodName = this.createString("<clinit>");
    public final DexString temporaryConstructorMethodPrefix = this.createString("$r8$constructor");
    public final DexString syntheticConstructorMethodPrefix = this.createString("$r8$init$synthetic");
    public final DexString thisName = this.createString("this");
    public final DexString lambdaInstanceFieldName = this.createString("INSTANCE");
    public final DexString javacLambdaMethodPrefix = this.createString("lambda$");
    public final DexString enumValuesFieldName = this.createString("$VALUES");
    public final DexString enabledFieldName = this.createString("ENABLED");
    public final DexString throwableArrayDescriptor = this.createString("[Ljava/lang/Throwable;");
    public final DexString valueString = this.createString("value");
    public final DexString kindString = this.createString("kind");
    public final DexString dalvikAnnotationOptimizationPrefix = this.createString("Ldalvik/annotation/optimization/");
    public final DexType booleanType = this.createStaticallyKnownType(this.booleanDescriptor);
    public final DexType byteType = this.createStaticallyKnownType(this.byteDescriptor);
    public final DexType charType = this.createStaticallyKnownType(this.charDescriptor);
    public final DexType doubleType = this.createStaticallyKnownType(this.doubleDescriptor);
    public final DexType floatType = this.createStaticallyKnownType(this.floatDescriptor);
    public final DexType intType = this.createStaticallyKnownType(this.intDescriptor);
    public final DexType longType = this.createStaticallyKnownType(this.longDescriptor);
    public final DexType shortType = this.createStaticallyKnownType(this.shortDescriptor);
    public final DexType voidType = this.createStaticallyKnownType(this.voidDescriptor);
    public final DexType booleanArrayType = this.createStaticallyKnownType(this.booleanArrayDescriptor);
    public final DexType byteArrayType = this.createStaticallyKnownType(this.byteArrayDescriptor);
    public final DexType charArrayType = this.createStaticallyKnownType(this.charArrayDescriptor);
    public final DexType doubleArrayType = this.createStaticallyKnownType(this.doubleArrayDescriptor);
    public final DexType floatArrayType = this.createStaticallyKnownType(this.floatArrayDescriptor);
    public final DexType intArrayType = this.createStaticallyKnownType(this.intArrayDescriptor);
    public final DexType longArrayType = this.createStaticallyKnownType(this.longArrayDescriptor);
    public final DexType shortArrayType = this.createStaticallyKnownType(this.shortArrayDescriptor);
    public final DexType boxedBooleanType = this.createStaticallyKnownType(this.boxedBooleanDescriptor);
    public final DexType boxedByteType = this.createStaticallyKnownType(this.boxedByteDescriptor);
    public final DexType boxedCharType = this.createStaticallyKnownType(this.boxedCharDescriptor);
    public final DexType boxedDoubleType = this.createStaticallyKnownType(this.boxedDoubleDescriptor);
    public final DexType boxedFloatType = this.createStaticallyKnownType(this.boxedFloatDescriptor);
    public final DexType boxedIntType = this.createStaticallyKnownType(this.boxedIntDescriptor);
    public final DexType boxedLongType = this.createStaticallyKnownType(this.boxedLongDescriptor);
    public final DexType boxedShortType = this.createStaticallyKnownType(this.boxedShortDescriptor);
    public final DexType boxedNumberType = this.createStaticallyKnownType(this.boxedNumberDescriptor);
    public final DexType boxedVoidType = this.createStaticallyKnownType(this.boxedVoidDescriptor);
    public final DexType charSequenceType = this.createStaticallyKnownType(this.charSequenceDescriptor);
    public final DexType charSequenceArrayType = this.createStaticallyKnownType(this.charSequenceArrayDescriptor);
    public final DexType stringType = this.createStaticallyKnownType(this.stringDescriptor);
    public final DexType stringArrayType = this.createStaticallyKnownType(this.stringArrayDescriptor);
    public final DexType objectType = this.createStaticallyKnownType(this.objectDescriptor);
    public final DexType recordType = this.createStaticallyKnownType(this.recordDescriptor);
    public final DexType recordTagType = this.createStaticallyKnownType(this.recordTagDescriptor);
    public final DexType objectArrayType = this.createStaticallyKnownType(this.objectArrayDescriptor);
    public final DexType classArrayType = this.createStaticallyKnownType(this.classArrayDescriptor);
    public final DexType enumType = this.createStaticallyKnownType(this.enumDescriptor);
    public final DexType annotationType = this.createStaticallyKnownType(this.annotationDescriptor);
    public final DexType objectsType = this.createStaticallyKnownType(this.objectsDescriptor);
    public final DexType collectionsType = this.createStaticallyKnownType(this.collectionsDescriptor);
    public final DexType iterableType = this.createStaticallyKnownType(this.iterableDescriptor);
    public final DexType mathType = this.createStaticallyKnownType(this.mathDescriptor);
    public final DexType strictMathType = this.createStaticallyKnownType(this.strictMathDescriptor);
    public final DexType referenceFieldUpdaterType = this.createStaticallyKnownType(this.referenceFieldUpdaterDescriptor);
    public final DexType classType = this.createStaticallyKnownType(this.classDescriptor);
    public final DexType packageType = this.createStaticallyKnownType(Package.class);
    public final DexType classLoaderType = this.createStaticallyKnownType(this.classLoaderDescriptor);
    public final DexType constructorType = this.createStaticallyKnownType(this.constructorDescriptor);
    public final DexType fieldType = this.createStaticallyKnownType(this.fieldDescriptor);
    public final DexType methodType = this.createStaticallyKnownType(this.methodDescriptor);
    public final DexType autoCloseableType = this.createStaticallyKnownType(this.autoCloseableDescriptor);
    public final DexType closeableType = this.createStaticallyKnownType(this.closeableDescriptor);
    public final DexType zipFileType = this.createStaticallyKnownType(this.zipFileDescriptor);
    public final DexType stringBuilderType = this.createStaticallyKnownType(this.stringBuilderDescriptor);
    public final DexType stringBufferType = this.createStaticallyKnownType(this.stringBufferDescriptor);
    public final DexType javaLangAnnotationRetentionPolicyType = this.createStaticallyKnownType("Ljava/lang/annotation/RetentionPolicy;");
    public final DexType javaLangReflectArrayType = this.createStaticallyKnownType("Ljava/lang/reflect/Array;");
    public final DexType javaLangSystemType = this.createStaticallyKnownType(this.javaLangSystemDescriptor);
    public final DexType javaIoPrintStreamType = this.createStaticallyKnownType("Ljava/io/PrintStream;");
    public final DexType varHandleType = this.createStaticallyKnownType(this.varHandleDescriptor);
    public final DexType methodHandleType = this.createStaticallyKnownType(this.methodHandleDescriptor);
    public final DexType methodTypeType = this.createStaticallyKnownType(this.methodTypeDescriptor);
    public final DexType invocationHandlerType = this.createStaticallyKnownType(this.invocationHandlerDescriptor);
    public final DexType proxyType = this.createStaticallyKnownType(this.proxyDescriptor);
    public final DexType serviceLoaderType = this.createStaticallyKnownType(this.serviceLoaderDescriptor);
    public final DexType serviceLoaderConfigurationErrorType = this.createStaticallyKnownType(this.serviceLoaderConfigurationErrorDescriptor);
    public final DexType listType = this.createStaticallyKnownType(this.listDescriptor);
    public final DexType setType = this.createStaticallyKnownType(this.setDescriptor);
    public final DexType mapType = this.createStaticallyKnownType(this.mapDescriptor);
    public final DexType mapEntryType = this.createStaticallyKnownType(this.mapEntryDescriptor);
    public final DexType abstractMapSimpleEntryType = this.createStaticallyKnownType("Ljava/util/AbstractMap$SimpleEntry;");
    public final DexType collectionType = this.createStaticallyKnownType(this.collectionDescriptor);
    public final DexType comparatorType = this.createStaticallyKnownType(this.comparatorDescriptor);
    public final DexType callableType = this.createStaticallyKnownType(this.callableDescriptor);
    public final DexType supplierType = this.createStaticallyKnownType(this.supplierDescriptor);
    public final DexType predicateType = this.createStaticallyKnownType(this.predicateDescriptor);
    public final DexType consumerType = this.createStaticallyKnownType(this.consumerDescriptor);
    public final DexType runnableType = this.createStaticallyKnownType(this.runnableDescriptor);
    public final DexType optionalType = this.createStaticallyKnownType(this.optionalDescriptor);
    public final DexType optionalDoubleType = this.createStaticallyKnownType(this.optionalDoubleDescriptor);
    public final DexType optionalIntType = this.createStaticallyKnownType(this.optionalIntDescriptor);
    public final DexType optionalLongType = this.createStaticallyKnownType(this.optionalLongDescriptor);
    public final DexType streamType = this.createStaticallyKnownType(this.streamDescriptor);
    public final DexType bufferType = this.createStaticallyKnownType(this.bufferDescriptor);
    public final DexType byteBufferType = this.createStaticallyKnownType(this.byteBufferDescriptor);
    public final DexType mappedByteBufferType = this.createStaticallyKnownType(this.mappedByteBufferDescriptor);
    public final DexType charBufferType = this.createStaticallyKnownType(this.charBufferDescriptor);
    public final DexType shortBufferType = this.createStaticallyKnownType(this.shortBufferDescriptor);
    public final DexType intBufferType = this.createStaticallyKnownType(this.intBufferDescriptor);
    public final DexType longBufferType = this.createStaticallyKnownType(this.longBufferDescriptor);
    public final DexType floatBufferType = this.createStaticallyKnownType(this.floatBufferDescriptor);
    public final DexType doubleBufferType = this.createStaticallyKnownType(this.doubleBufferDescriptor);
    public final List<DexType> typeSpecificBuffers = ImmutableList.of(this.byteBufferType, this.mappedByteBufferType, this.charBufferType, this.shortBufferType, this.intBufferType, this.longBufferType, this.floatBufferType, this.doubleBufferType);
    public final DexType doubleConsumer = this.createStaticallyKnownType("Ljava/util/function/DoubleConsumer;");
    public final DexType longConsumer = this.createStaticallyKnownType("Ljava/util/function/LongConsumer;");
    public final DexType intConsumer = this.createStaticallyKnownType("Ljava/util/function/IntConsumer;");
    public final DexType retentionType = this.createStaticallyKnownType("Ljava/lang/annotation/Retention;");
    public final DexType runtimeExceptionType = this.createStaticallyKnownType(this.runtimeExceptionDescriptor);
    public final DexType assertionErrorType = this.createStaticallyKnownType(this.assertionErrorDescriptor);
    public final DexType throwableType = this.createStaticallyKnownType(this.throwableDescriptor);
    public final DexType illegalAccessErrorType = this.createStaticallyKnownType(this.illegalAccessErrorDescriptor);
    public final DexType illegalArgumentExceptionType = this.createStaticallyKnownType(this.illegalArgumentExceptionDescriptor);
    public final DexType icceType = this.createStaticallyKnownType(this.icceDescriptor);
    public final DexType exceptionInInitializerErrorType = this.createStaticallyKnownType(this.exceptionInInitializerErrorDescriptor);
    public final DexType noClassDefFoundErrorType = this.createStaticallyKnownType(this.noClassDefFoundErrorDescriptor);
    public final DexType noSuchFieldErrorType = this.createStaticallyKnownType(this.noSuchFieldErrorDescriptor);
    public final DexType noSuchMethodErrorType = this.createStaticallyKnownType("Ljava/lang/NoSuchMethodError;");
    public final DexType npeType = this.createStaticallyKnownType(this.npeDescriptor);
    public final DexType reflectiveOperationExceptionType = this.createStaticallyKnownType(this.reflectiveOperationExceptionDescriptor);
    public final DexType kotlinMetadataType = this.createStaticallyKnownType(this.kotlinMetadataDescriptor);
    public final DexType javaIoFileType = this.createStaticallyKnownType("Ljava/io/File;");
    public final DexType javaMathBigIntegerType = this.createStaticallyKnownType("Ljava/math/BigInteger;");
    public final DexType javaNioByteOrderType = this.createStaticallyKnownType("Ljava/nio/ByteOrder;");
    public final DexType javaUtilCollectionsType = this.createStaticallyKnownType("Ljava/util/Collections;");
    public final DexType javaUtilComparatorType = this.createStaticallyKnownType("Ljava/util/Comparator;");
    public final DexType javaUtilConcurrentTimeUnitType = this.createStaticallyKnownType("Ljava/util/concurrent/TimeUnit;");
    public final DexType javaUtilListType = this.createStaticallyKnownType("Ljava/util/List;");
    public final DexType javaUtilLocaleType = this.createStaticallyKnownType("Ljava/util/Locale;");
    public final DexType javaUtilLoggingLevelType = this.createStaticallyKnownType("Ljava/util/logging/Level;");
    public final DexType javaUtilLoggingLoggerType = this.createStaticallyKnownType("Ljava/util/logging/Logger;");
    public final DexType javaUtilSetType = this.createStaticallyKnownType("Ljava/util/Set;");
    public final DexType androidAppActivity = this.createStaticallyKnownType("Landroid/app/Activity;");
    public final DexType androidOsBuildType = this.createStaticallyKnownType("Landroid/os/Build;");
    public final DexType androidOsBuildVersionType = this.createStaticallyKnownType("Landroid/os/Build$VERSION;");
    public final DexType androidOsBundleType = this.createStaticallyKnownType("Landroid/os/Bundle;");
    public final DexType androidOsParcelableCreatorType = this.createStaticallyKnownType("Landroid/os/Parcelable$Creator;");
    public final DexType androidSystemOsConstantsType = this.createStaticallyKnownType("Landroid/system/OsConstants;");
    public final DexType androidUtilLogType = this.createStaticallyKnownType("Landroid/util/Log;");
    public final DexType androidUtilPropertyType = this.createStaticallyKnownType("Landroid/util/Property;");
    public final DexType androidViewViewType = this.createStaticallyKnownType("Landroid/view/View;");
    public final DexType androidUtilSparseArrayType = this.createStaticallyKnownType("Landroid/util/SparseArray;");
    public final StringBuildingMethods stringBuilderMethods = new StringBuildingMethods(this.stringBuilderType);
    public final StringBuildingMethods stringBufferMethods = new StringBuildingMethods(this.stringBufferType);
    public final BooleanMembers booleanMembers = new BooleanMembers();
    public final ByteMembers byteMembers = new ByteMembers();
    public final CharMembers charMembers = new CharMembers();
    public final FloatMembers floatMembers = new FloatMembers();
    public final IntegerMembers integerMembers = new IntegerMembers();
    public final LongMembers longMembers = new LongMembers();
    public final ObjectsMethods objectsMethods = new ObjectsMethods();
    public final ObjectMembers objectMembers = new ObjectMembers();
    public final BufferMembers bufferMembers = new BufferMembers();
    public final RecordMembers recordMembers = new RecordMembers();
    public final ShortMembers shortMembers = new ShortMembers();
    public final StringMembers stringMembers = new StringMembers();
    public final SupplierMembers supplierMembers = new SupplierMembers();
    public final DoubleMembers doubleMembers = new DoubleMembers();
    public final ThrowableMethods throwableMethods = new ThrowableMethods();
    public final AssertionErrorMethods assertionErrorMethods = new AssertionErrorMethods();
    public final ClassMethods classMethods = new ClassMethods();
    public final ConstructorMethods constructorMethods = new ConstructorMethods();
    public final EnumMembers enumMembers = new EnumMembers();
    public final JavaLangReflectArrayMembers javaLangReflectArrayMembers = new JavaLangReflectArrayMembers();
    public final JavaLangAnnotationRetentionPolicyMembers javaLangAnnotationRetentionPolicyMembers = new JavaLangAnnotationRetentionPolicyMembers();
    public final JavaLangSystemMethods javaLangSystemMethods = new JavaLangSystemMethods();
    public final NullPointerExceptionMethods npeMethods = new NullPointerExceptionMethods();
    public final IllegalArgumentExceptionMethods illegalArgumentExceptionMethods = new IllegalArgumentExceptionMethods();
    public final PrimitiveTypesBoxedTypeFields primitiveTypesBoxedTypeFields = new PrimitiveTypesBoxedTypeFields();
    public final AtomicFieldUpdaterMethods atomicFieldUpdaterMethods = new AtomicFieldUpdaterMethods();
    public final Kotlin kotlin;
    public final PolymorphicMethods polymorphicMethods = new PolymorphicMethods();
    public final ProxyMethods proxyMethods = new ProxyMethods();
    public final AndroidOsBuildMembers androidOsBuildMembers = new AndroidOsBuildMembers();
    public final AndroidOsBuildVersionMembers androidOsBuildVersionMembers = new AndroidOsBuildVersionMembers();
    public final AndroidOsBundleMembers androidOsBundleMembers = new AndroidOsBundleMembers();
    public final AndroidSystemOsConstantsMembers androidSystemOsConstantsMembers = new AndroidSystemOsConstantsMembers();
    public final AndroidViewViewMembers androidViewViewMembers = new AndroidViewViewMembers();
    public final AndroidUtilSparseArrayMembers androidUtilSparseArrayMembers = new AndroidUtilSparseArrayMembers();
    public final JavaIoFileMembers javaIoFileMembers = new JavaIoFileMembers();
    public final JavaMathBigIntegerMembers javaMathBigIntegerMembers = new JavaMathBigIntegerMembers();
    public final JavaNioByteOrderMembers javaNioByteOrderMembers = new JavaNioByteOrderMembers();
    public final JavaUtilArraysMethods javaUtilArraysMethods = new JavaUtilArraysMethods();
    public final JavaUtilComparatorMembers javaUtilComparatorMembers = new JavaUtilComparatorMembers();
    public final JavaUtilConcurrentTimeUnitMembers javaUtilConcurrentTimeUnitMembers = new JavaUtilConcurrentTimeUnitMembers();
    public final JavaUtilLocaleMembers javaUtilLocaleMembers = new JavaUtilLocaleMembers();
    public final JavaUtilLoggingLevelMembers javaUtilLoggingLevelMembers = new JavaUtilLoggingLevelMembers();
    public final List<LibraryMembers> libraryMembersCollection = ImmutableList.of(this.booleanMembers, this.floatMembers, this.integerMembers, this.longMembers, this.stringMembers, this.androidOsBuildMembers, this.androidOsBuildVersionMembers, this.androidOsBundleMembers, this.androidSystemOsConstantsMembers, this.androidViewViewMembers, this.javaIoFileMembers, this.javaMathBigIntegerMembers, new LibraryMembers[]{this.javaNioByteOrderMembers, this.javaUtilComparatorMembers, this.javaUtilConcurrentTimeUnitMembers, this.javaUtilLocaleMembers, this.javaUtilLoggingLevelMembers});
    public final DexString twrCloseResourceMethodName = this.createString("$closeResource");
    public final DexProto twrCloseResourceMethodProto = this.createProto(this.voidType, this.throwableType, this.autoCloseableType);
    public final DexString deserializeLambdaMethodName = this.createString("$deserializeLambda$");
    public final DexType serializedLambdaType = this.createStaticallyKnownType("Ljava/lang/invoke/SerializedLambda;");
    public final DexProto deserializeLambdaMethodProto = this.createProto(this.objectType, this.serializedLambdaType);
    public final String defaultSourceFileAttributeString;
    public final DexString defaultSourceFileAttribute = this.createString("SourceFile");
    public final DexType annotationDefault = this.createStaticallyKnownType("Ldalvik/annotation/AnnotationDefault;");
    public final DexType annotationEnclosingClass = this.createStaticallyKnownType("Ldalvik/annotation/EnclosingClass;");
    public final DexType annotationEnclosingMethod = this.createStaticallyKnownType("Ldalvik/annotation/EnclosingMethod;");
    public final DexType annotationInnerClass = this.createStaticallyKnownType("Ldalvik/annotation/InnerClass;");
    public final DexType annotationMemberClasses = this.createStaticallyKnownType("Ldalvik/annotation/MemberClasses;");
    public final DexType annotationMethodParameters = this.createStaticallyKnownType("Ldalvik/annotation/MethodParameters;");
    public final DexType annotationSignature = this.createStaticallyKnownType("Ldalvik/annotation/Signature;");
    public final DexType annotationSourceDebugExtension = this.createStaticallyKnownType("Ldalvik/annotation/SourceDebugExtension;");
    public final DexType annotationThrows = this.createStaticallyKnownType("Ldalvik/annotation/Throws;");
    public final DexType annotationSynthesizedClass = this.createStaticallyKnownType("Lcom/android/tools/r8/annotations/SynthesizedClass;");
    public final DexType annotationCovariantReturnType = this.createStaticallyKnownType("Ldalvik/annotation/codegen/CovariantReturnType;");
    public final DexType annotationCovariantReturnTypes = this.createStaticallyKnownType("Ldalvik/annotation/codegen/CovariantReturnType$CovariantReturnTypes;");
    public final DexType annotationReachabilitySensitive = this.createStaticallyKnownType("Ldalvik/annotation/optimization/ReachabilitySensitive;");
    public final DexType metafactoryType = this.createStaticallyKnownType("Ljava/lang/invoke/LambdaMetafactory;");
    public final DexType callSiteType = this.createStaticallyKnownType("Ljava/lang/invoke/CallSite;");
    public final DexType lookupType = this.createStaticallyKnownType("Ljava/lang/invoke/MethodHandles$Lookup;");
    public final DexType objectMethodsType = this.createStaticallyKnownType("Ljava/lang/runtime/ObjectMethods;");
    public final DexType typeDescriptorType = this.createStaticallyKnownType("Ljava/lang/invoke/TypeDescriptor;");
    public final DexType iteratorType = this.createStaticallyKnownType("Ljava/util/Iterator;");
    public final DexType listIteratorType = this.createStaticallyKnownType("Ljava/util/ListIterator;");
    public final DexType enumerationType = this.createStaticallyKnownType("Ljava/util/Enumeration;");
    public final DexType serializableType = this.createStaticallyKnownType("Ljava/io/Serializable;");
    public final DexType externalizableType = this.createStaticallyKnownType("Ljava/io/Externalizable;");
    public final DexType cloneableType = this.createStaticallyKnownType("Ljava/lang/Cloneable;");
    public final DexType comparableType = this.createStaticallyKnownType("Ljava/lang/Comparable;");
    public final DexType stringConcatFactoryType = this.createStaticallyKnownType("Ljava/lang/invoke/StringConcatFactory;");
    public final DexType unsafeType = this.createStaticallyKnownType("Lsun/misc/Unsafe;");
    public final ObjectMethodsMembers objectMethodsMembers = new ObjectMethodsMembers();
    public final ServiceLoaderMethods serviceLoaderMethods = new ServiceLoaderMethods();
    public final StringConcatFactoryMembers stringConcatFactoryMembers = new StringConcatFactoryMembers();
    private final SyntheticNaming syntheticNaming = new SyntheticNaming();
    public final BiMap<DexType, DexType> primitiveToBoxed = HashBiMap.create(ImmutableMap.builder().put(this.booleanType, this.boxedBooleanType).put(this.byteType, this.boxedByteType).put(this.charType, this.boxedCharType).put(this.shortType, this.boxedShortType).put(this.intType, this.boxedIntType).put(this.longType, this.boxedLongType).put(this.floatType, this.boxedFloatType).put(this.doubleType, this.boxedDoubleType).build());
    public final Map<DexType, DexMethod> unboxPrimitiveMethod = ImmutableMap.builder().put(this.boxedBooleanType, this.createUnboxMethod(this.booleanType, this.unboxBooleanMethodName)).put(this.boxedByteType, this.createUnboxMethod(this.byteType, this.unboxByteMethodName)).put(this.boxedCharType, this.createUnboxMethod(this.charType, this.unboxCharMethodName)).put(this.boxedShortType, this.createUnboxMethod(this.shortType, this.unboxShortMethodName)).put(this.boxedIntType, this.createUnboxMethod(this.intType, this.unboxIntMethodName)).put(this.boxedLongType, this.createUnboxMethod(this.longType, this.unboxLongMethodName)).put(this.boxedFloatType, this.createUnboxMethod(this.floatType, this.unboxFloatMethodName)).put(this.boxedDoubleType, this.createUnboxMethod(this.doubleType, this.unboxDoubleMethodName)).build();
    public final DexMethod metafactoryMethod = this.createMethod(this.metafactoryType, this.createProto(this.callSiteType, this.lookupType, this.stringType, this.methodTypeType, this.methodTypeType, this.methodHandleType, this.methodTypeType), this.createString("metafactory"));
    public final DexMethod metafactoryAltMethod = this.createMethod(this.metafactoryType, this.createProto(this.callSiteType, this.lookupType, this.stringType, this.methodTypeType, this.objectArrayType), this.createString("altMetafactory"));
    public final DexMethod deserializeLambdaMethod = this.createMethod(this.objectType, this.deserializeLambdaMethodProto, this.deserializeLambdaMethodName);
    public Map<DexMethod, int[]> libraryMethodsNonNullParamOrThrow = this.buildLibraryMethodsNonNullParamOrThrow();
    public Set<DexMethod> libraryMethodsReturningReceiver = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)StringBuildingMethods.access$2500(this.stringBufferMethods))).addAll((Iterable)StringBuildingMethods.access$2500(this.stringBuilderMethods))).build();
    public final Set<DexMethod> libraryMethodsReturningNonNull;
    public Set<DexMethod> libraryMethodsWithReturnValueDependingOnlyOnArguments;
    public Set<DexType> libraryTypesAssumedToBePresent;
    public Set<DexType> libraryClassesWithoutStaticInitialization;
    private boolean skipNameValidationForTesting;

    public DexItemFactory() {
        this.defaultSourceFileAttributeString = "SourceFile";
        this.libraryMethodsReturningNonNull = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(new DexMethod[]{this.classMethods.getName, this.classMethods.getSimpleName, this.classMethods.forName, this.objectMembers.getClass, this.objectsMethods.requireNonNull, this.objectsMethods.requireNonNullWithMessage, this.objectsMethods.requireNonNullWithMessageSupplier, this.stringMembers.valueOf})).addAll((Iterable)this.stringBufferMethods.appendMethods)).addAll((Iterable)this.stringBuilderMethods.appendMethods)).build();
        this.libraryMethodsWithReturnValueDependingOnlyOnArguments = ((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.boxedValueOfMethods())).build();
        this.libraryTypesAssumedToBePresent = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(new DexType[]{this.androidAppActivity, this.callableType, this.enumType, this.npeType, this.objectType, this.stringBufferType, this.stringBuilderType, this.stringType})).addAll((Iterable)this.primitiveToBoxed.values())).build();
        this.libraryClassesWithoutStaticInitialization = ImmutableSet.of(this.boxedBooleanType, this.boxedByteType, this.boxedCharType, this.boxedDoubleType, this.boxedFloatType, this.boxedIntType, new DexType[]{this.boxedLongType, this.boxedNumberType, this.boxedShortType, this.boxedVoidType, this.enumType, this.javaLangSystemType, this.npeType, this.objectType, this.stringBufferType, this.stringBuilderType, this.stringType});
        this.skipNameValidationForTesting = false;
        this.kotlin = new Kotlin(this);
    }

    public static boolean isInternalSentinel(DexItem item) {
        return internalSentinels.containsKey(item);
    }

    private DexMethod createUnboxMethod(DexType primitiveType, DexString unboxMethodName) {
        DexProto proto = this.createProto(primitiveType, new DexType[0]);
        return this.createMethod((DexType)this.primitiveToBoxed.get(primitiveType), proto, unboxMethodName);
    }

    private Map<DexMethod, int[]> buildLibraryMethodsNonNullParamOrThrow() {
        ImmutableMap.Builder<DexMethod, int[]> builder = ImmutableMap.builder();
        for (DexMethod requireNonNullMethod : this.objectsMethods.requireNonNullMethods()) {
            builder.put(requireNonNullMethod, new int[]{0});
        }
        return builder.build();
    }

    private static <T extends DexItem> T canonicalize(Map<T, T> map, T item) {
        assert (item != null);
        assert (!DexItemFactory.isInternalSentinel(item));
        DexItem previous = (DexItem)map.putIfAbsent(item, item);
        return (T)(previous == null ? item : previous);
    }

    public static String escapeMemberString(String str) {
        return str.replace('.', '$');
    }

    private DexMethod internalCreateFreshMethodNameWithHolder(String baseName, DexType holder, DexProto proto, DexType target, Predicate<DexMethod> isFresh) {
        return this.internalCreateFreshMethodNameWithHolder(baseName, holder, proto, target, isFresh, 0);
    }

    private DexMethod internalCreateFreshMethodNameWithHolder(String baseName, DexType holder, DexProto proto, DexType target, Predicate<DexMethod> isFresh, int index) {
        return (DexMethod)this.createFreshMember(name -> {
            DexMethod tryMethod = this.createMethod(target, proto, (DexString)name);
            if (isFresh.test(tryMethod)) {
                return Optional.of(tryMethod);
            }
            return Optional.empty();
        }, baseName, holder, index);
    }

    private DexField internalCreateFreshFieldName(DexType originalHolder, DexType newHolder, DexType type, String baseName, Predicate<DexField> isFresh) {
        return (DexField)this.createFreshMember(name -> {
            DexField candidate = this.createField(newHolder, type, (DexString)name);
            return isFresh.test(candidate) ? Optional.of(candidate) : Optional.empty();
        }, baseName, originalHolder);
    }

    private DexMethod createInstanceInitializerWithFreshProto(DexProto proto, List<DexType> extraTypes, Function<DexProto, Optional<DexMethod>> isFresh) {
        LinkedList tryProtos = new LinkedList();
        Iterator<DexProto> current = IterableUtils.singleton(proto).iterator();
        int count = 0;
        while (true) {
            DexProto tryProto;
            Optional<DexMethod> object;
            assert (count++ < 100);
            if (!current.hasNext()) {
                assert (!tryProtos.isEmpty());
                current = ((Iterable)tryProtos.remove()).iterator();
                assert (current.hasNext());
            }
            if ((object = isFresh.apply(tryProto = current.next())).isPresent()) {
                return object.get();
            }
            assert (!extraTypes.isEmpty());
            tryProtos.add(Iterables.transform(extraTypes, extraType -> this.appendTypeToProto(tryProto, (DexType)extraType)));
        }
    }

    private DexType internalCreateType(DexString descriptor) {
        assert (!this.sorted);
        assert (descriptor != null);
        DexType result = this.types.get(descriptor);
        if (result == null) {
            result = new DexType(descriptor);
            assert (result.isArrayType() || result.isClassType() || result.isPrimitiveType() || result.isVoidType());
            assert (!DexItemFactory.isInternalSentinel(result));
            this.types.put(descriptor, result);
        }
        return result;
    }

    private DexType createStaticallyKnownType(String descriptor) {
        return this.createStaticallyKnownType(this.createString(descriptor));
    }

    private DexType createStaticallyKnownType(Class<?> clazz) {
        return this.createStaticallyKnownType(this.createString(DescriptorUtils.javaTypeToDescriptor(clazz.getName())));
    }

    private DexType createStaticallyKnownType(DexString descriptor) {
        DexType type = this.internalCreateType(descriptor);
        this.addPossiblySynthesizedType(type);
        return type;
    }

    private void addPossiblySynthesizedType(DexType type) {
        if (type.isArrayType()) {
            type = type.toBaseType(this);
        }
        if (type.isClassType()) {
            this.possibleCompilerSynthesizedTypes.add(type);
        }
    }

    private static DexType[] applyClassMappingToDexTypes(DexType[] types, Function<DexType, DexType> mapping) {
        Int2ReferenceArrayMap<DexType> changed = new Int2ReferenceArrayMap<DexType>();
        for (int i = 0; i < types.length; ++i) {
            DexType applied = mapping.apply(types[i]);
            if (applied == types[i]) continue;
            changed.put(Integer.valueOf(i), applied);
        }
        return changed.isEmpty() ? types : ArrayUtils.copyWithSparseChanges(DexType[].class, types, changed);
    }

    private DexString createShorty(DexType returnType, DexType[] argumentTypes) {
        StringBuilder shortyBuilder = new StringBuilder();
        shortyBuilder.append(returnType.toShorty());
        for (DexType argumentType : argumentTypes) {
            shortyBuilder.append(argumentType.toShorty());
        }
        return this.createString(shortyBuilder.toString());
    }

    public SyntheticNaming getSyntheticNaming() {
        return this.syntheticNaming;
    }

    public DexMethod getUnboxPrimitiveMethod(DexType type) {
        DexType boxType = this.primitiveToBoxed.getOrDefault(type, type);
        DexMethod unboxMethod = this.unboxPrimitiveMethod.get(boxType);
        if (unboxMethod == null) {
            throw new Unreachable("Invalid primitive type descriptor: " + type);
        }
        return unboxMethod;
    }

    public DexMethod getBoxPrimitiveMethod(DexType type) {
        DexType boxType = this.primitiveToBoxed.getOrDefault(type, type);
        DexType primitive = this.getPrimitiveFromBoxed(boxType);
        if (primitive == null) {
            throw new Unreachable("Invalid primitive type descriptor: " + type);
        }
        DexProto proto = this.createProto(boxType, primitive);
        return this.createMethod(boxType, proto, this.valueOfMethodName);
    }

    public DexType getBoxedForPrimitiveType(DexType primitive) {
        assert (primitive.isPrimitiveType());
        return (DexType)this.primitiveToBoxed.get(primitive);
    }

    public DexType getPrimitiveFromBoxed(DexType boxedPrimitive) {
        return (DexType)this.primitiveToBoxed.inverse().get(boxedPrimitive);
    }

    public Set<DexMethod> boxedValueOfMethods() {
        return this.primitiveToBoxed.entrySet().stream().map(entry -> {
            DexType primitive = (DexType)entry.getKey();
            DexType boxed = (DexType)entry.getValue();
            return this.createMethod(boxed.descriptor, this.valueOfMethodName, boxed.descriptor, new DexString[]{primitive.descriptor});
        }).collect(Collectors.toSet());
    }

    public void setSkipNameValidationForTesting(boolean skipNameValidationForTesting) {
        this.skipNameValidationForTesting = skipNameValidationForTesting;
    }

    public boolean getSkipNameValidationForTesting() {
        return this.skipNameValidationForTesting;
    }

    public boolean isLambdaMetafactoryMethod(DexMethod dexMethod) {
        return dexMethod == this.metafactoryMethod || dexMethod == this.metafactoryAltMethod;
    }

    public DexString createString(int size, byte[] content) {
        assert (!this.sorted);
        return DexItemFactory.canonicalize(this.strings, new DexString(size, content));
    }

    public DexString createString(String source) {
        assert (!this.sorted);
        return DexItemFactory.canonicalize(this.strings, new DexString(source));
    }

    public String createMemberString(String baseName, DexType holder, int index) {
        StringBuilder sb = new StringBuilder().append(baseName);
        if (holder != null) {
            sb.append('$').append(DexItemFactory.escapeMemberString(holder.toSourceString()));
        }
        if (index > 0) {
            sb.append("$").append(index);
        }
        return sb.toString();
    }

    public <T> T createFreshMember(Function<DexString, Optional<T>> tryString, String baseName, DexType holder) {
        return this.createFreshMember(tryString, baseName, holder, 0);
    }

    public <T> T createFreshMember(Function<DexString, Optional<T>> tryString, String baseName, DexType holder, int index) {
        int offset = 0;
        while (true) {
            assert (offset < 1000);
            DexString name = this.createString(this.createMemberString(baseName, holder, index + offset));
            Optional<T> result = tryString.apply(name);
            if (result.isPresent()) {
                return result.get();
            }
            ++offset;
        }
    }

    public <T extends DexMember<?, ?>> T createFreshMember(Function<DexString, Optional<T>> tryString, String baseName) {
        return (T)((DexMember)this.createFreshMember(tryString, baseName, null));
    }

    public DexString createGloballyFreshMemberString(String baseName, DexType holder) {
        String name;
        DexString dexName;
        assert (!this.sorted);
        int index = 0;
        while ((dexName = this.lookupString(name = this.createMemberString(baseName, holder, index++))) != null) {
        }
        return this.createString(name);
    }

    public DexString createGloballyFreshMemberString(String baseName) {
        return this.createGloballyFreshMemberString(baseName, null);
    }

    public DexType createFreshTypeName(DexType type, Predicate<DexType> isFresh) {
        return this.createFreshTypeName(type, isFresh, 0);
    }

    public DexType createFreshTypeName(DexType type, Predicate<DexType> isFresh, int index) {
        DexType newType;
        while (!isFresh.test(newType = type.addSuffixId(index++, this))) {
        }
        return newType;
    }

    public DexMethod createFreshMethodNameWithHolder(String baseName, DexType holder, DexProto proto, DexType target, Predicate<DexMethod> isFresh) {
        assert (holder != null);
        return this.internalCreateFreshMethodNameWithHolder(baseName, holder, proto, target, isFresh);
    }

    public DexMethod createFreshMethodNameWithoutHolder(String baseName, DexProto proto, DexType target, Predicate<DexMethod> isFresh) {
        return this.createFreshMethodNameWithoutHolder(baseName, proto, target, isFresh, 0);
    }

    public DexMethod createFreshMethodNameWithoutHolder(String baseName, DexProto proto, DexType target, Predicate<DexMethod> isFresh, int index) {
        return this.internalCreateFreshMethodNameWithHolder(baseName, null, proto, target, isFresh, index);
    }

    public DexMethodSignature createFreshMethodSignatureName(String baseName, DexType holder, DexProto proto, Predicate<DexMethodSignature> isFresh) {
        return (DexMethodSignature)this.createFreshMember(name -> {
            DexMethodSignature trySignature = DexMethodSignature.create(name, proto);
            if (isFresh.test(trySignature)) {
                return Optional.of(trySignature);
            }
            return Optional.empty();
        }, baseName, holder);
    }

    public DexField createFreshFieldNameWithoutHolder(DexType holder, DexType type, String baseName, Predicate<DexField> isFresh) {
        return this.internalCreateFreshFieldName(null, holder, type, baseName, isFresh);
    }

    public DexMethod createClassInitializer(DexType holder) {
        return this.createMethod(holder, this.createProto(this.voidType, new DexType[0]), this.classConstructorMethodName);
    }

    public DexMethod createInstanceInitializer(DexType holder, DexType ... parameters) {
        return this.createMethod(holder, this.createProto(this.voidType, parameters), this.constructorMethodName);
    }

    public DexMethod createInstanceInitializer(DexType holder, DexTypeList parameters) {
        return this.createInstanceInitializer(holder, parameters.values);
    }

    public DexMethod createInstanceInitializerWithFreshProto(DexMethod method, List<DexType> extraTypes, Predicate<DexMethod> isFresh) {
        assert (method.isInstanceInitializer(this));
        return this.createInstanceInitializerWithFreshProto(method.proto, extraTypes, (DexProto proto) -> Optional.of(method.withProto((DexProto)proto, this)).filter(isFresh));
    }

    public DexMethod createInstanceInitializerWithFreshProto(DexMethod method, DexType extraType, Predicate<DexMethod> isFresh) {
        assert (method.isInstanceInitializer(this));
        return this.createInstanceInitializerWithFreshProto(method.proto, ImmutableList.of(extraType), (DexProto proto) -> Optional.of(method.withProto((DexProto)proto, this)).filter(isFresh));
    }

    public DexString lookupString(int size, byte[] content) {
        return this.strings.get(new DexString(size, content));
    }

    public DexString lookupString(String source) {
        return this.strings.get(new DexString(source));
    }

    public synchronized List<Marker> extractMarkers() {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (DexString dexString : this.strings.keySet()) {
            Marker marker = Marker.parse(dexString);
            if (marker == null) continue;
            markers.add(marker);
        }
        return markers;
    }

    public synchronized DexType createSynthesizedType(String descriptor) {
        DexType type = this.internalCreateType(this.createString(descriptor));
        this.addPossiblySynthesizedType(type);
        return type;
    }

    public void registerTypeNeededForDesugaring(DexType type) {
        this.addPossiblySynthesizedType(type);
    }

    public boolean isPossiblyCompilerSynthesizedType(DexType type) {
        return this.possibleCompilerSynthesizedTypes.contains(type);
    }

    public void forEachPossiblyCompilerSynthesizedType(Consumer<DexType> fn) {
        this.possibleCompilerSynthesizedTypes.forEach(fn);
    }

    public synchronized DexType createType(DexString descriptor) {
        return this.internalCreateType(descriptor);
    }

    public DexType createType(String descriptor) {
        return this.createType(this.createString(descriptor));
    }

    public DexType createType(ClassReference clazz) {
        return this.createType(clazz.getDescriptor());
    }

    public DexType lookupType(DexString descriptor) {
        return this.types.get(descriptor);
    }

    public DexType createArrayType(int nesting, DexType baseType) {
        assert (nesting > 0);
        return this.createType(Strings.repeat("[", nesting) + baseType.toDescriptorString());
    }

    public DexField createField(DexType clazz, DexType type, DexString name) {
        assert (!this.sorted);
        DexField field = new DexField(clazz, type, name, this.skipNameValidationForTesting);
        return DexItemFactory.canonicalize(this.fields, field);
    }

    public DexField createField(DexType clazz, DexType type, String name) {
        return this.createField(clazz, type, this.createString(name));
    }

    public DexField createField(FieldReference fieldReference) {
        return this.createField(this.createType(fieldReference.getHolderClass().getDescriptor()), this.createType(fieldReference.getFieldType().getDescriptor()), fieldReference.getFieldName());
    }

    public DexProto createProto(DexType returnType, DexTypeList parameters) {
        return this.createProto(returnType, parameters, this.createShorty(returnType, parameters.getBacking()));
    }

    public DexProto createProto(DexType returnType, DexTypeList parameters, DexString shorty) {
        assert (!this.sorted);
        DexProto proto = new DexProto(shorty, returnType, parameters);
        return DexItemFactory.canonicalize(this.protos, proto);
    }

    public DexProto createProto(DexType returnType, DexType ... parameters) {
        assert (!this.sorted);
        return this.createProto(returnType, parameters.length == 0 ? DexTypeList.empty() : new DexTypeList(parameters), this.createShorty(returnType, parameters));
    }

    public DexProto createProto(DexType returnType, List<DexType> parameters) {
        return this.createProto(returnType, parameters.toArray(DexType.EMPTY_ARRAY));
    }

    public DexProto protoWithDifferentFirstParameter(DexProto proto, DexType firstParameter) {
        DexType[] parameterTypes = (DexType[])proto.parameters.values.clone();
        parameterTypes[0] = firstParameter;
        return this.createProto(proto.returnType, parameterTypes);
    }

    public DexProto prependHolderToProto(DexMethod method) {
        return this.prependTypeToProto(method.holder, method.proto);
    }

    public DexProto prependHolderToProtoIf(DexMethod method, boolean condition) {
        return condition ? this.prependHolderToProto(method) : method.getProto();
    }

    public DexProto prependTypeToProto(DexType extraFirstType, DexProto initialProto) {
        DexType[] parameterTypes = new DexType[initialProto.parameters.size() + 1];
        parameterTypes[0] = extraFirstType;
        System.arraycopy(initialProto.parameters.values, 0, parameterTypes, 1, initialProto.parameters.size());
        return this.createProto(initialProto.returnType, parameterTypes);
    }

    public DexProto appendTypeToProto(DexProto initialProto, DexType extraLastType) {
        DexType[] parameterTypes = new DexType[initialProto.parameters.size() + 1];
        System.arraycopy(initialProto.parameters.values, 0, parameterTypes, 0, initialProto.parameters.size());
        parameterTypes[parameterTypes.length - 1] = extraLastType;
        return this.createProto(initialProto.returnType, parameterTypes);
    }

    public DexMethod appendTypeToMethod(DexMethod initialMethod, DexType extraLastType) {
        DexProto newProto = this.appendTypeToProto(initialMethod.proto, extraLastType);
        return this.createMethod(initialMethod.holder, newProto, initialMethod.name);
    }

    public DexProto applyClassMappingToProto(DexProto proto, Function<DexType, DexType> mapping, Map<DexProto, DexProto> cache) {
        assert (cache != null);
        DexProto result = cache.get(proto);
        if (result == null) {
            DexType returnType = mapping.apply(proto.returnType);
            Object[] parameters = DexItemFactory.applyClassMappingToDexTypes(proto.parameters.values, mapping);
            if (returnType == proto.returnType && parameters == proto.parameters.values) {
                result = proto;
            } else {
                assert (returnType == proto.returnType || !returnType.equals(proto.returnType));
                assert (parameters == proto.parameters.values || !Arrays.equals(parameters, proto.parameters.values));
                result = this.createProto(returnType, (DexType[])parameters);
            }
            cache.put(proto, result);
        }
        return result;
    }

    public DexMethod createMethod(DexType holder, DexProto proto, DexString name) {
        assert (!this.sorted);
        DexMethod method = new DexMethod(holder, proto, name, this.skipNameValidationForTesting);
        return DexItemFactory.canonicalize(this.methods, method);
    }

    public DexMethod createMethod(DexType holder, DexProto proto, String name) {
        return this.createMethod(holder, proto, this.createString(name));
    }

    public DexMethod createMethod(MethodReference methodReference) {
        DexString[] formals = new DexString[methodReference.getFormalTypes().size()];
        ListUtils.forEachWithIndex(methodReference.getFormalTypes(), (formal, index) -> {
            formals[index] = this.createString(formal.getDescriptor());
        });
        return this.createMethod(this.createString(methodReference.getHolderClass().getDescriptor()), this.createString(methodReference.getMethodName()), methodReference.getReturnType() == null ? this.voidDescriptor : this.createString(methodReference.getReturnType().getDescriptor()), formals);
    }

    public DexMethodHandle createMethodHandle(DexMethodHandle.MethodHandleType type, DexMember<? extends DexItem, ? extends DexMember<?, ?>> fieldOrMethod, boolean isInterface) {
        return this.createMethodHandle(type, fieldOrMethod, isInterface, null);
    }

    public DexMethodHandle createMethodHandle(DexMethodHandle.MethodHandleType type, DexMember<? extends DexItem, ? extends DexMember<?, ?>> fieldOrMethod, boolean isInterface, DexMethod rewrittenTarget) {
        assert (!this.sorted);
        DexMethodHandle methodHandle = new DexMethodHandle(type, fieldOrMethod, isInterface, rewrittenTarget);
        return DexItemFactory.canonicalize(this.methodHandles, methodHandle);
    }

    public DexCallSite createCallSite(DexString methodName, DexProto methodProto, DexMethodHandle bootstrapMethod, List<DexValue> bootstrapArgs) {
        assert (!this.sorted);
        return new DexCallSite(methodName, methodProto, bootstrapMethod, bootstrapArgs);
    }

    public DexMethod createMethod(DexString clazzDescriptor, DexString name, DexString returnTypeDescriptor, DexString[] parameterDescriptors) {
        assert (!this.sorted);
        DexType clazz = this.createType(clazzDescriptor);
        DexType returnType = this.createType(returnTypeDescriptor);
        DexType[] parameterTypes = new DexType[parameterDescriptors.length];
        for (int i = 0; i < parameterDescriptors.length; ++i) {
            parameterTypes[i] = this.createType(parameterDescriptors[i]);
        }
        DexProto proto = this.createProto(returnType, parameterTypes);
        return this.createMethod(clazz, proto, name);
    }

    public DexMethod createClinitMethod(DexType holder) {
        return this.createMethod(holder, this.createProto(this.voidType, new DexType[0]), this.classConstructorMethodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.AdvanceLine createAdvanceLine(int delta) {
        Int2ReferenceMap<DexDebugEvent.AdvanceLine> int2ReferenceMap = this.advanceLines;
        synchronized (int2ReferenceMap) {
            return this.advanceLines.computeIfAbsent(delta, DexDebugEvent.AdvanceLine::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.AdvancePC createAdvancePC(int delta) {
        Int2ReferenceMap<DexDebugEvent.AdvancePC> int2ReferenceMap = this.advancePCs;
        synchronized (int2ReferenceMap) {
            return this.advancePCs.computeIfAbsent(delta, DexDebugEvent.AdvancePC::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.Default createDefault(int value) {
        Int2ReferenceMap<DexDebugEvent.Default> int2ReferenceMap = this.defaults;
        synchronized (int2ReferenceMap) {
            return this.defaults.computeIfAbsent(value, DexDebugEvent.Default::new);
        }
    }

    public DexDebugEvent.Default createDefault(int lineDelta, int pcDelta) {
        return this.createDefault(DexDebugEvent.Default.create((int)lineDelta, (int)pcDelta).value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.EndLocal createEndLocal(int registerNum) {
        Int2ReferenceMap<DexDebugEvent.EndLocal> int2ReferenceMap = this.endLocals;
        synchronized (int2ReferenceMap) {
            return this.endLocals.computeIfAbsent(registerNum, DexDebugEvent.EndLocal::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.RestartLocal createRestartLocal(int registerNum) {
        Int2ReferenceMap<DexDebugEvent.RestartLocal> int2ReferenceMap = this.restartLocals;
        synchronized (int2ReferenceMap) {
            return this.restartLocals.computeIfAbsent(registerNum, DexDebugEvent.RestartLocal::new);
        }
    }

    public DexDebugEvent.SetEpilogueBegin createSetEpilogueBegin() {
        return this.setEpilogueBegin;
    }

    public DexDebugEvent.SetPrologueEnd createSetPrologueEnd() {
        return this.setPrologueEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.SetFile createSetFile(DexString fileName) {
        Map<DexString, DexDebugEvent.SetFile> map = this.setFiles;
        synchronized (map) {
            return this.setFiles.computeIfAbsent(fileName, DexDebugEvent.SetFile::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.SetInlineFrame createSetInlineFrame(DexMethod callee, Position caller) {
        Map<DexDebugEvent.SetInlineFrame, DexDebugEvent.SetInlineFrame> map = this.setInlineFrames;
        synchronized (map) {
            return this.setInlineFrames.computeIfAbsent(new DexDebugEvent.SetInlineFrame(callee, caller), p -> p);
        }
    }

    public DexDebugEvent.SetOutlineFrame createSetOutlineFrame() {
        return this.setOutlineFrame;
    }

    public DexDebugEvent.SetOutlineCallerFrame createSetOutlineCallerFrame(DexMethod outlineCallee, Int2StructuralItemArrayMap<Position> outlinePositions) {
        return new DexDebugEvent.SetOutlineCallerFrame(outlineCallee, outlinePositions);
    }

    public boolean isConstructor(DexMethod method) {
        return method.name == this.constructorMethodName;
    }

    public boolean isClassConstructor(DexMethod method) {
        return method.name == this.classConstructorMethodName;
    }

    public void clearTypeElementsCache() {
        this.referenceTypes.clear();
        this.classTypeInterfaces.clear();
        this.leastUpperBoundOfInterfacesTable.clear();
    }

    public boolean verifyNoCachedTypeElements() {
        assert (this.referenceTypes.isEmpty());
        assert (this.classTypeInterfaces.isEmpty());
        assert (this.leastUpperBoundOfInterfacesTable.isEmpty());
        return true;
    }

    public ReferenceTypeElement createReferenceTypeElement(DexType type, Nullability nullability, AppView<?> appView) {
        TypeElement memberType = null;
        if (type.isArrayType()) {
            ReferenceTypeElement existing = this.referenceTypes.get(type);
            if (existing != null) {
                return existing.getOrCreateVariant(nullability);
            }
            memberType = TypeElement.fromDexType(type.toArrayElementType(this), Nullability.maybeNull(), appView, true);
        }
        TypeElement finalMemberType = memberType;
        return this.referenceTypes.computeIfAbsent(type, t -> {
            if (type.isClassType()) {
                if (!appView.enableWholeProgramOptimizations()) {
                    return ClassTypeElement.createForD8(type, nullability);
                }
                assert (((AppInfo)appView.appInfo()).hasClassHierarchy());
                if (appView.isInterface(type).isTrue()) {
                    return ClassTypeElement.create(this.objectType, nullability, appView.withClassHierarchy(), InterfaceCollection.singleton(type));
                }
                return ClassTypeElement.create(type, nullability, appView.withClassHierarchy());
            }
            assert (type.isArrayType());
            return ArrayTypeElement.create(finalMemberType, nullability);
        }).getOrCreateVariant(nullability);
    }

    public InterfaceCollection getOrComputeLeastUpperBoundOfImplementedInterfaces(DexType type, AppView<? extends AppInfoWithClassHierarchy> appView) {
        return this.classTypeInterfaces.computeIfAbsent(type, t -> {
            InterfaceCollection itfs = ((AppInfoWithClassHierarchy)appView.appInfo()).implementedInterfaces((DexType)t);
            return ClassTypeElement.computeLeastUpperBoundOfInterfaces(appView, itfs, itfs);
        });
    }

    @Deprecated
    public synchronized void forAllTypes(Consumer<DexType> f) {
        new ArrayList<DexType>(this.types.values()).forEach(f);
    }

    public class ServiceLoaderMethods {
        public final DexMethod load;
        public final DexMethod loadWithClassLoader;
        public final DexMethod loadInstalled;
        public final DexMethod iterator;

        private ServiceLoaderMethods() {
            DexString loadName = DexItemFactory.this.createString("load");
            this.load = DexItemFactory.this.createMethod(DexItemFactory.this.serviceLoaderType, DexItemFactory.this.createProto(DexItemFactory.this.serviceLoaderType, DexItemFactory.this.classType), loadName);
            this.loadWithClassLoader = DexItemFactory.this.createMethod(DexItemFactory.this.serviceLoaderType, DexItemFactory.this.createProto(DexItemFactory.this.serviceLoaderType, DexItemFactory.this.classType, DexItemFactory.this.classLoaderType), loadName);
            this.loadInstalled = DexItemFactory.this.createMethod(DexItemFactory.this.serviceLoaderType, DexItemFactory.this.createProto(DexItemFactory.this.serviceLoaderType, DexItemFactory.this.classType), DexItemFactory.this.createString("loadInstalled"));
            this.iterator = DexItemFactory.this.createMethod(DexItemFactory.this.serviceLoaderType, DexItemFactory.this.createProto(DexItemFactory.this.iteratorType, new DexType[0]), DexItemFactory.this.createString("iterator"));
        }

        public boolean isLoadMethod(DexMethod method) {
            return method == this.load || method == this.loadWithClassLoader || method == this.loadInstalled;
        }
    }

    public class ProxyMethods {
        public final DexMethod newProxyInstance;

        private ProxyMethods() {
            this.newProxyInstance = DexItemFactory.this.createMethod(DexItemFactory.this.proxyType, DexItemFactory.this.createProto(DexItemFactory.this.objectType, DexItemFactory.this.classLoaderType, DexItemFactory.this.classArrayType, DexItemFactory.this.invocationHandlerType), DexItemFactory.this.createString("newProxyInstance"));
        }
    }

    public class PolymorphicMethods {
        private final DexProto signature;
        private final DexProto setSignature;
        private final DexProto compareAndSetSignature;
        private final Set<DexString> varHandleMethods;
        private final Set<DexString> varHandleSetMethods;
        private final Set<DexString> varHandleCompareAndSetMethods;

        public PolymorphicMethods() {
            this.signature = DexItemFactory.this.createProto(DexItemFactory.this.objectType, DexItemFactory.this.objectArrayType);
            this.setSignature = DexItemFactory.this.createProto(DexItemFactory.this.voidType, DexItemFactory.this.objectArrayType);
            this.compareAndSetSignature = DexItemFactory.this.createProto(DexItemFactory.this.booleanType, DexItemFactory.this.objectArrayType);
            this.varHandleMethods = this.createStrings("compareAndExchange", "compareAndExchangeAcquire", "compareAndExchangeRelease", "get", "getAcquire", "getAndAdd", "getAndAddAcquire", "getAndAddRelease", "getAndBitwiseAnd", "getAndBitwiseAndAcquire", "getAndBitwiseAndRelease", "getAndBitwiseOr", "getAndBitwiseOrAcquire", "getAndBitwiseOrRelease", "getAndBitwiseXor", "getAndBitwiseXorAcquire", "getAndBitwiseXorRelease", "getAndSet", "getAndSetAcquire", "getAndSetRelease", "getOpaque", "getVolatile");
            this.varHandleSetMethods = this.createStrings("set", "setOpaque", "setRelease", "setVolatile");
            this.varHandleCompareAndSetMethods = this.createStrings("compareAndSet", "weakCompareAndSet", "weakCompareAndSetAcquire", "weakCompareAndSetPlain", "weakCompareAndSetRelease");
        }

        private Set<DexString> createStrings(String ... strings) {
            IdentityHashMap<DexString, DexString> map = new IdentityHashMap<DexString, DexString>();
            for (String string : strings) {
                DexString dexString = DexItemFactory.this.createString(string);
                map.put(dexString, dexString);
            }
            return map.keySet();
        }

        public DexMethod canonicalize(DexMethod invokeProto) {
            DexMethod result = null;
            if (invokeProto.holder == DexItemFactory.this.methodHandleType) {
                if (invokeProto.name == DexItemFactory.this.invokeMethodName || invokeProto.name == DexItemFactory.this.invokeExactMethodName) {
                    result = DexItemFactory.this.createMethod(DexItemFactory.this.methodHandleType, this.signature, invokeProto.name);
                }
            } else if (invokeProto.holder == DexItemFactory.this.varHandleType) {
                if (this.varHandleMethods.contains(invokeProto.name)) {
                    result = DexItemFactory.this.createMethod(DexItemFactory.this.varHandleType, this.signature, invokeProto.name);
                } else if (this.varHandleSetMethods.contains(invokeProto.name)) {
                    result = DexItemFactory.this.createMethod(DexItemFactory.this.varHandleType, this.setSignature, invokeProto.name);
                } else if (this.varHandleCompareAndSetMethods.contains(invokeProto.name)) {
                    result = DexItemFactory.this.createMethod(DexItemFactory.this.varHandleType, this.compareAndSetSignature, invokeProto.name);
                }
            }
            assert (result != null == this.isPolymorphicInvoke(invokeProto));
            return result;
        }

        public boolean isPolymorphicInvoke(DexMethod invokeProto) {
            if (invokeProto.holder == DexItemFactory.this.methodHandleType) {
                return invokeProto.name == DexItemFactory.this.invokeMethodName || invokeProto.name == DexItemFactory.this.invokeExactMethodName;
            }
            if (invokeProto.holder == DexItemFactory.this.varHandleType) {
                return this.varHandleMethods.contains(invokeProto.name) || this.varHandleSetMethods.contains(invokeProto.name) || this.varHandleCompareAndSetMethods.contains(invokeProto.name);
            }
            return false;
        }
    }

    public class SupplierMembers
    extends LibraryMembers {
        public final DexMethod get;

        private SupplierMembers() {
            this.get = DexItemFactory.this.createMethod(DexItemFactory.this.supplierType, DexItemFactory.this.createProto(DexItemFactory.this.objectType, new DexType[0]), "get");
        }
    }

    public class StringBuildingMethods {
        public final DexMethod appendBoolean;
        public final DexMethod appendChar;
        public final DexMethod appendCharArray;
        public final DexMethod appendSubCharArray;
        public final DexMethod appendCharSequence;
        public final DexMethod appendSubCharSequence;
        public final DexMethod appendInt;
        public final DexMethod appendDouble;
        public final DexMethod appendFloat;
        public final DexMethod appendLong;
        public final DexMethod appendObject;
        public final DexMethod appendString;
        public final DexMethod appendStringBuffer;
        public final DexMethod charSequenceConstructor;
        public final DexMethod defaultConstructor;
        public final DexMethod intConstructor;
        public final DexMethod stringConstructor;
        public final DexMethod toString;
        private final Set<DexMethod> appendMethods;
        private final Set<DexMethod> appendPrimitiveMethods;
        public final Set<DexMethod> constructorMethods;

        private StringBuildingMethods(DexType receiver) {
            DexString append = DexItemFactory.this.createString("append");
            this.appendBoolean = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.booleanType), append);
            this.appendChar = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.charType), append);
            this.appendCharArray = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.charArrayType), append);
            this.appendSubCharArray = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.charArrayType, DexItemFactory.this.intType, DexItemFactory.this.intType), append);
            this.appendCharSequence = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.charSequenceType), append);
            this.appendSubCharSequence = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.charSequenceType, DexItemFactory.this.intType, DexItemFactory.this.intType), append);
            this.appendInt = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.intType), append);
            this.appendDouble = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.doubleType), append);
            this.appendFloat = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.floatType), append);
            this.appendLong = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.longType), append);
            this.appendObject = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.objectType), append);
            this.appendString = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.stringType), append);
            this.appendStringBuffer = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.stringBufferType), append);
            this.charSequenceConstructor = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(DexItemFactory.this.voidType, DexItemFactory.this.charSequenceType), DexItemFactory.this.constructorMethodName);
            this.defaultConstructor = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(DexItemFactory.this.voidType, new DexType[0]), DexItemFactory.this.constructorMethodName);
            this.intConstructor = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(DexItemFactory.this.voidType, DexItemFactory.this.intType), DexItemFactory.this.constructorMethodName);
            this.stringConstructor = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(DexItemFactory.this.voidType, DexItemFactory.this.stringType), DexItemFactory.this.constructorMethodName);
            this.toString = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(DexItemFactory.this.stringType, new DexType[0]), DexItemFactory.this.toStringMethodName);
            this.appendMethods = ImmutableSet.of(this.appendBoolean, this.appendChar, this.appendCharArray, this.appendSubCharArray, this.appendCharSequence, this.appendSubCharSequence, new DexMethod[]{this.appendInt, this.appendDouble, this.appendFloat, this.appendLong, this.appendObject, this.appendString, this.appendStringBuffer});
            this.appendPrimitiveMethods = ImmutableSet.of(this.appendBoolean, this.appendChar, this.appendInt, this.appendDouble, this.appendFloat, this.appendLong, new DexMethod[0]);
            this.constructorMethods = ImmutableSet.of(this.charSequenceConstructor, this.defaultConstructor, this.intConstructor, this.stringConstructor);
        }

        public boolean isAppendMethod(DexMethod method) {
            return this.appendMethods.contains(method);
        }

        public boolean isAppendObjectMethod(DexMethod method) {
            return method == this.appendObject;
        }

        public boolean isAppendPrimitiveMethod(DexMethod method) {
            return this.appendPrimitiveMethods.contains(method);
        }

        public boolean isAppendStringMethod(DexMethod method) {
            return method == this.appendString;
        }

        public boolean isConstructorMethod(DexMethod method) {
            return this.constructorMethods.contains(method);
        }

        public boolean constructorInvokeIsSideEffectFree(DexMethod invokedMethod, List<Value> arguments) {
            if (invokedMethod == this.defaultConstructor) {
                return true;
            }
            if (invokedMethod == this.charSequenceConstructor) {
                TypeElement charSequenceType = arguments.get(1).getType();
                return charSequenceType.isClassType() && charSequenceType.asClassType().getClassType() == DexItemFactory.this.stringType;
            }
            if (invokedMethod == this.intConstructor) {
                Value capacityValue = arguments.get(1);
                if (capacityValue.hasValueRange()) {
                    return capacityValue.getValueRange().getMin() >= 0L;
                }
                return false;
            }
            if (invokedMethod == this.stringConstructor) {
                Value strValue = arguments.get(1);
                return !strValue.getType().isNullable();
            }
            assert (false) : "Unexpected invoke targeting `" + invokedMethod.toSourceString() + "`";
            return false;
        }
    }

    public class StringMembers
    extends LibraryMembers {
        public final DexField CASE_INSENSITIVE_ORDER;
        public final DexMethod isEmpty;
        public final DexMethod length;
        public final DexMethod concat;
        public final DexMethod constructor;
        public final DexMethod contains;
        public final DexMethod startsWith;
        public final DexMethod endsWith;
        public final DexMethod equals;
        public final DexMethod equalsIgnoreCase;
        public final DexMethod contentEqualsCharSequence;
        public final DexMethod indexOfInt;
        public final DexMethod indexOfString;
        public final DexMethod lastIndexOfInt;
        public final DexMethod lastIndexOfString;
        public final DexMethod compareTo;
        public final DexMethod compareToIgnoreCase;
        public final DexMethod hashCode;
        public final DexMethod valueOf;
        public final DexMethod toString;
        public final DexMethod intern;
        public final DexMethod trim;

        private StringMembers() {
            this.CASE_INSENSITIVE_ORDER = DexItemFactory.this.createField(DexItemFactory.this.stringType, DexItemFactory.this.javaUtilComparatorType, "CASE_INSENSITIVE_ORDER");
            this.constructor = DexItemFactory.this.createMethod(DexItemFactory.this.stringType, DexItemFactory.this.createProto(DexItemFactory.this.voidType, DexItemFactory.this.stringType), DexItemFactory.this.constructorMethodName);
            this.trim = DexItemFactory.this.createMethod(DexItemFactory.this.stringType, DexItemFactory.this.createProto(DexItemFactory.this.stringType, new DexType[0]), DexItemFactory.this.trimName);
            this.isEmpty = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.isEmptyMethodName, DexItemFactory.this.booleanDescriptor, DexString.EMPTY_ARRAY);
            this.length = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.lengthMethodName, DexItemFactory.this.intDescriptor, DexString.EMPTY_ARRAY);
            DexString[] needsOneCharSequence = new DexString[]{DexItemFactory.this.charSequenceDescriptor};
            DexString[] needsOneString = new DexString[]{DexItemFactory.this.stringDescriptor};
            DexString[] needsOneObject = new DexString[]{DexItemFactory.this.objectDescriptor};
            DexString[] needsOneInt = new DexString[]{DexItemFactory.this.intDescriptor};
            this.concat = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.concatMethodName, DexItemFactory.this.stringDescriptor, needsOneString);
            this.contains = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.containsMethodName, DexItemFactory.this.booleanDescriptor, needsOneCharSequence);
            this.startsWith = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.startsWithMethodName, DexItemFactory.this.booleanDescriptor, needsOneString);
            this.endsWith = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.endsWithMethodName, DexItemFactory.this.booleanDescriptor, needsOneString);
            this.equals = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.equalsMethodName, DexItemFactory.this.booleanDescriptor, needsOneObject);
            this.equalsIgnoreCase = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.equalsIgnoreCaseMethodName, DexItemFactory.this.booleanDescriptor, needsOneString);
            this.contentEqualsCharSequence = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.contentEqualsMethodName, DexItemFactory.this.booleanDescriptor, needsOneCharSequence);
            this.indexOfString = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.indexOfMethodName, DexItemFactory.this.intDescriptor, needsOneString);
            this.indexOfInt = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.indexOfMethodName, DexItemFactory.this.intDescriptor, needsOneInt);
            this.lastIndexOfString = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.lastIndexOfMethodName, DexItemFactory.this.intDescriptor, needsOneString);
            this.lastIndexOfInt = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.lastIndexOfMethodName, DexItemFactory.this.intDescriptor, needsOneInt);
            this.compareTo = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.compareToMethodName, DexItemFactory.this.intDescriptor, needsOneString);
            this.compareToIgnoreCase = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.compareToIgnoreCaseMethodName, DexItemFactory.this.intDescriptor, needsOneString);
            this.hashCode = DexItemFactory.this.createMethod(DexItemFactory.this.stringType, DexItemFactory.this.createProto(DexItemFactory.this.intType, new DexType[0]), DexItemFactory.this.hashCodeMethodName);
            this.valueOf = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.valueOfMethodName, DexItemFactory.this.stringDescriptor, needsOneObject);
            this.toString = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.toStringMethodName, DexItemFactory.this.stringDescriptor, DexString.EMPTY_ARRAY);
            this.intern = DexItemFactory.this.createMethod(DexItemFactory.this.stringDescriptor, DexItemFactory.this.internMethodName, DexItemFactory.this.stringDescriptor, DexString.EMPTY_ARRAY);
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.CASE_INSENSITIVE_ORDER);
        }
    }

    public class ShortMembers
    extends LibraryMembers {
        public final DexMethod toString;

        private ShortMembers() {
            this.toString = DexItemFactory.this.createMethod(DexItemFactory.this.boxedShortType, DexItemFactory.this.createProto(DexItemFactory.this.stringType, new DexType[0]), "toString");
        }
    }

    public class AtomicFieldUpdaterMethods {
        public final DexMethod intUpdater;
        public final DexMethod longUpdater;
        public final DexMethod referenceUpdater;
        private final Set<DexMethod> updaters;

        private AtomicFieldUpdaterMethods() {
            this.intUpdater = DexItemFactory.this.createMethod(DexItemFactory.this.intFieldUpdaterDescriptor, DexItemFactory.this.newUpdaterName, DexItemFactory.this.intFieldUpdaterDescriptor, new DexString[]{DexItemFactory.this.classDescriptor, DexItemFactory.this.stringDescriptor});
            this.longUpdater = DexItemFactory.this.createMethod(DexItemFactory.this.longFieldUpdaterDescriptor, DexItemFactory.this.newUpdaterName, DexItemFactory.this.longFieldUpdaterDescriptor, new DexString[]{DexItemFactory.this.classDescriptor, DexItemFactory.this.stringDescriptor});
            this.referenceUpdater = DexItemFactory.this.createMethod(DexItemFactory.this.referenceFieldUpdaterDescriptor, DexItemFactory.this.newUpdaterName, DexItemFactory.this.referenceFieldUpdaterDescriptor, new DexString[]{DexItemFactory.this.classDescriptor, DexItemFactory.this.classDescriptor, DexItemFactory.this.stringDescriptor});
            this.updaters = ImmutableSet.of(this.intUpdater, this.longUpdater, this.referenceUpdater);
        }

        public boolean isFieldUpdater(DexMethod method) {
            return this.updaters.contains(method);
        }
    }

    public class PrimitiveTypesBoxedTypeFields {
        public final DexField byteTYPE;
        public final DexField charTYPE;
        public final DexField shortTYPE;
        public final DexField intTYPE;
        public final DexField longTYPE;
        public final DexField floatTYPE;
        public final DexField doubleTYPE;
        private final Map<DexField, DexType> boxedFieldTypeToPrimitiveType;

        private PrimitiveTypesBoxedTypeFields() {
            this.byteTYPE = DexItemFactory.this.createField(DexItemFactory.this.boxedByteType, DexItemFactory.this.classType, "TYPE");
            this.charTYPE = DexItemFactory.this.createField(DexItemFactory.this.boxedCharType, DexItemFactory.this.classType, "TYPE");
            this.shortTYPE = DexItemFactory.this.createField(DexItemFactory.this.boxedShortType, DexItemFactory.this.classType, "TYPE");
            this.intTYPE = DexItemFactory.this.createField(DexItemFactory.this.boxedIntType, DexItemFactory.this.classType, "TYPE");
            this.longTYPE = DexItemFactory.this.createField(DexItemFactory.this.boxedLongType, DexItemFactory.this.classType, "TYPE");
            this.floatTYPE = DexItemFactory.this.createField(DexItemFactory.this.boxedFloatType, DexItemFactory.this.classType, "TYPE");
            this.doubleTYPE = DexItemFactory.this.createField(DexItemFactory.this.boxedDoubleType, DexItemFactory.this.classType, "TYPE");
            this.boxedFieldTypeToPrimitiveType = ImmutableMap.builder().put(DexItemFactory.this.booleanMembers.TYPE, DexItemFactory.this.booleanType).put(this.byteTYPE, DexItemFactory.this.byteType).put(this.charTYPE, DexItemFactory.this.charType).put(this.shortTYPE, DexItemFactory.this.shortType).put(this.intTYPE, DexItemFactory.this.intType).put(this.longTYPE, DexItemFactory.this.longType).put(this.floatTYPE, DexItemFactory.this.floatType).put(this.doubleTYPE, DexItemFactory.this.doubleType).build();
        }

        public DexType boxedFieldTypeToPrimitiveType(DexField field) {
            return this.boxedFieldTypeToPrimitiveType.get(field);
        }
    }

    public class IllegalArgumentExceptionMethods {
        public final DexMethod initWithMessage;

        public IllegalArgumentExceptionMethods() {
            this.initWithMessage = DexItemFactory.this.createMethod(DexItemFactory.this.illegalArgumentExceptionType, DexItemFactory.this.createProto(DexItemFactory.this.voidType, DexItemFactory.this.stringType), DexItemFactory.this.constructorMethodName);
        }
    }

    public class NullPointerExceptionMethods {
        public final DexMethod init;
        public final DexMethod initWithMessage;

        public NullPointerExceptionMethods() {
            this.init = DexItemFactory.this.createMethod(DexItemFactory.this.npeType, DexItemFactory.this.createProto(DexItemFactory.this.voidType, new DexType[0]), DexItemFactory.this.constructorMethodName);
            this.initWithMessage = DexItemFactory.this.createMethod(DexItemFactory.this.npeType, DexItemFactory.this.createProto(DexItemFactory.this.voidType, DexItemFactory.this.stringType), DexItemFactory.this.constructorMethodName);
        }
    }

    public class EnumMembers {
        public final DexField nameField;
        public final DexField ordinalField;
        public final DexMethod valueOf;
        public final DexMethod ordinalMethod;
        public final DexMethod nameMethod;
        public final DexMethod toString;
        public final DexMethod compareTo;
        public final DexMethod compareToWithObject;
        public final DexMethod equals;
        public final DexMethod hashCode;
        public final DexMethod constructor;
        public final DexMethod finalize;

        private EnumMembers() {
            this.nameField = DexItemFactory.this.createField(DexItemFactory.this.enumType, DexItemFactory.this.stringType, "name");
            this.ordinalField = DexItemFactory.this.createField(DexItemFactory.this.enumType, DexItemFactory.this.intType, "ordinal");
            this.compareToWithObject = DexItemFactory.this.createMethod(DexItemFactory.this.enumType, DexItemFactory.this.createProto(DexItemFactory.this.intType, DexItemFactory.this.objectType), "compareTo");
            this.constructor = DexItemFactory.this.createMethod(DexItemFactory.this.enumType, DexItemFactory.this.createProto(DexItemFactory.this.voidType, DexItemFactory.this.stringType, DexItemFactory.this.intType), DexItemFactory.this.constructorMethodName);
            this.finalize = DexItemFactory.this.createMethod(DexItemFactory.this.enumType, DexItemFactory.this.createProto(DexItemFactory.this.voidType, new DexType[0]), DexItemFactory.this.finalizeMethodName);
            this.valueOf = DexItemFactory.this.createMethod(DexItemFactory.this.enumDescriptor, DexItemFactory.this.valueOfMethodName, DexItemFactory.this.enumDescriptor, new DexString[]{DexItemFactory.this.classDescriptor, DexItemFactory.this.stringDescriptor});
            this.ordinalMethod = DexItemFactory.this.createMethod(DexItemFactory.this.enumDescriptor, DexItemFactory.this.ordinalMethodName, DexItemFactory.this.intDescriptor, DexString.EMPTY_ARRAY);
            this.nameMethod = DexItemFactory.this.createMethod(DexItemFactory.this.enumDescriptor, DexItemFactory.this.nameMethodName, DexItemFactory.this.stringDescriptor, DexString.EMPTY_ARRAY);
            this.toString = DexItemFactory.this.createMethod(DexItemFactory.this.enumDescriptor, DexItemFactory.this.toStringMethodName, DexItemFactory.this.stringDescriptor, DexString.EMPTY_ARRAY);
            this.compareTo = DexItemFactory.this.createMethod(DexItemFactory.this.enumDescriptor, DexItemFactory.this.compareToMethodName, DexItemFactory.this.intDescriptor, new DexString[]{DexItemFactory.this.enumDescriptor});
            this.equals = DexItemFactory.this.createMethod(DexItemFactory.this.enumDescriptor, DexItemFactory.this.equalsMethodName, DexItemFactory.this.booleanDescriptor, new DexString[]{DexItemFactory.this.objectDescriptor});
            this.hashCode = DexItemFactory.this.createMethod(DexItemFactory.this.enumDescriptor, DexItemFactory.this.hashCodeMethodName, DexItemFactory.this.intDescriptor, DexString.EMPTY_ARRAY);
        }

        public void forEachField(Consumer<DexField> fn) {
            fn.accept(this.nameField);
            fn.accept(this.ordinalField);
        }

        public boolean isNameOrOrdinalField(DexField field) {
            return field == this.nameField || field == this.ordinalField;
        }

        public boolean isEnumField(DexEncodedField staticField, DexType enumType) {
            assert (staticField.isStatic());
            return staticField.getType() == enumType && staticField.isEnum() && staticField.isFinal();
        }

        public boolean isValuesFieldCandidate(DexEncodedField staticField, DexType enumType) {
            assert (staticField.isStatic());
            return staticField.getType().isArrayType() && staticField.getType().toArrayElementType(DexItemFactory.this) == enumType && staticField.isSynthetic() && staticField.isFinal();
        }
    }

    public class JavaLangSystemMethods {
        public final DexMethod arraycopy;
        public final DexMethod identityHashCode;

        private JavaLangSystemMethods() {
            this.arraycopy = DexItemFactory.this.createMethod(DexItemFactory.this.javaLangSystemType, DexItemFactory.this.createProto(DexItemFactory.this.voidType, DexItemFactory.this.objectType, DexItemFactory.this.intType, DexItemFactory.this.objectType, DexItemFactory.this.intType, DexItemFactory.this.intType), "arraycopy");
            this.identityHashCode = DexItemFactory.this.createMethod(DexItemFactory.this.javaLangSystemType, DexItemFactory.this.createProto(DexItemFactory.this.intType, DexItemFactory.this.objectType), DexItemFactory.this.identityHashCodeName);
        }
    }

    public class JavaLangReflectArrayMembers {
        public final DexMethod newInstanceMethodWithDimensions;

        private JavaLangReflectArrayMembers() {
            this.newInstanceMethodWithDimensions = DexItemFactory.this.createMethod(DexItemFactory.this.javaLangReflectArrayType, DexItemFactory.this.createProto(DexItemFactory.this.objectType, DexItemFactory.this.classType, DexItemFactory.this.intArrayType), "newInstance");
        }
    }

    public class JavaLangAnnotationRetentionPolicyMembers {
        public final DexField CLASS;

        private JavaLangAnnotationRetentionPolicyMembers() {
            this.CLASS = DexItemFactory.this.createField(DexItemFactory.this.javaLangAnnotationRetentionPolicyType, DexItemFactory.this.javaLangAnnotationRetentionPolicyType, "CLASS");
        }
    }

    public class ConstructorMethods {
        public final DexMethod newInstance;

        private ConstructorMethods() {
            this.newInstance = DexItemFactory.this.createMethod(DexItemFactory.this.constructorDescriptor, DexItemFactory.this.newInstanceName, DexItemFactory.this.objectDescriptor, new DexString[]{DexItemFactory.this.objectArrayDescriptor});
        }
    }

    public class ClassMethods {
        public final DexMethod desiredAssertionStatus;
        public final DexMethod forName;
        public final DexMethod forName3;
        public final DexMethod getClassLoader;
        public final DexMethod getName;
        public final DexMethod getCanonicalName;
        public final DexMethod getSimpleName;
        public final DexMethod getTypeName;
        public final DexMethod getConstructor;
        public final DexMethod getDeclaredConstructor;
        public final DexMethod getField;
        public final DexMethod getDeclaredField;
        public final DexMethod getMethod;
        public final DexMethod getDeclaredMethod;
        public final DexMethod getPackage;
        public final DexMethod newInstance;
        private final Set<DexMethod> getMembers;
        public final Set<DexMethod> getNames;

        private ClassMethods() {
            this.getClassLoader = DexItemFactory.this.createMethod(DexItemFactory.this.classType, DexItemFactory.this.createProto(DexItemFactory.this.classLoaderType, new DexType[0]), "getClassLoader");
            this.getPackage = DexItemFactory.this.createMethod(DexItemFactory.this.classType, DexItemFactory.this.createProto(DexItemFactory.this.packageType, new DexType[0]), "getPackage");
            this.desiredAssertionStatus = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.desiredAssertionStatusMethodName, DexItemFactory.this.booleanDescriptor, DexString.EMPTY_ARRAY);
            this.forName = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.forNameMethodName, DexItemFactory.this.classDescriptor, new DexString[]{DexItemFactory.this.stringDescriptor});
            this.forName3 = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.forNameMethodName, DexItemFactory.this.classDescriptor, new DexString[]{DexItemFactory.this.stringDescriptor, DexItemFactory.this.booleanDescriptor, DexItemFactory.this.classLoaderDescriptor});
            this.getName = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getNameName, DexItemFactory.this.stringDescriptor, DexString.EMPTY_ARRAY);
            this.getCanonicalName = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getCanonicalNameName, DexItemFactory.this.stringDescriptor, DexString.EMPTY_ARRAY);
            this.getSimpleName = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getSimpleNameName, DexItemFactory.this.stringDescriptor, DexString.EMPTY_ARRAY);
            this.getTypeName = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getTypeNameName, DexItemFactory.this.stringDescriptor, DexString.EMPTY_ARRAY);
            this.getConstructor = DexItemFactory.this.createMethod(DexItemFactory.this.classType, DexItemFactory.this.createProto(DexItemFactory.this.constructorType, DexItemFactory.this.classArrayType), "getConstructor");
            this.getDeclaredConstructor = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getDeclaredConstructorName, DexItemFactory.this.constructorDescriptor, new DexString[]{DexItemFactory.this.classArrayDescriptor});
            this.getField = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getFieldName, DexItemFactory.this.fieldDescriptor, new DexString[]{DexItemFactory.this.stringDescriptor});
            this.getDeclaredField = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getDeclaredFieldName, DexItemFactory.this.fieldDescriptor, new DexString[]{DexItemFactory.this.stringDescriptor});
            this.getMethod = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getMethodName, DexItemFactory.this.methodDescriptor, new DexString[]{DexItemFactory.this.stringDescriptor, DexItemFactory.this.classArrayDescriptor});
            this.getDeclaredMethod = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getDeclaredMethodName, DexItemFactory.this.methodDescriptor, new DexString[]{DexItemFactory.this.stringDescriptor, DexItemFactory.this.classArrayDescriptor});
            this.newInstance = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.newInstanceName, DexItemFactory.this.objectDescriptor, DexString.EMPTY_ARRAY);
            this.getMembers = ImmutableSet.of(this.getField, this.getDeclaredField, this.getMethod, this.getDeclaredMethod);
            this.getNames = ImmutableSet.of(this.getName, this.getCanonicalName, this.getSimpleName, this.getTypeName);
        }

        public boolean isReflectiveClassLookup(DexMethod method) {
            return method == this.forName || method == this.forName3;
        }

        public boolean isReflectiveMemberLookup(DexMethod method) {
            return this.getMembers.contains(method);
        }

        public boolean isReflectiveNameLookup(DexMethod method) {
            return this.getNames.contains(method);
        }
    }

    public class ObjectsMethods {
        public final DexMethod equals;
        public final DexMethod hashCode;
        public final DexMethod isNull;
        public final DexMethod nonNull;
        public final DexMethod requireNonNull;
        public final DexMethod requireNonNullWithMessage;
        public final DexMethod requireNonNullWithMessageSupplier;
        public final DexMethod requireNonNullElse;
        public final DexMethod requireNonNullElseGet;
        public final DexMethod toStringWithObject;
        public final DexMethod toStringWithObjectAndNullDefault;

        private ObjectsMethods() {
            this.equals = DexItemFactory.this.createMethod(DexItemFactory.this.objectsType, DexItemFactory.this.createProto(DexItemFactory.this.booleanType, DexItemFactory.this.objectType, DexItemFactory.this.objectType), "equals");
            this.hashCode = DexItemFactory.this.createMethod(DexItemFactory.this.objectsType, DexItemFactory.this.createProto(DexItemFactory.this.intType, DexItemFactory.this.objectType), "hashCode");
            this.isNull = DexItemFactory.this.createMethod(DexItemFactory.this.objectsType, DexItemFactory.this.createProto(DexItemFactory.this.booleanType, DexItemFactory.this.objectType), "isNull");
            this.nonNull = DexItemFactory.this.createMethod(DexItemFactory.this.objectsType, DexItemFactory.this.createProto(DexItemFactory.this.booleanType, DexItemFactory.this.objectType), "nonNull");
            this.requireNonNullElse = DexItemFactory.this.createMethod(DexItemFactory.this.objectsType, DexItemFactory.this.createProto(DexItemFactory.this.objectType, DexItemFactory.this.objectType, DexItemFactory.this.objectType), "requireNonNullElse");
            this.requireNonNullElseGet = DexItemFactory.this.createMethod(DexItemFactory.this.objectsType, DexItemFactory.this.createProto(DexItemFactory.this.objectType, DexItemFactory.this.objectType, DexItemFactory.this.supplierType), "requireNonNullElseGet");
            this.toStringWithObject = DexItemFactory.this.createMethod(DexItemFactory.this.objectsType, DexItemFactory.this.createProto(DexItemFactory.this.stringType, DexItemFactory.this.objectType), "toString");
            this.toStringWithObjectAndNullDefault = DexItemFactory.this.createMethod(DexItemFactory.this.objectsType, DexItemFactory.this.createProto(DexItemFactory.this.stringType, DexItemFactory.this.objectType, DexItemFactory.this.stringType), "toString");
            DexString requireNonNullMethodName = DexItemFactory.this.createString("requireNonNull");
            this.requireNonNull = DexItemFactory.this.createMethod(DexItemFactory.this.objectsType, DexItemFactory.this.createProto(DexItemFactory.this.objectType, DexItemFactory.this.objectType), requireNonNullMethodName);
            this.requireNonNullWithMessage = DexItemFactory.this.createMethod(DexItemFactory.this.objectsType, DexItemFactory.this.createProto(DexItemFactory.this.objectType, DexItemFactory.this.objectType, DexItemFactory.this.stringType), requireNonNullMethodName);
            this.requireNonNullWithMessageSupplier = DexItemFactory.this.createMethod(DexItemFactory.this.objectsType, DexItemFactory.this.createProto(DexItemFactory.this.objectType, DexItemFactory.this.objectType, DexItemFactory.this.supplierType), requireNonNullMethodName);
        }

        public boolean isRequireNonNullMethod(DexMethod method) {
            return method == this.requireNonNull || method == this.requireNonNullWithMessage || method == this.requireNonNullWithMessageSupplier || method == this.requireNonNullElse || method == this.requireNonNullElseGet;
        }

        public boolean isToStringMethod(DexMethod method) {
            return method == this.toStringWithObject || method == this.toStringWithObjectAndNullDefault;
        }

        public Iterable<DexMethod> requireNonNullMethods() {
            return ImmutableList.of(this.requireNonNull, this.requireNonNullWithMessage, this.requireNonNullWithMessageSupplier);
        }
    }

    public class BufferMembers {
        public final DexMethod positionArg;
        public final DexMethod limitArg;
        public final DexMethod mark;
        public final DexMethod reset;
        public final DexMethod clear;
        public final DexMethod flip;
        public final DexMethod rewind;
        public final List<DexMethod> bufferCovariantMethods;

        public BufferMembers() {
            this.positionArg = DexItemFactory.this.createMethod(DexItemFactory.this.bufferType, DexItemFactory.this.createProto(DexItemFactory.this.bufferType, DexItemFactory.this.intType), "position");
            this.limitArg = DexItemFactory.this.createMethod(DexItemFactory.this.bufferType, DexItemFactory.this.createProto(DexItemFactory.this.bufferType, DexItemFactory.this.intType), "limit");
            this.mark = DexItemFactory.this.createMethod(DexItemFactory.this.bufferType, DexItemFactory.this.createProto(DexItemFactory.this.bufferType, new DexType[0]), "mark");
            this.reset = DexItemFactory.this.createMethod(DexItemFactory.this.bufferType, DexItemFactory.this.createProto(DexItemFactory.this.bufferType, new DexType[0]), "reset");
            this.clear = DexItemFactory.this.createMethod(DexItemFactory.this.bufferType, DexItemFactory.this.createProto(DexItemFactory.this.bufferType, new DexType[0]), "clear");
            this.flip = DexItemFactory.this.createMethod(DexItemFactory.this.bufferType, DexItemFactory.this.createProto(DexItemFactory.this.bufferType, new DexType[0]), "flip");
            this.rewind = DexItemFactory.this.createMethod(DexItemFactory.this.bufferType, DexItemFactory.this.createProto(DexItemFactory.this.bufferType, new DexType[0]), "rewind");
            this.bufferCovariantMethods = ImmutableList.of(this.positionArg, this.limitArg, this.mark, this.reset, this.clear, this.flip, this.rewind);
        }
    }

    public class ObjectMembers {
        public final DexField classIdField;
        public final DexField clinitField;
        public final DexMethod clone;
        public final DexMethod equals;
        public final DexMethod getClass;
        public final DexMethod hashCode;
        public final DexMethod constructor;
        public final DexMethod finalize;
        public final DexMethod toString;
        public final DexMethod notify;
        public final DexMethod notifyAll;
        public final DexMethod wait;
        public final DexMethod waitLong;
        public final DexMethod waitLongInt;

        private ObjectMembers() {
            this.classIdField = DexItemFactory.this.createField(DexItemFactory.this.objectType, DexItemFactory.this.intType, "$r8$classId");
            this.clinitField = DexItemFactory.this.createField(DexItemFactory.this.objectType, DexItemFactory.this.intType, "$r8$clinit");
            this.equals = DexItemFactory.this.createMethod(DexItemFactory.this.objectType, DexItemFactory.this.createProto(DexItemFactory.this.booleanType, DexItemFactory.this.objectType), "equals");
            this.hashCode = DexItemFactory.this.createMethod(DexItemFactory.this.objectType, DexItemFactory.this.createProto(DexItemFactory.this.intType, new DexType[0]), "hashCode");
            this.clone = DexItemFactory.this.createMethod(DexItemFactory.this.objectType, DexItemFactory.this.createProto(DexItemFactory.this.objectType, new DexType[0]), DexItemFactory.this.cloneMethodName);
            this.getClass = DexItemFactory.this.createMethod(DexItemFactory.this.objectDescriptor, DexItemFactory.this.getClassMethodName, DexItemFactory.this.classDescriptor, DexString.EMPTY_ARRAY);
            this.constructor = DexItemFactory.this.createMethod(DexItemFactory.this.objectDescriptor, DexItemFactory.this.constructorMethodName, DexItemFactory.this.voidType.descriptor, DexString.EMPTY_ARRAY);
            this.finalize = DexItemFactory.this.createMethod(DexItemFactory.this.objectDescriptor, DexItemFactory.this.finalizeMethodName, DexItemFactory.this.voidType.descriptor, DexString.EMPTY_ARRAY);
            this.toString = DexItemFactory.this.createMethod(DexItemFactory.this.objectDescriptor, DexItemFactory.this.toStringMethodName, DexItemFactory.this.stringDescriptor, DexString.EMPTY_ARRAY);
            this.notify = DexItemFactory.this.createMethod(DexItemFactory.this.objectDescriptor, DexItemFactory.this.notifyMethodName, DexItemFactory.this.voidDescriptor, DexString.EMPTY_ARRAY);
            this.notifyAll = DexItemFactory.this.createMethod(DexItemFactory.this.objectDescriptor, DexItemFactory.this.notifyAllMethodName, DexItemFactory.this.voidDescriptor, DexString.EMPTY_ARRAY);
            this.wait = DexItemFactory.this.createMethod(DexItemFactory.this.objectDescriptor, DexItemFactory.this.waitMethodName, DexItemFactory.this.voidDescriptor, DexString.EMPTY_ARRAY);
            this.waitLong = DexItemFactory.this.createMethod(DexItemFactory.this.objectDescriptor, DexItemFactory.this.waitMethodName, DexItemFactory.this.voidDescriptor, new DexString[]{DexItemFactory.this.longDescriptor});
            this.waitLongInt = DexItemFactory.this.createMethod(DexItemFactory.this.objectDescriptor, DexItemFactory.this.waitMethodName, DexItemFactory.this.voidDescriptor, new DexString[]{DexItemFactory.this.longDescriptor, DexItemFactory.this.intDescriptor});
        }

        public boolean isObjectMember(DexMethod method) {
            return method.match(this.clone) || method.match(this.getClass) || method.match(this.constructor) || method.match(this.finalize) || method.match(this.toString) || method.match(this.hashCode) || method.match(this.equals) || method.match(this.notify) || method.match(this.notifyAll) || method.match(this.wait) || method.match(this.waitLong) || method.match(this.waitLongInt);
        }

        public DexMethod matchingPublicObjectMember(DexMethod method) {
            switch (method.getName().byteAt(0)) {
                case 116: {
                    if (!method.match(this.toString)) break;
                    return this.toString;
                }
                case 104: {
                    if (!method.match(this.hashCode)) break;
                    return this.hashCode;
                }
                case 101: {
                    if (!method.match(this.equals)) break;
                    return this.equals;
                }
                case 103: {
                    if (!method.match(this.getClass)) break;
                    return this.getClass;
                }
                case 110: {
                    if (method.match(this.notify)) {
                        return this.notify;
                    }
                    if (!method.match(this.notifyAll)) break;
                    return this.notifyAll;
                }
                case 119: {
                    if (method.match(this.wait)) {
                        return this.wait;
                    }
                    if (method.match(this.waitLong)) {
                        return this.waitLong;
                    }
                    if (!method.match(this.waitLongInt)) break;
                    return this.waitLongInt;
                }
                default: {
                    return null;
                }
            }
            return null;
        }
    }

    public class ObjectMethodsMembers {
        public final DexMethod bootstrap;

        public ObjectMethodsMembers() {
            this.bootstrap = DexItemFactory.this.createMethod(DexItemFactory.this.objectMethodsType, DexItemFactory.this.createProto(DexItemFactory.this.objectType, DexItemFactory.this.lookupType, DexItemFactory.this.stringType, DexItemFactory.this.typeDescriptorType, DexItemFactory.this.classType, DexItemFactory.this.stringType, DexItemFactory.this.createArrayType(1, DexItemFactory.this.methodHandleType)), "bootstrap");
        }
    }

    public class RecordMembers {
        public final DexMethod constructor;
        public final DexMethod equals;
        public final DexMethod hashCode;
        public final DexMethod toString;

        public RecordMembers() {
            this.constructor = DexItemFactory.this.createMethod(DexItemFactory.this.recordType, DexItemFactory.this.createProto(DexItemFactory.this.voidType, new DexType[0]), "<init>");
            this.equals = DexItemFactory.this.createMethod(DexItemFactory.this.recordType, DexItemFactory.this.createProto(DexItemFactory.this.booleanType, DexItemFactory.this.objectType), "equals");
            this.hashCode = DexItemFactory.this.createMethod(DexItemFactory.this.recordType, DexItemFactory.this.createProto(DexItemFactory.this.intType, new DexType[0]), "hashCode");
            this.toString = DexItemFactory.this.createMethod(DexItemFactory.this.recordType, DexItemFactory.this.createProto(DexItemFactory.this.stringType, new DexType[0]), "toString");
        }
    }

    public class AssertionErrorMethods {
        public final DexMethod initMessage;
        public final DexMethod initMessageAndCause;

        private AssertionErrorMethods() {
            this.initMessage = DexItemFactory.this.createMethod(DexItemFactory.this.assertionErrorDescriptor, DexItemFactory.this.constructorMethodName, DexItemFactory.this.voidDescriptor, new DexString[]{DexItemFactory.this.objectDescriptor});
            this.initMessageAndCause = DexItemFactory.this.createMethod(DexItemFactory.this.assertionErrorDescriptor, DexItemFactory.this.constructorMethodName, DexItemFactory.this.voidDescriptor, new DexString[]{DexItemFactory.this.stringDescriptor, DexItemFactory.this.throwableDescriptor});
        }
    }

    public class ThrowableMethods {
        public final DexMethod addSuppressed;
        public final DexMethod getMessage;
        public final DexMethod getSuppressed;
        public final DexMethod initCause;

        private ThrowableMethods() {
            this.addSuppressed = DexItemFactory.this.createMethod(DexItemFactory.this.throwableDescriptor, DexItemFactory.this.createString("addSuppressed"), DexItemFactory.this.voidDescriptor, new DexString[]{DexItemFactory.this.throwableDescriptor});
            this.getSuppressed = DexItemFactory.this.createMethod(DexItemFactory.this.throwableDescriptor, DexItemFactory.this.createString("getSuppressed"), DexItemFactory.this.throwableArrayDescriptor, DexString.EMPTY_ARRAY);
            this.initCause = DexItemFactory.this.createMethod(DexItemFactory.this.throwableDescriptor, DexItemFactory.this.createString("initCause"), DexItemFactory.this.throwableDescriptor, new DexString[]{DexItemFactory.this.throwableDescriptor});
            this.getMessage = DexItemFactory.this.createMethod(DexItemFactory.this.throwableDescriptor, DexItemFactory.this.createString("getMessage"), DexItemFactory.this.stringDescriptor, DexString.EMPTY_ARRAY);
        }
    }

    public class StringConcatFactoryMembers {
        public final DexMethod makeConcat;
        public final DexMethod makeConcatWithConstants;

        public StringConcatFactoryMembers() {
            this.makeConcat = DexItemFactory.this.createMethod(DexItemFactory.this.stringConcatFactoryType, DexItemFactory.this.createProto(DexItemFactory.this.callSiteType, DexItemFactory.this.lookupType, DexItemFactory.this.stringType, DexItemFactory.this.methodTypeType), DexItemFactory.this.createString("makeConcat"));
            this.makeConcatWithConstants = DexItemFactory.this.createMethod(DexItemFactory.this.stringConcatFactoryType, DexItemFactory.this.createProto(DexItemFactory.this.callSiteType, DexItemFactory.this.lookupType, DexItemFactory.this.stringType, DexItemFactory.this.methodTypeType, DexItemFactory.this.stringType, DexItemFactory.this.objectArrayType), DexItemFactory.this.createString("makeConcatWithConstants"));
        }
    }

    public class IntegerMembers
    extends LibraryMembers {
        public final DexField TYPE;
        public final DexMethod toString;

        public IntegerMembers() {
            this.TYPE = DexItemFactory.this.createField(DexItemFactory.this.boxedIntType, DexItemFactory.this.classType, "TYPE");
            this.toString = DexItemFactory.this.createMethod(DexItemFactory.this.boxedIntType, DexItemFactory.this.createProto(DexItemFactory.this.stringType, new DexType[0]), "toString");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.TYPE);
        }
    }

    public class DoubleMembers {
        public final DexMethod isNaN;
        public final DexMethod toString;

        private DoubleMembers() {
            this.toString = DexItemFactory.this.createMethod(DexItemFactory.this.boxedDoubleType, DexItemFactory.this.createProto(DexItemFactory.this.stringType, new DexType[0]), "toString");
            this.isNaN = DexItemFactory.this.createMethod(DexItemFactory.this.boxedDoubleDescriptor, DexItemFactory.this.createString("isNaN"), DexItemFactory.this.booleanDescriptor, new DexString[]{DexItemFactory.this.doubleDescriptor});
        }
    }

    public class LongMembers
    extends LibraryMembers {
        public final DexField TYPE;
        public final DexMethod compare;
        public final DexMethod toString;

        private LongMembers() {
            this.TYPE = DexItemFactory.this.createField(DexItemFactory.this.boxedLongType, DexItemFactory.this.classType, "TYPE");
            this.toString = DexItemFactory.this.createMethod(DexItemFactory.this.boxedLongType, DexItemFactory.this.createProto(DexItemFactory.this.stringType, new DexType[0]), "toString");
            this.compare = DexItemFactory.this.createMethod(DexItemFactory.this.boxedLongDescriptor, DexItemFactory.this.createString("compare"), DexItemFactory.this.intDescriptor, new DexString[]{DexItemFactory.this.longDescriptor, DexItemFactory.this.longDescriptor});
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.TYPE);
        }
    }

    public class JavaUtilLoggingLevelMembers
    extends LibraryMembers {
        public final DexField CONFIG;
        public final DexField FINE;
        public final DexField FINER;
        public final DexField FINEST;
        public final DexField SEVERE;
        public final DexField WARNING;

        public JavaUtilLoggingLevelMembers() {
            this.CONFIG = DexItemFactory.this.createField(DexItemFactory.this.javaUtilLoggingLevelType, DexItemFactory.this.javaUtilLoggingLevelType, "CONFIG");
            this.FINE = DexItemFactory.this.createField(DexItemFactory.this.javaUtilLoggingLevelType, DexItemFactory.this.javaUtilLoggingLevelType, "FINE");
            this.FINER = DexItemFactory.this.createField(DexItemFactory.this.javaUtilLoggingLevelType, DexItemFactory.this.javaUtilLoggingLevelType, "FINER");
            this.FINEST = DexItemFactory.this.createField(DexItemFactory.this.javaUtilLoggingLevelType, DexItemFactory.this.javaUtilLoggingLevelType, "FINEST");
            this.SEVERE = DexItemFactory.this.createField(DexItemFactory.this.javaUtilLoggingLevelType, DexItemFactory.this.javaUtilLoggingLevelType, "SEVERE");
            this.WARNING = DexItemFactory.this.createField(DexItemFactory.this.javaUtilLoggingLevelType, DexItemFactory.this.javaUtilLoggingLevelType, "WARNING");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.CONFIG);
            consumer.accept(this.FINE);
            consumer.accept(this.FINER);
            consumer.accept(this.FINEST);
            consumer.accept(this.SEVERE);
            consumer.accept(this.WARNING);
        }
    }

    public class JavaUtilLocaleMembers
    extends LibraryMembers {
        public final DexField ENGLISH;
        public final DexField ROOT;
        public final DexField US;

        public JavaUtilLocaleMembers() {
            this.ENGLISH = DexItemFactory.this.createField(DexItemFactory.this.javaUtilLocaleType, DexItemFactory.this.javaUtilLocaleType, "ENGLISH");
            this.ROOT = DexItemFactory.this.createField(DexItemFactory.this.javaUtilLocaleType, DexItemFactory.this.javaUtilLocaleType, "ROOT");
            this.US = DexItemFactory.this.createField(DexItemFactory.this.javaUtilLocaleType, DexItemFactory.this.javaUtilLocaleType, "US");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.ENGLISH);
            consumer.accept(this.ROOT);
            consumer.accept(this.US);
        }
    }

    public class JavaUtilConcurrentTimeUnitMembers
    extends LibraryMembers {
        public final DexField DAYS;
        public final DexField HOURS;
        public final DexField MICROSECONDS;
        public final DexField MILLISECONDS;
        public final DexField MINUTES;
        public final DexField NANOSECONDS;
        public final DexField SECONDS;

        public JavaUtilConcurrentTimeUnitMembers() {
            this.DAYS = DexItemFactory.this.createField(DexItemFactory.this.javaUtilConcurrentTimeUnitType, DexItemFactory.this.javaUtilConcurrentTimeUnitType, "DAYS");
            this.HOURS = DexItemFactory.this.createField(DexItemFactory.this.javaUtilConcurrentTimeUnitType, DexItemFactory.this.javaUtilConcurrentTimeUnitType, "HOURS");
            this.MICROSECONDS = DexItemFactory.this.createField(DexItemFactory.this.javaUtilConcurrentTimeUnitType, DexItemFactory.this.javaUtilConcurrentTimeUnitType, "MICROSECONDS");
            this.MILLISECONDS = DexItemFactory.this.createField(DexItemFactory.this.javaUtilConcurrentTimeUnitType, DexItemFactory.this.javaUtilConcurrentTimeUnitType, "MILLISECONDS");
            this.MINUTES = DexItemFactory.this.createField(DexItemFactory.this.javaUtilConcurrentTimeUnitType, DexItemFactory.this.javaUtilConcurrentTimeUnitType, "MINUTES");
            this.NANOSECONDS = DexItemFactory.this.createField(DexItemFactory.this.javaUtilConcurrentTimeUnitType, DexItemFactory.this.javaUtilConcurrentTimeUnitType, "NANOSECONDS");
            this.SECONDS = DexItemFactory.this.createField(DexItemFactory.this.javaUtilConcurrentTimeUnitType, DexItemFactory.this.javaUtilConcurrentTimeUnitType, "SECONDS");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.DAYS);
            consumer.accept(this.HOURS);
            consumer.accept(this.MICROSECONDS);
            consumer.accept(this.MILLISECONDS);
            consumer.accept(this.MINUTES);
            consumer.accept(this.NANOSECONDS);
            consumer.accept(this.SECONDS);
        }
    }

    public class JavaUtilComparatorMembers
    extends LibraryMembers {
        public final DexField EMPTY_LIST;
        public final DexField EMPTY_SET;

        public JavaUtilComparatorMembers() {
            this.EMPTY_LIST = DexItemFactory.this.createField(DexItemFactory.this.javaUtilCollectionsType, DexItemFactory.this.javaUtilListType, "EMPTY_LIST");
            this.EMPTY_SET = DexItemFactory.this.createField(DexItemFactory.this.javaUtilCollectionsType, DexItemFactory.this.javaUtilSetType, "EMPTY_SET");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.EMPTY_LIST);
            consumer.accept(this.EMPTY_SET);
        }
    }

    public class JavaUtilArraysMethods {
        public final DexMethod asList;
        public final DexMethod equalsObjectArray;

        private JavaUtilArraysMethods() {
            this.asList = DexItemFactory.this.createMethod(DexItemFactory.this.arraysDescriptor, DexItemFactory.this.createString("asList"), DexItemFactory.this.listDescriptor, new DexString[]{DexItemFactory.this.objectArrayDescriptor});
            this.equalsObjectArray = DexItemFactory.this.createMethod(DexItemFactory.this.arraysDescriptor, DexItemFactory.this.equalsMethodName, DexItemFactory.this.booleanDescriptor, new DexString[]{DexItemFactory.this.objectArrayDescriptor, DexItemFactory.this.objectArrayDescriptor});
        }
    }

    public class JavaNioByteOrderMembers
    extends LibraryMembers {
        public final DexField LITTLE_ENDIAN;
        public final DexField BIG_ENDIAN;

        public JavaNioByteOrderMembers() {
            this.LITTLE_ENDIAN = DexItemFactory.this.createField(DexItemFactory.this.javaNioByteOrderType, DexItemFactory.this.javaNioByteOrderType, "LITTLE_ENDIAN");
            this.BIG_ENDIAN = DexItemFactory.this.createField(DexItemFactory.this.javaNioByteOrderType, DexItemFactory.this.javaNioByteOrderType, "BIG_ENDIAN");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.LITTLE_ENDIAN);
            consumer.accept(this.BIG_ENDIAN);
        }
    }

    public class JavaMathBigIntegerMembers
    extends LibraryMembers {
        public final DexField ONE;
        public final DexField ZERO;

        public JavaMathBigIntegerMembers() {
            this.ONE = DexItemFactory.this.createField(DexItemFactory.this.javaMathBigIntegerType, DexItemFactory.this.javaMathBigIntegerType, "ONE");
            this.ZERO = DexItemFactory.this.createField(DexItemFactory.this.javaMathBigIntegerType, DexItemFactory.this.javaMathBigIntegerType, "ZERO");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.ONE);
            consumer.accept(this.ZERO);
        }
    }

    public class JavaIoFileMembers
    extends LibraryMembers {
        public final DexField pathSeparator;
        public final DexField separator;

        public JavaIoFileMembers() {
            this.pathSeparator = DexItemFactory.this.createField(DexItemFactory.this.javaIoFileType, DexItemFactory.this.stringType, "pathSeparator");
            this.separator = DexItemFactory.this.createField(DexItemFactory.this.javaIoFileType, DexItemFactory.this.stringType, "separator");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.pathSeparator);
            consumer.accept(this.separator);
        }
    }

    public class FloatMembers
    extends LibraryMembers {
        public final DexField TYPE;
        public final DexMethod toString;

        private FloatMembers() {
            this.TYPE = DexItemFactory.this.createField(DexItemFactory.this.boxedFloatType, DexItemFactory.this.classType, "TYPE");
            this.toString = DexItemFactory.this.createMethod(DexItemFactory.this.boxedFloatType, DexItemFactory.this.createProto(DexItemFactory.this.stringType, new DexType[0]), "toString");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.TYPE);
        }
    }

    public class CharMembers
    extends LibraryMembers {
        public final DexMethod toString;

        private CharMembers() {
            this.toString = DexItemFactory.this.createMethod(DexItemFactory.this.boxedCharType, DexItemFactory.this.createProto(DexItemFactory.this.stringType, new DexType[0]), "toString");
        }
    }

    public class ByteMembers
    extends LibraryMembers {
        public final DexMethod byteValue;
        public final DexMethod toString;
        public final DexMethod valueOf;

        private ByteMembers() {
            this.byteValue = DexItemFactory.this.createMethod(DexItemFactory.this.boxedByteType, DexItemFactory.this.createProto(DexItemFactory.this.byteType, new DexType[0]), "byteValue");
            this.toString = DexItemFactory.this.createMethod(DexItemFactory.this.boxedByteType, DexItemFactory.this.createProto(DexItemFactory.this.stringType, new DexType[0]), "toString");
            this.valueOf = DexItemFactory.this.createMethod(DexItemFactory.this.boxedByteType, DexItemFactory.this.createProto(DexItemFactory.this.boxedByteType, DexItemFactory.this.byteType), "valueOf");
        }
    }

    public class BooleanMembers
    extends LibraryMembers {
        public final DexField FALSE;
        public final DexField TRUE;
        public final DexField TYPE;
        public final DexMethod booleanValue;
        public final DexMethod parseBoolean;
        public final DexMethod valueOf;
        public final DexMethod toString;

        private BooleanMembers() {
            this.FALSE = DexItemFactory.this.createField(DexItemFactory.this.boxedBooleanType, DexItemFactory.this.boxedBooleanType, "FALSE");
            this.TRUE = DexItemFactory.this.createField(DexItemFactory.this.boxedBooleanType, DexItemFactory.this.boxedBooleanType, "TRUE");
            this.TYPE = DexItemFactory.this.createField(DexItemFactory.this.boxedBooleanType, DexItemFactory.this.classType, "TYPE");
            this.booleanValue = DexItemFactory.this.createMethod(DexItemFactory.this.boxedBooleanType, DexItemFactory.this.createProto(DexItemFactory.this.booleanType, new DexType[0]), "booleanValue");
            this.parseBoolean = DexItemFactory.this.createMethod(DexItemFactory.this.boxedBooleanType, DexItemFactory.this.createProto(DexItemFactory.this.booleanType, DexItemFactory.this.stringType), "parseBoolean");
            this.valueOf = DexItemFactory.this.createMethod(DexItemFactory.this.boxedBooleanType, DexItemFactory.this.createProto(DexItemFactory.this.boxedBooleanType, DexItemFactory.this.booleanType), "valueOf");
            this.toString = DexItemFactory.this.createMethod(DexItemFactory.this.boxedBooleanType, DexItemFactory.this.createProto(DexItemFactory.this.stringType, new DexType[0]), "toString");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.FALSE);
            consumer.accept(this.TRUE);
            consumer.accept(this.TYPE);
        }
    }

    public class AndroidUtilSparseArrayMembers
    extends LibraryMembers {
        public final DexMethod put;
        public final DexMethod set;

        public AndroidUtilSparseArrayMembers() {
            this.put = DexItemFactory.this.createMethod(DexItemFactory.this.androidUtilSparseArrayType, DexItemFactory.this.createProto(DexItemFactory.this.voidType, DexItemFactory.this.intType, DexItemFactory.this.objectType), "put");
            this.set = DexItemFactory.this.createMethod(DexItemFactory.this.androidUtilSparseArrayType, DexItemFactory.this.createProto(DexItemFactory.this.voidType, DexItemFactory.this.intType, DexItemFactory.this.objectType), "set");
        }
    }

    public class AndroidViewViewMembers
    extends LibraryMembers {
        public final DexField TRANSLATION_Z;
        public final DexField EMPTY_STATE_SET;
        public final DexField ENABLED_STATE_SET;
        public final DexField PRESSED_ENABLED_STATE_SET;
        public final DexField SELECTED_STATE_SET;

        public AndroidViewViewMembers() {
            this.TRANSLATION_Z = DexItemFactory.this.createField(DexItemFactory.this.androidViewViewType, DexItemFactory.this.androidUtilPropertyType, "TRANSLATION_Z");
            this.EMPTY_STATE_SET = DexItemFactory.this.createField(DexItemFactory.this.androidViewViewType, DexItemFactory.this.intArrayType, "EMPTY_STATE_SET");
            this.ENABLED_STATE_SET = DexItemFactory.this.createField(DexItemFactory.this.androidViewViewType, DexItemFactory.this.intArrayType, "ENABLED_STATE_SET");
            this.PRESSED_ENABLED_STATE_SET = DexItemFactory.this.createField(DexItemFactory.this.androidViewViewType, DexItemFactory.this.intArrayType, "PRESSED_ENABLED_STATE_SET");
            this.SELECTED_STATE_SET = DexItemFactory.this.createField(DexItemFactory.this.androidViewViewType, DexItemFactory.this.intArrayType, "SELECTED_STATE_SET");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.TRANSLATION_Z);
            consumer.accept(this.EMPTY_STATE_SET);
            consumer.accept(this.ENABLED_STATE_SET);
            consumer.accept(this.PRESSED_ENABLED_STATE_SET);
            consumer.accept(this.SELECTED_STATE_SET);
        }
    }

    public class AndroidSystemOsConstantsMembers
    extends LibraryMembers {
        public final DexField S_IRUSR;
        public final DexField S_IXUSR;

        public AndroidSystemOsConstantsMembers() {
            this.S_IRUSR = DexItemFactory.this.createField(DexItemFactory.this.androidSystemOsConstantsType, DexItemFactory.this.intType, "S_IRUSR");
            this.S_IXUSR = DexItemFactory.this.createField(DexItemFactory.this.androidSystemOsConstantsType, DexItemFactory.this.intType, "S_IXUSR");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.S_IRUSR);
            consumer.accept(this.S_IXUSR);
        }
    }

    public class AndroidOsBundleMembers
    extends LibraryMembers {
        public final DexField CREATOR;
        public final DexField EMPTY;

        public AndroidOsBundleMembers() {
            this.CREATOR = DexItemFactory.this.createField(DexItemFactory.this.androidOsBundleType, DexItemFactory.this.androidOsParcelableCreatorType, "CREATOR");
            this.EMPTY = DexItemFactory.this.createField(DexItemFactory.this.androidOsBundleType, DexItemFactory.this.androidOsBundleType, "EMPTY");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.CREATOR);
            consumer.accept(this.EMPTY);
        }
    }

    public class AndroidOsBuildVersionMembers
    extends LibraryMembers {
        public final DexField CODENAME;
        public final DexField RELEASE;
        public final DexField SDK;
        public final DexField SDK_INT;
        public final DexField SECURITY_PATCH;

        public AndroidOsBuildVersionMembers() {
            this.CODENAME = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildVersionType, DexItemFactory.this.stringType, "CODENAME");
            this.RELEASE = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildVersionType, DexItemFactory.this.stringType, "RELEASE");
            this.SDK = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildVersionType, DexItemFactory.this.stringType, "SDK");
            this.SDK_INT = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildVersionType, DexItemFactory.this.intType, "SDK_INT");
            this.SECURITY_PATCH = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildVersionType, DexItemFactory.this.stringType, "SECURITY_PATCH");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.CODENAME);
            consumer.accept(this.RELEASE);
            consumer.accept(this.SDK);
            consumer.accept(this.SDK_INT);
            consumer.accept(this.SECURITY_PATCH);
        }
    }

    public class AndroidOsBuildMembers
    extends LibraryMembers {
        public final DexField BOOTLOADER;
        public final DexField BRAND;
        public final DexField CPU_ABI;
        public final DexField CPU_ABI2;
        public final DexField DEVICE;
        public final DexField DISPLAY;
        public final DexField FINGERPRINT;
        public final DexField HARDWARE;
        public final DexField MANUFACTURER;
        public final DexField MODEL;
        public final DexField PRODUCT;
        public final DexField SERIAL;
        public final DexField SUPPORTED_32_BIT_ABIS;
        public final DexField SUPPORTED_64_BIT_ABIS;
        public final DexField SUPPORTED_ABIS;
        public final DexField TIME;
        public final DexField TYPE;

        public AndroidOsBuildMembers() {
            this.BOOTLOADER = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringType, "BOOTLOADER");
            this.BRAND = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringType, "BRAND");
            this.CPU_ABI = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringType, "CPU_ABI");
            this.CPU_ABI2 = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringType, "CPU_ABI2");
            this.DEVICE = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringType, "DEVICE");
            this.DISPLAY = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringType, "DISPLAY");
            this.FINGERPRINT = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringType, "FINGERPRINT");
            this.HARDWARE = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringType, "HARDWARE");
            this.MANUFACTURER = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringType, "MANUFACTURER");
            this.MODEL = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringType, "MODEL");
            this.PRODUCT = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringType, "PRODUCT");
            this.SERIAL = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringType, "SERIAL");
            this.SUPPORTED_32_BIT_ABIS = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringArrayType, "SUPPORTED_32_BIT_ABIS");
            this.SUPPORTED_64_BIT_ABIS = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringArrayType, "SUPPORTED_64_BIT_ABIS");
            this.SUPPORTED_ABIS = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringArrayType, "SUPPORTED_ABIS");
            this.TIME = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.longType, "TIME");
            this.TYPE = DexItemFactory.this.createField(DexItemFactory.this.androidOsBuildType, DexItemFactory.this.stringType, "TYPE");
        }

        @Override
        public void forEachFinalField(Consumer<DexField> consumer) {
            consumer.accept(this.BOOTLOADER);
            consumer.accept(this.BRAND);
            consumer.accept(this.CPU_ABI);
            consumer.accept(this.CPU_ABI2);
            consumer.accept(this.DEVICE);
            consumer.accept(this.DISPLAY);
            consumer.accept(this.FINGERPRINT);
            consumer.accept(this.HARDWARE);
            consumer.accept(this.MANUFACTURER);
            consumer.accept(this.MODEL);
            consumer.accept(this.PRODUCT);
            consumer.accept(this.SERIAL);
            consumer.accept(this.SUPPORTED_32_BIT_ABIS);
            consumer.accept(this.SUPPORTED_64_BIT_ABIS);
            consumer.accept(this.SUPPORTED_ABIS);
            consumer.accept(this.TIME);
            consumer.accept(this.TYPE);
        }
    }

    public static abstract class LibraryMembers {
        public void forEachFinalField(Consumer<DexField> consumer) {
        }
    }
}

