/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.HashingVisitor;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class DexMethod
extends DexMember<DexEncodedMethod, DexMethod> {
    public final DexProto proto;

    DexMethod(DexType holder, DexProto proto, DexString name, boolean skipNameValidationForTesting) {
        super(holder, name);
        this.proto = proto;
        if (!skipNameValidationForTesting && !name.isValidMethodName()) {
            throw new CompilationError("Method name '" + name + "' in class '" + holder.toSourceString() + "' cannot be represented in dex format.");
        }
    }

    private static void specify(StructuralSpecification<DexMethod, ?> spec) {
        ((StructuralSpecification)((StructuralSpecification)spec.withItem(DexMember::getHolderType)).withItem(DexMember::getName)).withItem(m3 -> m3.proto);
    }

    private String toSourceString(boolean includeHolder, boolean includeReturnType) {
        StringBuilder builder = new StringBuilder();
        if (includeReturnType) {
            builder.append(this.getReturnType().toSourceString()).append(" ");
        }
        if (includeHolder) {
            builder.append(this.holder.toSourceString()).append(".");
        }
        builder.append(this.name).append("(");
        for (int i = 0; i < this.getArity(); ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(this.proto.parameters.values[i].toSourceString());
        }
        return builder.append(")").toString();
    }

    @Override
    public int compareTo(DexReference other) {
        if (other.isDexMethod()) {
            return this.compareTo(other.asDexMethod());
        }
        int comparisonResult = this.getHolderType().compareTo(other.getContextType());
        return comparisonResult != 0 ? comparisonResult : 1;
    }

    @Override
    public StructuralMapping<DexMethod> getStructuralMapping() {
        return DexMethod::specify;
    }

    @Override
    public DexMethod self() {
        return this;
    }

    @Override
    public int acceptCompareTo(DexMethod other, CompareToVisitor visitor) {
        return visitor.visitDexMethod(this, other);
    }

    @Override
    public void acceptHashing(HashingVisitor visitor) {
        visitor.visitDexType(this.holder);
        visitor.visitDexString(this.name);
        this.getReferencedTypes().forEach(visitor::visitDexType);
    }

    public DexType getArgumentType(int argumentIndex, boolean isStatic) {
        if (isStatic) {
            return this.getParameter(argumentIndex);
        }
        if (argumentIndex == 0) {
            return this.getHolderType();
        }
        return this.getParameter(argumentIndex - 1);
    }

    public int getNumberOfArguments(boolean isStatic) {
        return this.getArity() + BooleanUtils.intValue(!isStatic);
    }

    public DexType getParameter(int index) {
        return this.proto.getParameter(index);
    }

    public DexTypeList getParameters() {
        return this.proto.parameters;
    }

    public DexProto getProto() {
        return this.proto;
    }

    public DexType getReturnType() {
        return this.proto.returnType;
    }

    @Override
    public <T> T apply(Function<DexField, T> fieldConsumer, Function<DexMethod, T> methodConsumer) {
        return methodConsumer.apply(this);
    }

    @Override
    public <T> T apply(Function<DexType, T> classConsumer, Function<DexField, T> fieldConsumer, Function<DexMethod, T> methodConsumer) {
        return methodConsumer.apply(this);
    }

    @Override
    public void accept(Consumer<DexType> classConsumer, Consumer<DexField> fieldConsumer, Consumer<DexMethod> methodConsumer) {
        methodConsumer.accept(this);
    }

    @Override
    public <T> void accept(BiConsumer<DexType, T> classConsumer, BiConsumer<DexField, T> fieldConsumer, BiConsumer<DexMethod, T> methodConsumer, T arg) {
        methodConsumer.accept(this, (DexMethod)arg);
    }

    public DexEncodedMethod lookupOnClass(DexClass clazz) {
        return clazz != null ? clazz.lookupMember(this) : null;
    }

    public DexClassAndMethod lookupMemberOnClass(DexClass clazz) {
        return clazz != null ? clazz.lookupClassMethod(this) : null;
    }

    public ProgramMethod lookupOnProgramClass(DexProgramClass clazz) {
        return clazz != null ? clazz.lookupProgramMethod(this) : null;
    }

    public String toString() {
        return this.toSourceString();
    }

    public MethodReference asMethodReference() {
        ArrayList<TypeReference> parameters = new ArrayList<TypeReference>();
        for (DexType value : this.proto.parameters.values) {
            parameters.add(Reference.typeFromDescriptor(value.toDescriptorString()));
        }
        String returnTypeDescriptor = this.proto.returnType.toDescriptorString();
        TypeReference returnType = returnTypeDescriptor.equals("V") ? null : Reference.typeFromDescriptor(returnTypeDescriptor);
        return Reference.method(Reference.classFromDescriptor(this.holder.toDescriptorString()), this.name.toString(), parameters, returnType);
    }

    public int getArity() {
        return this.proto.parameters.size();
    }

    public DexMethodSignature getSignature() {
        return DexMethodSignature.create(this);
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        if (this.collectIndexedItemsExceptName(indexedItems)) {
            this.collectIndexedItemsName(indexedItems);
        }
    }

    boolean collectIndexedItemsExceptName(IndexedItemCollection indexedItems) {
        if (indexedItems.addMethod(this)) {
            this.holder.collectIndexedItems(indexedItems);
            this.proto.collectIndexedItems(indexedItems);
            return true;
        }
        return false;
    }

    void collectIndexedItemsName(IndexedItemCollection indexedItems) {
        indexedItems.getRenamedName(this).collectIndexedItems(indexedItems);
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public boolean isDexMethod() {
        return true;
    }

    @Override
    public DexMethod asDexMethod() {
        return this;
    }

    @Override
    public Iterable<DexType> getReferencedTypes() {
        return this.proto.getTypes();
    }

    @Override
    public int computeHashCode() {
        return this.holder.hashCode() * 7 + this.proto.hashCode() * 29 + this.name.hashCode() * 31;
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexMethod) {
            DexMethod o = (DexMethod)other;
            return this.holder.equals(o.holder) && this.name.equals(o.name) && this.proto.equals(o.proto);
        }
        return false;
    }

    @Override
    public boolean match(DexMethod method) {
        return method == this || this.match(method.getProto(), method.getName());
    }

    @Override
    public boolean match(DexMethodSignature method) {
        return this.match(method.getProto(), method.getName());
    }

    public boolean match(DexProto methodProto, DexString methodName) {
        return this.proto == methodProto && this.name == methodName;
    }

    @Override
    public boolean match(DexEncodedMethod encodedMethod) {
        return this.match((DexMethod)encodedMethod.getReference());
    }

    public String qualifiedName() {
        return this.holder + "." + this.name;
    }

    @Override
    public String toSmaliString() {
        return this.holder.toSmaliString() + "->" + this.name + this.proto.toSmaliString();
    }

    @Override
    public String toSourceString() {
        return this.toSourceString(true, true);
    }

    public String toSourceStringWithoutHolder() {
        return this.toSourceString(false, true);
    }

    public String toSourceStringWithoutHolderAndReturnType() {
        return this.toSourceString(false, false);
    }

    public boolean isLambdaDeserializeMethod(DexItemFactory dexItemFactory) {
        return this.name == dexItemFactory.deserializeLambdaMethodName && this.proto == dexItemFactory.deserializeLambdaMethodProto;
    }

    public boolean isInstanceInitializer(DexItemFactory factory) {
        return factory.isConstructor(this);
    }

    public boolean mustBeInlinedIntoInstanceInitializer(AppView<?> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        if (this.getName().startsWith(dexItemFactory.temporaryConstructorMethodPrefix)) {
            DexClassAndMethod method = appView.definitionFor(this);
            return method != null && appView.graphLens().getOriginalMethodSignature(this).isInstanceInitializer(dexItemFactory);
        }
        return false;
    }

    public boolean isHorizontallyMergedInstanceInitializer(DexItemFactory dexItemFactory) {
        return this.getName().startsWith(dexItemFactory.syntheticConstructorMethodPrefix);
    }

    public DexMethod withExtraArgumentPrepended(DexType type, DexItemFactory dexItemFactory) {
        return dexItemFactory.createMethod(this.holder, dexItemFactory.prependTypeToProto(type, this.proto), this.name);
    }

    public DexMethod withHolder(DexDefinition definition, DexItemFactory dexItemFactory) {
        return this.withHolder(definition.getContextType(), dexItemFactory);
    }

    public DexMethod withHolder(DexType reference, DexItemFactory dexItemFactory) {
        return dexItemFactory.createMethod(reference.getContextType(), this.proto, this.name);
    }

    public DexMethod withName(String name, DexItemFactory dexItemFactory) {
        return this.withName(dexItemFactory.createString(name), dexItemFactory);
    }

    public DexMethod withName(DexString name, DexItemFactory dexItemFactory) {
        return dexItemFactory.createMethod(this.holder, this.proto, name);
    }

    public DexMethod withProto(DexProto proto, DexItemFactory dexItemFactory) {
        return dexItemFactory.createMethod(this.holder, proto, this.name);
    }
}

