/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.NamingLensComparable;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.Handle;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.Objects;

public class DexMethodHandle
extends IndexedDexItem
implements NamingLensComparable<DexMethodHandle> {
    public final MethodHandleType type;
    public final DexMember<? extends DexItem, ? extends DexMember<?, ?>> member;
    public final boolean isInterface;
    public final DexMethod rewrittenTarget;

    public DexMethodHandle(MethodHandleType type, DexMember<? extends DexItem, ? extends DexMember<?, ?>> member, boolean isInterface, DexMethod rewrittenTarget) {
        this.type = type;
        this.member = member;
        this.isInterface = isInterface;
        this.rewrittenTarget = rewrittenTarget;
    }

    public static DexMethodHandle fromAsmHandle(Handle handle, JarApplicationReader application, DexType clazz) {
        MethodHandleType methodHandleType = MethodHandleType.fromAsmHandle(handle, application, clazz);
        DexMember descriptor = methodHandleType.isFieldType() ? application.getField(handle.getOwner(), handle.getName(), handle.getDesc()) : application.getMethod(handle.getOwner(), handle.getName(), handle.getDesc());
        return application.getMethodHandle(methodHandleType, descriptor, handle.isInterface());
    }

    private static void specify(StructuralSpecification<DexMethodHandle, ?> spec) {
        ((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)spec.withInt(m3 -> m3.type.getValue())).withConditionalItem(DexMethodHandle::isFieldHandle, DexMethodHandle::asField)).withConditionalItem(DexMethodHandle::isMethodHandle, DexMethodHandle::asMethod)).withBool(m3 -> m3.isInterface)).withNullableItem(m3 -> m3.rewrittenTarget);
    }

    private int getAsmTag() {
        switch (this.type) {
            case INVOKE_STATIC: {
                return 6;
            }
            case INVOKE_CONSTRUCTOR: {
                return 8;
            }
            case INVOKE_INSTANCE: {
                return 5;
            }
            case INVOKE_DIRECT: 
            case INVOKE_SUPER: {
                return 7;
            }
            case STATIC_GET: {
                return 2;
            }
            case STATIC_PUT: {
                return 4;
            }
            case INSTANCE_GET: {
                return 1;
            }
            case INSTANCE_PUT: {
                return 3;
            }
            case INVOKE_INTERFACE: {
                return 9;
            }
        }
        throw new Unreachable();
    }

    @Override
    public int computeHashCode() {
        return Objects.hash(new Object[]{this.type, this.member.computeHashCode(), this.isInterface, this.rewrittenTarget});
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexMethodHandle) {
            DexMethodHandle o = (DexMethodHandle)other;
            return this.type.equals((Object)o.type) && this.member.equals(o.member) && this.isInterface == o.isInterface && Objects.equals(this.rewrittenTarget, o.rewrittenTarget);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MethodHandle: {").append((Object)this.type).append(", ").append(this.member.toSourceString()).append("}");
        return builder.toString();
    }

    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        if (indexedItems.addMethodHandle(this)) {
            if (this.member.isDexField()) {
                DexField field = this.member.asDexField();
                field.collectIndexedItems(indexedItems);
            } else {
                DexMethod method = this.member.asDexMethod();
                if (this.rewrittenTarget != null) {
                    if (method.collectIndexedItemsExceptName(indexedItems)) {
                        this.rewrittenTarget.collectIndexedItemsName(indexedItems);
                    }
                } else {
                    method.collectIndexedItems(indexedItems);
                }
            }
        }
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public String toSmaliString() {
        return this.toString();
    }

    public boolean isFieldHandle() {
        return this.type.isFieldType();
    }

    public boolean isMethodHandle() {
        return this.type.isMethodType();
    }

    public boolean isStaticHandle() {
        return this.type.isStaticPut() || this.type.isStaticGet() || this.type.isInvokeStatic();
    }

    public DexMethod asMethod() {
        assert (this.isMethodHandle());
        return (DexMethod)this.member;
    }

    public DexField asField() {
        assert (this.isFieldHandle());
        return (DexField)this.member;
    }

    @Override
    public DexMethodHandle self() {
        return this;
    }

    @Override
    public StructuralMapping<DexMethodHandle> getStructuralMapping() {
        return DexMethodHandle::specify;
    }

    public Handle toAsmHandle() {
        return this.toAsmHandle(NamingLens.getIdentityLens());
    }

    public Handle toAsmHandle(NamingLens lens) {
        boolean itf;
        String desc;
        String name;
        String owner;
        if (this.isMethodHandle()) {
            DexMethod method = this.asMethod();
            owner = lens.lookupInternalName(method.holder);
            name = this.rewrittenTarget != null ? lens.lookupName(this.rewrittenTarget).toString() : lens.lookupName(method).toString();
            desc = method.proto.toDescriptorString(lens);
            if (method.holder.toDescriptorString().equals("Ljava/lang/invoke/LambdaMetafactory;")) {
                assert (!this.isInterface);
                itf = false;
            } else {
                itf = this.isInterface;
            }
        } else {
            assert (this.isFieldHandle());
            DexField field = this.asField();
            owner = lens.lookupInternalName(field.holder);
            name = lens.lookupName(field).toString();
            desc = lens.lookupDescriptor(field.type).toString();
            itf = this.isInterface;
        }
        return new Handle(this.getAsmTag(), owner, name, desc, itf);
    }

    public static final class MethodHandleType
    extends Enum<MethodHandleType> {
        public static final /* enum */ MethodHandleType STATIC_PUT = new MethodHandleType(0);
        public static final /* enum */ MethodHandleType STATIC_GET = new MethodHandleType(1);
        public static final /* enum */ MethodHandleType INSTANCE_PUT = new MethodHandleType(2);
        public static final /* enum */ MethodHandleType INSTANCE_GET = new MethodHandleType(3);
        public static final /* enum */ MethodHandleType INVOKE_STATIC = new MethodHandleType(4);
        public static final /* enum */ MethodHandleType INVOKE_INSTANCE = new MethodHandleType(5);
        public static final /* enum */ MethodHandleType INVOKE_CONSTRUCTOR = new MethodHandleType(6);
        public static final /* enum */ MethodHandleType INVOKE_DIRECT = new MethodHandleType(7);
        public static final /* enum */ MethodHandleType INVOKE_INTERFACE = new MethodHandleType(8);
        public static final /* enum */ MethodHandleType INVOKE_SUPER = new MethodHandleType(9);
        private static final /* synthetic */ MethodHandleType[] $VALUES;
        private final short value;

        public static MethodHandleType[] values() {
            return (MethodHandleType[])$VALUES.clone();
        }

        public static MethodHandleType valueOf(String name) {
            return Enum.valueOf(MethodHandleType.class, name);
        }

        private MethodHandleType(short value) {
            this.value = value;
        }

        public static MethodHandleType getKind(int value) {
            MethodHandleType kind;
            switch (value) {
                case 0: {
                    kind = STATIC_PUT;
                    break;
                }
                case 1: {
                    kind = STATIC_GET;
                    break;
                }
                case 2: {
                    kind = INSTANCE_PUT;
                    break;
                }
                case 3: {
                    kind = INSTANCE_GET;
                    break;
                }
                case 4: {
                    kind = INVOKE_STATIC;
                    break;
                }
                case 5: {
                    kind = INVOKE_INSTANCE;
                    break;
                }
                case 6: {
                    kind = INVOKE_CONSTRUCTOR;
                    break;
                }
                case 7: {
                    kind = INVOKE_DIRECT;
                    break;
                }
                case 8: {
                    kind = INVOKE_INTERFACE;
                    break;
                }
                case 9: {
                    kind = INVOKE_SUPER;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            assert (kind.getValue() == value);
            return kind;
        }

        public static MethodHandleType fromAsmHandle(Handle handle, JarApplicationReader application, DexType clazz) {
            switch (handle.getTag()) {
                case 1: {
                    return INSTANCE_GET;
                }
                case 2: {
                    return STATIC_GET;
                }
                case 3: {
                    return INSTANCE_PUT;
                }
                case 4: {
                    return STATIC_PUT;
                }
                case 7: {
                    assert (!handle.getName().equals("<init>"));
                    assert (!handle.getName().equals("<clinit>"));
                    DexType owner = application.getTypeFromName(handle.getOwner());
                    if (owner == clazz) {
                        return INVOKE_DIRECT;
                    }
                    return INVOKE_SUPER;
                }
                case 5: {
                    return INVOKE_INSTANCE;
                }
                case 9: {
                    return INVOKE_INTERFACE;
                }
                case 6: {
                    return INVOKE_STATIC;
                }
                case 8: {
                    return INVOKE_CONSTRUCTOR;
                }
            }
            throw new Unreachable("MethodHandle tag is not supported: " + handle.getTag());
        }

        static {
            $VALUES = new MethodHandleType[]{STATIC_PUT, STATIC_GET, INSTANCE_PUT, INSTANCE_GET, INVOKE_STATIC, INVOKE_INSTANCE, INVOKE_CONSTRUCTOR, INVOKE_DIRECT, INVOKE_INTERFACE, INVOKE_SUPER};
        }

        public short getValue() {
            return this.value;
        }

        public boolean isFieldType() {
            return this.isStaticPut() || this.isStaticGet() || this.isInstancePut() || this.isInstanceGet();
        }

        public boolean isMethodType() {
            return this.isInvokeStatic() || this.isInvokeInstance() || this.isInvokeInterface() || this.isInvokeSuper() || this.isInvokeConstructor() || this.isInvokeDirect();
        }

        public boolean isStaticPut() {
            return this == STATIC_PUT;
        }

        public boolean isStaticGet() {
            return this == STATIC_GET;
        }

        public boolean isInstancePut() {
            return this == INSTANCE_PUT;
        }

        public boolean isInstanceGet() {
            return this == INSTANCE_GET;
        }

        public boolean isInvokeStatic() {
            return this == INVOKE_STATIC;
        }

        public boolean isInvokeDirect() {
            return this == INVOKE_DIRECT;
        }

        public boolean isInvokeInstance() {
            return this == INVOKE_INSTANCE;
        }

        public boolean isInvokeInterface() {
            return this == INVOKE_INTERFACE;
        }

        public boolean isInvokeSuper() {
            return this == INVOKE_SUPER;
        }

        public boolean isInvokeConstructor() {
            return this == INVOKE_CONSTRUCTOR;
        }

        public Invoke.Type toInvokeType() {
            assert (this.isMethodType());
            switch (this) {
                case INVOKE_STATIC: {
                    return Invoke.Type.STATIC;
                }
                case INVOKE_INSTANCE: {
                    return Invoke.Type.VIRTUAL;
                }
                case INVOKE_CONSTRUCTOR: {
                    return Invoke.Type.DIRECT;
                }
                case INVOKE_DIRECT: {
                    return Invoke.Type.DIRECT;
                }
                case INVOKE_INTERFACE: {
                    return Invoke.Type.INTERFACE;
                }
                case INVOKE_SUPER: {
                    return Invoke.Type.SUPER;
                }
            }
            throw new Unreachable("Conversion to invoke type with unexpected method handle: " + (Object)((Object)this));
        }
    }
}

