/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.Objects;

public abstract class DexMethodSignature
implements StructuralItem<DexMethodSignature> {
    DexMethodSignature() {
    }

    public static DexMethodSignature create(DexMethod method) {
        return new MethodBased(method);
    }

    public static DexMethodSignature create(DexString name, DexProto proto) {
        return new NameAndProtoBased(name, proto);
    }

    private static void specify(StructuralSpecification<DexMethodSignature, ?> spec) {
        ((StructuralSpecification)spec.withItem(DexMethodSignature::getName)).withItem(DexMethodSignature::getProto);
    }

    public abstract DexString getName();

    public abstract DexProto getProto();

    public int getArity() {
        return this.getProto().getArity();
    }

    public DexType getParameter(int index) {
        return this.getProto().getParameter(index);
    }

    public DexTypeList getParameters() {
        return this.getProto().getParameters();
    }

    public DexType getReturnType() {
        return this.getProto().getReturnType();
    }

    @Override
    public StructuralMapping<DexMethodSignature> getStructuralMapping() {
        return DexMethodSignature::specify;
    }

    public DexMethodSignature withName(DexString name) {
        return DexMethodSignature.create(name, this.getProto());
    }

    public DexMethodSignature withParameters(DexTypeList parameters, DexItemFactory dexItemFactory) {
        return DexMethodSignature.create(this.getName(), dexItemFactory.createProto(this.getReturnType(), parameters));
    }

    public DexMethodSignature withProto(DexProto proto) {
        return DexMethodSignature.create(this.getName(), proto);
    }

    public DexMethod withHolder(ProgramDefinition definition, DexItemFactory dexItemFactory) {
        return this.withHolder(definition.getContextType(), dexItemFactory);
    }

    public DexMethod withHolder(DexReference reference, DexItemFactory dexItemFactory) {
        return dexItemFactory.createMethod(reference.getContextType(), this.getProto(), this.getName());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DexMethodSignature)) {
            return false;
        }
        DexMethodSignature that = (DexMethodSignature)o;
        return this.getName() == that.getName() && this.getProto() == that.getProto();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName(), this.getProto());
    }

    @Override
    public DexMethodSignature self() {
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.getReturnType().getTypeName()).append(" ").append(this.getName()).append("(");
        for (int i = 0; i < this.getArity(); ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(this.getParameter(i).getTypeName());
        }
        return builder.append(")").toString();
    }

    static class NameAndProtoBased
    extends DexMethodSignature {
        private final DexString name;
        private final DexProto proto;

        NameAndProtoBased(DexString name, DexProto proto) {
            this.name = name;
            this.proto = proto;
        }

        @Override
        public DexString getName() {
            return this.name;
        }

        @Override
        public DexProto getProto() {
            return this.proto;
        }
    }

    static class MethodBased
    extends DexMethodSignature {
        private final DexMethod method;

        MethodBased(DexMethod method) {
            this.method = method;
        }

        @Override
        public DexString getName() {
            return this.method.getName();
        }

        @Override
        public DexProto getProto() {
            return this.method.getProto();
        }
    }
}

