/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationDirectory;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMember;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedArray;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.MethodCollection;
import com.android.tools.r8.graph.NestHostClassAttribute;
import com.android.tools.r8.graph.NestMemberClassAttribute;
import com.android.tools.r8.graph.ProgramClass;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMember;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.kotlin.KotlinClassLevelInfo;
import com.android.tools.r8.kotlin.KotlinMetadataUtils;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.synthesis.SyntheticMarker;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.TraversalContinuation;
import com.android.tools.r8.utils.structural.Ordered;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class DexProgramClass
extends DexClass
implements ProgramClass,
Supplier<DexProgramClass>,
StructuralItem<DexProgramClass> {
    public static final DexProgramClass[] EMPTY_ARRAY = new DexProgramClass[0];
    private final ProgramResource.Kind originKind;
    private CfVersion initialClassFileVersion = null;
    private boolean deprecated = false;
    private KotlinClassLevelInfo kotlinInfo = KotlinMetadataUtils.getNoKotlinInfo();
    private OptionalBool reachabilitySensitive = OptionalBool.unknown();
    private final ChecksumSupplier checksumSupplier;
    private SyntheticMarker syntheticMarker;

    public DexProgramClass(DexType type, ProgramResource.Kind originKind, Origin origin, ClassAccessFlags accessFlags, DexType superType, DexTypeList interfaces, DexString sourceFile, NestHostClassAttribute nestHost, List<NestMemberClassAttribute> nestMembers, EnclosingMethodAttribute enclosingMember, List<InnerClassAttribute> innerClasses, GenericSignature.ClassSignature classSignature, DexAnnotationSet classAnnotations, DexEncodedField[] staticFields, DexEncodedField[] instanceFields, MethodCollection.MethodCollectionFactory methodCollectionFactory, boolean skipNameValidationForTesting, ChecksumSupplier checksumSupplier, SyntheticMarker syntheticMarker) {
        super(sourceFile, interfaces, accessFlags, superType, type, staticFields, instanceFields, methodCollectionFactory, nestHost, nestMembers, enclosingMember, innerClasses, classSignature, classAnnotations, origin, skipNameValidationForTesting);
        assert (checksumSupplier != null);
        assert (classAnnotations != null);
        this.originKind = originKind;
        this.checksumSupplier = checksumSupplier;
        this.syntheticMarker = syntheticMarker;
    }

    public DexProgramClass(DexType type, ProgramResource.Kind originKind, Origin origin, ClassAccessFlags accessFlags, DexType superType, DexTypeList interfaces, DexString sourceFile, NestHostClassAttribute nestHost, List<NestMemberClassAttribute> nestMembers, EnclosingMethodAttribute enclosingMember, List<InnerClassAttribute> innerClasses, GenericSignature.ClassSignature classSignature, DexAnnotationSet classAnnotations, DexEncodedField[] staticFields, DexEncodedField[] instanceFields, MethodCollection.MethodCollectionFactory methodCollectionFactory, boolean skipNameValidationForTesting, ChecksumSupplier checksumSupplier) {
        this(type, originKind, origin, accessFlags, superType, interfaces, sourceFile, nestHost, nestMembers, enclosingMember, innerClasses, classSignature, classAnnotations, staticFields, instanceFields, methodCollectionFactory, skipNameValidationForTesting, checksumSupplier, null);
    }

    private boolean internalComputeReachabilitySensitive(AppView<?> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        for (DexEncodedMember<?, ?> member : this.members()) {
            for (DexAnnotation annotation : member.annotations().annotations) {
                if (annotation.annotation.type != dexItemFactory.annotationReachabilitySensitive) continue;
                return true;
            }
        }
        return false;
    }

    private static void specify(StructuralSpecification<DexProgramClass, ?> spec) {
        ((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)spec.withItem(c -> c.type)).withItem(c -> c.superType)).withItem(c -> c.interfaces)).withItem(c -> c.accessFlags)).withNullableItem(c -> c.sourceFile)).withNullableItem(c -> c.initialClassFileVersion)).withBool(c -> c.deprecated)).withNullableItem(DexClass::getNestHostClassAttribute)).withItemCollection(DexClass::getNestMembersClassAttributes)).withItem(DexDefinition::annotations)).withAssert(c -> c.classSignature == GenericSignature.ClassSignature.noSignature())).withItemArray(c -> c.staticFields)).withItemArray(c -> c.instanceFields)).withItemCollection(DexClass::allMethodsSorted);
    }

    private ProgramField toProgramFieldOrNull(DexEncodedField field) {
        if (field != null) {
            return new ProgramField(this, field);
        }
        return null;
    }

    private ProgramMethod toProgramMethodOrNull(DexEncodedMethod method) {
        if (method != null) {
            return new ProgramMethod(this, method);
        }
        return null;
    }

    public static DexProgramClass asProgramClassOrNull(DexClass clazz) {
        return clazz != null ? clazz.asProgramClass() : null;
    }

    private boolean internalClassMayHaveInitializationSideEffects(AppView<?> appView, DexClass initialAccessHolder, Predicate<DexType> ignore, Set<DexType> seen) {
        assert (!this.isInterface());
        assert (seen.contains(this.getType()));
        assert (!ignore.test(this.getType()));
        if (this.hasClassInitializer() && !this.getClassInitializer().getOptimizationInfo().classInitializerMayBePostponed()) {
            return true;
        }
        return this.defaultValuesForStaticFieldsMayTriggerAllocation() || this.initializationOfParentTypesMayHaveSideEffects(appView, initialAccessHolder, ignore, seen);
    }

    private boolean internalInterfaceMayHaveInitializationSideEffects(AppView<?> appView, DexClass initialAccessHolder, Predicate<DexType> ignore, Set<DexType> seen) {
        assert (this.isInterface());
        assert (seen.contains(this.getType()));
        assert (!ignore.test(this.getType()));
        if (this == initialAccessHolder) {
            if (this.hasClassInitializer() && !this.getClassInitializer().getOptimizationInfo().classInitializerMayBePostponed()) {
                return true;
            }
            return this.defaultValuesForStaticFieldsMayTriggerAllocation();
        }
        if (this.hasClassInitializer() && !this.getClassInitializer().getOptimizationInfo().classInitializerMayBePostponed() && this.getMethodCollection().hasVirtualMethods(DexEncodedMethod::isDefaultMethod)) {
            return true;
        }
        return this.initializationOfParentTypesMayHaveSideEffects(appView, initialAccessHolder, ignore, seen);
    }

    private boolean initializationOfParentTypesMayHaveSideEffects(AppView<?> appView, DexClass initialAccessHolder, Predicate<DexType> ignore, Set<DexType> seen) {
        if (this.superType != null && this.superType.internalClassOrInterfaceMayHaveInitializationSideEffects(appView, initialAccessHolder, ignore, seen)) {
            return true;
        }
        for (DexType iface : this.interfaces) {
            if (!iface.internalClassOrInterfaceMayHaveInitializationSideEffects(appView, initialAccessHolder, ignore, seen)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAnnotations(DexEncodedField[] fields) {
        DexEncodedField[] dexEncodedFieldArray = fields;
        synchronized (fields) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Arrays.stream(fields).anyMatch(DexDefinition::hasAnnotations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAnnotations(MethodCollection methods) {
        MethodCollection methodCollection = methods;
        synchronized (methodCollection) {
            return methods.hasAnnotations();
        }
    }

    private boolean hasNonDefaultStaticFieldValues() {
        for (DexEncodedField field : this.staticFields) {
            DexValue value = field.getStaticValue();
            if (value == null || value.isDefault(((DexField)field.getReference()).type)) continue;
            return true;
        }
        return false;
    }

    private void addExtraInterfacesToInterfacesArray(List<GenericSignature.ClassTypeSignature> extraInterfaces) {
        DexType[] newInterfaces = Arrays.copyOf(this.interfaces.values, this.interfaces.size() + extraInterfaces.size());
        for (int i = this.interfaces.size(); i < newInterfaces.length; ++i) {
            newInterfaces[i] = extraInterfaces.get(i - this.interfaces.size()).type();
        }
        this.interfaces = new DexTypeList(newInterfaces);
    }

    private void addExtraInterfacesToSignatureIfPresent(List<GenericSignature.ClassTypeSignature> extraInterfaces) {
        if (this.classSignature.hasNoSignature() || extraInterfaces.isEmpty()) {
            return;
        }
        ImmutableCollection.Builder interfacesBuilder = ImmutableList.builder().addAll(this.classSignature.superInterfaceSignatures);
        for (GenericSignature.ClassTypeSignature extraInterface : extraInterfaces) {
            ((ImmutableList.Builder)interfacesBuilder).add(extraInterface);
        }
        this.classSignature = new GenericSignature.ClassSignature(this.classSignature.formalTypeParameters, this.classSignature.superClassSignature, (List<GenericSignature.ClassTypeSignature>)((Object)((ImmutableList.Builder)interfacesBuilder).build()));
    }

    public static Iterable<DexProgramClass> asProgramClasses(final Iterable<DexType> types, final DexDefinitionSupplier definitions) {
        return () -> new Iterator<DexProgramClass>(){
            private DexProgramClass next;
            private final Iterator iterator;
            {
                this.iterator = types.iterator();
                this.next = this.findNext();
            }

            private DexProgramClass findNext() {
                while (this.iterator.hasNext()) {
                    DexType next = (DexType)this.iterator.next();
                    DexClass clazz = definitions.contextIndependentDefinitionFor(next);
                    if (clazz == null || !clazz.isProgramClass()) continue;
                    return clazz.asProgramClass();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public DexProgramClass next() {
                DexProgramClass current = this.next;
                this.next = this.findNext();
                return current;
            }
        };
    }

    public static long invalidChecksumRequest(DexProgramClass clazz) {
        throw new CompilationError(clazz + " has no checksum information while checksum encoding is requested", clazz.origin);
    }

    public static long checksumFromType(DexProgramClass clazz) {
        return clazz.type.hashCode();
    }

    @Override
    public void accept(Consumer<DexProgramClass> programClassConsumer, Consumer<DexClasspathClass> classpathClassConsumer, Consumer<DexLibraryClass> libraryClassConsumer) {
        programClassConsumer.accept(this);
    }

    @Override
    public DexProgramClass self() {
        return this;
    }

    @Override
    public DexProgramClass getContext() {
        return this;
    }

    public boolean getOrComputeReachabilitySensitive(AppView<?> appView) {
        if (this.reachabilitySensitive.isUnknown()) {
            this.reachabilitySensitive = OptionalBool.of(this.internalComputeReachabilitySensitive(appView));
        }
        return this.reachabilitySensitive.isTrue();
    }

    @Override
    public StructuralMapping<DexProgramClass> getStructuralMapping() {
        return DexProgramClass::specify;
    }

    public SyntheticMarker stripSyntheticInputMarker() {
        SyntheticMarker marker = this.syntheticMarker;
        this.syntheticMarker = null;
        return marker;
    }

    public void forEachProgramField(Consumer<? super ProgramField> consumer) {
        this.forEachProgramFieldMatching(Predicates.alwaysTrue(), consumer);
    }

    public void forEachProgramFieldMatching(Predicate<? super DexEncodedField> predicate, Consumer<? super ProgramField> consumer) {
        this.forEachFieldMatching(predicate, field -> consumer.accept(new ProgramField(this, (DexEncodedField)field)));
    }

    public void forEachProgramInstanceField(Consumer<? super ProgramField> consumer) {
        this.forEachInstanceField(field -> consumer.accept(new ProgramField(this, (DexEncodedField)field)));
    }

    public void forEachProgramStaticField(Consumer<? super ProgramField> consumer) {
        this.forEachStaticField(field -> consumer.accept(new ProgramField(this, (DexEncodedField)field)));
    }

    public void forEachProgramMember(Consumer<? super ProgramMember<?, ?>> consumer) {
        this.forEachProgramField(consumer);
        this.forEachProgramMethod(consumer);
    }

    public void forEachProgramMethod(Consumer<? super ProgramMethod> consumer) {
        this.forEachProgramMethodMatching(Predicates.alwaysTrue(), consumer);
    }

    public void forEachProgramMethodMatching(Predicate<DexEncodedMethod> predicate, Consumer<? super ProgramMethod> consumer) {
        this.methodCollection.forEachMethodMatching(predicate, method -> consumer.accept(new ProgramMethod(this, (DexEncodedMethod)method)));
    }

    public Iterable<ProgramMethod> programMethods() {
        return Iterables.concat(this.directProgramMethods(), this.virtualProgramMethods());
    }

    public Iterable<ProgramMethod> directProgramMethods() {
        return Iterables.transform(this.directMethods(), method -> new ProgramMethod(this, (DexEncodedMethod)method));
    }

    public Iterable<ProgramMethod> directProgramMethods(Predicate<DexEncodedMethod> predicate) {
        return Iterables.transform(this.directMethods(predicate), method -> new ProgramMethod(this, (DexEncodedMethod)method));
    }

    public Iterable<ProgramMethod> virtualProgramMethods() {
        return Iterables.transform(this.virtualMethods(), method -> new ProgramMethod(this, (DexEncodedMethod)method));
    }

    public Iterable<ProgramMethod> virtualProgramMethods(Predicate<DexEncodedMethod> predicate) {
        return Iterables.transform(this.virtualMethods(predicate), method -> new ProgramMethod(this, (DexEncodedMethod)method));
    }

    public Iterable<ProgramMethod> programInstanceInitializers() {
        return this.directProgramMethods(DexEncodedMethod::isInstanceInitializer);
    }

    public void forEachProgramDirectMethod(Consumer<ProgramMethod> consumer) {
        this.forEachProgramDirectMethodMatching(Predicates.alwaysTrue(), consumer);
    }

    public void forEachProgramDirectMethodMatching(Predicate<DexEncodedMethod> predicate, Consumer<ProgramMethod> consumer) {
        this.methodCollection.forEachDirectMethodMatching(predicate, method -> consumer.accept(new ProgramMethod(this, (DexEncodedMethod)method)));
    }

    public void forEachProgramInstanceInitializer(Consumer<ProgramMethod> consumer) {
        this.forEachProgramInstanceInitializerMatching(Predicates.alwaysTrue(), consumer);
    }

    public void forEachProgramInstanceInitializerMatching(Predicate<DexEncodedMethod> predicate, Consumer<ProgramMethod> consumer) {
        this.forEachProgramDirectMethodMatching(method -> method.isInstanceInitializer() && predicate.test((DexEncodedMethod)method), consumer);
    }

    public void forEachProgramVirtualMethod(Consumer<ProgramMethod> consumer) {
        this.forEachProgramVirtualMethodMatching(Predicates.alwaysTrue(), consumer);
    }

    public void forEachProgramVirtualMethodMatching(Predicate<DexEncodedMethod> predicate, Consumer<ProgramMethod> consumer) {
        this.methodCollection.forEachVirtualMethodMatching(predicate, method -> consumer.accept(new ProgramMethod(this, (DexEncodedMethod)method)));
    }

    public ProgramMethod getProgramClassInitializer() {
        return this.toProgramMethodOrNull(this.getClassInitializer());
    }

    public ProgramMethod getProgramDefaultInitializer() {
        return this.getProgramInitializer(DexType.EMPTY_ARRAY);
    }

    public ProgramMethod getProgramInitializer(DexType[] types) {
        return this.toProgramMethodOrNull(this.getInitializer(types));
    }

    public <D extends DexEncodedMember<D, R>, R extends DexMember<D, R>> ProgramMember<D, R> lookupProgramMember(DexMember<D, R> member) {
        DexClassAndMember definition = member.isDexField() ? this.lookupProgramField(member.asDexField()) : this.lookupProgramMethod(member.asDexMethod());
        return definition;
    }

    public ProgramField lookupProgramField(DexField reference) {
        return this.toProgramFieldOrNull(this.lookupField(reference));
    }

    public ProgramMethod lookupProgramMethod(DexMethod reference) {
        return this.toProgramMethodOrNull(this.getMethodCollection().getMethod(reference));
    }

    public TraversalContinuation<?> traverseProgramMembers(Function<ProgramMember<?, ?>, TraversalContinuation<?>> fn) {
        TraversalContinuation<?> continuation = this.traverseProgramFields(fn);
        if (continuation.shouldContinue()) {
            return this.traverseProgramMethods(fn);
        }
        return TraversalContinuation.doBreak();
    }

    public TraversalContinuation<?> traverseProgramFields(Function<? super ProgramField, TraversalContinuation<?>> fn) {
        return this.traverseFields(field -> (TraversalContinuation)fn.apply(new ProgramField(this, (DexEncodedField)field)));
    }

    public TraversalContinuation<?> traverseProgramMethods(Function<? super ProgramMethod, TraversalContinuation<?>> fn) {
        return this.getMethodCollection().traverse(method -> (TraversalContinuation)fn.apply(new ProgramMethod(this, (DexEncodedMethod)method)));
    }

    public TraversalContinuation<?> traverseProgramInstanceInitializers(Function<ProgramMethod, TraversalContinuation<?>> fn) {
        return this.traverseProgramMethods(fn, DexEncodedMethod::isInstanceInitializer);
    }

    public TraversalContinuation<?> traverseProgramMethods(Function<ProgramMethod, TraversalContinuation<?>> fn, Predicate<DexEncodedMethod> predicate) {
        return this.getMethodCollection().traverse(method -> predicate.test((DexEncodedMethod)method) ? (TraversalContinuation)fn.apply(new ProgramMethod(this, (DexEncodedMethod)method)) : TraversalContinuation.doContinue());
    }

    public ProgramResource.Kind getOriginKind() {
        return this.originKind;
    }

    public boolean originatesFromDexResource() {
        return this.originKind == ProgramResource.Kind.DEX;
    }

    public boolean originatesFromClassResource() {
        return this.originKind == ProgramResource.Kind.CF;
    }

    public void collectIndexedItems(IndexedItemCollection indexedItems, GraphLens graphLens, LensCodeRewriterUtils rewriter) {
        if (indexedItems.addClass(this)) {
            this.type.collectIndexedItems(indexedItems);
            if (this.superType != null) {
                this.superType.collectIndexedItems(indexedItems);
            } else assert (this.type.toDescriptorString().equals("Ljava/lang/Object;"));
            if (this.sourceFile != null) {
                this.sourceFile.collectIndexedItems(indexedItems);
            }
            this.annotations().collectIndexedItems(indexedItems);
            if (this.interfaces != null) {
                this.interfaces.collectIndexedItems(indexedItems);
            }
            if (this.getEnclosingMethodAttribute() != null) {
                this.getEnclosingMethodAttribute().collectIndexedItems(indexedItems);
            }
            for (InnerClassAttribute attribute : this.getInnerClasses()) {
                attribute.collectIndexedItems(indexedItems);
            }
            this.forEachProgramField(field -> field.collectIndexedItems(indexedItems));
            this.forEachProgramMethod(method -> method.collectIndexedItems(indexedItems, graphLens, rewriter));
        }
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        assert (this.getEnclosingMethodAttribute() == null);
        assert (this.getInnerClasses().isEmpty());
        assert (!this.classSignature.hasSignature());
        if (this.hasClassOrMemberAnnotations()) {
            mixedItems.setAnnotationsDirectoryForClass(this, new DexAnnotationDirectory(this));
        }
    }

    @Override
    public void addDependencies(MixedSectionCollection collector) {
        assert (this.getEnclosingMethodAttribute() == null);
        assert (this.getInnerClasses().isEmpty());
        assert (!this.classSignature.hasSignature());
        if (this.hasMethodsOrFields()) {
            collector.add(this);
            this.methodCollection.forEachMethod(m3 -> m3.collectMixedSectionItems(collector));
            DexProgramClass.collectAll((MixedSectionCollection)collector, (DexItem[])this.staticFields);
            DexProgramClass.collectAll((MixedSectionCollection)collector, (DexItem[])this.instanceFields);
        }
        this.annotations().collectMixedSectionItems(collector);
        if (this.interfaces != null) {
            this.interfaces.collectMixedSectionItems(collector);
        }
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    public String toSourceString() {
        return this.type.toSourceString();
    }

    @Override
    public boolean isEffectivelyFinal(AppView<?> appView) {
        if (this.isFinal()) {
            return true;
        }
        if (appView.hasLiveness()) {
            assert (appView.enableWholeProgramOptimizations());
            InternalOptions options = appView.options();
            return !appView.getKeepInfo(this).isPinned(options) && !appView.appInfoWithLiveness().isInstantiatedIndirectly(this);
        }
        return false;
    }

    @Override
    public boolean isProgramClass() {
        return true;
    }

    @Override
    public DexProgramClass asProgramClass() {
        return this;
    }

    @Override
    public boolean isNotProgramClass() {
        return false;
    }

    @Override
    public KotlinClassLevelInfo getKotlinInfo() {
        return this.kotlinInfo;
    }

    public void setKotlinInfo(KotlinClassLevelInfo kotlinInfo) {
        assert (kotlinInfo != null);
        assert (this.kotlinInfo == KotlinMetadataUtils.getNoKotlinInfo());
        this.kotlinInfo = kotlinInfo;
    }

    public void clearKotlinInfo() {
        this.kotlinInfo = KotlinMetadataUtils.getNoKotlinInfo();
    }

    @Override
    boolean internalClassOrInterfaceMayHaveInitializationSideEffects(AppView<?> appView, DexClass initialAccessHolder, Predicate<DexType> ignore, Set<DexType> seen) {
        if (!seen.add(this.getType()) || ignore.test(this.getType())) {
            return false;
        }
        return this.isInterface() ? this.internalInterfaceMayHaveInitializationSideEffects(appView, initialAccessHolder, ignore, seen) : this.internalClassMayHaveInitializationSideEffects(appView, initialAccessHolder, ignore, seen);
    }

    public boolean hasFields() {
        return this.instanceFields.length + this.staticFields.length > 0;
    }

    public boolean hasMethods() {
        return this.methodCollection.size() > 0;
    }

    public boolean hasMethodsOrFields() {
        return this.hasMethods() || this.hasFields();
    }

    public boolean hasClassOrMemberAnnotations() {
        return !this.annotations().isEmpty() || this.hasAnnotations(this.methodCollection) || this.hasAnnotations(this.staticFields) || this.hasAnnotations(this.instanceFields);
    }

    boolean hasOnlyInternalizableAnnotations() {
        return !this.hasAnnotations(this.methodCollection) && !this.hasAnnotations(this.staticFields) && !this.hasAnnotations(this.instanceFields);
    }

    public DexEncodedArray computeStaticValuesArray(NamingLens namingLens) {
        if (!this.hasNonDefaultStaticFieldValues()) {
            return null;
        }
        DexEncodedField[] fields = this.staticFields;
        Arrays.sort(fields, (a, b) -> ((DexField)a.getReference()).compareToWithNamingLens((DexField)b.getReference(), namingLens));
        int length = 0;
        ArrayList<DexValue> values2 = new ArrayList<DexValue>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            DexEncodedField field = fields[i];
            DexValue staticValue = field.getStaticValue();
            assert (staticValue != null);
            values2.add(staticValue);
            if (staticValue.isDefault(((DexField)field.getReference()).type)) continue;
            length = i + 1;
        }
        return length > 0 ? new DexEncodedArray(values2.subList(0, length).toArray(DexValue.EMPTY_ARRAY)) : null;
    }

    public void addMethod(DexEncodedMethod method) {
        this.methodCollection.addMethod(method);
    }

    public void addVirtualMethod(DexEncodedMethod virtualMethod) {
        this.methodCollection.addVirtualMethod(virtualMethod);
    }

    public void replaceVirtualMethod(DexMethod virtualMethod, Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        this.methodCollection.replaceVirtualMethod(virtualMethod, replacement);
    }

    public void addExtraInterfaces(List<GenericSignature.ClassTypeSignature> extraInterfaces) {
        if (extraInterfaces.isEmpty()) {
            return;
        }
        this.addExtraInterfacesToInterfacesArray(extraInterfaces);
        this.addExtraInterfacesToSignatureIfPresent(extraInterfaces);
    }

    @Override
    public DexProgramClass get() {
        return this;
    }

    @Override
    public DexProgramClass getContextClass() {
        return this;
    }

    @Override
    public DexType getContextType() {
        return this.getType();
    }

    @Override
    public DexProgramClass getDefinition() {
        return this;
    }

    public void setInitialClassFileVersion(CfVersion initialClassFileVersion) {
        assert (this.initialClassFileVersion == null);
        assert (initialClassFileVersion != null);
        this.initialClassFileVersion = initialClassFileVersion;
    }

    public void downgradeInitialClassFileVersion(CfVersion version) {
        assert (version != null);
        this.initialClassFileVersion = Ordered.minIgnoreNull(this.initialClassFileVersion, version);
    }

    public boolean hasClassFileVersion() {
        return this.initialClassFileVersion != null;
    }

    public CfVersion getInitialClassFileVersion() {
        return this.initialClassFileVersion;
    }

    public void setDeprecated() {
        this.deprecated = true;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public long getChecksum() {
        return this.checksumSupplier.getChecksum(this);
    }

    public ChecksumSupplier getChecksumSupplier() {
        return this.checksumSupplier;
    }

    @FunctionalInterface
    public static interface ChecksumSupplier {
        public long getChecksum(DexProgramClass var1);
    }
}

