/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.NamingLensComparable;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.Collections;
import java.util.function.Consumer;

public class DexProto
extends IndexedDexItem
implements NamingLensComparable<DexProto> {
    public static final DexProto SENTINEL = new DexProto(null, null, null);
    public final DexString shorty;
    public final DexType returnType;
    public final DexTypeList parameters;

    DexProto(DexString shorty, DexType returnType, DexTypeList parameters) {
        this.shorty = shorty;
        this.returnType = returnType;
        this.parameters = parameters;
    }

    private static void specify(StructuralSpecification<DexProto, ?> spec) {
        ((StructuralSpecification)((StructuralSpecification)spec.withItem(DexProto::getReturnType)).withItem(p -> p.parameters)).withItem(p1 -> p1.shorty);
    }

    @Override
    public StructuralMapping<DexProto> getStructuralMapping() {
        return DexProto::specify;
    }

    @Override
    public DexProto self() {
        return this;
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexProto) {
            DexProto o = (DexProto)other;
            return this.shorty.equals(o.shorty) && this.returnType.equals(o.returnType) && this.parameters.equals(o.parameters);
        }
        return false;
    }

    @Override
    public int computeHashCode() {
        return this.shorty.hashCode() * 7 + this.returnType.hashCode() * 13 + this.parameters.hashCode() * 31;
    }

    public DexType getReturnType() {
        return this.returnType;
    }

    public Iterable<DexType> getParameterBaseTypes(DexItemFactory dexItemFactory) {
        return Iterables.transform(this.parameters, type -> type.toBaseType(dexItemFactory));
    }

    public Iterable<DexType> getBaseTypes(DexItemFactory dexItemFactory) {
        return Iterables.transform(this.getTypes(), type -> type.toBaseType(dexItemFactory));
    }

    public Iterable<DexType> getTypes() {
        return Iterables.concat(Collections.singleton(this.returnType), this.parameters);
    }

    public void forEachType(Consumer<DexType> consumer) {
        consumer.accept(this.returnType);
        this.parameters.forEach((Consumer<? super DexType>)consumer);
    }

    public DexType getParameter(int index) {
        return this.parameters.values[index];
    }

    public DexTypeList getParameters() {
        return this.parameters;
    }

    public int getArity() {
        return this.parameters.size();
    }

    public String toString() {
        return "Proto " + this.shorty + " " + this.returnType + " " + this.parameters;
    }

    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        if (indexedItems.addProto(this)) {
            this.shorty.collectIndexedItems(indexedItems);
            this.returnType.collectIndexedItems(indexedItems);
            this.parameters.collectIndexedItems(indexedItems);
        }
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public String toSmaliString() {
        return this.toDescriptorString();
    }

    public String toDescriptorString() {
        return this.toDescriptorString(NamingLens.getIdentityLens());
    }

    public String toDescriptorString(NamingLens lens) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < this.parameters.values.length; ++i) {
            builder.append(lens.lookupDescriptor(this.parameters.values[i]));
        }
        builder.append(")");
        builder.append(lens.lookupDescriptor(this.returnType));
        return builder.toString();
    }
}

