/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.NamingLensComparable;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.HashingVisitor;
import com.android.tools.r8.utils.structural.StructuralMapping;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class DexType
extends DexReference
implements NamingLensComparable<DexType> {
    public static final DexType[] EMPTY_ARRAY = new DexType[0];
    private static List<String> OLD_SYNTHESIZED_NAMES = ImmutableList.of("$r8$backportedMethods$utility", "$r8$java8methods$utility", "$r8$twr$utility", "$-DC", "$$ServiceLoaderMethods", "com.android.tools.r8.GeneratedOutlineSupport", "-$$Nest$Constructor", "-$$Lambda$", "-$$LambdaGroup$");
    public final DexString descriptor;
    private String toStringCache = null;

    DexType(DexString descriptor) {
        assert (!descriptor.toString().contains(".")) : "Malformed descriptor: " + descriptor.toString();
        this.descriptor = descriptor;
    }

    private boolean oldSynthesizedName(String name) {
        for (String synthesizedPrefix : OLD_SYNTHESIZED_NAMES) {
            if (!name.contains(synthesizedPrefix)) continue;
            return true;
        }
        return false;
    }

    private String getPackageOrName(boolean packagePart) {
        assert (this.isClassType());
        String descriptor = this.toDescriptorString();
        int lastSeparator = descriptor.lastIndexOf(47);
        if (lastSeparator == -1) {
            return packagePart ? "" : descriptor.substring(1, descriptor.length() - 1);
        }
        return packagePart ? descriptor.substring(1, lastSeparator) : descriptor.substring(lastSeparator + 1, descriptor.length() - 1);
    }

    public ClassReference asClassReference() {
        return Reference.classFromDescriptor(this.toDescriptorString());
    }

    public DynamicTypeWithUpperBound toDynamicType(AppView<AppInfoWithLiveness> appView) {
        return this.toDynamicType(appView, Nullability.maybeNull());
    }

    public DynamicTypeWithUpperBound toDynamicType(AppView<AppInfoWithLiveness> appView, Nullability nullability) {
        return DynamicType.create(appView, this.toTypeElement(appView, nullability));
    }

    public TypeElement toTypeElement(AppView<?> appView) {
        return this.toTypeElement(appView, Nullability.maybeNull());
    }

    public TypeElement toTypeElement(AppView<?> appView, Nullability nullability) {
        return TypeElement.fromDexType(this, nullability, appView);
    }

    @Override
    public int compareTo(DexReference other) {
        if (other.isDexType()) {
            return this.compareTo(other.asDexType());
        }
        int comparisonResult = this.compareTo(other.getContextType());
        return comparisonResult != 0 ? comparisonResult : -1;
    }

    @Override
    public DexType self() {
        return this;
    }

    @Override
    public StructuralMapping<DexType> getStructuralMapping() {
        throw new Unreachable();
    }

    @Override
    public int acceptCompareTo(DexType other, CompareToVisitor visitor) {
        return visitor.visitDexType(this, other);
    }

    @Override
    public void acceptHashing(HashingVisitor visitor) {
        visitor.visitDexType(this);
    }

    @Override
    public DexType getContextType() {
        return this;
    }

    public DexString getDescriptor() {
        return this.descriptor;
    }

    public int getRequiredRegisters() {
        assert (!this.isVoidType());
        return this.isWideType() ? 2 : 1;
    }

    @Override
    public int computeHashCode() {
        return this.descriptor.hashCode();
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexType) {
            return this.descriptor.equals(((DexType)other).descriptor);
        }
        return false;
    }

    public boolean classInitializationMayHaveSideEffectsInContext(AppView<?> appView, ProgramDefinition context) {
        DexClass clazz = appView.definitionFor(this);
        return clazz == null || clazz.classInitializationMayHaveSideEffectsInContext(appView, context);
    }

    final boolean internalClassOrInterfaceMayHaveInitializationSideEffects(AppView<?> appView, DexClass initialAccessHolder, Predicate<DexType> ignore, Set<DexType> seen) {
        DexClass clazz = appView.definitionFor(this);
        return clazz == null || clazz.internalClassOrInterfaceMayHaveInitializationSideEffects(appView, initialAccessHolder, ignore, seen);
    }

    public boolean isAlwaysNull(AppView<AppInfoWithLiveness> appView) {
        if (!this.isClassType()) {
            return false;
        }
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(appView.definitionFor(this));
        if (clazz == null) {
            return false;
        }
        if (clazz.isInterface() && appView.getOpenClosedInterfacesCollection().isMaybeOpen(clazz)) {
            return false;
        }
        return !appView.appInfo().isInstantiatedDirectlyOrIndirectly(clazz);
    }

    public boolean isSamePackage(DexType other) {
        return this.getPackageDescriptor().equals(other.getPackageDescriptor());
    }

    public String toDescriptorString() {
        return this.descriptor.toString();
    }

    public String toBinaryName() {
        String descriptor = this.toDescriptorString();
        assert (descriptor.length() > 1 && descriptor.charAt(0) == 'L' && descriptor.charAt(descriptor.length() - 1) == ';');
        return descriptor.substring(1, descriptor.length() - 1);
    }

    @Override
    public <T> T apply(Function<DexType, T> classConsumer, Function<DexField, T> fieldConsumer, Function<DexMethod, T> methodConsumer) {
        return classConsumer.apply(this);
    }

    @Override
    public void accept(Consumer<DexType> classConsumer, Consumer<DexField> fieldConsumer, Consumer<DexMethod> methodConsumer) {
        classConsumer.accept(this);
    }

    @Override
    public <T> void accept(BiConsumer<DexType, T> classConsumer, BiConsumer<DexField, T> fieldConsumer, BiConsumer<DexMethod, T> methodConsumer, T arg) {
        classConsumer.accept(this, (DexType)arg);
    }

    public String getTypeName() {
        return this.toSourceString();
    }

    @Override
    public String toSourceString() {
        if (this.toStringCache == null) {
            this.toStringCache = DexItemFactory.isInternalSentinel(this) ? this.descriptor.toString() : DescriptorUtils.descriptorToJavaType(this.toDescriptorString());
        }
        return this.toStringCache;
    }

    public char toShorty() {
        char c = (char)this.descriptor.content[0];
        return c == '[' ? (char)'L' : (char)c;
    }

    @Override
    public String toSmaliString() {
        return this.toDescriptorString();
    }

    public String toString() {
        return this.toSourceString();
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection collection) {
        if (collection.addType(this)) {
            collection.getRenamedDescriptor(this).collectIndexedItems(collection);
        }
    }

    @Override
    public void flushCachedValues() {
        super.flushCachedValues();
        this.toStringCache = null;
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public boolean isDexType() {
        return true;
    }

    @Override
    public DexType asDexType() {
        return this;
    }

    public boolean isPrimitiveType() {
        return DescriptorUtils.isPrimitiveType((char)this.descriptor.content[0]);
    }

    public boolean isVoidType() {
        return (char)this.descriptor.content[0] == 'V';
    }

    public boolean isBooleanType() {
        return this.descriptor.content[0] == 90;
    }

    public boolean isByteType() {
        return this.descriptor.content[0] == 66;
    }

    public boolean isCharType() {
        return this.descriptor.content[0] == 67;
    }

    public boolean isShortType() {
        return this.descriptor.content[0] == 83;
    }

    public boolean isIntType() {
        return this.descriptor.content[0] == 73;
    }

    public boolean isFloatType() {
        return this.descriptor.content[0] == 70;
    }

    public boolean isLongType() {
        return this.descriptor.content[0] == 74;
    }

    public boolean isDoubleType() {
        return this.descriptor.content[0] == 68;
    }

    public boolean isNullValueType() {
        boolean isNullValueType;
        boolean bl = isNullValueType = this.descriptor.content[0] == 78;
        assert (!isNullValueType || this == DexItemFactory.nullValueType);
        return isNullValueType;
    }

    public boolean isArrayType() {
        char firstChar = (char)this.descriptor.content[0];
        return firstChar == '[';
    }

    public boolean isClassType() {
        char firstChar = (char)this.descriptor.content[0];
        return firstChar == 'L';
    }

    public boolean isReferenceType() {
        boolean isReferenceType;
        boolean bl = isReferenceType = this.isArrayType() || this.isClassType();
        assert (isReferenceType != this.isPrimitiveType() || this.isVoidType());
        return isReferenceType;
    }

    public boolean isPrimitiveArrayType() {
        if (!this.isArrayType()) {
            return false;
        }
        return DescriptorUtils.isPrimitiveType((char)this.descriptor.content[1]);
    }

    public boolean isWideType() {
        return this.isDoubleType() || this.isLongType();
    }

    public boolean isSynthesizedTypeAllowedDuplication() {
        return this.descriptor.toString().equals("Ljava/lang/Record;") || this.descriptor.toString().equals("Lcom/android/tools/r8/RecordTag;");
    }

    public boolean isLegacySynthesizedTypeAllowedDuplication() {
        return this.oldSynthesizedName(this.toSourceString());
    }

    public boolean isInterface(DexDefinitionSupplier definitionSupplier) {
        return definitionSupplier.definitionFor(this).isInterface();
    }

    public DexProgramClass asProgramClass(DexDefinitionSupplier definitions) {
        return DexProgramClass.asProgramClassOrNull(definitions.definitionFor(this));
    }

    public boolean isProgramType(DexDefinitionSupplier definitions) {
        DexClass clazz = definitions.definitionFor(this);
        return clazz != null && clazz.isProgramClass();
    }

    public boolean isResolvable(AppView<?> appView) {
        DexClass clazz = appView.definitionFor(this);
        return clazz != null && clazz.isResolvable(appView);
    }

    public int elementSizeForPrimitiveArrayType() {
        assert (this.isPrimitiveArrayType());
        switch (this.descriptor.content[1]) {
            case 66: 
            case 90: {
                return 1;
            }
            case 67: 
            case 83: {
                return 2;
            }
            case 70: 
            case 73: {
                return 4;
            }
            case 68: 
            case 74: {
                return 8;
            }
        }
        throw new Unreachable("Not array of primitives '" + this.descriptor + "'");
    }

    public int getNumberOfLeadingSquareBrackets() {
        int leadingSquareBrackets = 0;
        while (this.descriptor.content[leadingSquareBrackets] == 91) {
            ++leadingSquareBrackets;
        }
        return leadingSquareBrackets;
    }

    public DexType toDimensionMinusOneType(DexItemFactory dexItemFactory) {
        DexType baseType = this.toBaseType(dexItemFactory);
        int leadingSquareBrackets = this.getNumberOfLeadingSquareBrackets();
        if (leadingSquareBrackets <= 1) {
            return baseType;
        }
        return dexItemFactory.createArrayType(leadingSquareBrackets - 1, baseType);
    }

    public DexType toBaseType(DexItemFactory dexItemFactory) {
        int leadingSquareBrackets = this.getNumberOfLeadingSquareBrackets();
        if (leadingSquareBrackets == 0) {
            return this;
        }
        DexString newDesc = dexItemFactory.createString(this.descriptor.size - leadingSquareBrackets, Arrays.copyOfRange(this.descriptor.content, leadingSquareBrackets, this.descriptor.content.length));
        return dexItemFactory.createType(newDesc);
    }

    public DexType lookupBaseType(DexItemFactory dexItemFactory) {
        int leadingSquareBrackets = this.getNumberOfLeadingSquareBrackets();
        if (leadingSquareBrackets == 0) {
            return this;
        }
        DexString newDesc = dexItemFactory.lookupString(this.descriptor.size - leadingSquareBrackets, Arrays.copyOfRange(this.descriptor.content, leadingSquareBrackets, this.descriptor.content.length));
        return dexItemFactory.lookupType(newDesc);
    }

    public DexType replaceBaseType(DexType newBase, DexItemFactory dexItemFactory) {
        assert (this.isArrayType());
        assert (!newBase.isArrayType());
        return newBase.toArrayType(this.getNumberOfLeadingSquareBrackets(), dexItemFactory);
    }

    public DexType replacePackage(String newPackageDescriptor, DexItemFactory dexItemFactory) {
        assert (this.isClassType());
        String descriptorString = this.toDescriptorString();
        String newDescriptorString = "L";
        if (!newPackageDescriptor.isEmpty()) {
            newDescriptorString = newDescriptorString + newPackageDescriptor + "/";
        }
        newDescriptorString = newDescriptorString + DescriptorUtils.getSimpleClassNameFromDescriptor(descriptorString) + ";";
        return dexItemFactory.createType(newDescriptorString);
    }

    public DexType addSuffix(String suffix, DexItemFactory dexItemFactory) {
        assert (this.isClassType());
        String descriptorString = this.toDescriptorString();
        int endIndex = descriptorString.length() - 1;
        String newDescriptorString = descriptorString.substring(0, endIndex) + suffix + ";";
        return dexItemFactory.createType(newDescriptorString);
    }

    public DexType addSuffixId(int index, DexItemFactory dexItemFactory) {
        if (index == 0) {
            return this;
        }
        assert (index > 0);
        return this.addSuffix("$" + index, dexItemFactory);
    }

    public DexType toArrayType(int dimensions, DexItemFactory dexItemFactory) {
        return dexItemFactory.createType(this.descriptor.toArrayDescriptor(dimensions, dexItemFactory));
    }

    public DexType toArrayElementType(DexItemFactory dexItemFactory) {
        assert (this.isArrayType());
        DexString newDesc = dexItemFactory.createString(this.descriptor.size - 1, Arrays.copyOfRange(this.descriptor.content, 1, this.descriptor.content.length));
        return dexItemFactory.createType(newDesc);
    }

    public String getPackageDescriptor() {
        return this.getPackageOrName(true);
    }

    public String getName() {
        if (this.isPrimitiveType()) {
            return this.toSourceString();
        }
        return this.getPackageOrName(false);
    }

    public String getSimpleName() {
        assert (this.isClassType());
        return DescriptorUtils.getSimpleClassNameFromDescriptor(this.toDescriptorString());
    }

    public DexType withSimpleName(String newSimpleName, DexItemFactory dexItemFactory) {
        assert (this.isClassType());
        return dexItemFactory.createType(DescriptorUtils.replaceSimpleClassNameInDescriptor(this.toDescriptorString(), newSimpleName));
    }

    public String getInternalName() {
        assert (this.isClassType() || this.isArrayType());
        return DescriptorUtils.descriptorToInternalName(this.toDescriptorString());
    }

    public String getPackageName() {
        return DescriptorUtils.getPackageNameFromBinaryName(this.toBinaryName());
    }
}

