/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Iterators;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.PredicateUtils;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class DexTypeList
extends DexItem
implements Iterable<DexType>,
StructuralItem<DexTypeList> {
    private static final DexTypeList theEmptyTypeList = new DexTypeList();
    public final DexType[] values;

    private static void specify(StructuralSpecification<DexTypeList, ?> spec) {
        spec.withItemArray(ts -> ts.values);
    }

    public static DexTypeList empty() {
        return theEmptyTypeList;
    }

    private DexTypeList() {
        this.values = DexType.EMPTY_ARRAY;
    }

    public DexTypeList(DexType[] values2) {
        assert (values2 != null && values2.length > 0);
        this.values = values2;
    }

    public DexTypeList(Collection<DexType> values2) {
        this(values2.toArray(DexType.EMPTY_ARRAY));
    }

    public static DexTypeList create(DexType[] values2) {
        return values2.length == 0 ? DexTypeList.empty() : new DexTypeList(values2);
    }

    public static DexTypeList create(Collection<DexType> values2) {
        return values2.isEmpty() ? DexTypeList.empty() : new DexTypeList(values2);
    }

    public DexType get(int index) {
        return this.values[index];
    }

    public DexType[] getBacking() {
        return this.values;
    }

    public DexTypeList keepIf(Predicate<DexType> predicate) {
        DexType[] filtered = ArrayUtils.filter(this.values, predicate, DexType.EMPTY_ARRAY);
        if (filtered != this.values) {
            return DexTypeList.create(filtered);
        }
        return this;
    }

    public DexTypeList map(Function<DexType, DexType> fn) {
        if (this.isEmpty()) {
            return DexTypeList.empty();
        }
        DexType[] newTypes = ArrayUtils.map(this.values, fn, DexType.EMPTY_ARRAY);
        return newTypes != this.values ? DexTypeList.create(newTypes) : this;
    }

    public DexTypeList removeIf(Predicate<DexType> predicate) {
        return this.keepIf(PredicateUtils.not(predicate));
    }

    @Override
    public DexTypeList self() {
        return this;
    }

    @Override
    public StructuralMapping<DexTypeList> getStructuralMapping() {
        return DexTypeList::specify;
    }

    public boolean contains(DexType type) {
        return ArrayUtils.contains(this.values, type);
    }

    @Override
    public void forEach(Consumer<? super DexType> consumer) {
        for (DexType value : this.values) {
            consumer.accept(value);
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    void collectIndexedItems(IndexedItemCollection indexedItems) {
        for (DexType type : this.values) {
            type.collectIndexedItems(indexedItems);
        }
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        mixedItems.add(this);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DexTypeList && Arrays.equals(this.values, ((DexTypeList)other).values);
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public int size() {
        return this.values.length;
    }

    public Stream<DexType> stream() {
        return Stream.of(this.values);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.values.length > 0) {
            builder.append(this.values[0]);
            for (int i = 1; i < this.values.length; ++i) {
                builder.append(' ').append(this.values[i]);
            }
        }
        return builder.toString();
    }

    @Override
    public Iterator<DexType> iterator() {
        return Iterators.forArray(this.values);
    }

    public DexTypeList getSorted() {
        if (this.values.length <= 1) {
            return this;
        }
        Object[] newValues = (DexType[])this.values.clone();
        Arrays.sort(newValues);
        return new DexTypeList((DexType[])newValues);
    }
}

