/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.ClassResolutionResult;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexApplicationReadFlags;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.graph.ProgramOrClasspathClass;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class DirectMappedDexApplication
extends DexApplication {
    private final Map<Code, DexEncodedMethod> codeOwners = new IdentityHashMap<Code, DexEncodedMethod>();
    private final ImmutableMap<DexType, ProgramOrClasspathClass> programOrClasspathClasses;
    private final ImmutableMap<DexType, DexLibraryClass> libraryClasses;
    private final ImmutableCollection<DexProgramClass> programClasses;
    private final ImmutableCollection<DexClasspathClass> classpathClasses;

    private DirectMappedDexApplication(ClassNameMapper proguardMap, DexApplicationReadFlags flags, ImmutableMap<DexType, ProgramOrClasspathClass> programOrClasspathClasses, ImmutableMap<DexType, DexLibraryClass> libraryClasses, ImmutableCollection<DexProgramClass> programClasses, ImmutableCollection<DexClasspathClass> classpathClasses, ImmutableList<DataResourceProvider> dataResourceProviders, InternalOptions options, DexString highestSortingString, Timing timing) {
        super(proguardMap, flags, dataResourceProviders, options, highestSortingString, timing);
        this.programOrClasspathClasses = programOrClasspathClasses;
        this.libraryClasses = libraryClasses;
        this.programClasses = programClasses;
        this.classpathClasses = classpathClasses;
    }

    private boolean mappingIsValid(Collection<DexProgramClass> classesBeforeLensApplication, GraphLens lens) {
        for (DexProgramClass clazz : classesBeforeLensApplication) {
            DexType type = clazz.getType();
            DexType renamed = lens.lookupType(type);
            if (!renamed.isIntType() && renamed != type && (this.definitionFor(type) != null || this.definitionFor(renamed) == null)) assert (this.definitionFor((DexType)type).type == renamed || this.definitionFor(renamed) != null) : "The lens and app is inconsistent";
        }
        return true;
    }

    public Collection<DexClasspathClass> classpathClasses() {
        return this.classpathClasses;
    }

    @Override
    Collection<DexProgramClass> programClasses() {
        return this.programClasses;
    }

    @Override
    public void forEachProgramType(Consumer<DexType> consumer) {
        this.programClasses.forEach(clazz -> consumer.accept(clazz.type));
    }

    @Override
    public void forEachLibraryType(Consumer<DexType> consumer) {
        this.libraryClasses.forEach((type, clazz) -> consumer.accept((DexType)type));
    }

    public Collection<DexLibraryClass> libraryClasses() {
        return this.libraryClasses.values();
    }

    @Override
    public ClassResolutionResult contextIndependentDefinitionForWithResolutionResult(DexType type) {
        assert (type.isClassType()) : "Cannot lookup definition for type: " + type;
        DexLibraryClass libraryClass = this.libraryClasses.get(type);
        ProgramOrClasspathClass programOrClasspathClass = this.programOrClasspathClasses.get(type);
        if (libraryClass == null && programOrClasspathClass == null) {
            return ClassResolutionResult.NoResolutionResult.noResult();
        }
        if (libraryClass != null && programOrClasspathClass == null) {
            return libraryClass;
        }
        if (libraryClass == null) {
            return programOrClasspathClass.asDexClass();
        }
        return ClassResolutionResult.builder().add(libraryClass).add(programOrClasspathClass).build();
    }

    @Override
    public DexClass definitionFor(DexType type) {
        assert (type.isClassType()) : "Cannot lookup definition for type: " + type;
        if (this.options.lookupLibraryBeforeProgram) {
            DexLibraryClass libraryClass = this.libraryClasses.get(type);
            if (libraryClass != null) {
                return libraryClass;
            }
            ProgramOrClasspathClass programOrClasspathClass = this.programOrClasspathClasses.get(type);
            return programOrClasspathClass != null ? programOrClasspathClass.asDexClass() : null;
        }
        ProgramOrClasspathClass programOrClasspathClass = this.programOrClasspathClasses.get(type);
        if (programOrClasspathClass != null && programOrClasspathClass.isProgramClass()) {
            return programOrClasspathClass.asDexClass();
        }
        DexLibraryClass libraryClass = this.libraryClasses.get(type);
        return libraryClass != null ? libraryClass : (programOrClasspathClass == null ? null : programOrClasspathClass.asDexClass());
    }

    @Override
    public DexProgramClass programDefinitionFor(DexType type) {
        ProgramOrClasspathClass programOrClasspathClass = this.programOrClasspathClasses.get(type);
        return programOrClasspathClass == null ? null : programOrClasspathClass.asProgramClass();
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public DirectMappedDexApplication toDirect() {
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public DirectMappedDexApplication asDirect() {
        return this;
    }

    @Override
    public String toString() {
        return "DexApplication (direct)";
    }

    public boolean verifyWithLens(DirectMappedDexApplication beforeLensApplication, GraphLens lens) {
        assert (this.mappingIsValid(beforeLensApplication.programClasses(), lens));
        assert (this.verifyCodeObjectsOwners());
        return true;
    }

    public Map<Code, DexEncodedMethod> computeCodeObjectOwnersForDebugging() {
        this.verifyCodeObjectsOwners();
        return this.codeOwners;
    }

    public DexEncodedMethod getCodeOwnerForDebugging(Code code) {
        return this.computeCodeObjectOwnersForDebugging().get(code);
    }

    public boolean verifyCodeObjectsOwners() {
        this.codeOwners.clear();
        for (DexProgramClass clazz : this.programClasses) {
            for (DexEncodedMethod method : clazz.methods(DexEncodedMethod::isNonAbstractNonNativeMethod)) {
                Code code = method.getCode();
                assert (code != null);
                if (code.isCfCode()) {
                    code = code.asCfCode();
                } else if (code.isSharedCodeObject()) continue;
                DexEncodedMethod otherMethod = this.codeOwners.put(code, method);
                assert (otherMethod == null);
            }
        }
        return true;
    }

    public static class Builder
    extends DexApplication.Builder<Builder> {
        private ImmutableCollection<DexClasspathClass> classpathClasses;
        private Map<DexType, DexLibraryClass> libraryClasses;
        private final List<DexClasspathClass> pendingClasspathClasses = new ArrayList<DexClasspathClass>();
        private final Set<DexType> pendingClasspathRemovalIfPresent = Sets.newIdentityHashSet();

        Builder(LazyLoadedDexApplication application) {
            super(application);
            LazyLoadedDexApplication.AllClasses allClasses = application.loadAllClasses();
            this.classpathClasses = allClasses.getClasspathClasses().values();
            this.libraryClasses = allClasses.getLibraryClasses();
            this.replaceProgramClasses(allClasses.getProgramClasses().values());
        }

        private Builder(DirectMappedDexApplication application) {
            super(application);
            this.classpathClasses = application.classpathClasses;
            this.libraryClasses = application.libraryClasses;
        }

        private void ensureMutableLibraryClassesMap() {
            if (!(this.libraryClasses instanceof IdentityHashMap)) {
                this.libraryClasses = new IdentityHashMap<DexType, DexLibraryClass>(this.libraryClasses);
            }
        }

        private void commitPendingClasspathClasses() {
            if (!this.pendingClasspathClasses.isEmpty()) {
                this.classpathClasses = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.classpathClasses)).addAll(this.pendingClasspathClasses)).build();
                this.pendingClasspathClasses.clear();
            }
        }

        private <T extends ProgramOrClasspathClass> boolean addAll(Map<DexType, ProgramOrClasspathClass> allClasses, Iterable<T> toAdd) {
            boolean seenRemoved = false;
            for (ProgramOrClasspathClass clazz : toAdd) {
                if (clazz.isProgramClass() || !this.pendingClasspathRemovalIfPresent.contains(clazz.getType())) {
                    ProgramOrClasspathClass old = allClasses.put(clazz.getType(), clazz);
                    assert (old == null) : "Class " + old.getType().toString() + " was already present.";
                    continue;
                }
                seenRemoved = true;
            }
            return seenRemoved;
        }

        private ImmutableMap<DexType, DexLibraryClass> getLibraryClassesAsImmutableMap() {
            if (this.libraryClasses instanceof ImmutableMap) {
                return (ImmutableMap)this.libraryClasses;
            }
            return ImmutableMap.copyOf(this.libraryClasses);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Builder asDirect() {
            return this;
        }

        @Override
        public void addProgramClassPotentiallyOverridingNonProgramClass(DexProgramClass clazz) {
            this.addProgramClass(clazz);
            this.pendingClasspathRemovalIfPresent.add(clazz.type);
            if (this.libraryClasses.containsKey(clazz.type)) {
                this.ensureMutableLibraryClassesMap();
                this.libraryClasses.remove(clazz.type);
            }
        }

        @Override
        Builder self() {
            return this;
        }

        public Builder addClasspathClass(DexClasspathClass clazz) {
            this.pendingClasspathClasses.add(clazz);
            return this.self();
        }

        public Builder replaceClasspathClasses(Collection<DexClasspathClass> newClasspathClasses) {
            assert (newClasspathClasses != null);
            this.classpathClasses = ImmutableList.copyOf(newClasspathClasses);
            this.pendingClasspathClasses.clear();
            return this.self();
        }

        public Builder replaceLibraryClasses(Collection<DexLibraryClass> libraryClasses) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            libraryClasses.forEach(clazz -> builder.put(clazz.type, clazz));
            this.libraryClasses = builder.build();
            return this.self();
        }

        @Override
        public DirectMappedDexApplication build() {
            this.commitPendingClasspathClasses();
            IdentityHashMap<DexType, ProgramOrClasspathClass> programAndClasspathClasses = new IdentityHashMap<DexType, ProgramOrClasspathClass>(this.getProgramClasses().size() + this.classpathClasses.size());
            ImmutableCollection newClasspathClasses = this.classpathClasses;
            if (this.addAll(programAndClasspathClasses, this.classpathClasses)) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (DexClasspathClass classpathClass : this.classpathClasses) {
                    if (this.pendingClasspathRemovalIfPresent.contains(classpathClass.getType())) continue;
                    builder.add(classpathClass);
                }
                newClasspathClasses = builder.build();
            }
            this.addAll(programAndClasspathClasses, this.getProgramClasses());
            return new DirectMappedDexApplication(this.proguardMap, this.flags, ImmutableMap.copyOf(programAndClasspathClasses), this.getLibraryClassesAsImmutableMap(), ImmutableList.copyOf(this.getProgramClasses()), newClasspathClasses, ImmutableList.copyOf(this.dataResourceProviders), this.options, this.highestSortingString, this.timing);
        }
    }
}

