/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.ClassWriter;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public final class EnclosingMethodAttribute {
    private DexType enclosingClass;
    private DexMethod enclosingMethod;

    public EnclosingMethodAttribute(DexType enclosingClass) {
        this.enclosingClass = enclosingClass;
    }

    public EnclosingMethodAttribute(DexMethod enclosingMethod) {
        this.enclosingMethod = enclosingMethod;
    }

    public static EnclosingMethodAttribute none() {
        return null;
    }

    public void write(ClassWriter writer, NamingLens lens) {
        if (this.enclosingMethod != null) {
            writer.visitOuterClass(lens.lookupInternalName(this.enclosingMethod.holder), lens.lookupName(this.enclosingMethod).toString(), this.enclosingMethod.proto.toDescriptorString(lens));
        } else {
            writer.visitOuterClass(lens.lookupInternalName(this.enclosingClass), null, null);
        }
    }

    public boolean hasEnclosingMethod() {
        return this.enclosingMethod != null;
    }

    public boolean hasEnclosingClass() {
        return this.enclosingClass != null;
    }

    public DexMethod getEnclosingMethod() {
        return this.enclosingMethod;
    }

    public DexType getEnclosingClass() {
        return this.enclosingClass;
    }

    public DexType getEnclosingType() {
        return this.enclosingMethod != null ? this.enclosingMethod.getHolderType() : this.enclosingClass;
    }

    public int hashCode() {
        assert (this.enclosingClass == null != (this.enclosingMethod == null));
        return System.identityHashCode(this.enclosingClass) + System.identityHashCode(this.enclosingMethod);
    }

    public boolean equals(Object obj) {
        return obj instanceof EnclosingMethodAttribute && this.enclosingClass == ((EnclosingMethodAttribute)obj).enclosingClass && this.enclosingMethod == ((EnclosingMethodAttribute)obj).enclosingMethod;
    }

    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        if (this.enclosingClass != null) {
            this.enclosingClass.collectIndexedItems(indexedItems);
        }
        if (this.enclosingMethod != null) {
            this.enclosingMethod.collectIndexedItems(indexedItems);
        }
    }

    public String toString() {
        return "[enclosingClass: " + (this.enclosingClass == null ? "null" : this.enclosingClass.toDescriptorString()) + ", enclosingMethod: " + (this.enclosingMethod == null ? "null" : this.enclosingMethod.toSourceString()) + "]";
    }

    public boolean isEnclosingPinned(AppView<AppInfoWithLiveness> appView) {
        if (this.enclosingMethod != null) {
            return appView.appInfo().isPinned(this.enclosingMethod);
        }
        if (this.enclosingClass != null) {
            return appView.appInfo().isPinned(this.enclosingClass);
        }
        return false;
    }
}

