/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.FieldAccessInfoCollection;
import com.android.tools.r8.graph.FieldAccessInfoImpl;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.utils.ObjectUtils;
import com.android.tools.r8.utils.SetUtils;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;

public class FieldAccessInfoCollectionImpl
implements FieldAccessInfoCollection<FieldAccessInfoImpl> {
    private final Map<DexField, FieldAccessInfoImpl> infos;

    public FieldAccessInfoCollectionImpl() {
        this(new IdentityHashMap<DexField, FieldAccessInfoImpl>());
    }

    public FieldAccessInfoCollectionImpl(Map<DexField, FieldAccessInfoImpl> infos) {
        this.infos = infos;
    }

    @Override
    public void destroyAccessContexts() {
        this.infos.values().forEach(FieldAccessInfoImpl::destroyAccessContexts);
    }

    @Override
    public void flattenAccessContexts() {
        this.infos.values().forEach(FieldAccessInfoImpl::flattenAccessContexts);
    }

    public FieldAccessInfoImpl computeIfAbsent(DexField field, Function<DexField, FieldAccessInfoImpl> fn) {
        return this.infos.computeIfAbsent(field, fn);
    }

    @Override
    public boolean contains(DexField field) {
        return this.infos.containsKey(field);
    }

    @Override
    public FieldAccessInfoImpl get(DexField field) {
        return this.infos.get(field);
    }

    public FieldAccessInfoImpl extend(DexField field, FieldAccessInfoImpl info) {
        assert (!this.infos.containsKey(field));
        this.infos.put(field, info);
        return info;
    }

    @Override
    public void forEach(Consumer<FieldAccessInfoImpl> consumer) {
        assert (this.verifyMappingIsOneToOne());
        this.infos.values().forEach(consumer);
    }

    @Override
    public void removeIf(BiPredicate<DexField, FieldAccessInfoImpl> predicate) {
        this.infos.entrySet().removeIf((? super E entry) -> predicate.test((DexField)entry.getKey(), (FieldAccessInfoImpl)entry.getValue()));
    }

    @Override
    public void restrictToProgram(DexDefinitionSupplier definitions) {
        this.removeIf((field, info) -> !definitions.definitionForHolder(field).isProgramClass());
    }

    public FieldAccessInfoCollectionImpl rewrittenWithLens(DexDefinitionSupplier definitions, GraphLens lens) {
        FieldAccessInfoCollectionImpl collection = new FieldAccessInfoCollectionImpl();
        Consumer<FieldAccessInfoImpl> rewriteAndMergeFieldInfo = info -> {
            FieldAccessInfoImpl rewrittenInfo = info.rewrittenWithLens(definitions, lens);
            DexField newField = rewrittenInfo.getField();
            collection.infos.compute(newField, (ignore, oldInfo) -> ObjectUtils.mapNotNullOrDefault(oldInfo, rewrittenInfo, rewrittenInfo::join));
        };
        this.infos.values().forEach(rewriteAndMergeFieldInfo);
        return collection;
    }

    public boolean verifyMappingIsOneToOne() {
        assert (this.infos.values().size() == SetUtils.newIdentityHashSet(this.infos.values()).size());
        return true;
    }
}

