/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.MemberResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.SuccessfulMemberResolutionResult;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.OptionalBool;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class FieldResolutionResult
extends MemberResolutionResult<DexEncodedField, DexField> {
    public static FailedFieldResolutionResult failure() {
        return FailedFieldResolutionResult.INSTANCE;
    }

    public static UnknownFieldResolutionResult unknown() {
        return UnknownFieldResolutionResult.INSTANCE;
    }

    public static SingleFieldResolutionResult<?> createSingleFieldResolutionResult(DexClass initialResolutionHolder, DexClass holder, DexEncodedField definition) {
        if (holder.isLibraryClass()) {
            return new SingleLibraryFieldResolutionResult(initialResolutionHolder, holder.asLibraryClass(), definition);
        }
        if (holder.isClasspathClass()) {
            return new SingleClasspathFieldResolutionResult(initialResolutionHolder, holder.asClasspathClass(), definition);
        }
        assert (holder.isProgramClass());
        return new SingleProgramFieldResolutionResult(initialResolutionHolder, holder.asProgramClass(), definition);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isFieldResolutionResult() {
        return true;
    }

    @Override
    public FieldResolutionResult asFieldResolutionResult() {
        return this;
    }

    public DexEncodedField getResolvedField() {
        return null;
    }

    public DexField getResolvedFieldReference() {
        return null;
    }

    public DexClassAndField getResolutionPair() {
        return null;
    }

    public ProgramField getSingleProgramField() {
        return null;
    }

    public ProgramField getProgramField() {
        return null;
    }

    public boolean isSingleFieldResolutionResult() {
        return false;
    }

    public boolean isSingleProgramFieldResolutionResult() {
        return false;
    }

    public boolean hasSuccessfulResolutionResult() {
        return false;
    }

    public SingleFieldResolutionResult<?> asSingleFieldResolutionResult() {
        return null;
    }

    public SingleProgramFieldResolutionResult asSingleProgramFieldResolutionResult() {
        return null;
    }

    public SingleClasspathFieldResolutionResult asSingleClasspathFieldResolutionResult() {
        return null;
    }

    @Override
    public boolean isSuccessfulMemberResolutionResult() {
        return false;
    }

    public SingleFieldResolutionResult<?> asSuccessfulMemberResolutionResult() {
        return null;
    }

    public boolean isPossiblyFailedOrUnknownResolution() {
        return false;
    }

    public boolean hasProgramOrClasspathResult() {
        return false;
    }

    public boolean hasProgramResult() {
        return false;
    }

    public boolean hasClasspathResult() {
        return false;
    }

    public boolean isMultiFieldResolutionResult() {
        return false;
    }

    public final void forEachFieldResolutionResult(Consumer<FieldResolutionResult> resultConsumer) {
        this.visitFieldResolutionResults(resultConsumer, resultConsumer, resultConsumer);
    }

    public final void forEachSuccessfulFieldResolutionResult(Consumer<SingleFieldResolutionResult<?>> resultConsumer) {
        this.visitFieldResolutionResults(resultConsumer, failedResult -> {});
    }

    public final void visitFieldResolutionResults(Consumer<SingleFieldResolutionResult<?>> singleResultConsumer, Consumer<FailedOrUnknownFieldResolutionResult> failedResolutionConsumer) {
        this.visitFieldResolutionResults(singleResultConsumer, singleResultConsumer, failedResolutionConsumer);
    }

    public abstract void visitFieldResolutionResults(Consumer<? super SingleFieldResolutionResult<?>> var1, Consumer<? super SingleLibraryFieldResolutionResult> var2, Consumer<? super FailedOrUnknownFieldResolutionResult> var3);

    public DexClass getInitialResolutionHolder() {
        return null;
    }

    public static class Builder {
        private FieldResolutionResult currentResult = null;

        private Builder() {
        }

        public void addResolutionResult(FieldResolutionResult otherResult) {
            if (this.currentResult == null) {
                this.currentResult = otherResult;
                return;
            }
            Box singleResult = new Box();
            ArrayList<SingleLibraryFieldResolutionResult> libraryResults = new ArrayList<SingleLibraryFieldResolutionResult>();
            ArrayList<FailedOrUnknownFieldResolutionResult> failedResults = new ArrayList<FailedOrUnknownFieldResolutionResult>();
            this.currentResult.visitFieldResolutionResults(singleResult::set, libraryResults::add, failedResults::add);
            otherResult.visitFieldResolutionResults(otherProgramOrClasspathResult -> {
                if (singleResult.isSet()) {
                    assert (false) : "Unexpected multiple results between program and classpath";
                    if (((SingleFieldResolutionResult)singleResult.get()).hasProgramResult()) {
                        return;
                    }
                }
                singleResult.set(otherProgramOrClasspathResult);
            }, newLibraryResult -> {
                if (!Iterables.any(libraryResults, existing -> existing.getResolvedHolder() == newLibraryResult.getResolvedHolder())) {
                    libraryResults.add((SingleLibraryFieldResolutionResult)newLibraryResult);
                }
            }, newFailedResult -> {
                if (!Iterables.any(failedResults, existing -> existing.isFailedResolution() == newFailedResult.isFailedResolution())) {
                    failedResults.add((FailedOrUnknownFieldResolutionResult)newFailedResult);
                }
            });
            if (!singleResult.isSet()) {
                this.currentResult = libraryResults.size() == 1 && failedResults.isEmpty() ? (FieldResolutionResult)libraryResults.get(0) : (libraryResults.isEmpty() && failedResults.size() == 1 ? (FieldResolutionResult)failedResults.get(0) : new MultipleLibraryFieldResolutionResult(libraryResults, failedResults));
            } else if (libraryResults.isEmpty() && failedResults.isEmpty()) {
                this.currentResult = (FieldResolutionResult)singleResult.get();
            } else if (((SingleFieldResolutionResult)singleResult.get()).hasProgramResult()) {
                this.currentResult = new MultipleProgramWithLibraryFieldResolutionResult(((SingleFieldResolutionResult)singleResult.get()).asSingleProgramFieldResolutionResult(), (List<SingleLibraryFieldResolutionResult>)libraryResults, (List<FailedOrUnknownFieldResolutionResult>)failedResults);
            } else {
                SingleClasspathFieldResolutionResult classpathResult = ((SingleFieldResolutionResult)singleResult.get()).asSingleClasspathFieldResolutionResult();
                assert (classpathResult != null);
                this.currentResult = new MultipleClasspathWithLibraryFieldResolutionResult(classpathResult, (List<SingleLibraryFieldResolutionResult>)libraryResults, (List<FailedOrUnknownFieldResolutionResult>)failedResults);
            }
        }

        public FieldResolutionResult buildOrIfEmpty(FieldResolutionResult emptyResult) {
            return this.currentResult == null ? emptyResult : this.currentResult;
        }
    }

    public static class UnknownFieldResolutionResult
    extends FailedOrUnknownFieldResolutionResult {
        private static final UnknownFieldResolutionResult INSTANCE = new UnknownFieldResolutionResult();
    }

    public static class FailedFieldResolutionResult
    extends FailedOrUnknownFieldResolutionResult {
        private static final FailedFieldResolutionResult INSTANCE = new FailedFieldResolutionResult();

        @Override
        public boolean isFailedResolution() {
            return true;
        }
    }

    public static abstract class FailedOrUnknownFieldResolutionResult
    extends FieldResolutionResult {
        @Override
        public OptionalBool isAccessibleFrom(ProgramDefinition context, AppInfoWithClassHierarchy appInfo) {
            return OptionalBool.FALSE;
        }

        @Override
        public void visitFieldResolutionResults(Consumer<? super SingleFieldResolutionResult<?>> programOrClasspathConsumer, Consumer<? super SingleLibraryFieldResolutionResult> libraryResultConsumer, Consumer<? super FailedOrUnknownFieldResolutionResult> failedResolutionConsumer) {
            failedResolutionConsumer.accept(this);
        }

        @Override
        public boolean isPossiblyFailedOrUnknownResolution() {
            return true;
        }
    }

    public static class MultipleLibraryFieldResolutionResult
    extends MultipleFieldResolutionResult<DexProgramClass, SingleProgramFieldResolutionResult> {
        public MultipleLibraryFieldResolutionResult(List<SingleLibraryFieldResolutionResult> libraryResolutionResults, List<FailedOrUnknownFieldResolutionResult> failedOrUnknownResolutionResults) {
            super(null, libraryResolutionResults, failedOrUnknownResolutionResults);
        }
    }

    public static class MultipleClasspathWithLibraryFieldResolutionResult
    extends MultipleFieldResolutionResult<DexClasspathClass, SingleClasspathFieldResolutionResult> {
        public MultipleClasspathWithLibraryFieldResolutionResult(SingleClasspathFieldResolutionResult programOrClasspathResult, List<SingleLibraryFieldResolutionResult> libraryResolutionResults, List<FailedOrUnknownFieldResolutionResult> failedOrUnknownResolutionResults) {
            super(programOrClasspathResult, libraryResolutionResults, failedOrUnknownResolutionResults);
        }
    }

    public static class MultipleProgramWithLibraryFieldResolutionResult
    extends MultipleFieldResolutionResult<DexProgramClass, SingleProgramFieldResolutionResult> {
        public MultipleProgramWithLibraryFieldResolutionResult(SingleProgramFieldResolutionResult programOrClasspathResult, List<SingleLibraryFieldResolutionResult> libraryResolutionResults, List<FailedOrUnknownFieldResolutionResult> failedOrUnknownResolutionResults) {
            super(programOrClasspathResult, libraryResolutionResults, failedOrUnknownResolutionResults);
        }

        @Override
        public ProgramField getProgramField() {
            return this.programOrClasspathResult == null ? null : ((SingleProgramFieldResolutionResult)this.programOrClasspathResult).getProgramField();
        }
    }

    public static abstract class MultipleFieldResolutionResult<C extends DexClass, T extends SingleFieldResolutionResult<C>>
    extends FieldResolutionResult {
        protected final T programOrClasspathResult;
        protected final List<SingleLibraryFieldResolutionResult> libraryResolutionResults;
        protected final List<FailedOrUnknownFieldResolutionResult> failedOrUnknownResolutionResults;

        public MultipleFieldResolutionResult(T programOrClasspathResult, List<SingleLibraryFieldResolutionResult> libraryResolutionResults, List<FailedOrUnknownFieldResolutionResult> failedOrUnknownResolutionResults) {
            assert (programOrClasspathResult == null || !((DexClass)((SingleFieldResolutionResult)programOrClasspathResult).getResolvedHolder()).isLibraryClass());
            assert (failedOrUnknownResolutionResults.stream().allMatch(FieldResolutionResult::isPossiblyFailedOrUnknownResolution));
            assert (BooleanUtils.intValue(programOrClasspathResult != null) + libraryResolutionResults.size() + failedOrUnknownResolutionResults.size() > 1) : "Should have been a single or failed result";
            this.programOrClasspathResult = programOrClasspathResult;
            this.libraryResolutionResults = libraryResolutionResults;
            this.failedOrUnknownResolutionResults = failedOrUnknownResolutionResults;
        }

        @Override
        public boolean isMultiFieldResolutionResult() {
            return true;
        }

        @Override
        public DexClass getInitialResolutionHolder() {
            throw new Unimplemented("Should not be called on MultipleFieldResolutionResult");
        }

        @Override
        public boolean hasProgramOrClasspathResult() {
            return this.programOrClasspathResult != null;
        }

        @Override
        public boolean hasProgramResult() {
            return this.programOrClasspathResult != null && ((FieldResolutionResult)this.programOrClasspathResult).hasProgramResult();
        }

        @Override
        public boolean hasClasspathResult() {
            return this.programOrClasspathResult != null && ((FieldResolutionResult)this.programOrClasspathResult).hasClasspathResult();
        }

        @Override
        public OptionalBool isAccessibleFrom(ProgramDefinition context, AppInfoWithClassHierarchy appInfo) {
            throw new Unimplemented("Should not be called on MultipleFieldResolutionResult");
        }

        @Override
        public boolean isPossiblyFailedOrUnknownResolution() {
            return !this.failedOrUnknownResolutionResults.isEmpty();
        }

        @Override
        public boolean isSuccessfulMemberResolutionResult() {
            return this.failedOrUnknownResolutionResults.isEmpty();
        }

        @Override
        public void visitFieldResolutionResults(Consumer<? super SingleFieldResolutionResult<?>> programOrClasspathConsumer, Consumer<? super SingleLibraryFieldResolutionResult> libraryResultConsumer, Consumer<? super FailedOrUnknownFieldResolutionResult> failedResolutionConsumer) {
            if (this.programOrClasspathResult != null) {
                programOrClasspathConsumer.accept((SingleFieldResolutionResult<?>)this.programOrClasspathResult);
            }
            this.libraryResolutionResults.forEach(libraryResultConsumer);
            this.failedOrUnknownResolutionResults.forEach(failedResolutionConsumer);
        }

        @Override
        public boolean hasSuccessfulResolutionResult() {
            return this.hasProgramOrClasspathResult() || !this.libraryResolutionResults.isEmpty();
        }
    }

    public static class SingleLibraryFieldResolutionResult
    extends SingleFieldResolutionResult<DexLibraryClass> {
        SingleLibraryFieldResolutionResult(DexClass initialResolutionHolder, DexLibraryClass resolvedHolder, DexEncodedField resolvedField) {
            super(initialResolutionHolder, resolvedHolder, resolvedField);
        }

        @Override
        public void visitFieldResolutionResults(Consumer<? super SingleFieldResolutionResult<?>> programOrClasspathConsumer, Consumer<? super SingleLibraryFieldResolutionResult> libraryResultConsumer, Consumer<? super FailedOrUnknownFieldResolutionResult> failedResolutionConsumer) {
            libraryResultConsumer.accept(this);
        }
    }

    public static class SingleClasspathFieldResolutionResult
    extends SingleFieldResolutionResult<DexClasspathClass> {
        SingleClasspathFieldResolutionResult(DexClass initialResolutionHolder, DexClasspathClass resolvedHolder, DexEncodedField resolvedField) {
            super(initialResolutionHolder, resolvedHolder, resolvedField);
        }

        @Override
        public SingleClasspathFieldResolutionResult asSingleClasspathFieldResolutionResult() {
            return this;
        }

        @Override
        public boolean hasProgramOrClasspathResult() {
            return true;
        }

        @Override
        public boolean hasClasspathResult() {
            return true;
        }

        @Override
        public void visitFieldResolutionResults(Consumer<? super SingleFieldResolutionResult<?>> programOrClasspathConsumer, Consumer<? super SingleLibraryFieldResolutionResult> libraryResultConsumer, Consumer<? super FailedOrUnknownFieldResolutionResult> failedResolutionConsumer) {
            programOrClasspathConsumer.accept(this);
        }
    }

    public static class SingleProgramFieldResolutionResult
    extends SingleFieldResolutionResult<DexProgramClass> {
        SingleProgramFieldResolutionResult(DexClass initialResolutionHolder, DexProgramClass resolvedHolder, DexEncodedField resolvedField) {
            super(initialResolutionHolder, resolvedHolder, resolvedField);
        }

        @Override
        public ProgramField getProgramField() {
            return this.getSingleProgramField();
        }

        @Override
        public ProgramField getSingleProgramField() {
            return new ProgramField((DexProgramClass)this.getResolvedHolder(), this.getResolvedField());
        }

        @Override
        public boolean isSingleProgramFieldResolutionResult() {
            return true;
        }

        @Override
        public SingleProgramFieldResolutionResult asSingleProgramFieldResolutionResult() {
            return this;
        }

        @Override
        public boolean hasProgramOrClasspathResult() {
            return true;
        }

        @Override
        public boolean hasProgramResult() {
            return true;
        }

        @Override
        public void visitFieldResolutionResults(Consumer<? super SingleFieldResolutionResult<?>> programOrClasspathConsumer, Consumer<? super SingleLibraryFieldResolutionResult> libraryResultConsumer, Consumer<? super FailedOrUnknownFieldResolutionResult> failedResolutionConsumer) {
            programOrClasspathConsumer.accept(this);
        }
    }

    public static abstract class SingleFieldResolutionResult<T extends DexClass>
    extends FieldResolutionResult
    implements SuccessfulMemberResolutionResult<DexEncodedField, DexField> {
        private final DexClass initialResolutionHolder;
        private final T resolvedHolder;
        private final DexEncodedField resolvedField;

        SingleFieldResolutionResult(DexClass initialResolutionHolder, T resolvedHolder, DexEncodedField resolvedField) {
            assert (((DexClass)resolvedHolder).type == resolvedField.getHolderType());
            this.initialResolutionHolder = initialResolutionHolder;
            this.resolvedHolder = resolvedHolder;
            this.resolvedField = resolvedField;
        }

        @Override
        public DexClass getInitialResolutionHolder() {
            return this.initialResolutionHolder;
        }

        public T getResolvedHolder() {
            return this.resolvedHolder;
        }

        @Override
        public DexEncodedField getResolvedField() {
            return this.resolvedField;
        }

        @Override
        public DexField getResolvedFieldReference() {
            return (DexField)this.resolvedField.getReference();
        }

        @Override
        public DexEncodedField getResolvedMember() {
            return this.resolvedField;
        }

        @Override
        public DexClassAndField getResolutionPair() {
            return DexClassAndField.create(this.resolvedHolder, this.resolvedField);
        }

        @Override
        public OptionalBool isAccessibleFrom(ProgramDefinition context, AppInfoWithClassHierarchy appInfo) {
            return AccessControl.isMemberAccessible(this, context, appInfo);
        }

        @Override
        public boolean isSingleFieldResolutionResult() {
            return true;
        }

        public SingleFieldResolutionResult<T> asSingleFieldResolutionResult() {
            return this;
        }

        @Override
        public boolean isSuccessfulMemberResolutionResult() {
            return true;
        }

        @Override
        public SingleFieldResolutionResult<T> asSuccessfulMemberResolutionResult() {
            return this;
        }

        @Override
        public boolean hasSuccessfulResolutionResult() {
            return true;
        }
    }
}

