/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GenericSignatureFormatDiagnostic;
import com.android.tools.r8.graph.GenericSignaturePrinter;
import com.android.tools.r8.graph.GenericSignatureVisitor;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.DescriptorUtils;
import java.lang.reflect.GenericSignatureFormatError;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class GenericSignature {
    private static final List<FormalTypeParameter> EMPTY_TYPE_PARAMS = ImmutableList.of();
    private static final List<FieldTypeSignature> EMPTY_TYPE_ARGUMENTS = ImmutableList.of();
    private static final List<ClassTypeSignature> EMPTY_SUPER_INTERFACES = ImmutableList.of();
    private static final List<TypeSignature> EMPTY_TYPE_SIGNATURES = ImmutableList.of();
    private static final ClassTypeSignature NO_FIELD_TYPE_SIGNATURE = new ClassTypeSignature(DexItemFactory.nullValueType, EMPTY_TYPE_ARGUMENTS);

    public static List<FormalTypeParameter> getEmptyTypeParams() {
        return EMPTY_TYPE_PARAMS;
    }

    public static List<FieldTypeSignature> getEmptyTypeArguments() {
        return EMPTY_TYPE_ARGUMENTS;
    }

    public static List<ClassTypeSignature> getEmptySuperInterfaces() {
        return EMPTY_SUPER_INTERFACES;
    }

    public static List<TypeSignature> getEmptyTypeSignatures() {
        return EMPTY_TYPE_SIGNATURES;
    }

    public static ClassSignature parseClassSignature(String className, String signature, Origin origin, DexItemFactory factory, DiagnosticsHandler diagnosticsHandler) {
        if (signature == null || signature.isEmpty()) {
            return ClassSignature.NO_CLASS_SIGNATURE;
        }
        Parser parser = new Parser(factory);
        try {
            return parser.parseClassSignature(signature);
        }
        catch (GenericSignatureFormatError e) {
            diagnosticsHandler.warning(GenericSignatureFormatDiagnostic.invalidClassSignature(signature, className, origin, e));
            return ClassSignature.NO_CLASS_SIGNATURE;
        }
    }

    public static FieldTypeSignature parseFieldTypeSignature(String fieldName, String signature, Origin origin, DexItemFactory factory, DiagnosticsHandler diagnosticsHandler) {
        if (signature == null || signature.isEmpty()) {
            return NO_FIELD_TYPE_SIGNATURE;
        }
        Parser parser = new Parser(factory);
        try {
            return parser.parseFieldTypeSignature(signature);
        }
        catch (GenericSignatureFormatError e) {
            diagnosticsHandler.warning(GenericSignatureFormatDiagnostic.invalidFieldSignature(signature, fieldName, origin, e));
            return NO_FIELD_TYPE_SIGNATURE;
        }
    }

    public static MethodTypeSignature parseMethodSignature(String methodName, String signature, Origin origin, DexItemFactory factory, DiagnosticsHandler diagnosticsHandler) {
        if (signature == null || signature.isEmpty()) {
            return MethodTypeSignature.NO_METHOD_TYPE_SIGNATURE;
        }
        Parser parser = new Parser(factory);
        try {
            return parser.parseMethodTypeSignature(signature);
        }
        catch (GenericSignatureFormatError e) {
            diagnosticsHandler.warning(GenericSignatureFormatDiagnostic.invalidMethodSignature(signature, methodName, origin, e));
            return MethodTypeSignature.NO_METHOD_TYPE_SIGNATURE;
        }
    }

    public static class Parser {
        private char symbol;
        private String identifier;
        private boolean eof;
        private char[] buffer;
        private int pos;
        private final DexItemFactory factory;

        private Parser(DexItemFactory factory) {
            this.factory = factory;
        }

        private void setInput(String input) {
            this.buffer = input.toCharArray();
            this.eof = false;
            this.pos = 0;
            this.symbol = '\u0000';
            this.identifier = null;
            this.scanSymbol();
        }

        private DexType parsedTypeName(String name) {
            String originalDescriptor = DescriptorUtils.getDescriptorFromClassBinaryName(name);
            return this.factory.createType(originalDescriptor);
        }

        private DexType parsedInnerTypeName(DexType enclosingType, String name) {
            if (enclosingType == null) {
                return null;
            }
            assert (enclosingType.isClassType());
            String enclosingDescriptor = enclosingType.toDescriptorString();
            return this.factory.createType(DescriptorUtils.getDescriptorFromClassBinaryName(DescriptorUtils.getClassBinaryNameFromDescriptor(enclosingDescriptor) + '$' + name));
        }

        private ClassSignature parseClassSignature() {
            List<FormalTypeParameter> formalTypeParameters = this.parseOptFormalTypeParameters();
            ClassTypeSignature superClassSignature = this.parseClassTypeSignature();
            ImmutableList.Builder builder = ImmutableList.builder();
            while (this.symbol > '\u0000') {
                builder.add(this.parseClassTypeSignature());
            }
            return new ClassSignature(formalTypeParameters, superClassSignature, (List<ClassTypeSignature>)((Object)builder.build()));
        }

        private List<FormalTypeParameter> parseOptFormalTypeParameters() {
            if (this.symbol != '<') {
                return EMPTY_TYPE_PARAMS;
            }
            this.scanSymbol();
            ImmutableList.Builder builder = ImmutableList.builder();
            while (this.symbol != '>' && this.symbol > '\u0000') {
                builder.add(this.updateFormalTypeParameter());
            }
            this.expect('>');
            return builder.build();
        }

        private FormalTypeParameter updateFormalTypeParameter() {
            this.scanIdentifier();
            assert (this.identifier != null);
            String typeParameterIdentifier = this.identifier;
            this.expect(':');
            FieldTypeSignature classBound = NO_FIELD_TYPE_SIGNATURE;
            if (this.symbol == 'L' || this.symbol == '[' || this.symbol == 'T') {
                classBound = this.parseFieldTypeSignature();
            }
            ImmutableList.Builder builder = null;
            while (this.symbol == ':') {
                if (builder == null) {
                    builder = ImmutableList.builder();
                }
                this.scanSymbol();
                builder.add(this.parseFieldTypeSignature());
            }
            if (builder == null) {
                return new FormalTypeParameter(typeParameterIdentifier, classBound, EMPTY_TYPE_ARGUMENTS);
            }
            return new FormalTypeParameter(typeParameterIdentifier, classBound, (List<FieldTypeSignature>)((Object)builder.build()));
        }

        private FieldTypeSignature parseFieldTypeSignature() {
            switch (this.symbol) {
                case 'L': {
                    return this.parseClassTypeSignature();
                }
                case '[': {
                    this.scanSymbol();
                    TypeSignature baseTypeSignature = this.updateTypeSignature();
                    return baseTypeSignature.toArrayTypeSignature().asFieldTypeSignature();
                }
                case 'T': {
                    return this.updateTypeVariableSignature();
                }
            }
            this.parseError("Expected L, [ or T", this.pos);
            throw new Unreachable("Either FieldTypeSignature is returned or a parse error is thrown.");
        }

        private ClassTypeSignature parseClassTypeSignature() {
            this.expect('L');
            StringBuilder qualIdent = new StringBuilder();
            this.scanIdentifier();
            assert (this.identifier != null);
            while (this.symbol == '/') {
                qualIdent.append(this.identifier).append(this.symbol);
                this.scanSymbol();
                this.scanIdentifier();
                assert (this.identifier != null);
            }
            qualIdent.append(this.identifier);
            DexType parsedEnclosingType = this.parsedTypeName(qualIdent.toString());
            List<FieldTypeSignature> typeArguments = this.updateOptTypeArguments();
            ClassTypeSignature outerTypeSignature = new ClassTypeSignature(parsedEnclosingType, typeArguments.isEmpty() ? EMPTY_TYPE_ARGUMENTS : typeArguments);
            ClassTypeSignature innerTypeSignature = null;
            while (this.symbol == '.') {
                this.scanSymbol();
                this.scanIdentifier();
                assert (this.identifier != null);
                parsedEnclosingType = this.parsedInnerTypeName(parsedEnclosingType, this.identifier);
                typeArguments = this.updateOptTypeArguments();
                outerTypeSignature = innerTypeSignature = new ClassTypeSignature(parsedEnclosingType, typeArguments.isEmpty() ? EMPTY_TYPE_ARGUMENTS : typeArguments, outerTypeSignature);
            }
            this.expect(';');
            return innerTypeSignature != null ? innerTypeSignature : outerTypeSignature;
        }

        private List<FieldTypeSignature> updateOptTypeArguments() {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (this.symbol == '<') {
                this.scanSymbol();
                builder.add(this.updateTypeArgument());
                while (this.symbol != '>' && this.symbol > '\u0000') {
                    builder.add(this.updateTypeArgument());
                }
                this.expect('>');
            }
            return builder.build();
        }

        private FieldTypeSignature updateTypeArgument() {
            if (this.symbol == '*') {
                this.scanSymbol();
                return StarFieldTypeSignature.STAR_FIELD_TYPE_SIGNATURE;
            }
            if (this.symbol == '+') {
                this.scanSymbol();
                return this.parseFieldTypeSignature().asArgument(WildcardIndicator.POSITIVE);
            }
            if (this.symbol == '-') {
                this.scanSymbol();
                return this.parseFieldTypeSignature().asArgument(WildcardIndicator.NEGATIVE);
            }
            return this.parseFieldTypeSignature().asArgument(WildcardIndicator.NONE);
        }

        private TypeVariableSignature updateTypeVariableSignature() {
            this.expect('T');
            this.scanIdentifier();
            assert (this.identifier != null);
            this.expect(';');
            return new TypeVariableSignature(this.identifier);
        }

        private TypeSignature updateTypeSignature() {
            switch (this.symbol) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    DexType type = this.factory.createType(String.valueOf(this.symbol));
                    BaseTypeSignature baseTypeSignature = new BaseTypeSignature(type);
                    this.scanSymbol();
                    return baseTypeSignature;
                }
            }
            return this.parseFieldTypeSignature();
        }

        private MethodTypeSignature parseMethodTypeSignature() {
            List<FormalTypeParameter> formalTypeParameters = this.parseOptFormalTypeParameters();
            this.expect('(');
            ImmutableList.Builder parameterSignatureBuilder = ImmutableList.builder();
            while (this.symbol != ')' && this.symbol > '\u0000') {
                parameterSignatureBuilder.add(this.updateTypeSignature());
            }
            this.expect(')');
            ReturnType returnType = this.updateReturnType();
            ImmutableList.Builder throwsSignatureBuilder = ImmutableList.builder();
            if (this.symbol == '^') {
                do {
                    this.scanSymbol();
                    if (this.symbol == 'T') {
                        throwsSignatureBuilder.add(this.updateTypeVariableSignature());
                        continue;
                    }
                    throwsSignatureBuilder.add(this.parseClassTypeSignature());
                } while (this.symbol == '^');
            }
            return new MethodTypeSignature(formalTypeParameters, (List<TypeSignature>)((Object)parameterSignatureBuilder.build()), returnType, (List<TypeSignature>)((Object)throwsSignatureBuilder.build()));
        }

        private ReturnType updateReturnType() {
            if (this.symbol != 'V') {
                return new ReturnType(this.updateTypeSignature());
            }
            this.scanSymbol();
            return ReturnType.VOID;
        }

        private void scanSymbol() {
            if (!this.eof) {
                assert (this.buffer != null);
                if (this.pos < this.buffer.length) {
                    this.symbol = this.buffer[this.pos];
                    ++this.pos;
                } else {
                    this.symbol = '\u0000';
                    this.eof = true;
                }
            } else {
                this.parseError("Unexpected end of signature", this.pos);
            }
        }

        private void expect(char c) {
            if (this.eof) {
                this.parseError("Unexpected end of signature", this.pos);
            }
            if (this.symbol == c) {
                this.scanSymbol();
            } else {
                this.parseError("Expected " + c, this.pos - 1);
            }
        }

        private boolean isStopSymbol(char ch) {
            switch (ch) {
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': {
                    return true;
                }
            }
            return false;
        }

        private void scanIdentifier() {
            if (!this.eof && this.pos < this.buffer.length) {
                StringBuilder identifierBuilder = new StringBuilder(32);
                if (!this.isStopSymbol(this.symbol)) {
                    identifierBuilder.append(this.symbol);
                    char[] bufferLocal = this.buffer;
                    assert (bufferLocal != null);
                    do {
                        char ch;
                        if ((ch = bufferLocal[this.pos]) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || !this.isStopSymbol(ch)) {
                            identifierBuilder.append(bufferLocal[this.pos]);
                            ++this.pos;
                            continue;
                        }
                        this.identifier = identifierBuilder.toString();
                        this.scanSymbol();
                        return;
                    } while (this.pos != bufferLocal.length);
                    this.identifier = identifierBuilder.toString();
                    this.symbol = '\u0000';
                    this.eof = true;
                } else {
                    this.symbol = '\u0000';
                    this.eof = true;
                    this.parseError();
                }
            } else {
                this.parseError("Unexpected end of signature", this.pos);
            }
        }

        private void parseError() {
            this.parseError("Unexpected", this.pos);
        }

        private void parseError(String message, int pos) {
            String arrow = CharBuffer.allocate(pos).toString().replace('\u0000', ' ') + '^';
            throw new GenericSignatureFormatError(message + " at position " + (pos + 1) + System.lineSeparator() + String.valueOf(this.buffer) + System.lineSeparator() + arrow);
        }

        ClassSignature parseClassSignature(String signature) {
            try {
                this.setInput(signature);
                return this.parseClassSignature();
            }
            catch (GenericSignatureFormatError e) {
                throw e;
            }
            catch (Throwable t) {
                GenericSignatureFormatError e = new GenericSignatureFormatError("Unknown error parsing class signature: " + t.getMessage());
                e.addSuppressed(t);
                throw e;
            }
        }

        MethodTypeSignature parseMethodTypeSignature(String signature) {
            try {
                this.setInput(signature);
                return this.parseMethodTypeSignature();
            }
            catch (GenericSignatureFormatError e) {
                throw e;
            }
            catch (Throwable t) {
                GenericSignatureFormatError e = new GenericSignatureFormatError("Unknown error parsing method signature: " + t.getMessage());
                e.addSuppressed(t);
                throw e;
            }
        }

        FieldTypeSignature parseFieldTypeSignature(String signature) {
            try {
                this.setInput(signature);
                return this.parseFieldTypeSignature();
            }
            catch (GenericSignatureFormatError e) {
                throw e;
            }
            catch (Throwable t) {
                GenericSignatureFormatError e = new GenericSignatureFormatError("Unknown error parsing field signature: " + t.getMessage());
                e.addSuppressed(t);
                throw e;
            }
        }
    }

    private static class InvalidMethodTypeSignature
    extends MethodTypeSignature {
        private final String genericSignature;

        public InvalidMethodTypeSignature(String genericSignature) {
            super(EMPTY_TYPE_PARAMS, EMPTY_TYPE_SIGNATURES, ReturnType.VOID, EMPTY_TYPE_SIGNATURES);
            this.genericSignature = genericSignature;
        }

        @Override
        public String toRenamedString(NamingLens namingLens, Predicate<DexType> isTypeMissing) {
            return this.genericSignature;
        }

        @Override
        public String toString() {
            return this.genericSignature;
        }

        @Override
        public boolean isInvalid() {
            return true;
        }

        @Override
        public MethodTypeSignature visit(GenericSignatureVisitor visitor) {
            assert (false) : "Should not visit an invalid signature";
            return this;
        }

        @Override
        public InvalidMethodTypeSignature toInvalid() {
            assert (false) : "Should not be called for an invalid signature";
            return this;
        }
    }

    public static class MethodTypeSignature
    implements DexDefinitionSignature<DexEncodedMethod> {
        private static final MethodTypeSignature NO_METHOD_TYPE_SIGNATURE = new MethodTypeSignature(GenericSignature.access$000(), GenericSignature.access$600(), ReturnType.VOID, GenericSignature.access$600());
        final List<FormalTypeParameter> formalTypeParameters;
        final List<TypeSignature> typeSignatures;
        final ReturnType returnType;
        final List<TypeSignature> throwsSignatures;

        public static MethodTypeSignature noSignature() {
            return NO_METHOD_TYPE_SIGNATURE;
        }

        MethodTypeSignature(List<FormalTypeParameter> formalTypeParameters, List<TypeSignature> typeSignatures, ReturnType returnType, List<TypeSignature> throwsSignatures) {
            assert (formalTypeParameters != null);
            assert (typeSignatures != null);
            assert (returnType != null);
            assert (throwsSignatures != null);
            this.formalTypeParameters = formalTypeParameters;
            this.typeSignatures = typeSignatures;
            this.returnType = returnType;
            this.throwsSignatures = throwsSignatures;
        }

        public TypeSignature getParameterTypeSignature(int i) {
            if (this.typeSignatures.isEmpty() || i < 0 || i >= this.typeSignatures.size()) {
                return null;
            }
            return this.typeSignatures.get(i);
        }

        public ReturnType returnType() {
            return this.returnType;
        }

        public List<TypeSignature> throwsSignatures() {
            return this.throwsSignatures;
        }

        @Override
        public boolean isMethodTypeSignature() {
            return true;
        }

        @Override
        public boolean hasSignature() {
            return this != NO_METHOD_TYPE_SIGNATURE;
        }

        @Override
        public MethodTypeSignature asMethodTypeSignature() {
            return this;
        }

        public MethodTypeSignature visit(GenericSignatureVisitor visitor) {
            List<FormalTypeParameter> rewrittenParameters = visitor.visitFormalTypeParameters(this.formalTypeParameters);
            List<TypeSignature> rewrittenSignatures = visitor.visitMethodTypeSignatures(this.typeSignatures);
            ReturnType rewrittenReturnType = visitor.visitReturnType(this.returnType);
            List<TypeSignature> rewrittenThrows = visitor.visitThrowsSignatures(this.throwsSignatures);
            if (this.formalTypeParameters == rewrittenParameters && this.typeSignatures == rewrittenSignatures && this.returnType == rewrittenReturnType && this.throwsSignatures == rewrittenThrows) {
                return this;
            }
            return new MethodTypeSignature(rewrittenParameters, rewrittenSignatures, rewrittenReturnType, rewrittenThrows);
        }

        public List<FormalTypeParameter> getFormalTypeParameters() {
            return this.formalTypeParameters;
        }

        public String toRenamedString(NamingLens namingLens, Predicate<DexType> isTypeMissing) {
            if (this.hasNoSignature()) {
                return null;
            }
            GenericSignaturePrinter genericSignaturePrinter = new GenericSignaturePrinter(namingLens, isTypeMissing);
            genericSignaturePrinter.visitMethodSignature(this);
            return genericSignaturePrinter.toString();
        }

        public String toString() {
            return this.toRenamedString(NamingLens.getIdentityLens(), Predicates.alwaysTrue());
        }

        public InvalidMethodTypeSignature toInvalid() {
            return new InvalidMethodTypeSignature(this.toString());
        }
    }

    public static class ReturnType {
        static final ReturnType VOID = new ReturnType(null);
        final TypeSignature typeSignature;

        ReturnType(TypeSignature typeSignature) {
            this.typeSignature = typeSignature;
        }

        public boolean isVoidDescriptor() {
            return this.typeSignature == null;
        }

        public TypeSignature typeSignature() {
            return this.typeSignature;
        }
    }

    public static class BaseTypeSignature
    extends TypeSignature {
        final DexType type;

        BaseTypeSignature(DexType type) {
            assert (type != null);
            assert (type.isPrimitiveType()) : type.toDescriptorString();
            this.type = type;
        }

        @Override
        public boolean isBaseTypeSignature() {
            return true;
        }

        @Override
        public BaseTypeSignature asBaseTypeSignature() {
            return this;
        }

        @Override
        public ArrayTypeSignature toArrayTypeSignature() {
            assert (!this.type.isVoidType());
            return new ArrayTypeSignature(this);
        }
    }

    public static class TypeVariableSignature
    extends FieldTypeSignature {
        final String typeVariable;

        private TypeVariableSignature(String typeVariable) {
            this(typeVariable, WildcardIndicator.NOT_AN_ARGUMENT);
        }

        private TypeVariableSignature(String typeVariable, WildcardIndicator indicator) {
            super(indicator);
            assert (typeVariable != null);
            this.typeVariable = typeVariable;
        }

        @Override
        public boolean isTypeVariableSignature() {
            return true;
        }

        @Override
        public TypeVariableSignature asTypeVariableSignature() {
            return this;
        }

        @Override
        public FieldTypeSignature asArgument(WildcardIndicator indicator) {
            assert (indicator != WildcardIndicator.NOT_AN_ARGUMENT);
            return new TypeVariableSignature(this.typeVariable, indicator);
        }

        @Override
        public ArrayTypeSignature toArrayTypeSignature() {
            return new ArrayTypeSignature(this);
        }

        public String typeVariable() {
            return this.typeVariable;
        }
    }

    public static class ArrayTypeSignature
    extends FieldTypeSignature {
        final TypeSignature elementSignature;

        ArrayTypeSignature(TypeSignature elementSignature) {
            this(elementSignature, WildcardIndicator.NOT_AN_ARGUMENT);
        }

        private ArrayTypeSignature(TypeSignature elementSignature, WildcardIndicator indicator) {
            super(indicator);
            assert (elementSignature != null);
            this.elementSignature = elementSignature;
        }

        public TypeSignature elementSignature() {
            return this.elementSignature;
        }

        @Override
        public boolean isArrayTypeSignature() {
            return true;
        }

        @Override
        public ArrayTypeSignature asArrayTypeSignature() {
            return this;
        }

        @Override
        public FieldTypeSignature asArgument(WildcardIndicator indicator) {
            assert (indicator != WildcardIndicator.NOT_AN_ARGUMENT);
            return new ArrayTypeSignature(this.elementSignature, indicator);
        }

        @Override
        public ArrayTypeSignature toArrayTypeSignature() {
            return new ArrayTypeSignature(this);
        }

        public ArrayTypeSignature visit(GenericSignatureVisitor visitor) {
            TypeSignature rewrittenElementSignature = visitor.visitTypeSignature(this.elementSignature);
            if (rewrittenElementSignature == null) {
                return null;
            }
            if (this.elementSignature == rewrittenElementSignature) {
                return this;
            }
            return new ArrayTypeSignature(rewrittenElementSignature, this.getWildcardIndicator());
        }
    }

    public static class ClassTypeSignature
    extends FieldTypeSignature {
        final DexType type;
        final List<FieldTypeSignature> typeArguments;
        final ClassTypeSignature enclosingTypeSignature;

        public ClassTypeSignature(DexType type) {
            this(type, EMPTY_TYPE_ARGUMENTS, null);
        }

        public ClassTypeSignature(DexType type, List<FieldTypeSignature> typeArguments) {
            this(type, typeArguments, null, WildcardIndicator.NOT_AN_ARGUMENT);
        }

        public ClassTypeSignature(DexType type, List<FieldTypeSignature> typeArguments, ClassTypeSignature enclosingTypeSignature) {
            this(type, typeArguments, enclosingTypeSignature, WildcardIndicator.NOT_AN_ARGUMENT);
        }

        private ClassTypeSignature(DexType type, List<FieldTypeSignature> typeArguments, ClassTypeSignature enclosingTypeSignature, WildcardIndicator indicator) {
            super(indicator);
            assert (type != null);
            assert (typeArguments != null);
            this.type = type;
            this.typeArguments = typeArguments;
            this.enclosingTypeSignature = enclosingTypeSignature;
            assert (type != DexItemFactory.nullValueType || indicator == WildcardIndicator.NOT_AN_ARGUMENT);
            assert (typeArguments.stream().allMatch(FieldTypeSignature::isArgument));
            assert (typeArguments.stream().allMatch(FieldTypeSignature::hasSignature));
        }

        public DexType type() {
            return this.type;
        }

        public List<FieldTypeSignature> typeArguments() {
            return this.typeArguments;
        }

        @Override
        public boolean isClassTypeSignature() {
            return true;
        }

        @Override
        public ClassTypeSignature asClassTypeSignature() {
            return this;
        }

        @Override
        public ClassTypeSignature asArgument(WildcardIndicator indicator) {
            assert (indicator != WildcardIndicator.NOT_AN_ARGUMENT);
            assert (this.hasSignature());
            return new ClassTypeSignature(this.type, this.typeArguments, this.enclosingTypeSignature, indicator);
        }

        @Override
        public ArrayTypeSignature toArrayTypeSignature() {
            return new ArrayTypeSignature(this);
        }

        public ClassTypeSignature visit(GenericSignatureVisitor visitor) {
            DexType visitedType = visitor.visitType(this.type);
            if (visitedType == null) {
                return null;
            }
            List<FieldTypeSignature> rewrittenArguments = visitor.visitTypeArguments(this.type, visitedType, this.typeArguments);
            ClassTypeSignature rewrittenOuter = null;
            if (this.enclosingTypeSignature != null) {
                rewrittenOuter = visitor.visitEnclosing(this.enclosingTypeSignature, this);
            }
            if (this.type == visitedType && this.typeArguments == rewrittenArguments && this.enclosingTypeSignature == rewrittenOuter) {
                return this;
            }
            return new ClassTypeSignature(visitedType, rewrittenArguments, rewrittenOuter, this.getWildcardIndicator());
        }

        public boolean hasTypeVariableArguments() {
            for (FieldTypeSignature typeArgument : this.typeArguments) {
                if (!typeArgument.isTypeVariableSignature()) continue;
                return true;
            }
            return false;
        }
    }

    static final class StarFieldTypeSignature
    extends FieldTypeSignature {
        private static final StarFieldTypeSignature STAR_FIELD_TYPE_SIGNATURE = new StarFieldTypeSignature();

        private StarFieldTypeSignature() {
            super(WildcardIndicator.NONE);
        }

        public static StarFieldTypeSignature getStarFieldTypeSignature() {
            return STAR_FIELD_TYPE_SIGNATURE;
        }

        @Override
        public FieldTypeSignature asArgument(WildcardIndicator indicator) {
            throw new Unreachable("Should not be called");
        }

        @Override
        public boolean isStar() {
            return true;
        }
    }

    private static class InvalidFieldTypeSignature
    extends FieldTypeSignature {
        private final String genericSignature;

        public InvalidFieldTypeSignature(String genericSignature) {
            super(WildcardIndicator.NONE);
            this.genericSignature = genericSignature;
        }

        @Override
        public FieldTypeSignature asArgument(WildcardIndicator indicator) {
            assert (false) : "Should not be called for an invalid signature";
            return this;
        }

        @Override
        public String toString() {
            return this.genericSignature;
        }

        @Override
        public String toRenamedString(NamingLens namingLens, Predicate<DexType> isTypeMissing) {
            return this.genericSignature;
        }

        @Override
        public InvalidFieldTypeSignature toInvalid() {
            assert (false) : " Should not be called for an invalid signature";
            return this;
        }
    }

    public static abstract class FieldTypeSignature
    extends TypeSignature
    implements DexDefinitionSignature<DexEncodedField> {
        private final WildcardIndicator wildcardIndicator;

        private FieldTypeSignature(WildcardIndicator wildcardIndicator) {
            this.wildcardIndicator = wildcardIndicator;
        }

        public static FieldTypeSignature noSignature() {
            return NO_FIELD_TYPE_SIGNATURE;
        }

        public final boolean isArgument() {
            return this.wildcardIndicator != WildcardIndicator.NOT_AN_ARGUMENT;
        }

        public WildcardIndicator getWildcardIndicator() {
            return this.wildcardIndicator;
        }

        @Override
        public boolean isFieldTypeSignature() {
            return true;
        }

        @Override
        public FieldTypeSignature asFieldTypeSignature() {
            return this;
        }

        public boolean isClassTypeSignature() {
            return false;
        }

        public ClassTypeSignature asClassTypeSignature() {
            return null;
        }

        public boolean isArrayTypeSignature() {
            return false;
        }

        public ArrayTypeSignature asArrayTypeSignature() {
            return null;
        }

        public boolean isTypeVariableSignature() {
            return false;
        }

        public TypeVariableSignature asTypeVariableSignature() {
            return null;
        }

        @Override
        public boolean hasSignature() {
            return this != NO_FIELD_TYPE_SIGNATURE;
        }

        public abstract FieldTypeSignature asArgument(WildcardIndicator var1);

        public boolean isStar() {
            return false;
        }

        public String toRenamedString(NamingLens namingLens, Predicate<DexType> isTypeMissing) {
            if (this.hasNoSignature()) {
                return null;
            }
            GenericSignaturePrinter genericSignaturePrinter = new GenericSignaturePrinter(namingLens, isTypeMissing);
            genericSignaturePrinter.visitTypeSignature(this);
            return genericSignaturePrinter.toString();
        }

        public String toString() {
            return this.toRenamedString(NamingLens.getIdentityLens(), Predicates.alwaysTrue());
        }

        public InvalidFieldTypeSignature toInvalid() {
            return new InvalidFieldTypeSignature(this.toString());
        }
    }

    public static enum WildcardIndicator {
        NOT_AN_ARGUMENT,
        NONE,
        NEGATIVE,
        POSITIVE;

    }

    public static abstract class TypeSignature {
        public boolean isFieldTypeSignature() {
            return false;
        }

        public FieldTypeSignature asFieldTypeSignature() {
            return null;
        }

        public boolean isBaseTypeSignature() {
            return false;
        }

        public BaseTypeSignature asBaseTypeSignature() {
            return null;
        }

        public ArrayTypeSignature toArrayTypeSignature() {
            return null;
        }
    }

    private static class InvalidClassSignature
    extends ClassSignature {
        private final String genericSignatureString;

        InvalidClassSignature(String genericSignatureString) {
            super(EMPTY_TYPE_PARAMS, NO_FIELD_TYPE_SIGNATURE, EMPTY_SUPER_INTERFACES);
            this.genericSignatureString = genericSignatureString;
        }

        @Override
        public String toRenamedString(NamingLens namingLens, Predicate<DexType> isTypeMissing) {
            return this.genericSignatureString;
        }

        @Override
        public String toString() {
            return this.genericSignatureString;
        }

        @Override
        public InvalidClassSignature toInvalid() {
            assert (false) : "Should not invoke toInvalid on an invalid signature";
            return this;
        }

        @Override
        public ClassSignature visit(GenericSignatureVisitor visitor) {
            assert (false) : "Should not visit an invalid signature";
            return this;
        }

        @Override
        public boolean isInvalid() {
            return true;
        }
    }

    public static class ClassSignature
    implements DexDefinitionSignature<DexClass> {
        private static final ClassSignature NO_CLASS_SIGNATURE = new ClassSignature(GenericSignature.access$000(), GenericSignature.access$100(), GenericSignature.access$200());
        final List<FormalTypeParameter> formalTypeParameters;
        final ClassTypeSignature superClassSignature;
        final List<ClassTypeSignature> superInterfaceSignatures;

        ClassSignature(List<FormalTypeParameter> formalTypeParameters, ClassTypeSignature superClassSignature, List<ClassTypeSignature> superInterfaceSignatures) {
            assert (formalTypeParameters != null);
            assert (superClassSignature != null);
            assert (superInterfaceSignatures != null);
            this.formalTypeParameters = formalTypeParameters;
            this.superClassSignature = superClassSignature;
            this.superInterfaceSignatures = superInterfaceSignatures;
        }

        public static ClassSignature noSignature() {
            return NO_CLASS_SIGNATURE;
        }

        public static ClassSignatureBuilder builder() {
            return new ClassSignatureBuilder();
        }

        public ClassTypeSignature superClassSignature() {
            return this.superClassSignature;
        }

        public List<ClassTypeSignature> superInterfaceSignatures() {
            return this.superInterfaceSignatures;
        }

        @Override
        public boolean hasSignature() {
            return this != NO_CLASS_SIGNATURE;
        }

        public InvalidClassSignature toInvalid() {
            return new InvalidClassSignature(this.toString());
        }

        @Override
        public boolean isClassSignature() {
            return true;
        }

        @Override
        public ClassSignature asClassSignature() {
            return this;
        }

        public List<FormalTypeParameter> getFormalTypeParameters() {
            return this.formalTypeParameters;
        }

        public ClassSignature visit(GenericSignatureVisitor visitor) {
            List<FormalTypeParameter> rewrittenParameters = visitor.visitFormalTypeParameters(this.formalTypeParameters);
            ClassTypeSignature rewrittenSuperClass = visitor.visitSuperClass(this.superClassSignature);
            List<ClassTypeSignature> rewrittenInterfaces = visitor.visitSuperInterfaces(this.superInterfaceSignatures);
            if (this.formalTypeParameters == rewrittenParameters && this.superClassSignature == rewrittenSuperClass && this.superInterfaceSignatures == rewrittenInterfaces) {
                return this;
            }
            return new ClassSignature(rewrittenParameters, rewrittenSuperClass, rewrittenInterfaces);
        }

        public String toRenamedString(NamingLens namingLens, Predicate<DexType> isTypeMissing) {
            if (this.hasNoSignature()) {
                return null;
            }
            GenericSignaturePrinter genericSignaturePrinter = new GenericSignaturePrinter(namingLens, isTypeMissing);
            genericSignaturePrinter.visitClassSignature(this);
            return genericSignaturePrinter.toString();
        }

        public String toString() {
            return this.toRenamedString(NamingLens.getIdentityLens(), Predicates.alwaysTrue());
        }

        public ClassSignature toObjectBoundWithSameFormals(ClassTypeSignature objectBound) {
            return new ClassSignature(this.formalTypeParameters, objectBound, GenericSignature.getEmptySuperInterfaces());
        }

        public List<FieldTypeSignature> getGenericArgumentsToSuperType(DexType type) {
            assert (this.hasSignature());
            if (this.superClassSignature.type == type) {
                return this.superClassSignature.typeArguments;
            }
            for (ClassTypeSignature superInterfaceSignature : this.superInterfaceSignatures) {
                if (superInterfaceSignature.type != type) continue;
                return superInterfaceSignature.typeArguments;
            }
            return null;
        }

        public static class ClassSignatureBuilder {
            private List<FormalTypeParameter> formalTypeParameters = new ArrayList<FormalTypeParameter>();
            private ClassTypeSignature superClassSignature = null;
            private List<ClassTypeSignature> superInterfaceSignatures = new ArrayList<ClassTypeSignature>();

            private ClassSignatureBuilder() {
            }

            public ClassSignatureBuilder addFormalTypeParameters(List<FormalTypeParameter> formals) {
                this.formalTypeParameters.addAll(formals);
                return this;
            }

            public ClassSignatureBuilder setSuperClassSignature(ClassTypeSignature superClassSignature) {
                this.superClassSignature = superClassSignature;
                return this;
            }

            public ClassSignatureBuilder addInterface(ClassTypeSignature iface) {
                this.superInterfaceSignatures.add(iface);
                return this;
            }

            public ClassSignature build() {
                ClassSignature classSignature = new ClassSignature(this.formalTypeParameters, this.superClassSignature, this.superInterfaceSignatures);
                return classSignature;
            }
        }
    }

    public static class FormalTypeParameter {
        final String name;
        final FieldTypeSignature classBound;
        final List<FieldTypeSignature> interfaceBounds;

        FormalTypeParameter(String name, FieldTypeSignature classBound, List<FieldTypeSignature> interfaceBounds) {
            this.name = name;
            this.classBound = classBound;
            this.interfaceBounds = interfaceBounds;
            assert (classBound != null);
            assert (interfaceBounds != null);
        }

        public String getName() {
            return this.name;
        }

        public FieldTypeSignature getClassBound() {
            return this.classBound;
        }

        public List<FieldTypeSignature> getInterfaceBounds() {
            return this.interfaceBounds;
        }

        public FormalTypeParameter visit(GenericSignatureVisitor visitor) {
            FieldTypeSignature rewrittenClassBound = visitor.visitClassBound(this.classBound);
            List<FieldTypeSignature> rewrittenInterfaceBounds = visitor.visitInterfaceBounds(this.interfaceBounds);
            if (this.classBound == rewrittenClassBound && this.interfaceBounds == rewrittenInterfaceBounds) {
                return this;
            }
            return new FormalTypeParameter(this.name, rewrittenClassBound == null ? FieldTypeSignature.noSignature() : rewrittenClassBound, rewrittenInterfaceBounds);
        }
    }

    static interface DexDefinitionSignature<T extends DexDefinition> {
        default public boolean isClassSignature() {
            return false;
        }

        default public boolean isFieldTypeSignature() {
            return false;
        }

        default public boolean isMethodTypeSignature() {
            return false;
        }

        default public ClassSignature asClassSignature() {
            return null;
        }

        default public FieldTypeSignature asFieldTypeSignature() {
            return null;
        }

        default public MethodTypeSignature asMethodTypeSignature() {
            return null;
        }

        public boolean hasSignature();

        default public boolean hasNoSignature() {
            return !this.hasSignature();
        }

        default public boolean isInvalid() {
            return false;
        }

        default public boolean isValid() {
            return !this.isInvalid();
        }

        public DexDefinitionSignature<T> toInvalid();
    }
}

