/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.GenericSignatureContextBuilder;
import com.android.tools.r8.graph.GenericSignatureValidationDiagnostic;
import com.android.tools.r8.shaking.KeepClassInfo;
import com.android.tools.r8.shaking.KeepFieldInfo;
import com.android.tools.r8.shaking.KeepMethodInfo;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ListUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class GenericSignatureCorrectnessHelper {
    private final AppView<?> appView;
    private final Mode mode;
    private final InternalOptions options;
    private final GenericSignatureContextBuilder contextBuilder;

    private GenericSignatureCorrectnessHelper(AppView<?> appView, GenericSignatureContextBuilder contextBuilder, Mode mode) {
        this.appView = appView;
        this.contextBuilder = contextBuilder;
        this.mode = mode;
        this.options = appView.options();
    }

    public static GenericSignatureCorrectnessHelper createForInitialCheck(AppView<?> appView, GenericSignatureContextBuilder contextBuilder) {
        return new GenericSignatureCorrectnessHelper(appView, contextBuilder, Mode.CLEAR_IF_INVALID);
    }

    public static GenericSignatureCorrectnessHelper createForVerification(AppView<?> appView, GenericSignatureContextBuilder contextBuilder) {
        return new GenericSignatureCorrectnessHelper(appView, contextBuilder, Mode.VERIFY);
    }

    private <T extends GenericSignature.DexDefinitionSignature<?>> SignatureEvaluationResult evaluate(Supplier<T> getter, Function<T, SignatureEvaluationResult> evaluate, Consumer<SignatureEvaluationResult> invalidAction) {
        GenericSignature.DexDefinitionSignature signature = (GenericSignature.DexDefinitionSignature)getter.get();
        if (signature.hasNoSignature() || signature.isInvalid()) {
            return SignatureEvaluationResult.VALID;
        }
        SignatureEvaluationResult signatureResult = evaluate.apply(signature);
        assert (signatureResult.isValid() || this.mode.doNotVerify());
        if (signatureResult.isInvalid() && this.mode.clearIfInvalid()) {
            invalidAction.accept(signatureResult);
        }
        return signatureResult;
    }

    public SignatureEvaluationResult run(Collection<DexProgramClass> programClasses) {
        if (this.appView.options().disableGenericSignatureValidation || !this.appView.options().parseSignatureAttribute()) {
            return SignatureEvaluationResult.VALID;
        }
        SignatureEvaluationResult evaluationResult = SignatureEvaluationResult.VALID;
        for (DexProgramClass clazz : programClasses) {
            evaluationResult = evaluationResult.combine(this.evaluateSignaturesForClass(clazz));
        }
        return evaluationResult;
    }

    public SignatureEvaluationResult evaluateSignaturesForClass(DexProgramClass clazz) {
        if (this.appView.options().disableGenericSignatureValidation || !this.appView.options().parseSignatureAttribute()) {
            return SignatureEvaluationResult.VALID;
        }
        GenericSignatureContextEvaluator genericSignatureContextEvaluator = new GenericSignatureContextEvaluator(this.appView, this.mode, clazz);
        GenericSignatureContextBuilder.TypeParameterContext typeParameterContext = this.contextBuilder.computeTypeParameterContext(this.appView, clazz.type, Predicates.alwaysFalse());
        SignatureEvaluationResult result = genericSignatureContextEvaluator.evaluateClassSignatureForContext(typeParameterContext);
        if (result.isInvalid() && this.mode.clearIfInvalid()) {
            KeepClassInfo classInfo = this.appView.getKeepInfo().getClassInfo(clazz);
            if (this.appView.hasLiveness() && !classInfo.isShrinkingAllowed(this.appView.options())) {
                assert (!classInfo.isSignatureRemovalAllowed(this.appView.options()));
                this.appView.options().reporter.info(GenericSignatureValidationDiagnostic.invalidClassSignature(clazz.getClassSignature().toString(), clazz.getTypeName(), clazz.getOrigin(), result));
            }
            clazz.clearClassSignature();
        }
        for (DexEncodedMethod method : clazz.methods()) {
            result = result.combine(this.evaluate(method::getGenericSignature, methodSignature -> genericSignatureContextEvaluator.visitMethodSignature(methodSignature, typeParameterContext), invalidResult -> {
                KeepMethodInfo methodInfo = this.appView.getKeepInfo().getMethodInfo(method, clazz);
                if (this.appView.hasLiveness() && !methodInfo.isShrinkingAllowed(this.appView.options())) {
                    assert (!methodInfo.isSignatureRemovalAllowed(this.appView.options()));
                    this.appView.options().reporter.info(GenericSignatureValidationDiagnostic.invalidMethodSignature(method.getGenericSignature().toString(), method.toSourceString(), clazz.getOrigin(), invalidResult));
                }
                method.clearGenericSignature();
            }));
        }
        for (DexEncodedField field : clazz.fields()) {
            result = result.combine(this.evaluate(field::getGenericSignature, fieldSignature -> genericSignatureContextEvaluator.visitFieldTypeSignature(fieldSignature, typeParameterContext), invalidResult -> {
                KeepFieldInfo fieldInfo = this.appView.getKeepInfo().getFieldInfo(field, clazz);
                if (this.appView.hasLiveness() && !fieldInfo.isShrinkingAllowed(this.appView.options())) {
                    assert (!fieldInfo.isSignatureRemovalAllowed(this.appView.options()));
                    this.appView.options().reporter.info(GenericSignatureValidationDiagnostic.invalidFieldSignature(field.getGenericSignature().toString(), field.toSourceString(), clazz.getOrigin(), invalidResult));
                }
                field.clearGenericSignature();
            }));
        }
        return result;
    }

    private static class GenericSignatureContextEvaluator {
        private final AppView<?> appView;
        private final DexProgramClass context;
        private final Mode mode;

        private GenericSignatureContextEvaluator(AppView<?> appView, Mode mode, DexProgramClass context) {
            this.appView = appView;
            this.mode = mode;
            this.context = context;
        }

        private SignatureEvaluationResult evaluateClassSignatureForContext(GenericSignatureContextBuilder.TypeParameterContext typeParameterContext) {
            GenericSignature.ClassSignature classSignature = this.context.classSignature;
            if (classSignature.hasNoSignature() || classSignature.isInvalid()) {
                return SignatureEvaluationResult.VALID;
            }
            SignatureEvaluationResult signatureEvaluationResult = this.evaluateFormalTypeParameters(classSignature.formalTypeParameters, typeParameterContext);
            if (signatureEvaluationResult.isInvalid()) {
                return signatureEvaluationResult;
            }
            if (!(this.context.superType == this.appView.dexItemFactory().objectType && classSignature.superClassSignature().hasNoSignature() || this.context.superType == classSignature.superClassSignature().type())) {
                assert (this.mode.doNotVerify()) : "Super type inconsistency in generic signature";
                return SignatureEvaluationResult.INVALID_SUPER_TYPE;
            }
            signatureEvaluationResult = this.evaluateTypeArgumentsAppliedToType(classSignature.superClassSignature().typeArguments(), this.context.superType, typeParameterContext);
            if (signatureEvaluationResult.isInvalid()) {
                return signatureEvaluationResult;
            }
            List<GenericSignature.ClassTypeSignature> superInterfaces = classSignature.superInterfaceSignatures();
            if (this.context.interfaces.size() != superInterfaces.size()) {
                assert (this.mode.doNotVerify());
                return SignatureEvaluationResult.INVALID_INTERFACE_COUNT;
            }
            DexType[] actualInterfaces = this.context.interfaces.values;
            for (int i = 0; i < actualInterfaces.length; ++i) {
                signatureEvaluationResult = this.evaluateTypeArgumentsAppliedToType(superInterfaces.get(i).typeArguments(), actualInterfaces[i], typeParameterContext);
                if (!signatureEvaluationResult.isInvalid()) continue;
                return signatureEvaluationResult;
            }
            return SignatureEvaluationResult.VALID;
        }

        private SignatureEvaluationResult visitMethodSignature(GenericSignature.MethodTypeSignature methodSignature, GenericSignatureContextBuilder.TypeParameterContext typeParameterContext) {
            if (this.context.classSignature.isInvalid()) {
                return SignatureEvaluationResult.VALID;
            }
            GenericSignatureContextBuilder.TypeParameterContext methodContext = methodSignature.formalTypeParameters.isEmpty() ? typeParameterContext : typeParameterContext.addLiveParameters(ListUtils.map(methodSignature.getFormalTypeParameters(), GenericSignature.FormalTypeParameter::getName));
            SignatureEvaluationResult evaluateResult = this.evaluateFormalTypeParameters(methodSignature.getFormalTypeParameters(), methodContext);
            if (evaluateResult.isInvalid()) {
                return evaluateResult;
            }
            evaluateResult = this.evaluateTypeArguments(methodSignature.typeSignatures, methodContext);
            if (evaluateResult.isInvalid()) {
                return evaluateResult;
            }
            evaluateResult = this.evaluateTypeArguments(methodSignature.throwsSignatures, methodContext);
            if (evaluateResult.isInvalid()) {
                return evaluateResult;
            }
            GenericSignature.ReturnType returnType = methodSignature.returnType();
            if (!returnType.isVoidDescriptor() && (evaluateResult = this.evaluateTypeArgument(returnType.typeSignature(), methodContext)).isInvalid()) {
                return evaluateResult;
            }
            return evaluateResult;
        }

        private SignatureEvaluationResult evaluateTypeArguments(List<GenericSignature.TypeSignature> typeSignatures, GenericSignatureContextBuilder.TypeParameterContext typeParameterContext) {
            for (GenericSignature.TypeSignature typeSignature : typeSignatures) {
                SignatureEvaluationResult signatureEvaluationResult = this.evaluateTypeArgument(typeSignature, typeParameterContext);
                if (!signatureEvaluationResult.isInvalid()) continue;
                return signatureEvaluationResult;
            }
            return SignatureEvaluationResult.VALID;
        }

        private SignatureEvaluationResult visitFieldTypeSignature(GenericSignature.FieldTypeSignature fieldSignature, GenericSignatureContextBuilder.TypeParameterContext typeParameterContext) {
            if (this.context.classSignature.isInvalid()) {
                return SignatureEvaluationResult.VALID;
            }
            return this.evaluateTypeArgument(fieldSignature, typeParameterContext);
        }

        private SignatureEvaluationResult evaluateFormalTypeParameters(List<GenericSignature.FormalTypeParameter> typeParameters, GenericSignatureContextBuilder.TypeParameterContext typeParameterContext) {
            for (GenericSignature.FormalTypeParameter typeParameter : typeParameters) {
                SignatureEvaluationResult evaluationResult = this.evaluateTypeParameter(typeParameter, typeParameterContext);
                if (!evaluationResult.isInvalid()) continue;
                return evaluationResult;
            }
            return SignatureEvaluationResult.VALID;
        }

        private SignatureEvaluationResult evaluateTypeParameter(GenericSignature.FormalTypeParameter typeParameter, GenericSignatureContextBuilder.TypeParameterContext typeParameterContext) {
            SignatureEvaluationResult evaluationResult = this.evaluateTypeArgument(typeParameter.classBound, typeParameterContext);
            if (evaluationResult.isInvalid()) {
                return evaluationResult;
            }
            for (GenericSignature.FieldTypeSignature interfaceBound : typeParameter.interfaceBounds) {
                evaluationResult = this.evaluateTypeArgument(interfaceBound, typeParameterContext);
                if (evaluationResult == SignatureEvaluationResult.VALID) continue;
                return evaluationResult;
            }
            return SignatureEvaluationResult.VALID;
        }

        private SignatureEvaluationResult evaluateTypeArgument(GenericSignature.TypeSignature typeSignature, GenericSignatureContextBuilder.TypeParameterContext typeParameterContext) {
            if (typeSignature.isBaseTypeSignature()) {
                return SignatureEvaluationResult.VALID;
            }
            GenericSignature.FieldTypeSignature fieldTypeSignature = typeSignature.asFieldTypeSignature();
            if (fieldTypeSignature.hasNoSignature() || fieldTypeSignature.isStar()) {
                return SignatureEvaluationResult.VALID;
            }
            if (fieldTypeSignature.isTypeVariableSignature()) {
                String typeVariable = fieldTypeSignature.asTypeVariableSignature().typeVariable();
                if (typeParameterContext.isLiveParameter(typeVariable)) {
                    return SignatureEvaluationResult.VALID;
                }
                assert (this.mode.doNotVerify());
                return SignatureEvaluationResult.INVALID_TYPE_VARIABLE_UNDEFINED;
            }
            if (fieldTypeSignature.isArrayTypeSignature()) {
                return this.evaluateTypeArgument(fieldTypeSignature.asArrayTypeSignature().elementSignature(), typeParameterContext);
            }
            assert (fieldTypeSignature.isClassTypeSignature());
            return this.evaluateTypeArguments(fieldTypeSignature.asClassTypeSignature(), typeParameterContext);
        }

        private SignatureEvaluationResult evaluateTypeArguments(GenericSignature.ClassTypeSignature classTypeSignature, GenericSignatureContextBuilder.TypeParameterContext typeParameterContext) {
            return this.evaluateTypeArgumentsAppliedToType(classTypeSignature.typeArguments, classTypeSignature.type(), typeParameterContext);
        }

        private SignatureEvaluationResult evaluateTypeArgumentsAppliedToType(List<GenericSignature.FieldTypeSignature> typeArguments, DexType type, GenericSignatureContextBuilder.TypeParameterContext typeParameterContext) {
            for (GenericSignature.FieldTypeSignature typeArgument : typeArguments) {
                SignatureEvaluationResult evaluationResult = this.evaluateTypeArgument(typeArgument, typeParameterContext);
                if (!evaluationResult.isInvalid()) continue;
                assert (this.mode.doNotVerify());
                return evaluationResult;
            }
            DexClass clazz = ((AppInfo)this.appView.appInfo()).definitionForWithoutExistenceAssert(type);
            if (clazz == null) {
                return SignatureEvaluationResult.VALID;
            }
            if (typeArguments.isEmpty()) {
                return SignatureEvaluationResult.VALID;
            }
            if (typeArguments.size() != clazz.classSignature.getFormalTypeParameters().size()) {
                assert (this.mode.doNotVerify());
                return SignatureEvaluationResult.INVALID_APPLICATION_COUNT;
            }
            return SignatureEvaluationResult.VALID;
        }
    }

    public static final class SignatureEvaluationResult
    extends Enum<SignatureEvaluationResult> {
        public static final /* enum */ SignatureEvaluationResult INVALID_SUPER_TYPE = new SignatureEvaluationResult();
        public static final /* enum */ SignatureEvaluationResult INVALID_INTERFACE_TYPE = new SignatureEvaluationResult();
        public static final /* enum */ SignatureEvaluationResult INVALID_INTERFACE_COUNT = new SignatureEvaluationResult();
        public static final /* enum */ SignatureEvaluationResult INVALID_APPLICATION_COUNT = new SignatureEvaluationResult();
        public static final /* enum */ SignatureEvaluationResult INVALID_TYPE_VARIABLE_UNDEFINED = new SignatureEvaluationResult();
        public static final /* enum */ SignatureEvaluationResult VALID = new SignatureEvaluationResult();
        private static final /* synthetic */ SignatureEvaluationResult[] $VALUES;

        public static SignatureEvaluationResult[] values() {
            return (SignatureEvaluationResult[])$VALUES.clone();
        }

        public static SignatureEvaluationResult valueOf(String name) {
            return Enum.valueOf(SignatureEvaluationResult.class, name);
        }

        static {
            $VALUES = new SignatureEvaluationResult[]{INVALID_SUPER_TYPE, INVALID_INTERFACE_TYPE, INVALID_INTERFACE_COUNT, INVALID_APPLICATION_COUNT, INVALID_TYPE_VARIABLE_UNDEFINED, VALID};
        }

        public boolean isValid() {
            return this == VALID;
        }

        public boolean isInvalid() {
            return this != VALID;
        }

        public SignatureEvaluationResult combine(SignatureEvaluationResult other) {
            return this.isInvalid() ? this : other;
        }

        public String getDescription() {
            switch (this) {
                case INVALID_APPLICATION_COUNT: {
                    return "The applied generic arguments have different count than the expected formals";
                }
                case INVALID_INTERFACE_COUNT: {
                    return "The generic signature has a different number of interfaces than the class";
                }
                case INVALID_SUPER_TYPE: {
                    return "The generic super type is not the same as the class super type";
                }
                case INVALID_TYPE_VARIABLE_UNDEFINED: {
                    return "A type variable is not in scope";
                }
            }
            assert (this.isValid());
            throw new Unreachable("Should not throw an error for a valid signature");
        }
    }

    private static enum Mode {
        VERIFY,
        CLEAR_IF_INVALID;


        public boolean doNotVerify() {
            return this.clearIfInvalid();
        }

        public boolean clearIfInvalid() {
            return this == CLEAR_IF_INVALID;
        }
    }
}

