/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import java.lang.reflect.GenericSignatureFormatError;

public class GenericSignatureFormatDiagnostic
implements Diagnostic {
    private final Origin origin;
    private final Position position;
    private final String message;

    GenericSignatureFormatDiagnostic(Origin origin, Position position, String message) {
        this.origin = origin;
        this.position = position;
        this.message = message;
    }

    static GenericSignatureFormatDiagnostic invalidClassSignature(String signature, String name, Origin origin, GenericSignatureFormatError error) {
        return GenericSignatureFormatDiagnostic.invalidSignature(signature, "class", name, origin, error);
    }

    static GenericSignatureFormatDiagnostic invalidMethodSignature(String signature, String name, Origin origin, GenericSignatureFormatError error) {
        return GenericSignatureFormatDiagnostic.invalidSignature(signature, "method", name, origin, error);
    }

    static GenericSignatureFormatDiagnostic invalidFieldSignature(String signature, String name, Origin origin, GenericSignatureFormatError error) {
        return GenericSignatureFormatDiagnostic.invalidSignature(signature, "field", name, origin, error);
    }

    private static GenericSignatureFormatDiagnostic invalidSignature(String signature, String kind, String name, Origin origin, GenericSignatureFormatError error) {
        String message = "Invalid signature '" + signature + "' for " + kind + " " + name + "." + System.lineSeparator() + "Signature is ignored and will not be present in the output." + System.lineSeparator() + "Parser error: " + error.getMessage();
        return new GenericSignatureFormatDiagnostic(origin, Position.UNKNOWN, message);
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public String getDiagnosticMessage() {
        return this.message;
    }
}

