/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.GenericSignatureContextBuilder;
import com.android.tools.r8.graph.GenericSignatureVisitor;
import com.android.tools.r8.utils.ListUtils;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class GenericSignaturePartialTypeArgumentApplier
implements GenericSignatureVisitor {
    private final GenericSignatureContextBuilder.TypeParameterContext typeParameterContext;
    private final BiPredicate<DexType, DexType> enclosingPruned;
    private final Predicate<DexType> hasGenericTypeParameters;
    private final AppView<?> appView;
    private final GenericSignature.ClassTypeSignature objectArgument;
    private boolean makeAllTypeArgumentsObject = false;

    private GenericSignaturePartialTypeArgumentApplier(AppView<?> appView, GenericSignatureContextBuilder.TypeParameterContext typeParameterContext, BiPredicate<DexType, DexType> enclosingPruned, Predicate<DexType> hasGenericTypeParameters) {
        this.appView = appView;
        this.typeParameterContext = typeParameterContext;
        this.enclosingPruned = enclosingPruned;
        this.hasGenericTypeParameters = hasGenericTypeParameters;
        this.objectArgument = new GenericSignature.ClassTypeSignature(appView.dexItemFactory().objectType).asArgument(GenericSignature.WildcardIndicator.NONE);
    }

    public static GenericSignaturePartialTypeArgumentApplier build(AppView<?> appView, GenericSignatureContextBuilder.TypeParameterContext typeParameterContext, BiPredicate<DexType, DexType> enclosingPruned, Predicate<DexType> hasGenericTypeParameters) {
        return new GenericSignaturePartialTypeArgumentApplier(appView, typeParameterContext, enclosingPruned, hasGenericTypeParameters);
    }

    public GenericSignaturePartialTypeArgumentApplier buildForMethod(List<GenericSignature.FormalTypeParameter> formals) {
        if (formals.isEmpty()) {
            return this;
        }
        return new GenericSignaturePartialTypeArgumentApplier(this.appView, this.typeParameterContext.addLiveParameters(ListUtils.map(formals, GenericSignature.FormalTypeParameter::getName)), this.enclosingPruned, this.hasGenericTypeParameters);
    }

    @Override
    public GenericSignature.ClassSignature visitClassSignature(GenericSignature.ClassSignature classSignature) {
        if (classSignature.hasNoSignature() || classSignature.isInvalid()) {
            return classSignature;
        }
        return classSignature.visit(this);
    }

    @Override
    public GenericSignature.MethodTypeSignature visitMethodSignature(GenericSignature.MethodTypeSignature methodSignature) {
        if (methodSignature.hasNoSignature() || methodSignature.isInvalid()) {
            return methodSignature;
        }
        return methodSignature.visit(this);
    }

    @Override
    public DexType visitType(DexType type) {
        return type;
    }

    @Override
    public GenericSignature.TypeSignature visitTypeSignature(GenericSignature.TypeSignature typeSignature) {
        if (typeSignature.isBaseTypeSignature()) {
            return typeSignature;
        }
        return this.visitFieldTypeSignature(typeSignature.asFieldTypeSignature());
    }

    @Override
    public GenericSignature.FormalTypeParameter visitFormalTypeParameter(GenericSignature.FormalTypeParameter formalTypeParameter) {
        GenericSignature.FormalTypeParameter rewritten = formalTypeParameter.visit(this);
        assert (rewritten.getClassBound() != null && rewritten.getClassBound().hasSignature() || !rewritten.getInterfaceBounds().isEmpty());
        return rewritten;
    }

    @Override
    public List<GenericSignature.FieldTypeSignature> visitInterfaceBounds(List<GenericSignature.FieldTypeSignature> fieldSignatures) {
        if (fieldSignatures.isEmpty()) {
            return fieldSignatures;
        }
        return ListUtils.mapOrElse(fieldSignatures, this::visitFieldTypeSignature);
    }

    @Override
    public List<GenericSignature.ClassTypeSignature> visitSuperInterfaces(List<GenericSignature.ClassTypeSignature> interfaceSignatures) {
        if (interfaceSignatures.isEmpty()) {
            return interfaceSignatures;
        }
        return ListUtils.mapOrElse(interfaceSignatures, this::visitSuperInterface);
    }

    @Override
    public List<GenericSignature.FieldTypeSignature> visitTypeArguments(DexType originalType, DexType lookedUpType, List<GenericSignature.FieldTypeSignature> typeArguments) {
        assert (originalType == lookedUpType);
        if (typeArguments.isEmpty()) {
            return typeArguments;
        }
        if (!this.hasGenericTypeParameters.test(this.appView.graphLens().lookupType(originalType))) {
            return GenericSignature.getEmptyTypeArguments();
        }
        return ListUtils.mapOrElse(typeArguments, this::visitFieldTypeSignature);
    }

    @Override
    public GenericSignature.ClassTypeSignature visitSuperInterface(GenericSignature.ClassTypeSignature classTypeSignature) {
        return classTypeSignature.visit(this);
    }

    @Override
    public GenericSignature.FieldTypeSignature visitClassBound(GenericSignature.FieldTypeSignature fieldSignature) {
        if (fieldSignature.hasNoSignature()) {
            return fieldSignature;
        }
        return this.visitFieldTypeSignature(fieldSignature);
    }

    @Override
    public GenericSignature.FieldTypeSignature visitInterfaceBound(GenericSignature.FieldTypeSignature fieldSignature) {
        return this.visitFieldTypeSignature(fieldSignature);
    }

    @Override
    public GenericSignature.ClassTypeSignature visitEnclosing(GenericSignature.ClassTypeSignature enclosingSignature, GenericSignature.ClassTypeSignature enclosedSignature) {
        DexType enclosedType;
        DexType enclosingType = this.appView.graphLens().lookupType(enclosingSignature.type());
        if (this.enclosingPruned.test(enclosingType, enclosedType = this.appView.graphLens().lookupType(enclosedSignature.type()))) {
            return null;
        }
        return enclosingSignature.visit(this);
    }

    @Override
    public List<GenericSignature.TypeSignature> visitThrowsSignatures(List<GenericSignature.TypeSignature> typeSignatures) {
        if (typeSignatures.isEmpty()) {
            return typeSignatures;
        }
        return ListUtils.mapOrElse(typeSignatures, this::visitTypeSignature);
    }

    @Override
    public GenericSignature.ReturnType visitReturnType(GenericSignature.ReturnType returnType) {
        if (returnType.isVoidDescriptor()) {
            return returnType;
        }
        GenericSignature.TypeSignature originalSignature = returnType.typeSignature;
        GenericSignature.TypeSignature rewrittenSignature = this.visitTypeSignature(originalSignature);
        if (originalSignature == rewrittenSignature) {
            return returnType;
        }
        return new GenericSignature.ReturnType(rewrittenSignature);
    }

    @Override
    public List<GenericSignature.FormalTypeParameter> visitFormalTypeParameters(List<GenericSignature.FormalTypeParameter> formalTypeParameters) {
        if (formalTypeParameters.isEmpty()) {
            return formalTypeParameters;
        }
        return ListUtils.mapOrElse(formalTypeParameters, this::visitFormalTypeParameter);
    }

    @Override
    public List<GenericSignature.TypeSignature> visitMethodTypeSignatures(List<GenericSignature.TypeSignature> typeSignatures) {
        if (typeSignatures.isEmpty()) {
            return typeSignatures;
        }
        return ListUtils.mapOrElse(typeSignatures, this::visitTypeSignature);
    }

    @Override
    public GenericSignature.ClassTypeSignature visitSuperClass(GenericSignature.ClassTypeSignature classTypeSignature) {
        return classTypeSignature.visit(this);
    }

    @Override
    public GenericSignature.FieldTypeSignature visitFieldTypeSignature(GenericSignature.FieldTypeSignature fieldSignature) {
        if (fieldSignature.hasNoSignature() || fieldSignature.isInvalid()) {
            return fieldSignature;
        }
        if (fieldSignature.isStar()) {
            return fieldSignature;
        }
        if (fieldSignature.isClassTypeSignature()) {
            return fieldSignature.asClassTypeSignature().visit(this);
        }
        if (fieldSignature.isArrayTypeSignature()) {
            return fieldSignature.asArrayTypeSignature().visit(this);
        }
        assert (fieldSignature.isTypeVariableSignature());
        if (this.makeAllTypeArgumentsObject) {
            return this.objectArgument;
        }
        String typeVariableName = fieldSignature.asTypeVariableSignature().typeVariable();
        if (this.typeParameterContext.isLiveParameter(typeVariableName)) {
            return fieldSignature;
        }
        GenericSignature.FieldTypeSignature substitution = this.typeParameterContext.getPrunedSubstitution(typeVariableName);
        if (substitution == null) {
            return this.objectArgument;
        }
        this.makeAllTypeArgumentsObject = true;
        substitution = this.visitFieldTypeSignature(substitution);
        this.makeAllTypeArgumentsObject = false;
        return substitution.isArgument() ? substitution : substitution.asArgument(GenericSignature.WildcardIndicator.NONE);
    }
}

