/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.GenericSignatureVisitor;
import com.android.tools.r8.utils.ListUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class GenericSignatureTypeRewriter {
    private final DexItemFactory factory;
    private final Predicate<DexType> wasPruned;
    private final Function<DexType, DexType> lookupType;
    private final DexProgramClass context;
    private final GenericSignature.ClassTypeSignature objectTypeSignature;
    private final Predicate<DexType> hasGenericTypeVariables;

    public GenericSignatureTypeRewriter(AppView<?> appView, DexProgramClass context, Predicate<DexType> hasGenericTypeVariables) {
        this(appView.dexItemFactory(), ((AppInfo)appView.appInfo()).hasLiveness() ? ((AppInfo)appView.appInfo()).withLiveness()::wasPruned : Predicates.alwaysFalse(), appView.graphLens()::lookupType, context, hasGenericTypeVariables);
    }

    public GenericSignatureTypeRewriter(DexItemFactory factory, Predicate<DexType> wasPruned, Function<DexType, DexType> lookupType, DexProgramClass context, Predicate<DexType> hasGenericTypeVariables) {
        this.factory = factory;
        this.wasPruned = wasPruned;
        this.lookupType = lookupType;
        this.context = context;
        this.hasGenericTypeVariables = hasGenericTypeVariables;
        this.objectTypeSignature = new GenericSignature.ClassTypeSignature(factory.objectType, GenericSignature.getEmptyTypeArguments());
    }

    public GenericSignature.ClassSignature rewrite(GenericSignature.ClassSignature classSignature) {
        if (classSignature.hasNoSignature() || classSignature.isInvalid()) {
            return classSignature;
        }
        return new GenericSignatureRewriter().visitClassSignature(classSignature);
    }

    public GenericSignature.FieldTypeSignature rewrite(GenericSignature.FieldTypeSignature fieldTypeSignature) {
        if (fieldTypeSignature.hasNoSignature() || fieldTypeSignature.isInvalid()) {
            return fieldTypeSignature;
        }
        GenericSignature.FieldTypeSignature rewrittenSignature = new GenericSignatureRewriter().visitFieldTypeSignature(fieldTypeSignature);
        return rewrittenSignature == null ? GenericSignature.FieldTypeSignature.noSignature() : rewrittenSignature;
    }

    public GenericSignature.MethodTypeSignature rewrite(GenericSignature.MethodTypeSignature methodTypeSignature) {
        if (methodTypeSignature.hasNoSignature() || methodTypeSignature.isInvalid()) {
            return methodTypeSignature;
        }
        return new GenericSignatureRewriter().visitMethodSignature(methodTypeSignature);
    }

    private class GenericSignatureRewriter
    implements GenericSignatureVisitor {
        private GenericSignatureRewriter() {
        }

        @Override
        public GenericSignature.ClassSignature visitClassSignature(GenericSignature.ClassSignature classSignature) {
            GenericSignature.ClassSignature rewritten = classSignature.visit(this);
            if (rewritten.getFormalTypeParameters().isEmpty() && rewritten.superInterfaceSignatures.isEmpty() && rewritten.superClassSignature.type == ((GenericSignatureTypeRewriter)GenericSignatureTypeRewriter.this).factory.objectType) {
                return GenericSignature.ClassSignature.noSignature();
            }
            return rewritten;
        }

        @Override
        public GenericSignature.MethodTypeSignature visitMethodSignature(GenericSignature.MethodTypeSignature methodSignature) {
            return methodSignature.visit(this);
        }

        @Override
        public GenericSignature.FieldTypeSignature visitFieldTypeSignature(GenericSignature.FieldTypeSignature fieldSignature) {
            if (fieldSignature.isStar() || fieldSignature.isTypeVariableSignature()) {
                return fieldSignature;
            }
            if (fieldSignature.isArrayTypeSignature()) {
                return fieldSignature.asArrayTypeSignature().visit(this);
            }
            assert (fieldSignature.isClassTypeSignature());
            return fieldSignature.asClassTypeSignature().visit(this);
        }

        @Override
        public GenericSignature.TypeSignature visitTypeSignature(GenericSignature.TypeSignature typeSignature) {
            if (typeSignature.isBaseTypeSignature()) {
                return typeSignature;
            }
            return this.visitFieldTypeSignature(typeSignature.asFieldTypeSignature());
        }

        @Override
        public List<GenericSignature.FormalTypeParameter> visitFormalTypeParameters(List<GenericSignature.FormalTypeParameter> formalTypeParameters) {
            if (formalTypeParameters.isEmpty()) {
                return formalTypeParameters;
            }
            return ListUtils.mapOrElse(formalTypeParameters, this::visitFormalTypeParameter);
        }

        @Override
        public GenericSignature.FormalTypeParameter visitFormalTypeParameter(GenericSignature.FormalTypeParameter formalTypeParameter) {
            boolean isEmptyClassBound;
            GenericSignature.FormalTypeParameter rewritten = formalTypeParameter.visit(this);
            boolean bl = isEmptyClassBound = rewritten.getClassBound() == null || rewritten.getClassBound().hasNoSignature();
            if (isEmptyClassBound && rewritten.getInterfaceBounds().isEmpty()) {
                return new GenericSignature.FormalTypeParameter(formalTypeParameter.getName(), GenericSignatureTypeRewriter.this.objectTypeSignature, rewritten.getInterfaceBounds());
            }
            return rewritten;
        }

        @Override
        public GenericSignature.ClassTypeSignature visitSuperClass(GenericSignature.ClassTypeSignature classTypeSignature) {
            if (((GenericSignatureTypeRewriter)GenericSignatureTypeRewriter.this).context.superType == ((GenericSignatureTypeRewriter)GenericSignatureTypeRewriter.this).factory.objectType) {
                return classTypeSignature.type == ((GenericSignatureTypeRewriter)GenericSignatureTypeRewriter.this).factory.objectType ? classTypeSignature : GenericSignatureTypeRewriter.this.objectTypeSignature;
            }
            GenericSignature.ClassTypeSignature rewritten = classTypeSignature.visit(this);
            return rewritten == null ? GenericSignatureTypeRewriter.this.objectTypeSignature : rewritten;
        }

        @Override
        public List<GenericSignature.ClassTypeSignature> visitSuperInterfaces(List<GenericSignature.ClassTypeSignature> interfaceSignatures) {
            if (interfaceSignatures.isEmpty()) {
                return interfaceSignatures;
            }
            List<GenericSignature.ClassTypeSignature> rewrittenInterfaces = ListUtils.mapOrElse(interfaceSignatures, this::visitSuperInterface);
            ArrayList<GenericSignature.ClassTypeSignature> finalInterfaces = new ArrayList<GenericSignature.ClassTypeSignature>(rewrittenInterfaces.size());
            ((GenericSignatureTypeRewriter)GenericSignatureTypeRewriter.this).context.interfaces.forEach((Consumer<? super DexType>)((Consumer<DexType>)iface -> {
                GenericSignature.ClassTypeSignature rewrittenSignature = ListUtils.firstMatching(rewrittenInterfaces, rewritten -> rewritten.type == iface);
                finalInterfaces.add(rewrittenSignature != null ? rewrittenSignature : new GenericSignature.ClassTypeSignature((DexType)iface));
            }));
            return finalInterfaces;
        }

        @Override
        public GenericSignature.ClassTypeSignature visitSuperInterface(GenericSignature.ClassTypeSignature classTypeSignature) {
            GenericSignature.ClassTypeSignature rewritten = classTypeSignature.visit(this);
            return rewritten == null || rewritten.type() == ((GenericSignatureTypeRewriter)GenericSignatureTypeRewriter.this).context.type ? null : rewritten;
        }

        @Override
        public List<GenericSignature.TypeSignature> visitMethodTypeSignatures(List<GenericSignature.TypeSignature> typeSignatures) {
            if (typeSignatures.isEmpty()) {
                return typeSignatures;
            }
            return ListUtils.mapOrElse(typeSignatures, typeSignature -> {
                GenericSignature.TypeSignature rewrittenSignature = this.visitTypeSignature((GenericSignature.TypeSignature)typeSignature);
                return rewrittenSignature == null ? GenericSignatureTypeRewriter.this.objectTypeSignature : rewrittenSignature;
            });
        }

        @Override
        public GenericSignature.ReturnType visitReturnType(GenericSignature.ReturnType returnType) {
            if (returnType.isVoidDescriptor()) {
                return GenericSignature.ReturnType.VOID;
            }
            GenericSignature.TypeSignature originalType = returnType.typeSignature();
            GenericSignature.TypeSignature rewrittenType = this.visitTypeSignature(originalType);
            if (rewrittenType == null) {
                return GenericSignature.ReturnType.VOID;
            }
            if (rewrittenType == originalType) {
                return returnType;
            }
            return new GenericSignature.ReturnType(rewrittenType);
        }

        @Override
        public List<GenericSignature.TypeSignature> visitThrowsSignatures(List<GenericSignature.TypeSignature> typeSignatures) {
            if (typeSignatures.isEmpty()) {
                return typeSignatures;
            }
            return ListUtils.mapOrElse(typeSignatures, this::visitTypeSignature);
        }

        @Override
        public GenericSignature.FieldTypeSignature visitClassBound(GenericSignature.FieldTypeSignature fieldSignature) {
            if (fieldSignature.hasNoSignature()) {
                return fieldSignature;
            }
            return this.visitFieldTypeSignature(fieldSignature);
        }

        @Override
        public List<GenericSignature.FieldTypeSignature> visitInterfaceBounds(List<GenericSignature.FieldTypeSignature> fieldSignatures) {
            if (fieldSignatures.isEmpty()) {
                return fieldSignatures;
            }
            return ListUtils.mapOrElse(fieldSignatures, this::visitFieldTypeSignature);
        }

        @Override
        public GenericSignature.FieldTypeSignature visitInterfaceBound(GenericSignature.FieldTypeSignature fieldSignature) {
            return this.visitFieldTypeSignature(fieldSignature);
        }

        @Override
        public GenericSignature.ClassTypeSignature visitEnclosing(GenericSignature.ClassTypeSignature enclosingSignature, GenericSignature.ClassTypeSignature enclosedSignature) {
            return enclosingSignature.visit(this);
        }

        @Override
        public List<GenericSignature.FieldTypeSignature> visitTypeArguments(DexType originalType, DexType lookedUpType, List<GenericSignature.FieldTypeSignature> typeArguments) {
            assert (lookedUpType != null);
            if (typeArguments.isEmpty()) {
                return typeArguments;
            }
            if (GenericSignatureTypeRewriter.this.wasPruned.test(originalType) || !GenericSignatureTypeRewriter.this.hasGenericTypeVariables.test(lookedUpType)) {
                return GenericSignature.getEmptyTypeArguments();
            }
            return ListUtils.mapOrElse(typeArguments, fieldTypeSignature -> {
                GenericSignature.FieldTypeSignature rewrittenSignature = this.visitFieldTypeSignature((GenericSignature.FieldTypeSignature)fieldTypeSignature);
                return rewrittenSignature == null ? GenericSignatureTypeRewriter.this.objectTypeSignature.asArgument(GenericSignature.WildcardIndicator.NONE) : rewrittenSignature;
            });
        }

        @Override
        public DexType visitType(DexType type) {
            DexType rewrittenType = (DexType)GenericSignatureTypeRewriter.this.lookupType.apply(type);
            return GenericSignatureTypeRewriter.this.wasPruned.test(rewrittenType) ? null : rewrittenType;
        }
    }
}

