/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.GenericSignatureVisitor;
import com.android.tools.r8.graph.ProgramDefinition;
import java.util.List;
import java.util.function.BiConsumer;

class GenericSignatureTypeVisitor
implements GenericSignatureVisitor {
    private final ProgramDefinition context;
    private final BiConsumer<DexType, ProgramDefinition> visitedTypeConsumer;

    GenericSignatureTypeVisitor(ProgramDefinition context, BiConsumer<DexType, ProgramDefinition> visitedTypeConsumer) {
        this.context = context;
        this.visitedTypeConsumer = visitedTypeConsumer;
    }

    @Override
    public GenericSignature.ClassSignature visitClassSignature(GenericSignature.ClassSignature classSignature) {
        if (classSignature.hasNoSignature()) {
            return classSignature;
        }
        return classSignature.visit(this);
    }

    @Override
    public GenericSignature.MethodTypeSignature visitMethodSignature(GenericSignature.MethodTypeSignature methodSignature) {
        if (methodSignature.hasNoSignature()) {
            return methodSignature;
        }
        return methodSignature.visit(this);
    }

    @Override
    public GenericSignature.FieldTypeSignature visitFieldTypeSignature(GenericSignature.FieldTypeSignature fieldSignature) {
        if (fieldSignature.hasNoSignature()) {
            return fieldSignature;
        }
        if (fieldSignature.isStar()) {
            return fieldSignature;
        }
        if (fieldSignature.isTypeVariableSignature()) {
            return fieldSignature;
        }
        if (fieldSignature.isArrayTypeSignature()) {
            fieldSignature.asArrayTypeSignature().visit(this);
            return fieldSignature;
        }
        assert (fieldSignature.isClassTypeSignature());
        return fieldSignature.asClassTypeSignature().visit(this);
    }

    @Override
    public List<GenericSignature.FormalTypeParameter> visitFormalTypeParameters(List<GenericSignature.FormalTypeParameter> formalTypeParameters) {
        formalTypeParameters.forEach(this::visitFormalTypeParameter);
        return formalTypeParameters;
    }

    @Override
    public GenericSignature.FieldTypeSignature visitClassBound(GenericSignature.FieldTypeSignature fieldSignature) {
        if (fieldSignature.hasNoSignature()) {
            return fieldSignature;
        }
        return this.visitFieldTypeSignature(fieldSignature);
    }

    @Override
    public List<GenericSignature.FieldTypeSignature> visitInterfaceBounds(List<GenericSignature.FieldTypeSignature> fieldSignatures) {
        fieldSignatures.forEach(this::visitInterfaceBound);
        return fieldSignatures;
    }

    @Override
    public GenericSignature.FieldTypeSignature visitInterfaceBound(GenericSignature.FieldTypeSignature fieldSignature) {
        return this.visitFieldTypeSignature(fieldSignature);
    }

    @Override
    public GenericSignature.ClassTypeSignature visitSuperClass(GenericSignature.ClassTypeSignature classTypeSignature) {
        return classTypeSignature.visit(this);
    }

    @Override
    public List<GenericSignature.ClassTypeSignature> visitSuperInterfaces(List<GenericSignature.ClassTypeSignature> interfaceSignatures) {
        if (interfaceSignatures == null) {
            return null;
        }
        interfaceSignatures.forEach(this::visitSuperInterface);
        return interfaceSignatures;
    }

    @Override
    public GenericSignature.ClassTypeSignature visitSuperInterface(GenericSignature.ClassTypeSignature classTypeSignature) {
        return classTypeSignature.visit(this);
    }

    @Override
    public GenericSignature.TypeSignature visitTypeSignature(GenericSignature.TypeSignature typeSignature) {
        if (typeSignature.isBaseTypeSignature()) {
            return typeSignature;
        }
        assert (typeSignature.isFieldTypeSignature());
        return this.visitFieldTypeSignature(typeSignature.asFieldTypeSignature());
    }

    @Override
    public GenericSignature.ClassTypeSignature visitEnclosing(GenericSignature.ClassTypeSignature enclosingSignature, GenericSignature.ClassTypeSignature enclosedSignature) {
        return enclosingSignature.visit(this);
    }

    @Override
    public GenericSignature.ReturnType visitReturnType(GenericSignature.ReturnType returnType) {
        if (returnType.isVoidDescriptor()) {
            return returnType;
        }
        this.visitTypeSignature(returnType.typeSignature);
        return returnType;
    }

    @Override
    public List<GenericSignature.TypeSignature> visitMethodTypeSignatures(List<GenericSignature.TypeSignature> typeSignatures) {
        typeSignatures.forEach(this::visitTypeSignature);
        return typeSignatures;
    }

    @Override
    public List<GenericSignature.TypeSignature> visitThrowsSignatures(List<GenericSignature.TypeSignature> typeSignatures) {
        typeSignatures.forEach(this::visitTypeSignature);
        return typeSignatures;
    }

    @Override
    public List<GenericSignature.FieldTypeSignature> visitTypeArguments(DexType originalType, DexType lookedUpType, List<GenericSignature.FieldTypeSignature> typeArguments) {
        typeArguments.forEach(this::visitFieldTypeSignature);
        return typeArguments;
    }

    @Override
    public GenericSignature.FormalTypeParameter visitFormalTypeParameter(GenericSignature.FormalTypeParameter formalTypeParameter) {
        return formalTypeParameter.visit(this);
    }

    @Override
    public DexType visitType(DexType type) {
        this.visitedTypeConsumer.accept(type, this.context);
        return type;
    }
}

