/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.MapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ImmediateProgramSubtypingInfo {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final Map<DexProgramClass, List<DexProgramClass>> immediateSubtypes;

    private ImmediateProgramSubtypingInfo(AppView<? extends AppInfoWithClassHierarchy> appView, Map<DexProgramClass, List<DexProgramClass>> immediateSubtypes) {
        this.appView = appView;
        this.immediateSubtypes = immediateSubtypes;
    }

    public static ImmediateProgramSubtypingInfo create(AppView<? extends AppInfoWithClassHierarchy> appView) {
        IdentityHashMap<DexProgramClass, List<DexProgramClass>> immediateSubtypes = new IdentityHashMap<DexProgramClass, List<DexProgramClass>>();
        for (DexProgramClass clazz : appView.appInfo().classes()) {
            clazz.forEachImmediateSupertype(supertype -> {
                DexProgramClass superclass = DexProgramClass.asProgramClassOrNull(appView.definitionFor((DexType)supertype));
                if (superclass != null) {
                    ((List)immediateSubtypes.computeIfAbsent(superclass, MapUtils.ignoreKey(ArrayList::new))).add(clazz);
                }
            });
        }
        return new ImmediateProgramSubtypingInfo(appView, immediateSubtypes);
    }

    public void forEachImmediateSuperClass(DexClass clazz, Consumer<? super DexClass> consumer) {
        this.forEachImmediateSuperClassMatching(clazz, (? super DexType supertype, ? super DexClass superclass) -> superclass != null, (? super DexType supertype, ? super DexClass superclass) -> consumer.accept((DexClass)superclass));
    }

    public void forEachImmediateSuperClass(DexClass clazz, BiConsumer<? super DexType, ? super DexClass> consumer) {
        this.forEachImmediateSuperClassMatching(clazz, (? super DexType supertype, ? super DexClass superclass) -> true, consumer);
    }

    public void forEachImmediateSuperClassMatching(DexClass clazz, BiPredicate<? super DexType, ? super DexClass> predicate, BiConsumer<? super DexType, ? super DexClass> consumer) {
        clazz.forEachImmediateSupertype(supertype -> {
            DexClass superclass = this.appView.definitionFor((DexType)supertype);
            if (predicate.test((DexType)supertype, superclass)) {
                consumer.accept((DexType)supertype, superclass);
            }
        });
    }

    public void forEachImmediateSuperClassMatching(DexClass clazz, Predicate<? super DexClass> predicate, Consumer<? super DexClass> consumer) {
        clazz.forEachImmediateSupertype(supertype -> {
            DexClass superclass = this.appView.definitionFor((DexType)supertype);
            if (superclass != null && predicate.test(superclass)) {
                consumer.accept(superclass);
            }
        });
    }

    public void forEachImmediateProgramSuperClass(DexProgramClass clazz, Consumer<? super DexProgramClass> consumer) {
        this.forEachImmediateProgramSuperClassMatching(clazz, Predicates.alwaysTrue(), consumer);
    }

    public void forEachImmediateProgramSuperClassMatching(DexProgramClass clazz, Predicate<? super DexProgramClass> predicate, Consumer<? super DexProgramClass> consumer) {
        clazz.forEachImmediateSupertype(supertype -> {
            DexProgramClass superclass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor((DexType)supertype));
            if (superclass != null && predicate.test(superclass)) {
                consumer.accept(superclass);
            }
        });
    }

    public void forEachImmediateSubClassMatching(DexProgramClass clazz, Predicate<? super DexProgramClass> predicate, Consumer<? super DexProgramClass> consumer) {
        this.getSubclasses(clazz).forEach(subclass -> {
            if (predicate.test((DexProgramClass)subclass)) {
                consumer.accept((DexProgramClass)subclass);
            }
        });
    }

    public List<DexProgramClass> getSubclasses(DexProgramClass clazz) {
        return this.immediateSubtypes.getOrDefault(clazz, Collections.emptyList());
    }
}

