/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AccessFlags;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import java.util.List;
import java.util.function.BooleanSupplier;

public class MethodAccessFlags
extends AccessFlags<MethodAccessFlags> {
    private static final int SHARED_FLAGS = 7679;
    private static final int CF_FLAGS = 7679;
    private static final int DEX_FLAGS = 204287;

    private MethodAccessFlags(int flags) {
        this(flags, flags);
    }

    private MethodAccessFlags(int originalFlags, int modifiedFlags) {
        super(originalFlags, modifiedFlags);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MethodAccessFlags createForClassInitializer() {
        return MethodAccessFlags.fromSharedAccessFlags(4104, true);
    }

    public static MethodAccessFlags createPublicStaticSynthetic() {
        return MethodAccessFlags.fromSharedAccessFlags(4105, false);
    }

    public static MethodAccessFlags fromSharedAccessFlags(int access, boolean isConstructor) {
        assert ((access & 0x1DFF) == access);
        return MethodAccessFlags.fromCfAccessFlags(access, isConstructor);
    }

    public static MethodAccessFlags fromCfAccessFlags(int access, boolean isConstructor) {
        return new MethodAccessFlags(access & 0x1DFF | (isConstructor ? 65536 : 0));
    }

    public static MethodAccessFlags fromDexAccessFlags(int access) {
        MethodAccessFlags flags = new MethodAccessFlags(access & 0x31DFF);
        if (flags.isDeclaredSynchronized()) {
            flags.setSynchronized();
            flags.unsetDeclaredSynchronized();
        }
        return flags;
    }

    private boolean isDeclaredSynchronized() {
        return this.isSet(131072);
    }

    private void setDeclaredSynchronized() {
        this.set(131072);
    }

    @Override
    protected List<String> getNames() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(super.getNames())).add("synchronized")).add("bridge")).add("varargs")).add("native")).add("abstract")).add("strictfp")).build();
    }

    @Override
    protected List<BooleanSupplier> getPredicates() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(super.getPredicates())).add(this::isSynchronized)).add(this::isBridge)).add(this::isVarargs)).add(this::isNative)).add(this::isAbstract)).add(this::isStrict)).build();
    }

    @Override
    public MethodAccessFlags copy() {
        return new MethodAccessFlags(this.originalFlags, this.modifiedFlags);
    }

    @Override
    public MethodAccessFlags self() {
        return this;
    }

    @Override
    public int getAsCfAccessFlags() {
        return this.materialize() & 0xFFFEFFFF;
    }

    @Override
    public int getAsDexAccessFlags() {
        MethodAccessFlags copy = this.copy();
        if (copy.isSynchronized() && !copy.isNative()) {
            copy.unsetSynchronized();
            copy.setDeclaredSynchronized();
        }
        return copy.materialize();
    }

    @Override
    public MethodAccessFlags asMethodAccessFlags() {
        return this;
    }

    public boolean isSynchronized() {
        return this.isSet(32);
    }

    public void setSynchronized() {
        this.set(32);
    }

    public void demoteFromSynchronized() {
        this.demote(32);
    }

    public void unsetSynchronized() {
        this.unset(32);
    }

    public boolean isBridge() {
        return this.isSet(64);
    }

    public void setBridge() {
        this.set(64);
    }

    public void unsetBridge() {
        this.unset(64);
    }

    public void demoteFromBridge() {
        this.demote(64);
    }

    public boolean isVarargs() {
        return this.isSet(128);
    }

    public void setVarargs() {
        this.set(128);
    }

    public void unsetVarargs() {
        this.unset(128);
    }

    public boolean isNative() {
        return this.isSet(256);
    }

    public void setNative() {
        this.set(256);
    }

    public void unsetNative() {
        this.unset(256);
    }

    public boolean isAbstract() {
        return this.isSet(1024);
    }

    public void setAbstract() {
        this.set(1024);
    }

    public void demoteFromAbstract() {
        this.demote(1024);
    }

    public void promoteToAbstract() {
        this.promote(1024);
    }

    public void unsetAbstract() {
        this.unset(1024);
    }

    public boolean isStrict() {
        return this.isSet(2048);
    }

    public void setStrict() {
        this.set(2048);
    }

    public void demoteFromStrict() {
        this.demote(2048);
    }

    public void unsetStrict() {
        this.unset(2048);
    }

    public boolean isConstructor() {
        return this.isSet(65536);
    }

    public void setConstructor() {
        this.set(65536);
    }

    public void setConstructor(DexMethod method, DexItemFactory dexItemFactory) {
        if (dexItemFactory.isConstructor(method) || dexItemFactory.isClassConstructor(method)) {
            this.setConstructor();
        }
    }

    public void unsetConstructor() {
        this.unset(65536);
    }

    public void unsetDeclaredSynchronized() {
        this.unset(131072);
    }

    public static class Builder
    extends AccessFlags.BuilderBase<Builder, MethodAccessFlags> {
        Builder() {
            super(MethodAccessFlags.fromSharedAccessFlags(0, false));
        }

        public Builder set(int flag) {
            ((MethodAccessFlags)this.flags).set(flag);
            return this;
        }

        public Builder setBridge() {
            ((MethodAccessFlags)this.flags).setBridge();
            return this;
        }

        public Builder setConstructor() {
            ((MethodAccessFlags)this.flags).setConstructor();
            return this;
        }

        public Builder setStrict(boolean value) {
            if (value) {
                ((MethodAccessFlags)this.flags).setStrict();
            } else {
                ((MethodAccessFlags)this.flags).unsetStrict();
            }
            return this;
        }

        public Builder setSynchronized(boolean value) {
            if (value) {
                ((MethodAccessFlags)this.flags).setSynchronized();
            } else {
                ((MethodAccessFlags)this.flags).unsetSynchronized();
            }
            return this;
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

