/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.utils.ConsumerUtils;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class MethodAccessInfoCollection {
    private final Map<DexMethod, ProgramMethodSet> directInvokes;
    private final Map<DexMethod, ProgramMethodSet> interfaceInvokes;
    private final Map<DexMethod, ProgramMethodSet> staticInvokes;
    private final Map<DexMethod, ProgramMethodSet> superInvokes;
    private final Map<DexMethod, ProgramMethodSet> virtualInvokes;

    private MethodAccessInfoCollection(Map<DexMethod, ProgramMethodSet> directInvokes, Map<DexMethod, ProgramMethodSet> interfaceInvokes, Map<DexMethod, ProgramMethodSet> staticInvokes, Map<DexMethod, ProgramMethodSet> superInvokes, Map<DexMethod, ProgramMethodSet> virtualInvokes) {
        this.directInvokes = directInvokes;
        this.interfaceInvokes = interfaceInvokes;
        this.staticInvokes = staticInvokes;
        this.superInvokes = superInvokes;
        this.virtualInvokes = virtualInvokes;
    }

    public static ConcurrentBuilder concurrentBuilder() {
        return new ConcurrentBuilder();
    }

    public static IdentityBuilder identityBuilder() {
        return new IdentityBuilder();
    }

    private static void rewriteInvokesWithLens(Builder<?> builder, Map<DexMethod, ProgramMethodSet> invokes, DexDefinitionSupplier definitions, GraphLens lens, Invoke.Type type) {
        invokes.forEach((reference, contexts) -> {
            ProgramMethodSet newContexts = contexts.rewrittenWithLens(definitions, lens);
            for (ProgramMethod newContext : newContexts) {
                GraphLens.MethodLookupResult methodLookupResult = lens.lookupMethod((DexMethod)reference, (DexMethod)newContext.getReference(), type);
                DexMethod newReference = (DexMethod)methodLookupResult.getReference();
                Invoke.Type newType = methodLookupResult.getType();
                builder.registerInvokeInContext(newReference, newContext, newType);
            }
        });
    }

    public Modifier modifier() {
        return new Modifier(this.directInvokes, this.interfaceInvokes, this.staticInvokes, this.superInvokes, this.virtualInvokes);
    }

    public void forEachMethodReference(Consumer<DexMethod> method) {
        Set seen = Sets.newIdentityHashSet();
        this.directInvokes.keySet().forEach(ConsumerUtils.acceptIfNotSeen(method, seen));
        this.interfaceInvokes.keySet().forEach(ConsumerUtils.acceptIfNotSeen(method, seen));
        this.staticInvokes.keySet().forEach(ConsumerUtils.acceptIfNotSeen(method, seen));
        this.superInvokes.keySet().forEach(ConsumerUtils.acceptIfNotSeen(method, seen));
        this.virtualInvokes.keySet().forEach(ConsumerUtils.acceptIfNotSeen(method, seen));
    }

    public void forEachDirectInvoke(BiConsumer<DexMethod, ProgramMethodSet> consumer) {
        this.directInvokes.forEach(consumer);
    }

    public void forEachInterfaceInvoke(BiConsumer<DexMethod, ProgramMethodSet> consumer) {
        this.interfaceInvokes.forEach(consumer);
    }

    public void forEachStaticInvoke(BiConsumer<DexMethod, ProgramMethodSet> consumer) {
        this.staticInvokes.forEach(consumer);
    }

    public void forEachSuperInvoke(BiConsumer<DexMethod, ProgramMethodSet> consumer) {
        this.superInvokes.forEach(consumer);
    }

    public void forEachSuperInvokeContext(DexMethod method, Consumer<ProgramMethod> consumer) {
        this.superInvokes.getOrDefault(method, ProgramMethodSet.empty()).forEach(consumer);
    }

    public void forEachVirtualInvoke(BiConsumer<DexMethod, ProgramMethodSet> consumer) {
        this.virtualInvokes.forEach(consumer);
    }

    public void forEachVirtualInvokeContext(DexMethod method, Consumer<ProgramMethod> consumer) {
        this.virtualInvokes.getOrDefault(method, ProgramMethodSet.empty()).forEach(consumer);
    }

    public MethodAccessInfoCollection rewrittenWithLens(DexDefinitionSupplier definitions, GraphLens lens) {
        IdentityBuilder builder = MethodAccessInfoCollection.identityBuilder();
        MethodAccessInfoCollection.rewriteInvokesWithLens(builder, this.directInvokes, definitions, lens, Invoke.Type.DIRECT);
        MethodAccessInfoCollection.rewriteInvokesWithLens(builder, this.interfaceInvokes, definitions, lens, Invoke.Type.INTERFACE);
        MethodAccessInfoCollection.rewriteInvokesWithLens(builder, this.staticInvokes, definitions, lens, Invoke.Type.STATIC);
        MethodAccessInfoCollection.rewriteInvokesWithLens(builder, this.superInvokes, definitions, lens, Invoke.Type.SUPER);
        MethodAccessInfoCollection.rewriteInvokesWithLens(builder, this.virtualInvokes, definitions, lens, Invoke.Type.VIRTUAL);
        return builder.build();
    }

    public static class Modifier
    extends Builder<Map<DexMethod, ProgramMethodSet>> {
        private Modifier(Map<DexMethod, ProgramMethodSet> directInvokes, Map<DexMethod, ProgramMethodSet> interfaceInvokes, Map<DexMethod, ProgramMethodSet> staticInvokes, Map<DexMethod, ProgramMethodSet> superInvokes, Map<DexMethod, ProgramMethodSet> virtualInvokes) {
            super(directInvokes, interfaceInvokes, staticInvokes, superInvokes, virtualInvokes, null);
        }

        public void addAll(MethodAccessInfoCollection collection) {
            collection.forEachDirectInvoke(this::registerInvokeDirectInContexts);
            collection.forEachInterfaceInvoke(this::registerInvokeInterfaceInContexts);
            collection.forEachStaticInvoke(this::registerInvokeStaticInContexts);
            collection.forEachSuperInvoke(this::registerInvokeSuperInContexts);
            collection.forEachVirtualInvoke(this::registerInvokeVirtualInContexts);
        }
    }

    public static class IdentityBuilder
    extends Builder<IdentityHashMap<DexMethod, ProgramMethodSet>> {
        private IdentityBuilder() {
            super(IdentityHashMap::new);
        }
    }

    public static class ConcurrentBuilder
    extends Builder<ConcurrentHashMap<DexMethod, ProgramMethodSet>> {
        private ConcurrentBuilder() {
            super(ConcurrentHashMap::new);
        }
    }

    public static abstract class Builder<T extends Map<DexMethod, ProgramMethodSet>> {
        private final T directInvokes;
        private final T interfaceInvokes;
        private final T staticInvokes;
        private final T superInvokes;
        private final T virtualInvokes;

        private Builder(Supplier<T> factory) {
            this((Map)factory.get(), (Map)factory.get(), (Map)factory.get(), (Map)factory.get(), (Map)factory.get());
        }

        private Builder(T directInvokes, T interfaceInvokes, T staticInvokes, T superInvokes, T virtualInvokes) {
            this.directInvokes = directInvokes;
            this.interfaceInvokes = interfaceInvokes;
            this.staticInvokes = staticInvokes;
            this.superInvokes = superInvokes;
            this.virtualInvokes = virtualInvokes;
        }

        private static boolean registerInvokeMethodInContext(DexMethod invokedMethod, ProgramMethod context, Map<DexMethod, ProgramMethodSet> invokes) {
            return invokes.computeIfAbsent(invokedMethod, ignore -> ProgramMethodSet.create()).add(context);
        }

        /* synthetic */ Builder(Map x0, Map x1, Map x2, Map x3, Map x4, 1 x5) {
            this(x0, x1, x2, x3, x4);
        }

        public T getDirectInvokes() {
            return this.directInvokes;
        }

        public T getInterfaceInvokes() {
            return this.interfaceInvokes;
        }

        public T getStaticInvokes() {
            return this.staticInvokes;
        }

        public T getSuperInvokes() {
            return this.superInvokes;
        }

        public T getVirtualInvokes() {
            return this.virtualInvokes;
        }

        public boolean registerInvokeInContext(DexMethod invokedMethod, ProgramMethod context, Invoke.Type type) {
            switch (type) {
                case DIRECT: {
                    return this.registerInvokeDirectInContext(invokedMethod, context);
                }
                case INTERFACE: {
                    return this.registerInvokeInterfaceInContext(invokedMethod, context);
                }
                case STATIC: {
                    return this.registerInvokeStaticInContext(invokedMethod, context);
                }
                case SUPER: {
                    return this.registerInvokeSuperInContext(invokedMethod, context);
                }
                case VIRTUAL: {
                    return this.registerInvokeVirtualInContext(invokedMethod, context);
                }
            }
            assert (false);
            return false;
        }

        public boolean registerInvokeDirectInContext(DexMethod invokedMethod, ProgramMethod context) {
            return Builder.registerInvokeMethodInContext(invokedMethod, context, this.directInvokes);
        }

        public void registerInvokeDirectInContexts(DexMethod invokedMethod, ProgramMethodSet contexts) {
            contexts.forEach(context -> this.registerInvokeDirectInContext(invokedMethod, (ProgramMethod)context));
        }

        public boolean registerInvokeInterfaceInContext(DexMethod invokedMethod, ProgramMethod context) {
            return Builder.registerInvokeMethodInContext(invokedMethod, context, this.interfaceInvokes);
        }

        public void registerInvokeInterfaceInContexts(DexMethod invokedMethod, ProgramMethodSet contexts) {
            contexts.forEach(context -> this.registerInvokeInterfaceInContext(invokedMethod, (ProgramMethod)context));
        }

        public boolean registerInvokeStaticInContext(DexMethod invokedMethod, ProgramMethod context) {
            return Builder.registerInvokeMethodInContext(invokedMethod, context, this.staticInvokes);
        }

        public void registerInvokeStaticInContexts(DexMethod invokedMethod, ProgramMethodSet contexts) {
            contexts.forEach(context -> this.registerInvokeStaticInContext(invokedMethod, (ProgramMethod)context));
        }

        public boolean registerInvokeSuperInContext(DexMethod invokedMethod, ProgramMethod context) {
            return Builder.registerInvokeMethodInContext(invokedMethod, context, this.superInvokes);
        }

        public void registerInvokeSuperInContexts(DexMethod invokedMethod, ProgramMethodSet contexts) {
            contexts.forEach(context -> this.registerInvokeSuperInContext(invokedMethod, (ProgramMethod)context));
        }

        public boolean registerInvokeVirtualInContext(DexMethod invokedMethod, ProgramMethod context) {
            return Builder.registerInvokeMethodInContext(invokedMethod, context, this.virtualInvokes);
        }

        public void registerInvokeVirtualInContexts(DexMethod invokedMethod, ProgramMethodSet contexts) {
            contexts.forEach(context -> this.registerInvokeVirtualInContext(invokedMethod, (ProgramMethod)context));
        }

        public MethodAccessInfoCollection build() {
            return new MethodAccessInfoCollection((Map)this.directInvokes, (Map)this.interfaceInvokes, (Map)this.staticInvokes, (Map)this.superInvokes, (Map)this.virtualInvokes);
        }
    }
}

