/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.base.MoreObjects;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.MethodCollectionBacking;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.PredicateUtils;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class MethodArrayBacking
extends MethodCollectionBacking {
    private DexEncodedMethod[] directMethods;
    private DexEncodedMethod[] virtualMethods;

    private MethodArrayBacking(DexEncodedMethod[] directMethods, DexEncodedMethod[] virtualMethods) {
        this.directMethods = directMethods;
        this.virtualMethods = virtualMethods;
    }

    public static MethodArrayBacking fromArrays(DexEncodedMethod[] directMethods, DexEncodedMethod[] virtualMethods) {
        return new MethodArrayBacking(directMethods, virtualMethods);
    }

    private boolean verifyNoDuplicateMethods() {
        Set unique = Sets.newIdentityHashSet();
        this.forEachMethod(method -> {
            boolean changed = unique.add((DexMethod)method.getReference());
            assert (changed) : "Duplicate method `" + ((DexMethod)method.getReference()).toSourceString() + "`";
        });
        return true;
    }

    private DexEncodedMethod removeMethodHelper(DexMethod method, DexEncodedMethod[] methods, Consumer<DexEncodedMethod[]> newMethodsConsumer) {
        for (int i = 0; i < methods.length; ++i) {
            if (!method.match(methods[i])) continue;
            return this.removeMethodWithIndex(i, methods, newMethodsConsumer);
        }
        return null;
    }

    private static DexEncodedMethod[] removeMethodsHelper(Set<DexEncodedMethod> methodsToRemove, DexEncodedMethod[] existingMethods) {
        ArrayList<DexEncodedMethod> newMethods = new ArrayList<DexEncodedMethod>(existingMethods.length);
        for (DexEncodedMethod method : existingMethods) {
            if (methodsToRemove.contains(method)) continue;
            newMethods.add(method);
        }
        return newMethods.toArray(DexEncodedMethod.EMPTY_ARRAY);
    }

    private DexEncodedMethod removeMethodWithIndex(int index, DexEncodedMethod[] methods, Consumer<DexEncodedMethod[]> newMethodsConsumer) {
        DexEncodedMethod removed = methods[index];
        DexEncodedMethod[] newMethods = new DexEncodedMethod[methods.length - 1];
        System.arraycopy(methods, 0, newMethods, 0, index);
        System.arraycopy(methods, index + 1, newMethods, index, methods.length - index - 1);
        newMethodsConsumer.accept(newMethods);
        return removed;
    }

    private static DexEncodedMethod internalGetMethod(DexProto methodProto, DexString methodName, DexEncodedMethod[] methods) {
        for (DexEncodedMethod method : methods) {
            if (!((DexMethod)method.getReference()).match(methodProto, methodName)) continue;
            return method;
        }
        return null;
    }

    private DexEncodedMethod replaceMethod(DexMethod reference, Function<DexEncodedMethod, DexEncodedMethod> replacement, DexEncodedMethod[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            DexEncodedMethod newMethod;
            DexEncodedMethod method = methods[i];
            if (!reference.match(method)) continue;
            methods[i] = newMethod = replacement.apply(method);
            return newMethod;
        }
        return null;
    }

    private List<DexEncodedMethod> internalReplaceDirectMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        ArrayList<DexEncodedMethod> newVirtualMethods = new ArrayList<DexEncodedMethod>();
        for (int i = 0; i < this.directMethods.length; ++i) {
            DexEncodedMethod method = this.directMethods[i];
            DexEncodedMethod newMethod = replacement.apply(method);
            assert (newMethod != null);
            if (method == newMethod) continue;
            if (this.belongsToDirectPool(newMethod)) {
                this.directMethods[i] = newMethod;
                continue;
            }
            this.directMethods[i] = null;
            newVirtualMethods.add(newMethod);
        }
        if (!newVirtualMethods.isEmpty()) {
            this.directMethods = ArrayUtils.filter(this.directMethods, Objects::nonNull, DexEncodedMethod.EMPTY_ARRAY, this.directMethods.length - newVirtualMethods.size());
        }
        return newVirtualMethods;
    }

    private List<DexEncodedMethod> internalReplaceVirtualMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        ArrayList<DexEncodedMethod> newDirectMethods = new ArrayList<DexEncodedMethod>();
        for (int i = 0; i < this.virtualMethods.length; ++i) {
            DexEncodedMethod method = this.virtualMethods[i];
            DexEncodedMethod newMethod = replacement.apply(method);
            if (method == newMethod) continue;
            if (this.belongsToVirtualPool(newMethod)) {
                this.virtualMethods[i] = newMethod;
                continue;
            }
            this.virtualMethods[i] = null;
            newDirectMethods.add(newMethod);
        }
        if (!newDirectMethods.isEmpty()) {
            this.virtualMethods = ArrayUtils.filter(this.virtualMethods, Objects::nonNull, DexEncodedMethod.EMPTY_ARRAY, this.virtualMethods.length - newDirectMethods.size());
        }
        return newDirectMethods;
    }

    @Override
    boolean verify() {
        assert (this.verifyNoDuplicateMethods());
        return true;
    }

    @Override
    String getDescriptionString() {
        return "<method-arraybacking>";
    }

    @Override
    public int numberOfDirectMethods() {
        return this.directMethods.length;
    }

    @Override
    public int numberOfVirtualMethods() {
        return this.virtualMethods.length;
    }

    @Override
    int size() {
        return this.directMethods.length + this.virtualMethods.length;
    }

    @Override
    TraversalContinuation<?> traverse(Function<DexEncodedMethod, TraversalContinuation<?>> fn) {
        TraversalContinuation<?> stepResult;
        for (DexEncodedMethod method : this.directMethods) {
            stepResult = fn.apply(method);
            if (!stepResult.shouldBreak()) continue;
            return stepResult;
        }
        for (DexEncodedMethod method : this.virtualMethods) {
            stepResult = fn.apply(method);
            if (!stepResult.shouldBreak()) continue;
            return stepResult;
        }
        return TraversalContinuation.doContinue();
    }

    @Override
    public Iterable<DexEncodedMethod> methods() {
        return Iterables.concat(Arrays.asList(this.directMethods), Arrays.asList(this.virtualMethods));
    }

    List<DexEncodedMethod> directMethods() {
        assert (this.directMethods != null);
        return Arrays.asList(this.directMethods);
    }

    @Override
    void addDirectMethods(Collection<DexEncodedMethod> methods) {
        DexEncodedMethod[] newMethods = new DexEncodedMethod[this.directMethods.length + methods.size()];
        System.arraycopy(this.directMethods, 0, newMethods, 0, this.directMethods.length);
        int i = this.directMethods.length;
        Iterator<DexEncodedMethod> iterator2 = methods.iterator();
        while (iterator2.hasNext()) {
            DexEncodedMethod method;
            newMethods[i] = method = iterator2.next();
            ++i;
        }
        this.directMethods = newMethods;
        assert (this.verifyNoDuplicateMethods());
    }

    @Override
    void clearDirectMethods() {
        this.directMethods = DexEncodedMethod.EMPTY_ARRAY;
    }

    @Override
    DexEncodedMethod removeMethod(DexMethod method) {
        DexEncodedMethod removedDirectMethod = this.removeMethodHelper(method, this.directMethods, newDirectMethods -> {
            this.directMethods = newDirectMethods;
        });
        if (removedDirectMethod != null) {
            assert (this.belongsToDirectPool(removedDirectMethod));
            return removedDirectMethod;
        }
        DexEncodedMethod removedVirtualMethod = this.removeMethodHelper(method, this.virtualMethods, newVirtualMethods -> {
            this.virtualMethods = newVirtualMethods;
        });
        assert (removedVirtualMethod == null || this.belongsToVirtualPool(removedVirtualMethod));
        return removedVirtualMethod;
    }

    @Override
    void removeMethods(Set<DexEncodedMethod> methods) {
        this.directMethods = MethodArrayBacking.removeMethodsHelper(methods, this.directMethods);
        this.virtualMethods = MethodArrayBacking.removeMethodsHelper(methods, this.virtualMethods);
    }

    @Override
    void setDirectMethods(DexEncodedMethod[] methods) {
        this.directMethods = MoreObjects.firstNonNull(methods, DexEncodedMethod.EMPTY_ARRAY);
        assert (this.verifyNoDuplicateMethods());
    }

    List<DexEncodedMethod> virtualMethods() {
        assert (this.virtualMethods != null);
        return Arrays.asList(this.virtualMethods);
    }

    @Override
    void addVirtualMethods(Collection<DexEncodedMethod> methods) {
        DexEncodedMethod[] newMethods = new DexEncodedMethod[this.virtualMethods.length + methods.size()];
        System.arraycopy(this.virtualMethods, 0, newMethods, 0, this.virtualMethods.length);
        int i = this.virtualMethods.length;
        Iterator<DexEncodedMethod> iterator2 = methods.iterator();
        while (iterator2.hasNext()) {
            DexEncodedMethod method;
            newMethods[i] = method = iterator2.next();
            ++i;
        }
        this.virtualMethods = newMethods;
        assert (this.verifyNoDuplicateMethods());
    }

    @Override
    void clearVirtualMethods() {
        this.virtualMethods = DexEncodedMethod.EMPTY_ARRAY;
    }

    @Override
    void setVirtualMethods(DexEncodedMethod[] methods) {
        this.virtualMethods = MoreObjects.firstNonNull(methods, DexEncodedMethod.EMPTY_ARRAY);
        assert (this.verifyNoDuplicateMethods());
    }

    @Override
    void virtualizeMethods(Set<DexEncodedMethod> privateInstanceMethods) {
        int vLen = this.virtualMethods.length;
        int dLen = this.directMethods.length;
        int mLen = privateInstanceMethods.size();
        assert (mLen <= dLen);
        DexEncodedMethod[] newDirectMethods = new DexEncodedMethod[dLen - mLen];
        int index = 0;
        for (int i = 0; i < dLen; ++i) {
            DexEncodedMethod encodedMethod = this.directMethods[i];
            if (privateInstanceMethods.contains(encodedMethod)) continue;
            newDirectMethods[index++] = encodedMethod;
        }
        assert (index == dLen - mLen);
        this.setDirectMethods(newDirectMethods);
        DexEncodedMethod[] newVirtualMethods = new DexEncodedMethod[vLen + mLen];
        System.arraycopy(this.virtualMethods, 0, newVirtualMethods, 0, vLen);
        index = vLen;
        for (DexEncodedMethod encodedMethod : privateInstanceMethods) {
            newVirtualMethods[index++] = encodedMethod;
        }
        this.setVirtualMethods(newVirtualMethods);
    }

    @Override
    DexEncodedMethod getDirectMethod(DexMethod method) {
        for (DexEncodedMethod directMethod : this.directMethods) {
            if (!method.match(directMethod)) continue;
            return directMethod;
        }
        return null;
    }

    @Override
    DexEncodedMethod getDirectMethod(Predicate<DexEncodedMethod> predicate) {
        return PredicateUtils.findFirst(this.directMethods, predicate);
    }

    @Override
    DexEncodedMethod getVirtualMethod(DexMethod method) {
        for (DexEncodedMethod virtualMethod : this.virtualMethods) {
            if (!method.match(virtualMethod)) continue;
            return virtualMethod;
        }
        return null;
    }

    @Override
    DexEncodedMethod getVirtualMethod(Predicate<DexEncodedMethod> predicate) {
        return PredicateUtils.findFirst(this.virtualMethods, predicate);
    }

    @Override
    DexEncodedMethod getMethod(DexProto methodProto, DexString methodName) {
        DexEncodedMethod directMethod = MethodArrayBacking.internalGetMethod(methodProto, methodName, this.directMethods);
        return directMethod == null ? MethodArrayBacking.internalGetMethod(methodProto, methodName, this.virtualMethods) : directMethod;
    }

    @Override
    void addMethod(DexEncodedMethod method) {
        if (this.belongsToDirectPool(method)) {
            this.addDirectMethod(method);
        } else {
            this.addVirtualMethod(method);
        }
    }

    @Override
    void addVirtualMethod(DexEncodedMethod virtualMethod) {
        assert (this.belongsToVirtualPool(virtualMethod));
        this.virtualMethods = ArrayUtils.appendSingleElement(this.virtualMethods, virtualMethod);
    }

    @Override
    void addDirectMethod(DexEncodedMethod directMethod) {
        assert (this.belongsToDirectPool(directMethod));
        this.directMethods = ArrayUtils.appendSingleElement(this.directMethods, directMethod);
    }

    @Override
    public DexEncodedMethod replaceDirectMethod(DexMethod method, Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        DexEncodedMethod newMethod = this.replaceMethod(method, replacement, this.directMethods);
        assert (newMethod == null || this.belongsToDirectPool(newMethod));
        return newMethod;
    }

    @Override
    public DexEncodedMethod replaceVirtualMethod(DexMethod method, Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        DexEncodedMethod newMethod = this.replaceMethod(method, replacement, this.virtualMethods);
        assert (newMethod == null || this.belongsToVirtualPool(newMethod));
        return newMethod;
    }

    @Override
    public DexEncodedMethod replaceDirectMethodWithVirtualMethod(DexMethod method, Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        for (int i = 0; i < this.directMethods.length; ++i) {
            DexEncodedMethod directMethod = this.directMethods[i];
            if (!method.match(directMethod)) continue;
            DexEncodedMethod newMethod = replacement.apply(directMethod);
            assert (this.belongsToVirtualPool(newMethod));
            this.removeMethodWithIndex(i, this.directMethods, newDirectMethods -> {
                this.directMethods = newDirectMethods;
            });
            this.addVirtualMethod(newMethod);
            return newMethod;
        }
        return null;
    }

    @Override
    public void replaceMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        List<DexEncodedMethod> newVirtualMethods = this.internalReplaceDirectMethods(replacement);
        List<DexEncodedMethod> newDirectMethods = this.internalReplaceVirtualMethods(replacement);
        this.addDirectMethods(newDirectMethods);
        this.addVirtualMethods(newVirtualMethods);
    }

    @Override
    public void replaceDirectMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        List<DexEncodedMethod> newVirtualMethods = this.internalReplaceDirectMethods(replacement);
        this.addVirtualMethods(newVirtualMethods);
    }

    @Override
    public void replaceVirtualMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        List<DexEncodedMethod> newDirectMethods = this.internalReplaceVirtualMethods(replacement);
        this.addDirectMethods(newDirectMethods);
    }

    @Override
    public void replaceAllDirectMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        DexEncodedMethod[] oldMethods = this.directMethods;
        this.clearDirectMethods();
        DexEncodedMethod[] newMethods = new DexEncodedMethod[oldMethods.length];
        for (int i = 0; i < oldMethods.length; ++i) {
            newMethods[i] = replacement.apply(oldMethods[i]);
        }
        this.directMethods = newMethods;
    }

    @Override
    public void replaceAllVirtualMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        DexEncodedMethod[] oldMethods = this.virtualMethods;
        this.clearVirtualMethods();
        DexEncodedMethod[] newMethods = new DexEncodedMethod[oldMethods.length];
        for (int i = 0; i < oldMethods.length; ++i) {
            newMethods[i] = replacement.apply(oldMethods[i]);
        }
        this.virtualMethods = newMethods;
    }

    @Override
    MethodCollectionBacking map(Function<DexEncodedMethod, DexEncodedMethod> fn) {
        int i;
        DexEncodedMethod[] newDirectMethods = new DexEncodedMethod[this.directMethods.length];
        DexEncodedMethod[] newVirtualMethods = new DexEncodedMethod[this.virtualMethods.length];
        for (i = 0; i < this.directMethods.length; ++i) {
            DexEncodedMethod newDirectMethod;
            newDirectMethods[i] = newDirectMethod = fn.apply(this.directMethods[i]);
            assert (this.belongsToDirectPool(newDirectMethod));
        }
        for (i = 0; i < this.virtualMethods.length; ++i) {
            DexEncodedMethod newVirtualMethod;
            newVirtualMethods[i] = newVirtualMethod = fn.apply(this.virtualMethods[i]);
            assert (this.belongsToVirtualPool(newVirtualMethod));
        }
        return MethodArrayBacking.fromArrays(newDirectMethods, newVirtualMethods);
    }
}

