/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.MethodArrayBacking;
import com.android.tools.r8.graph.MethodCollectionBacking;
import com.android.tools.r8.graph.MethodMapBacking;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class MethodCollection {
    private static final int ARRAY_BACKING_THRESHOLD = 30;
    private final DexClass holder;
    private MethodCollectionBacking backing;
    private DexEncodedMethod cachedClassInitializer = DexEncodedMethod.SENTINEL;

    MethodCollection(DexClass holder, MethodCollectionBacking backing) {
        this.holder = holder;
        this.backing = backing;
    }

    public static MethodCollection create(DexClass holder, DexEncodedMethod[] directMethods, DexEncodedMethod[] virtualMethods) {
        MethodCollectionBacking backing;
        int methodCount = directMethods.length + virtualMethods.length;
        if (methodCount > 30) {
            backing = MethodMapBacking.createLinked(methodCount);
            backing.setDirectMethods(directMethods);
            backing.setVirtualMethods(virtualMethods);
        } else {
            backing = MethodArrayBacking.fromArrays(directMethods, virtualMethods);
        }
        return MethodCollection.createInternal(holder, backing);
    }

    private static MethodCollection createInternal(DexClass holder, MethodCollectionBacking backing) {
        return new MethodCollection(holder, backing);
    }

    private void resetCaches() {
        this.resetDirectMethodCaches();
        this.resetVirtualMethodCaches();
    }

    private void resetDirectMethodCaches() {
        this.resetClassInitializerCache();
    }

    private void resetVirtualMethodCaches() {
    }

    private void resetClassInitializerCache() {
        this.cachedClassInitializer = DexEncodedMethod.SENTINEL;
    }

    private boolean verifyCorrectnessOfMethodHolder(DexEncodedMethod method) {
        assert (method.getHolderType() == this.holder.type) : "Expected method `" + ((DexMethod)method.getReference()).toSourceString() + "` to have holder `" + this.holder.type.toSourceString() + "`";
        return true;
    }

    private boolean verifyCorrectnessOfMethodHolders(DexEncodedMethod[] methods) {
        if (methods == null) {
            return true;
        }
        return this.verifyCorrectnessOfMethodHolders(Arrays.asList(methods));
    }

    private boolean verifyCorrectnessOfMethodHolders(Iterable<DexEncodedMethod> methods) {
        for (DexEncodedMethod method : methods) {
            assert (this.verifyCorrectnessOfMethodHolder(method));
        }
        return true;
    }

    public MethodCollection fixup(DexClass newHolder, Function<DexEncodedMethod, DexEncodedMethod> fn) {
        MethodCollectionBacking newBacking = this.backing.map(fn);
        return MethodCollection.createInternal(newHolder, newBacking);
    }

    public boolean hasMethods(Predicate<DexEncodedMethod> predicate) {
        return this.getMethod(predicate) != null;
    }

    public boolean hasDirectMethods() {
        return this.hasDirectMethods(Predicates.alwaysTrue());
    }

    public boolean hasDirectMethods(Predicate<DexEncodedMethod> predicate) {
        return this.backing.getDirectMethod(predicate) != null;
    }

    public boolean hasVirtualMethods() {
        return this.hasVirtualMethods(Predicates.alwaysTrue());
    }

    public boolean hasVirtualMethods(Predicate<DexEncodedMethod> predicate) {
        return this.backing.getVirtualMethod(predicate) != null;
    }

    public int numberOfDirectMethods() {
        return this.backing.numberOfDirectMethods();
    }

    public int numberOfVirtualMethods() {
        return this.backing.numberOfVirtualMethods();
    }

    public int size() {
        return this.backing.size();
    }

    public TraversalContinuation<?> traverse(Function<DexEncodedMethod, TraversalContinuation<?>> fn) {
        return this.backing.traverse(fn);
    }

    public void forEachMethod(Consumer<DexEncodedMethod> consumer) {
        this.forEachMethodMatching(Predicates.alwaysTrue(), consumer);
    }

    public void forEachMethodMatching(Predicate<DexEncodedMethod> predicate, Consumer<DexEncodedMethod> consumer) {
        this.backing.forEachMethod(method -> {
            if (predicate.test((DexEncodedMethod)method)) {
                consumer.accept((DexEncodedMethod)method);
            }
        });
    }

    public void forEachDirectMethod(Consumer<DexEncodedMethod> consumer) {
        this.forEachDirectMethodMatching(Predicates.alwaysTrue(), consumer);
    }

    public void forEachDirectMethodMatching(Predicate<DexEncodedMethod> predicate, Consumer<DexEncodedMethod> consumer) {
        this.backing.forEachDirectMethod(method -> {
            if (predicate.test((DexEncodedMethod)method)) {
                consumer.accept((DexEncodedMethod)method);
            }
        });
    }

    public void forEachVirtualMethod(Consumer<DexEncodedMethod> consumer) {
        this.forEachVirtualMethodMatching(Predicates.alwaysTrue(), consumer);
    }

    public void forEachVirtualMethodMatching(Predicate<DexEncodedMethod> predicate, Consumer<DexEncodedMethod> consumer) {
        this.backing.forEachVirtualMethod(method -> {
            if (predicate.test((DexEncodedMethod)method)) {
                consumer.accept((DexEncodedMethod)method);
            }
        });
    }

    public Iterable<DexEncodedMethod> methods() {
        return this.backing.methods();
    }

    public Iterable<DexEncodedMethod> methods(Predicate<? super DexEncodedMethod> predicate) {
        return IterableUtils.filter(this.methods(), predicate);
    }

    public List<DexEncodedMethod> allMethodsSorted() {
        ArrayList<DexEncodedMethod> sorted2 = new ArrayList<DexEncodedMethod>(this.size());
        this.forEachMethod(sorted2::add);
        sorted2.sort(Comparator.comparing(DexEncodedMember::getReference));
        return sorted2;
    }

    public Iterable<DexEncodedMethod> directMethods() {
        return this.backing.directMethods();
    }

    public Iterable<DexEncodedMethod> virtualMethods() {
        return this.backing.virtualMethods();
    }

    public DexEncodedMethod getMethod(DexMethod method) {
        return this.backing.getMethod(method.getProto(), method.getName());
    }

    public DexEncodedMethod getMethod(DexProto methodProto, DexString methodName) {
        return this.backing.getMethod(methodProto, methodName);
    }

    public final DexEncodedMethod getMethod(DexMethodSignature method) {
        return this.getMethod(method.getProto(), method.getName());
    }

    public DexEncodedMethod getMethod(Predicate<DexEncodedMethod> predicate) {
        DexEncodedMethod result = this.backing.getDirectMethod(predicate);
        return result != null ? result : this.backing.getVirtualMethod(predicate);
    }

    public DexEncodedMethod getDirectMethod(DexMethod method) {
        return this.backing.getDirectMethod(method);
    }

    public DexEncodedMethod getDirectMethod(Predicate<DexEncodedMethod> predicate) {
        return this.backing.getDirectMethod(predicate);
    }

    public DexEncodedMethod getVirtualMethod(DexMethod method) {
        return this.backing.getVirtualMethod(method);
    }

    public DexEncodedMethod getVirtualMethod(Predicate<DexEncodedMethod> predicate) {
        return this.backing.getVirtualMethod(predicate);
    }

    public synchronized DexEncodedMethod getClassInitializer() {
        if (this.cachedClassInitializer == DexEncodedMethod.SENTINEL) {
            this.cachedClassInitializer = null;
            for (DexEncodedMethod directMethod : this.directMethods()) {
                if (!directMethod.isClassInitializer()) continue;
                this.cachedClassInitializer = directMethod;
                break;
            }
        }
        return this.cachedClassInitializer;
    }

    public void addMethod(DexEncodedMethod method) {
        this.resetCaches();
        this.backing.addMethod(method);
    }

    public void addVirtualMethod(DexEncodedMethod virtualMethod) {
        this.resetVirtualMethodCaches();
        this.backing.addVirtualMethod(virtualMethod);
    }

    public void addDirectMethod(DexEncodedMethod directMethod) {
        this.resetDirectMethodCaches();
        this.backing.addDirectMethod(directMethod);
    }

    public DexEncodedMethod replaceDirectMethod(DexMethod method, Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        this.resetDirectMethodCaches();
        return this.backing.replaceDirectMethod(method, replacement);
    }

    public DexEncodedMethod replaceVirtualMethod(DexMethod method, Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        this.resetVirtualMethodCaches();
        return this.backing.replaceVirtualMethod(method, replacement);
    }

    public void replaceMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        this.resetCaches();
        this.backing.replaceMethods(replacement);
    }

    public void replaceDirectMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        this.resetDirectMethodCaches();
        this.backing.replaceDirectMethods(replacement);
    }

    public void replaceVirtualMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        this.resetVirtualMethodCaches();
        this.backing.replaceVirtualMethods(replacement);
    }

    public void replaceAllDirectMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        this.resetDirectMethodCaches();
        this.backing.replaceAllDirectMethods(replacement);
    }

    public void replaceAllVirtualMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        this.resetVirtualMethodCaches();
        this.backing.replaceAllVirtualMethods(replacement);
    }

    public DexEncodedMethod replaceDirectMethodWithVirtualMethod(DexMethod method, Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        this.resetCaches();
        return this.backing.replaceDirectMethodWithVirtualMethod(method, replacement);
    }

    public void addDirectMethods(Collection<DexEncodedMethod> methods) {
        assert (this.verifyCorrectnessOfMethodHolders(methods));
        this.resetDirectMethodCaches();
        this.backing.addDirectMethods(methods);
    }

    public void clearDirectMethods() {
        this.resetDirectMethodCaches();
        this.backing.clearDirectMethods();
    }

    public DexEncodedMethod removeMethod(DexMethod method) {
        DexEncodedMethod removed = this.backing.removeMethod(method);
        if (removed != null) {
            if (this.backing.belongsToDirectPool(removed)) {
                this.resetDirectMethodCaches();
            } else {
                assert (this.backing.belongsToVirtualPool(removed));
                this.resetVirtualMethodCaches();
            }
        }
        return removed;
    }

    public void removeMethods(Set<DexEncodedMethod> methods) {
        this.backing.removeMethods(methods);
        this.resetDirectMethodCaches();
        this.resetVirtualMethodCaches();
    }

    public void setDirectMethods(DexEncodedMethod[] methods) {
        assert (this.verifyCorrectnessOfMethodHolders(methods));
        this.resetDirectMethodCaches();
        this.backing.setDirectMethods(methods);
    }

    public void setSingleDirectMethod(DexEncodedMethod method) {
        this.setDirectMethods(new DexEncodedMethod[]{method});
    }

    public void addVirtualMethods(Collection<DexEncodedMethod> methods) {
        assert (this.verifyCorrectnessOfMethodHolders(methods));
        this.resetVirtualMethodCaches();
        this.backing.addVirtualMethods(methods);
    }

    public void clearVirtualMethods() {
        this.resetVirtualMethodCaches();
        this.backing.clearVirtualMethods();
    }

    public void setVirtualMethods(DexEncodedMethod[] methods) {
        assert (this.verifyCorrectnessOfMethodHolders(methods));
        this.resetVirtualMethodCaches();
        this.backing.setVirtualMethods(methods);
    }

    public void virtualizeMethods(Set<DexEncodedMethod> privateInstanceMethods) {
        this.resetVirtualMethodCaches();
        this.backing.virtualizeMethods(privateInstanceMethods);
    }

    public boolean hasAnnotations() {
        return this.traverse(method -> method.hasAnyAnnotations() ? TraversalContinuation.doBreak() : TraversalContinuation.doContinue()).shouldBreak();
    }

    public void useSortedBacking() {
        assert (this.size() == 0);
        this.backing = MethodMapBacking.createSorted();
    }

    public boolean verify() {
        this.forEachMethod(method -> {
            assert (this.verifyCorrectnessOfMethodHolder((DexEncodedMethod)method));
        });
        assert (this.backing.verify());
        return true;
    }

    public String getBackingDescriptionString() {
        return this.backing.getDescriptionString();
    }

    @FunctionalInterface
    public static interface MethodCollectionFactory {
        public static MethodCollectionFactory empty() {
            return MethodCollectionFactory.fromMethods(DexEncodedMethod.EMPTY_ARRAY, DexEncodedMethod.EMPTY_ARRAY);
        }

        public static MethodCollectionFactory fromMethods(DexEncodedMethod[] directs, DexEncodedMethod[] virtuals) {
            return holder -> MethodCollection.create(holder, directs, virtuals);
        }

        public MethodCollection create(DexClass var1);
    }
}

