/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.MethodCollection;
import com.android.tools.r8.graph.MethodCollectionBacking;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class MethodCollectionConcurrencyChecked
extends MethodCollection {
    private AtomicInteger readCount = new AtomicInteger();
    private AtomicInteger writeCount = new AtomicInteger();

    MethodCollectionConcurrencyChecked(DexClass holder, MethodCollectionBacking backing) {
        super(holder, backing);
    }

    private boolean assertReadEntry() {
        assert (this.writeCount.get() == 0);
        assert (this.readCount.incrementAndGet() >= 1);
        return true;
    }

    private boolean assertReadExit() {
        assert (this.readCount.decrementAndGet() >= 0);
        assert (this.writeCount.get() == 0);
        return true;
    }

    private boolean assertWriteEntry() {
        assert (this.readCount.get() == 0);
        assert (this.writeCount.incrementAndGet() == 1);
        return true;
    }

    private boolean assertWriteExit() {
        assert (this.writeCount.decrementAndGet() == 0);
        assert (this.readCount.get() == 0);
        return true;
    }

    @Override
    public boolean hasDirectMethods(Predicate<DexEncodedMethod> predicate) {
        boolean result;
        assert (this.assertReadEntry());
        boolean bl = result = super.getDirectMethod(predicate) != null;
        assert (this.assertReadExit());
        return result;
    }

    @Override
    public boolean hasVirtualMethods(Predicate<DexEncodedMethod> predicate) {
        boolean result;
        assert (this.assertReadEntry());
        boolean bl = result = super.getVirtualMethod(predicate) != null;
        assert (this.assertReadExit());
        return result;
    }

    @Override
    public int numberOfDirectMethods() {
        assert (this.assertReadEntry());
        int result = super.numberOfDirectMethods();
        assert (this.assertReadExit());
        return result;
    }

    @Override
    public int numberOfVirtualMethods() {
        assert (this.assertReadEntry());
        int result = super.numberOfVirtualMethods();
        assert (this.assertReadExit());
        return result;
    }

    @Override
    public int size() {
        assert (this.assertReadEntry());
        int result = super.size();
        assert (this.assertReadExit());
        return result;
    }

    @Override
    public TraversalContinuation<?> traverse(Function<DexEncodedMethod, TraversalContinuation<?>> fn) {
        assert (this.assertReadEntry());
        TraversalContinuation<?> result = super.traverse(fn);
        assert (this.assertReadExit());
        return result;
    }

    @Override
    public void forEachMethodMatching(Predicate<DexEncodedMethod> predicate, Consumer<DexEncodedMethod> consumer) {
        assert (this.assertReadEntry());
        super.forEachMethodMatching(predicate, consumer);
        assert (this.assertReadExit());
    }

    @Override
    public void forEachDirectMethodMatching(Predicate<DexEncodedMethod> predicate, Consumer<DexEncodedMethod> consumer) {
        assert (this.assertReadEntry());
        super.forEachDirectMethodMatching(predicate, consumer);
        assert (this.assertReadExit());
    }

    @Override
    public void forEachVirtualMethodMatching(Predicate<DexEncodedMethod> predicate, Consumer<DexEncodedMethod> consumer) {
        assert (this.assertReadEntry());
        super.forEachVirtualMethodMatching(predicate, consumer);
        assert (this.assertReadExit());
    }

    @Override
    public Iterable<DexEncodedMethod> methods() {
        return super.methods();
    }

    @Override
    public Iterable<DexEncodedMethod> directMethods() {
        return super.directMethods();
    }

    @Override
    public Iterable<DexEncodedMethod> virtualMethods() {
        return super.virtualMethods();
    }

    @Override
    public DexEncodedMethod getMethod(DexMethod method) {
        assert (this.assertReadEntry());
        DexEncodedMethod result = super.getMethod(method);
        assert (this.assertReadExit());
        return result;
    }

    @Override
    public DexEncodedMethod getMethod(Predicate<DexEncodedMethod> predicate) {
        assert (this.assertReadEntry());
        DexEncodedMethod result = super.getMethod(predicate);
        assert (this.assertReadExit());
        return result;
    }

    @Override
    public DexEncodedMethod getDirectMethod(DexMethod method) {
        assert (this.assertReadEntry());
        DexEncodedMethod result = super.getDirectMethod(method);
        assert (this.assertReadExit());
        return result;
    }

    @Override
    public DexEncodedMethod getDirectMethod(Predicate<DexEncodedMethod> predicate) {
        assert (this.assertReadEntry());
        DexEncodedMethod result = super.getDirectMethod(predicate);
        assert (this.assertReadExit());
        return result;
    }

    @Override
    public DexEncodedMethod getVirtualMethod(DexMethod method) {
        assert (this.assertReadEntry());
        DexEncodedMethod result = super.getVirtualMethod(method);
        assert (this.assertReadExit());
        return result;
    }

    @Override
    public DexEncodedMethod getVirtualMethod(Predicate<DexEncodedMethod> predicate) {
        assert (this.assertReadEntry());
        DexEncodedMethod result = super.getVirtualMethod(predicate);
        assert (this.assertReadExit());
        return result;
    }

    @Override
    public void addMethod(DexEncodedMethod method) {
        assert (this.assertWriteEntry());
        super.addMethod(method);
        assert (this.assertWriteExit());
    }

    @Override
    public void addVirtualMethod(DexEncodedMethod virtualMethod) {
        assert (this.assertWriteEntry());
        super.addVirtualMethod(virtualMethod);
        assert (this.assertWriteExit());
    }

    @Override
    public void addDirectMethod(DexEncodedMethod directMethod) {
        assert (this.assertWriteEntry());
        super.addDirectMethod(directMethod);
        assert (this.assertWriteExit());
    }

    @Override
    public DexEncodedMethod replaceDirectMethod(DexMethod method, Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        assert (this.assertWriteEntry());
        DexEncodedMethod result = super.replaceDirectMethod(method, replacement);
        assert (this.assertWriteExit());
        return result;
    }

    @Override
    public DexEncodedMethod replaceVirtualMethod(DexMethod method, Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        assert (this.assertWriteEntry());
        DexEncodedMethod result = super.replaceVirtualMethod(method, replacement);
        assert (this.assertWriteExit());
        return result;
    }

    @Override
    public void replaceMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        assert (this.assertWriteEntry());
        super.replaceMethods(replacement);
        assert (this.assertWriteExit());
    }

    @Override
    public void replaceDirectMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        assert (this.assertWriteEntry());
        super.replaceDirectMethods(replacement);
        assert (this.assertWriteExit());
    }

    @Override
    public void replaceVirtualMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        assert (this.assertWriteEntry());
        super.replaceVirtualMethods(replacement);
        assert (this.assertWriteExit());
    }

    @Override
    public void replaceAllDirectMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        assert (this.assertWriteEntry());
        super.replaceAllDirectMethods(replacement);
        assert (this.assertWriteExit());
    }

    @Override
    public void replaceAllVirtualMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        assert (this.assertWriteEntry());
        super.replaceAllVirtualMethods(replacement);
        assert (this.assertWriteExit());
    }

    @Override
    public DexEncodedMethod replaceDirectMethodWithVirtualMethod(DexMethod method, Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        assert (this.assertWriteEntry());
        DexEncodedMethod result = super.replaceDirectMethodWithVirtualMethod(method, replacement);
        assert (this.assertWriteExit());
        return result;
    }

    @Override
    public void addDirectMethods(Collection<DexEncodedMethod> methods) {
        assert (this.assertWriteEntry());
        super.addDirectMethods(methods);
        assert (this.assertWriteExit());
    }

    @Override
    public void clearDirectMethods() {
        assert (this.assertWriteEntry());
        super.clearDirectMethods();
        assert (this.assertWriteExit());
    }

    @Override
    public DexEncodedMethod removeMethod(DexMethod method) {
        assert (this.assertWriteEntry());
        DexEncodedMethod result = super.removeMethod(method);
        assert (this.assertWriteExit());
        return result;
    }

    @Override
    public void removeMethods(Set<DexEncodedMethod> methods) {
        assert (this.assertWriteEntry());
        super.removeMethods(methods);
        assert (this.assertWriteExit());
    }

    @Override
    public void setDirectMethods(DexEncodedMethod[] methods) {
        assert (this.assertWriteEntry());
        super.setDirectMethods(methods);
        assert (this.assertWriteExit());
    }

    @Override
    public void addVirtualMethods(Collection<DexEncodedMethod> methods) {
        assert (this.assertWriteEntry());
        super.addVirtualMethods(methods);
        assert (this.assertWriteExit());
    }

    @Override
    public void clearVirtualMethods() {
        assert (this.assertWriteEntry());
        super.clearVirtualMethods();
        assert (this.assertWriteExit());
    }

    @Override
    public void setVirtualMethods(DexEncodedMethod[] methods) {
        assert (this.assertWriteEntry());
        super.setVirtualMethods(methods);
        assert (this.assertWriteExit());
    }

    @Override
    public void virtualizeMethods(Set<DexEncodedMethod> privateInstanceMethods) {
        assert (this.assertWriteEntry());
        super.virtualizeMethods(privateInstanceMethods);
        assert (this.assertWriteExit());
    }

    @Override
    public void useSortedBacking() {
        assert (this.assertWriteEntry());
        super.useSortedBacking();
        assert (this.assertWriteExit());
    }
}

