/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.InstantiatedSubTypeInfo;
import com.android.tools.r8.graph.LookupCompletenessHelper;
import com.android.tools.r8.graph.LookupLambdaTarget;
import com.android.tools.r8.graph.LookupResult;
import com.android.tools.r8.graph.LookupTarget;
import com.android.tools.r8.graph.MemberResolutionResult;
import com.android.tools.r8.graph.PinnedPredicate;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.SuccessfulMemberResolutionResult;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.InstantiatedObject;
import com.android.tools.r8.utils.BooleanBox;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.ConsumerUtils;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.collections.DexClassAndMethodSet;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

public abstract class MethodResolutionResult
extends MemberResolutionResult<DexEncodedMethod, DexMethod> {
    @Override
    public boolean isMethodResolutionResult() {
        return true;
    }

    @Override
    public MethodResolutionResult asMethodResolutionResult() {
        return this;
    }

    public boolean isSingleResolution() {
        return false;
    }

    public SingleResolutionResult asSingleResolution() {
        return null;
    }

    @Override
    public boolean isSuccessfulMemberResolutionResult() {
        return false;
    }

    @Override
    public SuccessfulMemberResolutionResult<DexEncodedMethod, DexMethod> asSuccessfulMemberResolutionResult() {
        return null;
    }

    public boolean isIncompatibleClassChangeErrorResult() {
        return false;
    }

    public boolean isNoSuchMethodErrorResult(DexClass context, AppInfoWithClassHierarchy appInfo) {
        return false;
    }

    public boolean isIllegalAccessErrorResult(DexClass context, AppInfoWithClassHierarchy appInfo) {
        return false;
    }

    public boolean isClassNotFoundResult() {
        return false;
    }

    public boolean isArrayCloneMethodResult() {
        return false;
    }

    public FailedResolutionResult asFailedResolution() {
        return null;
    }

    public DexClass getResolvedHolder() {
        return null;
    }

    public DexEncodedMethod getResolvedMethod() {
        return null;
    }

    public final DexEncodedMethod getSingleTarget() {
        return this.isSingleResolution() ? this.asSingleResolution().getResolvedMethod() : null;
    }

    public DexClass getInitialResolutionHolder() {
        return null;
    }

    public ProgramMethod getResolvedProgramMethod() {
        return null;
    }

    public DexClassAndMethod getResolutionPair() {
        return null;
    }

    public abstract OptionalBool isAccessibleForVirtualDispatchFrom(ProgramDefinition var1, AppInfoWithClassHierarchy var2);

    public abstract boolean isVirtualTarget();

    public abstract DexClassAndMethod lookupInvokeSpecialTarget(DexProgramClass var1, AppInfoWithClassHierarchy var2);

    public abstract DexClassAndMethod lookupInvokeSuperTarget(DexProgramClass var1, AppInfoWithClassHierarchy var2);

    public abstract DexEncodedMethod lookupInvokeDirectTarget(DexProgramClass var1, AppInfoWithClassHierarchy var2);

    public abstract DexEncodedMethod lookupInvokeStaticTarget(DexProgramClass var1, AppInfoWithClassHierarchy var2);

    public abstract LookupResult lookupVirtualDispatchTargets(DexProgramClass var1, AppInfoWithClassHierarchy var2, InstantiatedSubTypeInfo var3, PinnedPredicate var4);

    public final LookupResult lookupVirtualDispatchTargets(DexProgramClass context, AppInfoWithLiveness appInfo) {
        return this.lookupVirtualDispatchTargets(context, (AppInfoWithClassHierarchy)appInfo, appInfo, appInfo::isPinnedNotProgramOrLibraryOverride);
    }

    public abstract LookupResult lookupVirtualDispatchTargets(DexProgramClass var1, AppInfoWithLiveness var2, DexProgramClass var3, DexProgramClass var4);

    public abstract LookupTarget lookupVirtualDispatchTarget(InstantiatedObject var1, AppInfoWithClassHierarchy var2);

    public abstract DexClassAndMethod lookupVirtualDispatchTarget(DexClass var1, AppInfoWithClassHierarchy var2);

    public abstract LookupTarget lookupVirtualDispatchTarget(LambdaDescriptor var1, AppInfoWithClassHierarchy var2, Consumer<? super DexEncodedMethod> var3);

    static class IllegalAccessOrNoSuchMethodResult
    extends FailedResolutionWithCausingMethods {
        private final DexClass initialResolutionHolder;

        public IllegalAccessOrNoSuchMethodResult(DexClass initialResolutionHolder, Collection<DexEncodedMethod> methodsCausingError) {
            super(methodsCausingError);
            this.initialResolutionHolder = initialResolutionHolder;
        }

        public IllegalAccessOrNoSuchMethodResult(DexClass initialResolutionHolder, DexEncodedMethod methodCausingError) {
            this(initialResolutionHolder, Collections.singletonList(methodCausingError));
            assert (methodCausingError != null);
        }

        private boolean verifyInvalidSymbolicReference() {
            BooleanBox invalidSymbolicReference = new BooleanBox(true);
            this.forEachFailureDependency(method -> invalidSymbolicReference.and(method.getHolderType() != this.initialResolutionHolder.getType()));
            return invalidSymbolicReference.get();
        }

        @Override
        public boolean isIllegalAccessErrorResult(DexClass context, AppInfoWithClassHierarchy appInfo) {
            if (!this.hasMethodsCausingError()) {
                return false;
            }
            BooleanBox seenNoAccess = new BooleanBox(false);
            this.forEachFailureDependency(method -> {
                DexClassAndMethod classAndMethod = DexClassAndMethod.create(appInfo.definitionFor(method.getHolderType()), method);
                seenNoAccess.or(AccessControl.isMemberAccessible(classAndMethod, this.initialResolutionHolder, context, appInfo).isFalse());
            });
            return seenNoAccess.get();
        }

        @Override
        public boolean isNoSuchMethodErrorResult(DexClass context, AppInfoWithClassHierarchy appInfo) {
            if (!this.hasMethodsCausingError()) {
                return true;
            }
            if (this.isIllegalAccessErrorResult(context, appInfo)) {
                return false;
            }
            assert (this.verifyInvalidSymbolicReference());
            return true;
        }
    }

    public static class NoSuchMethodResult
    extends FailedResolutionResult {
        static final NoSuchMethodResult INSTANCE = new NoSuchMethodResult();

        @Override
        public boolean isNoSuchMethodErrorResult(DexClass context, AppInfoWithClassHierarchy appInfo) {
            return true;
        }
    }

    public static class IncompatibleClassResult
    extends FailedResolutionWithCausingMethods {
        static final IncompatibleClassResult INSTANCE = new IncompatibleClassResult(Collections.emptyList());

        private IncompatibleClassResult(Collection<DexEncodedMethod> methodsCausingError) {
            super(methodsCausingError);
        }

        static IncompatibleClassResult create(Collection<DexEncodedMethod> methodsCausingError) {
            return methodsCausingError.isEmpty() ? INSTANCE : new IncompatibleClassResult(methodsCausingError);
        }

        @Override
        public boolean isIncompatibleClassChangeErrorResult() {
            return true;
        }
    }

    public static abstract class FailedResolutionWithCausingMethods
    extends FailedResolutionResult {
        private final Collection<DexEncodedMethod> methodsCausingError;

        private FailedResolutionWithCausingMethods(Collection<DexEncodedMethod> methodsCausingError) {
            this.methodsCausingError = methodsCausingError;
        }

        @Override
        public void forEachFailureDependency(Consumer<? super DexEncodedMethod> methodCausingFailureConsumer) {
            this.methodsCausingError.forEach(methodCausingFailureConsumer);
        }

        @Override
        public boolean hasMethodsCausingError() {
            return this.methodsCausingError.size() > 0;
        }
    }

    public static class ClassNotFoundResult
    extends FailedResolutionResult {
        static final ClassNotFoundResult INSTANCE = new ClassNotFoundResult();

        private ClassNotFoundResult() {
        }

        @Override
        public boolean isClassNotFoundResult() {
            return true;
        }
    }

    public static abstract class FailedResolutionResult
    extends EmptyResult {
        @Override
        public boolean isFailedResolution() {
            return true;
        }

        @Override
        public FailedResolutionResult asFailedResolution() {
            return this;
        }

        public void forEachFailureDependency(Consumer<? super DexEncodedMethod> methodCausingFailureConsumer) {
        }

        @Override
        public OptionalBool isAccessibleFrom(ProgramDefinition context, AppInfoWithClassHierarchy appInfo) {
            return OptionalBool.FALSE;
        }

        @Override
        public OptionalBool isAccessibleForVirtualDispatchFrom(ProgramDefinition context, AppInfoWithClassHierarchy appInfo) {
            return OptionalBool.FALSE;
        }

        @Override
        public boolean isVirtualTarget() {
            return false;
        }

        public boolean hasMethodsCausingError() {
            return false;
        }
    }

    public static class ArrayCloneMethodResult
    extends EmptyResult {
        static final ArrayCloneMethodResult INSTANCE = new ArrayCloneMethodResult();

        private ArrayCloneMethodResult() {
        }

        @Override
        public OptionalBool isAccessibleFrom(ProgramDefinition context, AppInfoWithClassHierarchy appInfo) {
            return OptionalBool.TRUE;
        }

        @Override
        public OptionalBool isAccessibleForVirtualDispatchFrom(ProgramDefinition context, AppInfoWithClassHierarchy appInfo) {
            return OptionalBool.TRUE;
        }

        @Override
        public boolean isVirtualTarget() {
            return true;
        }

        @Override
        public boolean isArrayCloneMethodResult() {
            return true;
        }
    }

    static abstract class EmptyResult
    extends MethodResolutionResult {
        EmptyResult() {
        }

        @Override
        public final DexClassAndMethod lookupInvokeSpecialTarget(DexProgramClass context, AppInfoWithClassHierarchy appInfo) {
            return null;
        }

        @Override
        public DexClassAndMethod lookupInvokeSuperTarget(DexProgramClass context, AppInfoWithClassHierarchy appInfo) {
            return null;
        }

        @Override
        public DexEncodedMethod lookupInvokeStaticTarget(DexProgramClass context, AppInfoWithClassHierarchy appInfo) {
            return null;
        }

        @Override
        public DexEncodedMethod lookupInvokeDirectTarget(DexProgramClass context, AppInfoWithClassHierarchy appInfo) {
            return null;
        }

        @Override
        public LookupResult lookupVirtualDispatchTargets(DexProgramClass context, AppInfoWithClassHierarchy appInfo, InstantiatedSubTypeInfo instantiatedInfo, PinnedPredicate pinnedPredicate) {
            return LookupResult.getIncompleteEmptyResult();
        }

        @Override
        public LookupResult lookupVirtualDispatchTargets(DexProgramClass context, AppInfoWithLiveness appInfo, DexProgramClass refinedReceiverUpperBound, DexProgramClass refinedReceiverLowerBound) {
            return LookupResult.getIncompleteEmptyResult();
        }

        @Override
        public DexClassAndMethod lookupVirtualDispatchTarget(InstantiatedObject instance, AppInfoWithClassHierarchy appInfo) {
            return null;
        }

        @Override
        public DexClassAndMethod lookupVirtualDispatchTarget(DexClass dynamicInstance, AppInfoWithClassHierarchy appInfo) {
            return null;
        }

        @Override
        public DexClassAndMethod lookupVirtualDispatchTarget(LambdaDescriptor lambdaInstance, AppInfoWithClassHierarchy appInfo, Consumer<? super DexEncodedMethod> methodCausingFailureConsumer) {
            return null;
        }
    }

    public static class SingleResolutionResult
    extends MethodResolutionResult
    implements SuccessfulMemberResolutionResult<DexEncodedMethod, DexMethod> {
        private final DexClass initialResolutionHolder;
        private final DexClass resolvedHolder;
        private final DexEncodedMethod resolvedMethod;

        public SingleResolutionResult(DexClass initialResolutionHolder, DexClass resolvedHolder, DexEncodedMethod resolvedMethod) {
            assert (initialResolutionHolder != null);
            assert (resolvedHolder != null);
            assert (resolvedMethod != null);
            assert (resolvedHolder.type == resolvedMethod.getHolderType());
            this.resolvedHolder = resolvedHolder;
            this.resolvedMethod = resolvedMethod;
            this.initialResolutionHolder = initialResolutionHolder;
            assert (!resolvedMethod.isPrivateMethod() || initialResolutionHolder.type == resolvedMethod.getHolderType());
        }

        private DexClassAndMethod internalInvokeSpecialOrSuper(DexProgramClass context, AppInfoWithClassHierarchy appInfo, BiPredicate<DexClass, DexClass> isSuperclass) {
            if (this.getResolvedMethod().isStatic()) {
                return null;
            }
            if (this.getResolvedHolder().isInterface() && this.getResolvedMethod().isPrivate()) {
                return this.getResolutionPair();
            }
            DexClass symbolicReference = this.initialResolutionHolder;
            DexClass initialType = !this.resolvedMethod.isInstanceInitializer() && !symbolicReference.isInterface() && isSuperclass.test(symbolicReference, context) ? (context.superType == null ? null : appInfo.definitionFor(context.superType)) : symbolicReference;
            if (initialType == null) {
                return null;
            }
            DexMethod method = (DexMethod)this.getResolvedMethod().getReference();
            DexClassAndMethod target = null;
            DexClass current = initialType;
            while (current != null && (target = current.lookupClassMethod(method)) == null) {
                current = current.superType == null ? null : appInfo.definitionFor(current.superType);
            }
            if (target == null) {
                target = appInfo.lookupMaximallySpecificMethod(initialType, method);
            }
            if (target == null) {
                return null;
            }
            if (target.getAccessFlags().isStatic()) {
                return null;
            }
            if ((((DexEncodedMethod)target.getDefinition()).isInstanceInitializer() || target.getAccessFlags().isPrivate()) && target.getHolderType() != symbolicReference.type) {
                return null;
            }
            if (target.getAccessFlags().isAbstract()) {
                return null;
            }
            return target;
        }

        private static boolean isSuperclass(DexClass sup, DexClass sub, AppInfoWithClassHierarchy appInfo) {
            return appInfo.isStrictSubtypeOf(sub.type, sup.type);
        }

        private InstantiatedSubTypeInfo instantiatedSubTypeInfoForInstantiatedType(AppInfoWithLiveness appInfo, DexProgramClass refinedReceiverUpperBound, DexProgramClass refinedReceiverLowerBound, Box<Boolean> hasInstantiatedLambdas) {
            return (ignored, subTypeConsumer, callSiteConsumer) -> {
                Consumer<DexProgramClass> lambdaInstantiatedConsumer = subType -> {
                    subTypeConsumer.accept(subType);
                    if (appInfo.isInstantiatedInterface((DexProgramClass)subType)) {
                        hasInstantiatedLambdas.set(true);
                    }
                };
                if (refinedReceiverLowerBound == null) {
                    appInfo.forEachInstantiatedSubType(refinedReceiverUpperBound.type, lambdaInstantiatedConsumer, callSiteConsumer);
                } else {
                    appInfo.forEachInstantiatedSubTypeInChain(refinedReceiverUpperBound, refinedReceiverLowerBound, lambdaInstantiatedConsumer, callSiteConsumer);
                }
            };
        }

        private static void addVirtualDispatchTarget(DexClassAndMethod target, boolean holderIsInterface, LookupResult.LookupResultSuccess.Builder resultBuilder) {
            DexEncodedMethod targetMethod = (DexEncodedMethod)target.getDefinition();
            assert (!targetMethod.isPrivateMethod());
            if (holderIsInterface) {
                if (targetMethod.isDefaultMethod()) {
                    resultBuilder.addMethodTarget(target);
                }
                if (!targetMethod.accessFlags.isAbstract() && targetMethod.accessFlags.isBridge()) {
                    resultBuilder.addMethodTarget(target);
                }
            } else {
                resultBuilder.addMethodTarget(target);
            }
        }

        private DexClassAndMethod lookupVirtualDispatchTarget(DexClass dynamicInstance, AppInfoWithClassHierarchy appInfo, DexType resolutionHolder, Consumer<? super DexEncodedMethod> methodCausingFailureConsumer) {
            assert (appInfo.isSubtype(dynamicInstance.type, resolutionHolder)) : dynamicInstance.type + " is not a subtype of " + resolutionHolder;
            if (this.resolvedMethod.isPrivateMethod()) {
                return this.getResolutionPair();
            }
            boolean allowPackageBlocked = this.resolvedMethod.accessFlags.isPackagePrivate();
            DexClass current = dynamicInstance;
            DexEncodedMethod overrideTarget = this.resolvedMethod;
            while (current != null) {
                DexEncodedMethod candidate = SingleResolutionResult.lookupOverrideCandidate(overrideTarget, current);
                if (candidate == DexEncodedMethod.SENTINEL && allowPackageBlocked) {
                    overrideTarget = SingleResolutionResult.findWideningOverride(this.resolvedMethod, current, appInfo);
                    allowPackageBlocked = false;
                    continue;
                }
                if (candidate == null || candidate == DexEncodedMethod.SENTINEL) {
                    if (current.type == overrideTarget.getHolderType()) {
                        return null;
                    }
                    current = current.superType == null ? null : appInfo.definitionFor(current.superType);
                    continue;
                }
                return DexClassAndMethod.create(current, candidate);
            }
            if (!this.resolvedHolder.isInterface()) {
                return null;
            }
            return this.lookupMaximallySpecificDispatchTarget(dynamicInstance, appInfo, methodCausingFailureConsumer);
        }

        private DexClassAndMethod lookupMaximallySpecificDispatchTarget(DexClass dynamicInstance, AppInfoWithClassHierarchy appInfo, Consumer<? super DexEncodedMethod> methodCausingFailureConsumer) {
            MethodResolutionResult maximallySpecificResolutionResult = appInfo.resolveMaximallySpecificTarget(dynamicInstance, (DexMethod)this.resolvedMethod.getReference());
            if (maximallySpecificResolutionResult.isSingleResolution()) {
                return maximallySpecificResolutionResult.getResolutionPair();
            }
            if (maximallySpecificResolutionResult.isFailedResolution()) {
                maximallySpecificResolutionResult.asFailedResolution().forEachFailureDependency(methodCausingFailureConsumer);
                return null;
            }
            assert (maximallySpecificResolutionResult.isArrayCloneMethodResult());
            return null;
        }

        private DexClassAndMethod lookupMaximallySpecificDispatchTarget(LambdaDescriptor lambdaDescriptor, AppInfoWithClassHierarchy appInfo, Consumer<? super DexEncodedMethod> methodCausingFailureConsumer) {
            MethodResolutionResult maximallySpecificResolutionResult = appInfo.resolveMaximallySpecificTarget(lambdaDescriptor, (DexMethod)this.resolvedMethod.getReference());
            if (maximallySpecificResolutionResult.isSingleResolution()) {
                return maximallySpecificResolutionResult.getResolutionPair();
            }
            if (maximallySpecificResolutionResult.isFailedResolution()) {
                maximallySpecificResolutionResult.asFailedResolution().forEachFailureDependency(methodCausingFailureConsumer);
                return null;
            }
            assert (maximallySpecificResolutionResult.isArrayCloneMethodResult());
            return null;
        }

        private static DexEncodedMethod lookupOverrideCandidate(DexEncodedMethod method, DexClass clazz) {
            DexEncodedMethod candidate = clazz.lookupVirtualMethod((DexMethod)method.getReference());
            assert (candidate == null || !candidate.isPrivateMethod());
            if (candidate != null) {
                return SingleResolutionResult.isOverriding(method, candidate) ? candidate : DexEncodedMethod.SENTINEL;
            }
            return null;
        }

        private static DexEncodedMethod findWideningOverride(DexEncodedMethod resolvedMethod, DexClass clazz, AppInfoWithClassHierarchy appView) {
            assert (resolvedMethod.accessFlags.isPackagePrivate());
            while (clazz.superType != null) {
                clazz = appView.definitionFor(clazz.superType);
                if (clazz == null) {
                    return resolvedMethod;
                }
                DexEncodedMethod otherOverride = clazz.lookupVirtualMethod((DexMethod)resolvedMethod.getReference());
                if (otherOverride == null || !SingleResolutionResult.isOverriding(resolvedMethod, otherOverride) || !otherOverride.accessFlags.isPublic() && !otherOverride.accessFlags.isProtected()) continue;
                assert (resolvedMethod != otherOverride);
                return otherOverride;
            }
            return resolvedMethod;
        }

        public static boolean isOverriding(DexEncodedMethod resolvedMethod, DexEncodedMethod candidate) {
            assert (((DexMethod)resolvedMethod.getReference()).match((DexMethod)candidate.getReference()));
            assert (!candidate.isPrivateMethod());
            if (resolvedMethod.accessFlags.isPublic() || resolvedMethod.accessFlags.isProtected()) {
                return true;
            }
            assert (resolvedMethod.accessFlags.isPackagePrivate());
            return resolvedMethod.getHolderType().isSamePackage(candidate.getHolderType());
        }

        public SingleResolutionResult withInitialResolutionHolder(DexClass newInitialResolutionHolder) {
            return newInitialResolutionHolder != this.initialResolutionHolder ? new SingleResolutionResult(newInitialResolutionHolder, this.resolvedHolder, this.resolvedMethod) : this;
        }

        @Override
        public DexClass getInitialResolutionHolder() {
            return this.initialResolutionHolder;
        }

        @Override
        public DexClass getResolvedHolder() {
            return this.resolvedHolder;
        }

        @Override
        public DexEncodedMethod getResolvedMember() {
            return this.resolvedMethod;
        }

        @Override
        public DexEncodedMethod getResolvedMethod() {
            return this.resolvedMethod;
        }

        @Override
        public ProgramMethod getResolvedProgramMethod() {
            return this.resolvedHolder.isProgramClass() ? new ProgramMethod(this.resolvedHolder.asProgramClass(), this.resolvedMethod) : null;
        }

        @Override
        public DexClassAndMethod getResolutionPair() {
            return DexClassAndMethod.create(this.resolvedHolder, this.resolvedMethod);
        }

        @Override
        public boolean isSingleResolution() {
            return true;
        }

        @Override
        public SingleResolutionResult asSingleResolution() {
            return this;
        }

        @Override
        public boolean isSuccessfulMemberResolutionResult() {
            return true;
        }

        @Override
        public SuccessfulMemberResolutionResult<DexEncodedMethod, DexMethod> asSuccessfulMemberResolutionResult() {
            return this;
        }

        @Override
        public OptionalBool isAccessibleFrom(ProgramDefinition context, AppInfoWithClassHierarchy appInfo) {
            return AccessControl.isMemberAccessible(this, context, appInfo);
        }

        @Override
        public OptionalBool isAccessibleForVirtualDispatchFrom(ProgramDefinition context, AppInfoWithClassHierarchy appInfo) {
            if (this.resolvedMethod.isVirtualMethod()) {
                return this.isAccessibleFrom(context, appInfo);
            }
            return OptionalBool.FALSE;
        }

        @Override
        public boolean isVirtualTarget() {
            return this.resolvedMethod.isVirtualMethod();
        }

        @Override
        public DexClassAndMethod lookupInvokeSpecialTarget(DexProgramClass context, AppInfoWithClassHierarchy appInfo) {
            if (this.isAccessibleFrom((ProgramDefinition)context, appInfo).isPossiblyTrue()) {
                return this.internalInvokeSpecialOrSuper(context, appInfo, (sup, sub) -> SingleResolutionResult.isSuperclass(sup, sub, appInfo));
            }
            return null;
        }

        @Override
        public DexClassAndMethod lookupInvokeSuperTarget(DexProgramClass context, AppInfoWithClassHierarchy appInfo) {
            if (this.resolvedMethod.isInstanceInitializer() || this.initialResolutionHolder != context && !SingleResolutionResult.isSuperclass(this.initialResolutionHolder, context, appInfo)) {
                return null;
            }
            if (this.isAccessibleFrom((ProgramDefinition)context, appInfo).isPossiblyTrue()) {
                return this.internalInvokeSpecialOrSuper(context, appInfo, (sup, sub) -> true);
            }
            return null;
        }

        @Override
        public DexEncodedMethod lookupInvokeStaticTarget(DexProgramClass context, AppInfoWithClassHierarchy appInfo) {
            if (this.isAccessibleFrom((ProgramDefinition)context, appInfo).isFalse()) {
                return null;
            }
            if (this.resolvedMethod.isStatic()) {
                return this.resolvedMethod;
            }
            return null;
        }

        @Override
        public DexEncodedMethod lookupInvokeDirectTarget(DexProgramClass context, AppInfoWithClassHierarchy appInfo) {
            if (this.isAccessibleFrom((ProgramDefinition)context, appInfo).isFalse()) {
                return null;
            }
            if (this.resolvedMethod.isDirectMethod()) {
                return this.resolvedMethod;
            }
            return null;
        }

        @Override
        public LookupResult lookupVirtualDispatchTargets(DexProgramClass context, AppInfoWithClassHierarchy appInfo, InstantiatedSubTypeInfo instantiatedInfo, PinnedPredicate pinnedPredicate) {
            assert (appInfo.isSubtype(this.initialResolutionHolder.type, this.resolvedHolder.type)) : this.initialResolutionHolder.type + " is not a subtype of " + this.resolvedHolder.type;
            if (context != null && this.isAccessibleFrom((ProgramDefinition)context, appInfo).isFalse()) {
                return LookupResult.createFailedResult();
            }
            if (this.resolvedMethod.isPrivateMethod()) {
                boolean isIncomplete = pinnedPredicate.isPinned(this.resolvedHolder) && pinnedPredicate.isPinned(this.resolvedMethod);
                return LookupResult.createResult(DexClassAndMethodSet.create(this.getResolutionPair()), Collections.emptyList(), Collections.emptyList(), isIncomplete ? LookupResult.LookupResultSuccess.LookupResultCollectionState.Incomplete : LookupResult.LookupResultSuccess.LookupResultCollectionState.Complete);
            }
            assert (this.resolvedMethod.isNonPrivateVirtualMethod());
            LookupResult.LookupResultSuccess.Builder resultBuilder = LookupResult.LookupResultSuccess.builder();
            LookupCompletenessHelper incompleteness = new LookupCompletenessHelper(pinnedPredicate);
            instantiatedInfo.forEachInstantiatedSubType(this.initialResolutionHolder.type, subClass -> {
                incompleteness.checkClass((DexClass)subClass);
                DexClassAndMethod dexClassAndMethod = this.lookupVirtualDispatchTarget((DexClass)subClass, appInfo, this.resolvedHolder.type, resultBuilder::addMethodCausingFailure);
                if (dexClassAndMethod != null) {
                    incompleteness.checkDexClassAndMethod(dexClassAndMethod);
                    SingleResolutionResult.addVirtualDispatchTarget(dexClassAndMethod, this.resolvedHolder.isInterface(), resultBuilder);
                }
            }, lambda -> {
                assert (this.resolvedHolder.isInterface() || this.resolvedHolder.type == appInfo.dexItemFactory().objectType);
                LookupTarget target = this.lookupVirtualDispatchTarget((LambdaDescriptor)lambda, appInfo, resultBuilder::addMethodCausingFailure);
                if (target != null) {
                    if (target.isLambdaTarget()) {
                        resultBuilder.addLambdaTarget(target.asLambdaTarget());
                    } else {
                        SingleResolutionResult.addVirtualDispatchTarget(target.asMethodTarget(), this.resolvedHolder.isInterface(), resultBuilder);
                    }
                }
            });
            return resultBuilder.setState(incompleteness.computeCollectionState((DexMethod)this.resolvedMethod.getReference(), appInfo)).build();
        }

        @Override
        public LookupResult lookupVirtualDispatchTargets(DexProgramClass context, AppInfoWithLiveness appInfo, DexProgramClass refinedReceiverUpperBound, DexProgramClass refinedReceiverLowerBound) {
            assert (refinedReceiverUpperBound != null);
            assert (appInfo.isSubtype(refinedReceiverUpperBound.type, this.initialResolutionHolder.type));
            assert (refinedReceiverLowerBound == null || appInfo.isSubtype(refinedReceiverLowerBound.type, refinedReceiverUpperBound.type));
            Box<Boolean> hasInstantiatedLambdas = new Box<Boolean>(false);
            InstantiatedSubTypeInfo instantiatedSubTypeInfo = this.instantiatedSubTypeInfoForInstantiatedType(appInfo, refinedReceiverUpperBound, refinedReceiverLowerBound, hasInstantiatedLambdas);
            LookupResult lookupResult = this.lookupVirtualDispatchTargets(context, (AppInfoWithClassHierarchy)appInfo, instantiatedSubTypeInfo, appInfo::isPinnedNotProgramOrLibraryOverride);
            if (hasInstantiatedLambdas.get().booleanValue() && lookupResult.isLookupResultSuccess()) {
                lookupResult.asLookupResultSuccess().setIncomplete();
            }
            return lookupResult;
        }

        @Override
        public LookupTarget lookupVirtualDispatchTarget(InstantiatedObject instance, AppInfoWithClassHierarchy appInfo) {
            return instance.isClass() ? this.lookupVirtualDispatchTarget(instance.asClass(), appInfo) : this.lookupVirtualDispatchTarget(instance.asLambda(), appInfo, ConsumerUtils.emptyConsumer());
        }

        @Override
        public DexClassAndMethod lookupVirtualDispatchTarget(DexClass dynamicInstance, AppInfoWithClassHierarchy appInfo) {
            return this.lookupVirtualDispatchTarget(dynamicInstance, appInfo, this.initialResolutionHolder.type, ConsumerUtils.emptyConsumer());
        }

        @Override
        public LookupTarget lookupVirtualDispatchTarget(LambdaDescriptor lambdaInstance, AppInfoWithClassHierarchy appInfo, Consumer<? super DexEncodedMethod> methodCausingFailureConsumer) {
            if (lambdaInstance.getMainMethod().match(this.resolvedMethod)) {
                DexClass holder;
                DexMethod methodReference = lambdaInstance.implHandle.asMethod();
                DexClassAndMethod method = methodReference.lookupMemberOnClass(holder = appInfo.definitionForHolder(methodReference));
                if (method == null) {
                    return null;
                }
                return new LookupLambdaTarget(lambdaInstance, method);
            }
            return this.lookupMaximallySpecificDispatchTarget(lambdaInstance, appInfo, methodCausingFailureConsumer);
        }
    }
}

