/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ObjectAllocationInfoCollection;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.shaking.GraphReporter;
import com.android.tools.r8.shaking.InstantiationReason;
import com.android.tools.r8.shaking.KeepReason;
import com.android.tools.r8.shaking.MissingClasses;
import com.android.tools.r8.utils.LensUtils;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.TraversalContinuation;
import com.android.tools.r8.utils.WorkList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class ObjectAllocationInfoCollectionImpl
implements ObjectAllocationInfoCollection {
    final Map<DexProgramClass, Set<DexEncodedMethod>> classesWithAllocationSiteTracking = new IdentityHashMap<DexProgramClass, Set<DexEncodedMethod>>();
    final Set<DexProgramClass> classesWithoutAllocationSiteTracking = Sets.newIdentityHashSet();
    final Set<DexProgramClass> annotationsWithUnknownSubtypeHierarchy = Sets.newIdentityHashSet();
    final Set<DexProgramClass> interfacesWithUnknownSubtypeHierarchy = Sets.newIdentityHashSet();
    final Map<DexType, List<LambdaDescriptor>> instantiatedLambdas = new IdentityHashMap<DexType, List<LambdaDescriptor>>();
    Map<DexType, Set<DexClass>> instantiatedHierarchy = new IdentityHashMap<DexType, Set<DexClass>>();

    private ObjectAllocationInfoCollectionImpl() {
    }

    public static Builder builder(boolean trackAllocationSites, GraphReporter reporter) {
        return new Builder(trackAllocationSites, reporter);
    }

    public abstract void mutate(Consumer<Builder> var1, AppInfo var2);

    @Override
    public boolean isInstantiatedDirectly(DexProgramClass clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        if (this.classesWithAllocationSiteTracking.containsKey(clazz)) {
            assert (!this.classesWithAllocationSiteTracking.get(clazz).isEmpty());
            return true;
        }
        return this.classesWithoutAllocationSiteTracking.contains(clazz);
    }

    @Override
    public boolean isInstantiatedDirectlyOrHasInstantiatedSubtype(DexProgramClass clazz) {
        return !clazz.isInterface() && this.isInstantiatedDirectly(clazz) || this.hasInstantiatedStrictSubtype(clazz);
    }

    @Override
    public boolean hasInstantiatedStrictSubtype(DexProgramClass clazz) {
        if (this.instantiatedHierarchy.get(clazz.type) != null) {
            return true;
        }
        if (!clazz.isInterface()) {
            return false;
        }
        return this.annotationsWithUnknownSubtypeHierarchy.contains(clazz) || this.interfacesWithUnknownSubtypeHierarchy.contains(clazz) || this.isImmediateInterfaceOfInstantiatedLambda(clazz);
    }

    @Override
    public boolean isInterfaceWithUnknownSubtypeHierarchy(DexProgramClass clazz) {
        return clazz.isInterface() && this.interfacesWithUnknownSubtypeHierarchy.contains(clazz);
    }

    @Override
    public boolean isImmediateInterfaceOfInstantiatedLambda(DexProgramClass iface) {
        return iface.isInterface() && this.instantiatedLambdas.get(iface.type) != null;
    }

    public Set<DexClass> getImmediateSubtypesInInstantiatedHierarchy(DexType type) {
        return this.instantiatedHierarchy.get(type);
    }

    @Override
    public void forEachClassWithKnownAllocationSites(BiConsumer<DexProgramClass, Set<DexEncodedMethod>> consumer) {
        this.classesWithAllocationSiteTracking.forEach(consumer);
    }

    @Override
    public boolean isAllocationSitesKnown(DexProgramClass clazz) {
        return this.classesWithAllocationSiteTracking.containsKey(clazz);
    }

    @Override
    public ObjectAllocationInfoCollectionImpl rewrittenWithLens(DexDefinitionSupplier definitions, GraphLens lens) {
        return ObjectAllocationInfoCollectionImpl.builder(true, null).rewrittenWithLens(this, definitions, lens).build(definitions);
    }

    public ObjectAllocationInfoCollectionImpl withoutPrunedItems(PrunedItems prunedItems) {
        if (prunedItems.hasRemovedMethods()) {
            Iterator<Map.Entry<DexProgramClass, Set<DexEncodedMethod>>> iterator2 = this.classesWithAllocationSiteTracking.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<DexProgramClass, Set<DexEncodedMethod>> entry = iterator2.next();
                Set<DexEncodedMethod> allocationSites = entry.getValue();
                allocationSites.removeIf(allocationSite -> prunedItems.getRemovedMethods().contains(allocationSite.getReference()));
                if (!allocationSites.isEmpty()) continue;
                this.classesWithoutAllocationSiteTracking.add(entry.getKey());
                iterator2.remove();
            }
        }
        return this;
    }

    public void forEachInstantiatedSubType(DexType type, Consumer<DexProgramClass> onClass, Consumer<LambdaDescriptor> onLambda, AppInfo appInfo) {
        this.traverseInstantiatedSubtypes(type, clazz -> {
            onClass.accept((DexProgramClass)clazz);
            return TraversalContinuation.doContinue();
        }, lambda -> {
            onLambda.accept((LambdaDescriptor)lambda);
            return TraversalContinuation.doContinue();
        }, appInfo);
    }

    public TraversalContinuation<?> traverseInstantiatedSubtypes(DexType type, Function<DexProgramClass, TraversalContinuation<?>> onClass, Function<LambdaDescriptor, TraversalContinuation<?>> onLambda, AppInfo appInfo) {
        WorkList<DexClass> worklist = WorkList.newIdentityWorkList();
        if (type == appInfo.dexItemFactory().objectType) {
            this.instantiatedHierarchy.forEach((key, subtypes) -> {
                DexClass clazz = appInfo.definitionFor((DexType)key);
                if (clazz != null) {
                    worklist.addIfNotSeen(clazz);
                }
                worklist.addIfNotSeen((Iterable<DexClass>)subtypes);
            });
        } else {
            DexClass initialClass = appInfo.definitionFor(type);
            if (initialClass == null) {
                worklist.addIfNotSeen(this.instantiatedHierarchy.getOrDefault(type, Collections.emptySet()));
                for (LambdaDescriptor lambda : this.instantiatedLambdas.getOrDefault(type, Collections.emptyList())) {
                    if (!onLambda.apply(lambda).shouldBreak()) continue;
                    return TraversalContinuation.doBreak();
                }
            } else {
                worklist.addIfNotSeen(initialClass);
            }
        }
        while (worklist.hasNext()) {
            DexProgramClass programClass;
            DexClass clazz = (DexClass)worklist.next();
            if (clazz.isProgramClass() && (this.isInstantiatedDirectly(programClass = clazz.asProgramClass()) || this.isInterfaceWithUnknownSubtypeHierarchy(programClass)) && onClass.apply(programClass).shouldBreak()) {
                return TraversalContinuation.doBreak();
            }
            worklist.addIfNotSeen(this.instantiatedHierarchy.getOrDefault(clazz.type, Collections.emptySet()));
            for (LambdaDescriptor lambda : this.instantiatedLambdas.getOrDefault(clazz.type, Collections.emptyList())) {
                if (!onLambda.apply(lambda).shouldBreak()) continue;
                return TraversalContinuation.doBreak();
            }
        }
        return TraversalContinuation.doContinue();
    }

    public Set<DexType> getInstantiatedLambdaInterfaces() {
        return this.instantiatedLambdas.keySet();
    }

    @Override
    public void forEachInstantiatedLambdaInterfaces(Consumer<DexType> consumer) {
        this.getInstantiatedLambdaInterfaces().forEach(consumer);
    }

    public void removeAllocationsForPrunedItems(PrunedItems prunedItems) {
        Set<DexType> removedClasses = prunedItems.getRemovedClasses();
        if (removedClasses.isEmpty()) {
            return;
        }
        this.classesWithAllocationSiteTracking.entrySet().removeIf(entry -> removedClasses.contains(((DexProgramClass)entry.getKey()).getType()));
        this.classesWithoutAllocationSiteTracking.removeIf(clazz -> removedClasses.contains(clazz.getType()));
        this.annotationsWithUnknownSubtypeHierarchy.removeIf(annotation -> removedClasses.contains(annotation.getType()));
        boolean removed = this.interfacesWithUnknownSubtypeHierarchy.removeIf(iface -> removedClasses.contains(iface.getType()));
        assert (!removed) : "Unexpected removal of an interface marking an unknown hierarchy.";
        removedClasses.forEach(this.instantiatedLambdas::remove);
    }

    public boolean verifyAllocatedTypesAreLive(Set<DexType> liveTypes, MissingClasses missingClasses, DexDefinitionSupplier definitions) {
        for (DexProgramClass dexProgramClass : this.classesWithAllocationSiteTracking.keySet()) {
            assert (liveTypes.contains(dexProgramClass.getType()));
        }
        for (DexProgramClass dexProgramClass : this.classesWithoutAllocationSiteTracking) {
            assert (liveTypes.contains(dexProgramClass.getType()));
        }
        for (DexProgramClass dexProgramClass : this.annotationsWithUnknownSubtypeHierarchy) {
            assert (liveTypes.contains(dexProgramClass.getType()));
        }
        for (DexProgramClass dexProgramClass : this.interfacesWithUnknownSubtypeHierarchy) {
            assert (liveTypes.contains(dexProgramClass.getType()));
        }
        for (DexType dexType : this.instantiatedLambdas.keySet()) {
            assert (missingClasses.contains(dexType) || definitions.definitionFor(dexType).isNotProgramClass() || liveTypes.contains(dexType));
        }
        return true;
    }

    public static class Builder
    extends ObjectAllocationInfoCollectionImpl {
        private Data data;

        private Builder(boolean trackAllocationSites, GraphReporter reporter) {
            this.data = new Data(trackAllocationSites, reporter);
        }

        private boolean shouldTrackAllocationSitesForClass(DexProgramClass clazz, InstantiationReason instantiationReason) {
            if (!this.data.trackAllocationSites) {
                return false;
            }
            if (instantiationReason != InstantiationReason.NEW_INSTANCE_INSTRUCTION) {
                return false;
            }
            return !this.classesWithoutAllocationSiteTracking.contains(clazz);
        }

        private void repopulateInstantiatedHierarchy(DexDefinitionSupplier definitions) {
            this.instantiatedHierarchy = new IdentityHashMap();
            this.classesWithAllocationSiteTracking.keySet().forEach(clazz -> this.populateInstantiatedHierarchy(definitions, (DexClass)clazz));
            this.classesWithoutAllocationSiteTracking.forEach(clazz -> this.populateInstantiatedHierarchy(definitions, (DexClass)clazz));
            this.interfacesWithUnknownSubtypeHierarchy.forEach(clazz -> this.populateInstantiatedHierarchy(definitions, (DexClass)clazz));
            this.instantiatedLambdas.keySet().forEach(type -> this.populateInstantiatedHierarchy(definitions, (DexType)type));
        }

        private void populateInstantiatedHierarchy(DexDefinitionSupplier definitions, DexType type) {
            DexClass clazz = definitions.definitionFor(type);
            if (clazz != null) {
                this.populateInstantiatedHierarchy(definitions, clazz);
            }
        }

        private void populateInstantiatedHierarchy(DexDefinitionSupplier definitions, DexClass clazz) {
            if (clazz.superType != null) {
                this.populateInstantiatedHierarchy(definitions, clazz.superType, clazz);
            }
            for (DexType iface : clazz.interfaces.values) {
                this.populateInstantiatedHierarchy(definitions, iface, clazz);
            }
        }

        private void populateInstantiatedHierarchy(DexDefinitionSupplier definitions, DexType type, DexClass subtype) {
            if (type == definitions.dexItemFactory().objectType) {
                return;
            }
            Set<DexClass> subtypes = (Set<DexClass>)this.instantiatedHierarchy.get(type);
            if (subtypes != null) {
                subtypes.add(subtype);
                return;
            }
            subtypes = Sets.newIdentityHashSet();
            subtypes.add(subtype);
            this.instantiatedHierarchy.put(type, subtypes);
            this.populateInstantiatedHierarchy(definitions, type);
        }

        private boolean verifyAllSuperTypesAreInHierarchy(DexDefinitionSupplier definitions, Iterable<DexType> dexTypes) {
            for (DexType supertype : dexTypes) {
                assert (this.typeIsInHierarchy(definitions, supertype)) : "Type not found in hierarchy: " + supertype;
            }
            return true;
        }

        private boolean typeIsInHierarchy(DexDefinitionSupplier definitions, DexType type) {
            return type == definitions.dexItemFactory().objectType || this.instantiatedHierarchy.containsKey(type);
        }

        private boolean isImmediateSuperType(DexType type, DexClass subtype) {
            for (DexType supertype : subtype.allImmediateSupertypes()) {
                if (type != supertype) continue;
                return true;
            }
            return false;
        }

        public ObjectAllocationInfoCollectionImpl build(DexDefinitionSupplier definitions) {
            assert (this.data != null);
            if (this.instantiatedHierarchy == null) {
                this.repopulateInstantiatedHierarchy(definitions);
            }
            assert (this.validate(definitions));
            this.data = null;
            return this;
        }

        @Override
        public void mutate(Consumer<Builder> mutator, AppInfo appInfo) {
            mutator.accept(this);
            this.repopulateInstantiatedHierarchy(appInfo);
        }

        public boolean recordDirectAllocationSite(DexProgramClass clazz, ProgramMethod context, InstantiationReason instantiationReason, KeepReason keepReason, AppInfo appInfo) {
            assert (!clazz.isInterface());
            if (this.data.reporter != null) {
                this.data.reporter.registerClass(clazz, keepReason);
            }
            this.populateInstantiatedHierarchy((DexDefinitionSupplier)appInfo, clazz);
            if (this.shouldTrackAllocationSitesForClass(clazz, instantiationReason)) {
                assert (context != null);
                Set allocationSitesForClass = this.classesWithAllocationSiteTracking.computeIfAbsent(clazz, ignore -> Sets.newIdentityHashSet());
                allocationSitesForClass.add((DexEncodedMethod)context.getDefinition());
                return allocationSitesForClass.size() == 1;
            }
            if (this.classesWithoutAllocationSiteTracking.add(clazz)) {
                Set allocationSitesForClass = (Set)this.classesWithAllocationSiteTracking.remove(clazz);
                return allocationSitesForClass == null;
            }
            return false;
        }

        public boolean recordInstantiatedAnnotation(DexProgramClass annotation, AppInfo appInfo) {
            assert (annotation.isInterface());
            assert (annotation.isAnnotation());
            if (this.annotationsWithUnknownSubtypeHierarchy.add(annotation)) {
                this.populateInstantiatedHierarchy((DexDefinitionSupplier)appInfo, annotation);
                return true;
            }
            return false;
        }

        public boolean recordInstantiatedInterface(DexProgramClass iface, AppInfo appInfo) {
            assert (iface.isInterface());
            assert (!iface.isAnnotation());
            if (this.interfacesWithUnknownSubtypeHierarchy.add(iface)) {
                this.populateInstantiatedHierarchy((DexDefinitionSupplier)appInfo, iface);
                return true;
            }
            return false;
        }

        public void recordInstantiatedLambdaInterface(DexType iface, LambdaDescriptor lambda, AppInfo appInfo) {
            this.instantiatedLambdas.computeIfAbsent(iface, key -> new ArrayList()).add(lambda);
            this.populateInstantiatedHierarchy((DexDefinitionSupplier)appInfo, iface);
        }

        public void injectInterfaces(DexDefinitionSupplier definitions, DexProgramClass clazz, Set<DexClass> newInterfaces) {
            for (DexClass newInterface : newInterfaces) {
                this.populateInstantiatedHierarchy(definitions, newInterface.type, clazz);
            }
        }

        public void markNoLongerInstantiated(DexProgramClass clazz) {
            this.classesWithAllocationSiteTracking.remove(clazz);
            this.classesWithoutAllocationSiteTracking.remove(clazz);
            this.instantiatedHierarchy = null;
        }

        Builder rewrittenWithLens(ObjectAllocationInfoCollectionImpl objectAllocationInfos, DexDefinitionSupplier definitions, GraphLens lens) {
            this.instantiatedHierarchy = null;
            objectAllocationInfos.classesWithoutAllocationSiteTracking.forEach(clazz -> {
                DexType type = lens.lookupType(clazz.type);
                if (type.isPrimitiveType()) {
                    assert (!objectAllocationInfos.hasInstantiatedStrictSubtype((DexProgramClass)clazz));
                    return;
                }
                DexProgramClass rewrittenClass = DexProgramClass.asProgramClassOrNull(definitions.definitionFor(type));
                assert (rewrittenClass != null);
                this.classesWithoutAllocationSiteTracking.add(rewrittenClass);
            });
            objectAllocationInfos.classesWithAllocationSiteTracking.forEach((clazz, allocationSitesForClass) -> {
                DexType type = lens.lookupType(clazz.type);
                if (type.isPrimitiveType()) {
                    assert (!objectAllocationInfos.hasInstantiatedStrictSubtype((DexProgramClass)clazz));
                    return;
                }
                DexProgramClass rewrittenClass = DexProgramClass.asProgramClassOrNull(definitions.definitionFor(type));
                assert (rewrittenClass != null);
                if (this.classesWithoutAllocationSiteTracking.contains(rewrittenClass)) {
                    return;
                }
                this.classesWithAllocationSiteTracking.computeIfAbsent(rewrittenClass, ignore -> Sets.newIdentityHashSet()).addAll(LensUtils.rewrittenWithRenamedSignature(allocationSitesForClass, definitions, lens));
            });
            for (DexProgramClass abstractType : objectAllocationInfos.interfacesWithUnknownSubtypeHierarchy) {
                DexType type = lens.lookupType(abstractType.type);
                if (type.isPrimitiveType()) {
                    assert (false);
                    continue;
                }
                DexProgramClass rewrittenClass = DexProgramClass.asProgramClassOrNull(definitions.definitionFor(type));
                assert (rewrittenClass != null);
                assert (!this.interfacesWithUnknownSubtypeHierarchy.contains(rewrittenClass));
                this.interfacesWithUnknownSubtypeHierarchy.add(rewrittenClass);
            }
            objectAllocationInfos.instantiatedLambdas.forEach((iface, lambdas) -> {
                DexType type = lens.lookupType((DexType)iface);
                if (type.isPrimitiveType()) {
                    assert (false);
                    return;
                }
                ((List)this.instantiatedLambdas.computeIfAbsent(type, MapUtils.ignoreKey(ArrayList::new))).addAll(lambdas);
            });
            return this;
        }

        boolean validate(DexDefinitionSupplier definitions) {
            this.classesWithAllocationSiteTracking.forEach((clazz, contexts) -> {
                assert (!clazz.isInterface());
                assert (!this.classesWithoutAllocationSiteTracking.contains(clazz));
                assert (this.verifyAllSuperTypesAreInHierarchy(definitions, clazz.allImmediateSupertypes()));
            });
            this.classesWithoutAllocationSiteTracking.forEach(clazz -> {
                assert (!clazz.isInterface());
                assert (!this.classesWithAllocationSiteTracking.containsKey(clazz));
                assert (this.verifyAllSuperTypesAreInHierarchy(definitions, clazz.allImmediateSupertypes()));
            });
            this.instantiatedLambdas.forEach((iface, lambdas) -> {
                assert (!lambdas.isEmpty());
                DexClass definition = definitions.definitionFor((DexType)iface);
                if (definition != null) {
                    assert (definition.isInterface());
                    assert (this.verifyAllSuperTypesAreInHierarchy(definitions, definition.allImmediateSupertypes()));
                }
            });
            for (DexProgramClass iface2 : this.interfacesWithUnknownSubtypeHierarchy) {
                this.verifyAllSuperTypesAreInHierarchy(definitions, iface2.allImmediateSupertypes());
            }
            this.instantiatedHierarchy.forEach((type, subtypes) -> {
                assert (!subtypes.isEmpty());
                for (DexClass subtype : subtypes) {
                    assert (this.isImmediateSuperType((DexType)type, subtype));
                }
            });
            return true;
        }

        private static class Data {
            private final boolean trackAllocationSites;
            private final GraphReporter reporter;

            private Data(boolean trackAllocationSites, GraphReporter reporter) {
                this.trackAllocationSites = trackAllocationSites;
                this.reporter = reporter;
            }
        }
    }
}

