/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMember;
import com.android.tools.r8.graph.ThrowNullCode;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.graph.UseRegistryWithResult;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.NumberGenerator;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.conversion.MethodConversionOptions;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.kotlin.KotlinMethodLevelInfo;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public final class ProgramMethod
extends DexClassAndMethod
implements ProgramMember<DexEncodedMethod, DexMethod> {
    public ProgramMethod(DexProgramClass holder, DexEncodedMethod method) {
        super((DexClass)holder, method);
    }

    private boolean convertToAbstractMethodIfPossible(AppView<AppInfoWithLiveness> appView) {
        boolean canBeAbstract = this.canBeConvertedToAbstractMethod(appView);
        if (canBeAbstract) {
            MethodAccessFlags accessFlags = this.getAccessFlags();
            accessFlags.demoteFromFinal();
            accessFlags.demoteFromStrict();
            accessFlags.demoteFromSynchronized();
            accessFlags.promoteToAbstract();
            ((DexEncodedMethod)this.getDefinition()).clearApiLevelForCode();
            ((DexEncodedMethod)this.getDefinition()).unsetCode();
            OptimizationFeedback.getSimpleFeedback().unsetOptimizationInfoForAbstractMethod(this);
        }
        return canBeAbstract;
    }

    public IRCode buildIR(AppView<?> appView) {
        return this.buildIR(appView, new MethodConversionOptions.MutableMethodConversionOptions(appView.options()));
    }

    public IRCode buildIR(AppView<?> appView, MethodConversionOptions.MutableMethodConversionOptions conversionOptions) {
        DexEncodedMethod method = (DexEncodedMethod)this.getDefinition();
        return method.hasCode() ? method.getCode().buildIR(this, appView, this.getOrigin(), conversionOptions) : null;
    }

    public IRCode buildInliningIR(ProgramMethod context, AppView<?> appView, NumberGenerator valueNumberGenerator, Position callerPosition, Origin origin, MethodProcessor methodProcessor) {
        Code code = ((DexEncodedMethod)this.getDefinition()).getCode();
        GraphLens codeLens = appView.graphLens();
        RewrittenPrototypeDescription protoChanges = RewrittenPrototypeDescription.none();
        if (methodProcessor.shouldApplyCodeRewritings(this)) {
            codeLens = ((DexEncodedMethod)this.getDefinition()).getCode().getCodeLens(appView);
            protoChanges = appView.graphLens().lookupPrototypeChangesForMethodDefinition((DexMethod)this.getReference());
        }
        return code.buildInliningIR(context, this, appView, codeLens, valueNumberGenerator, callerPosition, origin, protoChanges);
    }

    public void collectIndexedItems(IndexedItemCollection indexedItems, GraphLens graphLens, LensCodeRewriterUtils rewriter) {
        DexEncodedMethod definition = (DexEncodedMethod)this.getDefinition();
        assert (!definition.isObsolete());
        ((DexMethod)this.getReference()).collectIndexedItems(indexedItems);
        if (definition.hasCode()) {
            Code code = definition.getCode();
            code.asDexWritableCode().collectIndexedItems(indexedItems, this, graphLens, rewriter);
        }
        definition.annotations().collectIndexedItems(indexedItems);
        definition.parameterAnnotationsList.collectIndexedItems(indexedItems);
    }

    public boolean canBeConvertedToAbstractMethod(AppView<AppInfoWithLiveness> appView) {
        return (appView.options().canUseAbstractMethodOnNonAbstractClass() || this.getHolder().isAbstract() || this.getHolder().isInterface()) && !this.getAccessFlags().isNative() && !this.getAccessFlags().isPrivate() && !this.getAccessFlags().isStatic() && !((DexEncodedMethod)this.getDefinition()).isInstanceInitializer() && !appView.appInfo().isFailedResolutionTarget((DexMethod)this.getReference());
    }

    public void convertToAbstractOrThrowNullMethod(AppView<AppInfoWithLiveness> appView) {
        if (!this.convertToAbstractMethodIfPossible(appView)) {
            this.convertToThrowNullMethod(appView);
        }
    }

    public void convertToThrowNullMethod(AppView<?> appView) {
        MethodAccessFlags accessFlags = this.getAccessFlags();
        accessFlags.demoteFromAbstract();
        ((DexEncodedMethod)this.getDefinition()).setApiLevelForCode(appView.computedMinApiLevel());
        this.setCode(ThrowNullCode.get(), appView);
        OptimizationFeedback.getSimpleFeedback().markProcessed((DexEncodedMethod)this.getDefinition(), Inliner.ConstraintWithTarget.ALWAYS);
        OptimizationFeedback.getSimpleFeedback().unsetOptimizationInfoForThrowNullMethod(this);
    }

    public void registerCodeReferences(UseRegistry<?> registry) {
        Code code = ((DexEncodedMethod)this.getDefinition()).getCode();
        if (code != null) {
            if (Log.ENABLED) {
                Log.verbose(this.getClass(), "Registering definitions reachable from `%s`.", this);
            }
            code.registerCodeReferences(this, registry);
        }
    }

    public <R> R registerCodeReferencesWithResult(UseRegistryWithResult<R, ?> registry) {
        this.registerCodeReferences(registry);
        return registry.getResult();
    }

    @Override
    public ProgramMethod getContext() {
        return this;
    }

    @Override
    public DexProgramClass getContextClass() {
        return this.getHolder();
    }

    @Override
    public boolean isProgramMember() {
        return true;
    }

    public ProgramMethod asProgramMember() {
        return this;
    }

    @Override
    public boolean isProgramMethod() {
        return true;
    }

    @Override
    public ProgramMethod asMethod() {
        return this;
    }

    @Override
    public ProgramMethod asProgramMethod() {
        return this;
    }

    @Override
    public DexProgramClass getHolder() {
        DexClass holder = super.getHolder();
        assert (holder.isProgramClass());
        return holder.asProgramClass();
    }

    @Override
    public KotlinMethodLevelInfo getKotlinInfo() {
        return ((DexEncodedMethod)this.getDefinition()).getKotlinInfo();
    }

    public boolean getOrComputeReachabilitySensitive(AppView<?> appView) {
        return this.getHolder().getOrComputeReachabilitySensitive(appView);
    }

    public void setCode(Code newCode, AppView<?> appView) {
        Code code = ((DexEncodedMethod)this.getDefinition()).getCode();
        Int2ReferenceMap<DebugLocalInfo> parameterInfo = ((DexEncodedMethod)this.getDefinition()).getParameterInfo();
        if (code != null && code.isCfCode() && !((DexEncodedMethod)this.getDefinition()).hasParameterInfo() && !this.keepLocals(appView)) {
            parameterInfo = code.collectParameterInfo((DexEncodedMethod)this.getDefinition(), appView);
        }
        ((DexEncodedMethod)this.getDefinition()).setCode(newCode, parameterInfo);
    }

    public boolean keepLocals(AppView<?> appView) {
        if (appView.testing().noLocalsTableOnInput) {
            return false;
        }
        return appView.options().debug || this.getOrComputeReachabilitySensitive(appView);
    }
}

