/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramPackage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ProgramPackageCollection
implements Iterable<ProgramPackage> {
    protected final Map<String, ProgramPackage> packages;

    protected ProgramPackageCollection(Map<String, ProgramPackage> packages) {
        this.packages = packages;
    }

    public static ProgramPackageCollection createWithAllProgramClasses(AppView<?> appView) {
        assert (!((AppInfo)appView.appInfo()).getSyntheticItems().hasPendingSyntheticClasses());
        ProgramPackageCollection programPackages = new ProgramPackageCollection(new HashMap<String, ProgramPackage>());
        for (DexProgramClass clazz : ((AppInfo)appView.appInfo()).classes()) {
            programPackages.addProgramClass(clazz);
        }
        return programPackages;
    }

    public static ProgramPackageCollection createEmpty() {
        return new ProgramPackageCollection(new HashMap<String, ProgramPackage>());
    }

    public boolean addProgramClass(DexProgramClass clazz) {
        return this.packages.computeIfAbsent(clazz.getType().getPackageDescriptor(), ProgramPackage::new).add(clazz);
    }

    public boolean contains(DexProgramClass clazz) {
        ProgramPackage pkg = this.packages.get(clazz.getType().getPackageDescriptor());
        return pkg != null && pkg.contains(clazz);
    }

    public boolean isEmpty() {
        return this.packages.isEmpty();
    }

    @Override
    public Iterator<ProgramPackage> iterator() {
        return this.packages.values().iterator();
    }
}

