/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import java.util.Collection;
import java.util.Set;

public class PrunedItems {
    private final DexApplication prunedApp;
    private final Set<DexReference> additionalPinnedItems;
    private final Set<DexType> noLongerSyntheticItems;
    private final Set<DexType> removedClasses;
    private final Set<DexField> removedFields;
    private final Set<DexMethod> removedMethods;

    private PrunedItems(DexApplication prunedApp, Set<DexReference> additionalPinnedItems, Set<DexType> noLongerSyntheticItems, Set<DexType> removedClasses, Set<DexField> removedFields, Set<DexMethod> removedMethods) {
        this.prunedApp = prunedApp;
        this.additionalPinnedItems = additionalPinnedItems;
        this.noLongerSyntheticItems = noLongerSyntheticItems;
        this.removedClasses = removedClasses;
        this.removedFields = removedFields;
        this.removedMethods = removedMethods;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PrunedItems empty(DexApplication application) {
        return new Builder().setPrunedApp(application).build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean isEmpty() {
        return this.removedClasses.isEmpty() && this.removedFields.isEmpty() && this.removedMethods.isEmpty() && this.additionalPinnedItems.isEmpty();
    }

    public boolean isRemoved(DexField field) {
        return this.removedFields.contains(field) || this.removedClasses.contains(field.getHolderType());
    }

    public boolean isRemoved(DexMethod method) {
        return this.removedMethods.contains(method) || this.removedClasses.contains(method.getHolderType());
    }

    public boolean isRemoved(DexReference reference) {
        return reference.apply(this::isRemoved, this::isRemoved, this::isRemoved);
    }

    public boolean isRemoved(DexType type) {
        return this.removedClasses.contains(type);
    }

    public DexApplication getPrunedApp() {
        return this.prunedApp;
    }

    public Set<? extends DexReference> getAdditionalPinnedItems() {
        return this.additionalPinnedItems;
    }

    public Set<DexType> getNoLongerSyntheticItems() {
        return this.noLongerSyntheticItems;
    }

    public boolean hasRemovedClasses() {
        return !this.removedClasses.isEmpty();
    }

    public boolean hasRemovedFields() {
        return !this.removedFields.isEmpty();
    }

    public boolean hasRemovedMembers() {
        return this.hasRemovedFields() || this.hasRemovedMethods();
    }

    public boolean hasRemovedMethods() {
        return !this.removedMethods.isEmpty();
    }

    public Set<DexType> getRemovedClasses() {
        return this.removedClasses;
    }

    public Set<DexField> getRemovedFields() {
        return this.removedFields;
    }

    public Set<DexMethod> getRemovedMethods() {
        return this.removedMethods;
    }

    public static class Builder {
        private DexApplication prunedApp;
        private final Set<DexReference> additionalPinnedItems = Sets.newIdentityHashSet();
        private final Set<DexType> noLongerSyntheticItems = Sets.newIdentityHashSet();
        private Set<DexType> removedClasses = Sets.newIdentityHashSet();
        private final Set<DexField> removedFields = Sets.newIdentityHashSet();
        private Set<DexMethod> removedMethods = Sets.newIdentityHashSet();

        Builder() {
        }

        Builder(PrunedItems prunedItems) {
            this.additionalPinnedItems.addAll(prunedItems.getAdditionalPinnedItems());
            this.noLongerSyntheticItems.addAll(prunedItems.getNoLongerSyntheticItems());
            this.prunedApp = prunedItems.getPrunedApp();
            this.removedClasses.addAll(prunedItems.getRemovedClasses());
            this.removedFields.addAll(prunedItems.getRemovedFields());
            this.removedMethods.addAll(prunedItems.getRemovedMethods());
        }

        public Builder setPrunedApp(DexApplication prunedApp) {
            this.prunedApp = prunedApp;
            return this;
        }

        public Builder addAdditionalPinnedItems(Collection<? extends DexReference> additionalPinnedItems) {
            this.additionalPinnedItems.addAll(additionalPinnedItems);
            return this;
        }

        public Builder addNoLongerSyntheticItems(Set<DexType> noLongerSyntheticItems) {
            this.noLongerSyntheticItems.addAll(noLongerSyntheticItems);
            return this;
        }

        public Builder addRemovedClass(DexType removedClass) {
            this.noLongerSyntheticItems.add(removedClass);
            this.removedClasses.add(removedClass);
            return this;
        }

        public Builder addRemovedClasses(Set<DexType> removedClasses) {
            this.noLongerSyntheticItems.addAll(removedClasses);
            this.removedClasses.addAll(removedClasses);
            return this;
        }

        public Builder addRemovedField(DexField removedField) {
            this.removedFields.add(removedField);
            return this;
        }

        public Builder addRemovedMethod(DexMethod removedMethod) {
            this.removedMethods.add(removedMethod);
            return this;
        }

        public Builder setRemovedClasses(Set<DexType> removedClasses) {
            this.removedClasses = removedClasses;
            return this;
        }

        public Builder setRemovedMethods(Set<DexMethod> removedMethods) {
            this.removedMethods = removedMethods;
            return this;
        }

        public PrunedItems build() {
            return new PrunedItems(this.prunedApp, this.additionalPinnedItems, this.noLongerSyntheticItems, this.removedClasses, this.removedFields, this.removedMethods);
        }
    }
}

