/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph.analysis;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.analysis.EnqueuerAnalysis;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.EnqueuerWorklist;
import java.util.IdentityHashMap;
import java.util.Map;

public class InitializedClassesInInstanceMethodsAnalysis
extends EnqueuerAnalysis {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final Map<DexType, DexType> mapping = new IdentityHashMap<DexType, DexType>();

    public InitializedClassesInInstanceMethodsAnalysis(AppView<? extends AppInfoWithClassHierarchy> appView) {
        this.appView = appView;
    }

    @Override
    public void processNewlyInstantiatedClass(DexProgramClass clazz, ProgramMethod context, EnqueuerWorklist worklist) {
        DexType key = clazz.type;
        DexType objectType = this.appView.dexItemFactory().objectType;
        if (context == null) {
            this.mapping.put(key, objectType);
            return;
        }
        AppInfoWithClassHierarchy appInfo = this.appView.appInfo();
        DexType guaranteedToBeInitialized = context.getHolderType();
        DexType existingGuaranteedToBeInitialized = this.mapping.getOrDefault(key, guaranteedToBeInitialized);
        this.mapping.put(key, ClassTypeElement.computeLeastUpperBoundOfClasses(appInfo, guaranteedToBeInitialized, existingGuaranteedToBeInitialized));
    }

    @Override
    public void done(Enqueuer enqueuer) {
        this.appView.setInitializedClassesInInstanceMethods(new InitializedClassesInInstanceMethods(this.appView, this.mapping));
    }

    public static class InitializedClassesInInstanceMethods {
        private final AppView<? extends AppInfoWithClassHierarchy> appView;
        private final Map<DexType, DexType> mapping;

        private InitializedClassesInInstanceMethods(AppView<? extends AppInfoWithClassHierarchy> appView, Map<DexType, DexType> mapping) {
            this.appView = appView;
            this.mapping = mapping;
        }

        public boolean isClassDefinitelyLoadedInInstanceMethod(DexProgramClass subject, ProgramMethod context) {
            assert (!((DexEncodedMethod)context.getDefinition()).isStatic());
            AppInfoWithClassHierarchy appInfo = this.appView.appInfo();
            if (appInfo.hasLiveness() && appInfo.withLiveness().isPinned(subject.type)) {
                return false;
            }
            DexType guaranteedToBeInitializedInContext = this.mapping.getOrDefault(context.getHolderType(), this.appView.dexItemFactory().objectType);
            if (!appInfo.isSubtype(guaranteedToBeInitializedInContext, subject.type)) {
                return false;
            }
            return !subject.isInterface();
        }
    }
}

