/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph.bytecodemetadata;

import com.android.tools.r8.graph.bytecodemetadata.BytecodeInstructionMetadata;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.utils.MapUtils;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class BytecodeMetadataProvider {
    private static final BytecodeMetadataProvider EMPTY = new BytecodeMetadataProvider(Collections.emptyMap());
    private final Map<Instruction, BytecodeInstructionMetadata> backing;

    BytecodeMetadataProvider(Map<Instruction, BytecodeInstructionMetadata> backing) {
        this.backing = backing;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BytecodeMetadataProvider empty() {
        return EMPTY;
    }

    public BytecodeInstructionMetadata getMetadata(Instruction instruction) {
        return this.backing.get(instruction);
    }

    public static class Builder {
        private final Map<Instruction, BytecodeInstructionMetadata.Builder> builders = new IdentityHashMap<Instruction, BytecodeInstructionMetadata.Builder>();

        public Builder addMetadata(Instruction instruction, Consumer<BytecodeInstructionMetadata.Builder> fn) {
            assert (!this.builders.containsKey(instruction));
            BytecodeInstructionMetadata.Builder builder = this.builders.computeIfAbsent(instruction, MapUtils.ignoreKey(BytecodeInstructionMetadata::builder));
            fn.accept(builder);
            return this;
        }

        public BytecodeMetadataProvider build() {
            if (this.builders.isEmpty()) {
                return BytecodeMetadataProvider.empty();
            }
            IdentityHashMap<Instruction, BytecodeInstructionMetadata> backing = new IdentityHashMap<Instruction, BytecodeInstructionMetadata>(this.builders.size());
            this.builders.forEach((instruction, builder) -> backing.put((Instruction)instruction, builder.build()));
            return new BytecodeMetadataProvider(backing);
        }
    }
}

