/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph.classmerging;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.classmerging.MergedClasses;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneMap;
import com.android.tools.r8.utils.collections.EmptyBidirectionalOneToOneMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class VerticallyMergedClasses
implements MergedClasses {
    private final BidirectionalManyToOneMap<DexType, DexType> mergedClasses;
    private final BidirectionalManyToOneMap<DexType, DexType> mergedInterfaces;

    public VerticallyMergedClasses(BidirectionalManyToOneMap<DexType, DexType> mergedClasses, BidirectionalManyToOneMap<DexType, DexType> mergedInterfaces) {
        this.mergedClasses = mergedClasses;
        this.mergedInterfaces = mergedInterfaces;
    }

    public static VerticallyMergedClasses empty() {
        EmptyBidirectionalOneToOneMap<DexType, DexType> emptyMap = new EmptyBidirectionalOneToOneMap<DexType, DexType>();
        return new VerticallyMergedClasses(emptyMap, emptyMap);
    }

    @Override
    public void forEachMergeGroup(BiConsumer<Set<DexType>, DexType> consumer) {
        this.mergedClasses.forEachManyToOneMapping(consumer);
    }

    public Map<DexType, DexType> getForwardMap() {
        return this.mergedClasses.getForwardMap();
    }

    public Collection<DexType> getSourcesFor(DexType type) {
        return this.mergedClasses.getKeys(type);
    }

    public DexType getTargetFor(DexType type) {
        assert (this.mergedClasses.containsKey(type));
        return this.mergedClasses.get(type);
    }

    public DexType getTargetForOrDefault(DexType type, DexType defaultValue) {
        return this.mergedClasses.getOrDefault(type, defaultValue);
    }

    public boolean hasBeenMergedIntoSubtype(DexType type) {
        return this.mergedClasses.containsKey(type);
    }

    public boolean hasInterfaceBeenMergedIntoSubtype(DexType type) {
        return this.mergedInterfaces.containsKey(type);
    }

    public boolean isEmpty() {
        return this.mergedClasses.isEmpty();
    }

    @Override
    public boolean isMergeTarget(DexType type) {
        return !this.getSourcesFor(type).isEmpty();
    }

    @Override
    public boolean hasBeenMergedIntoDifferentType(DexType type) {
        return this.hasBeenMergedIntoSubtype(type);
    }

    @Override
    public boolean verifyAllSourcesPruned(AppView<AppInfoWithLiveness> appView) {
        for (DexType source : this.mergedClasses.keySet()) {
            assert (appView.appInfo().wasPruned(source)) : "Expected vertically merged class `" + source.toSourceString() + "` to be absent";
        }
        return true;
    }
}

