/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph.proto;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.proto.ArgumentInfo;
import com.android.tools.r8.graph.proto.ArgumentPermutation;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfoFixer;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntCollection;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntLists;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSortedSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.IntObjConsumer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

public class ArgumentInfoCollection {
    private static final Int2ObjectRBTreeMap<ArgumentInfo> EMPTY_MAP = new Int2ObjectRBTreeMap();
    private static final ArgumentInfoCollection EMPTY = new ArgumentInfoCollection();
    private final Int2ObjectSortedMap<ArgumentInfo> argumentInfos;
    private final int argumentInfosSize;
    private final ArgumentPermutation argumentPermutation;
    private final boolean isConvertedToStaticMethod;

    private ArgumentInfoCollection() {
        this.argumentInfos = EMPTY_MAP;
        this.argumentInfosSize = -1;
        this.argumentPermutation = ArgumentPermutation.getDefault();
        this.isConvertedToStaticMethod = false;
    }

    private ArgumentInfoCollection(Int2ObjectSortedMap<ArgumentInfo> argumentInfos, int argumentInfosSize, ArgumentPermutation argumentPermutation, boolean isConvertedToStaticMethod) {
        assert (argumentInfos != null);
        assert (argumentPermutation != null);
        assert (!argumentInfos.isEmpty() || argumentInfos == EMPTY_MAP);
        assert (!argumentInfos.isEmpty() || !argumentPermutation.isDefault() || isConvertedToStaticMethod) : "should use empty.";
        assert (argumentInfosSize >= 0);
        this.argumentInfos = argumentInfos;
        this.argumentInfosSize = argumentInfosSize;
        this.argumentPermutation = argumentPermutation;
        this.isConvertedToStaticMethod = isConvertedToStaticMethod;
    }

    public static ArgumentInfoCollection empty() {
        return EMPTY;
    }

    private static int getNumberOfRemovedArgumentsBefore(int index, Int2ObjectSortedMap<ArgumentInfo> argumentInfos) {
        int removed = 0;
        for (Int2ObjectMap.Entry entry : argumentInfos.int2ObjectEntrySet()) {
            int argumentIndex = entry.getIntKey();
            ArgumentInfo argumentInfo = (ArgumentInfo)entry.getValue();
            if (argumentIndex >= index) {
                assert (argumentIndex > index || !argumentInfo.isRemovedArgumentInfo());
                break;
            }
            if (!argumentInfo.isRemovedArgumentInfo()) continue;
            ++removed;
        }
        return removed;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static Int2ObjectMap.Entry<ArgumentInfo> peekNext(ObjectBidirectionalIterator<Int2ObjectMap.Entry<ArgumentInfo>> iterator2) {
        if (iterator2.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator2.next();
            iterator2.previous();
            return entry;
        }
        return null;
    }

    public void forEach(IntObjConsumer<ArgumentInfo> consumer) {
        for (Int2ObjectMap.Entry entry : this.argumentInfos.int2ObjectEntrySet()) {
            consumer.accept(entry.getIntKey(), (ArgumentInfo)entry.getValue());
        }
    }

    public IntSortedSet getKeys() {
        return this.argumentInfos.keySet();
    }

    public IntCollection getRemovedParameterIndices() {
        int numberOfRemovedArguments = this.numberOfRemovedArguments();
        if (numberOfRemovedArguments == 0) {
            return IntLists.EMPTY_LIST;
        }
        if (numberOfRemovedArguments == this.argumentInfos.size()) {
            return this.getKeys();
        }
        IntArrayList removedParameterIndices = new IntArrayList(numberOfRemovedArguments);
        Iterator<Int2ObjectMap.Entry<ArgumentInfo>> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            Int2ObjectMap.Entry<ArgumentInfo> entry = iterator2.next();
            if (!((ArgumentInfo)entry.getValue()).isRemovedArgumentInfo()) continue;
            removedParameterIndices.add(entry.getIntKey());
        }
        return removedParameterIndices;
    }

    public boolean isArgumentRemoved(int argumentIndex) {
        return this.getArgumentInfo(argumentIndex).isRemovedArgumentInfo();
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public Iterator<Int2ObjectMap.Entry<ArgumentInfo>> iterator() {
        return this.argumentInfos.int2ObjectEntrySet().iterator();
    }

    public boolean hasRemovedArguments() {
        for (ArgumentInfo value : this.argumentInfos.values()) {
            if (!value.isRemovedArgumentInfo()) continue;
            return true;
        }
        return false;
    }

    public int numberOfRemovedArguments() {
        return ArgumentInfoCollection.getNumberOfRemovedArgumentsBefore(Integer.MAX_VALUE, this.argumentInfos);
    }

    public int getNumberOfRemovedArgumentsBefore(int index) {
        return ArgumentInfoCollection.getNumberOfRemovedArgumentsBefore(index, this.argumentInfos);
    }

    public int numberOfRemovedNonReceiverArguments(ProgramMethod method) {
        return this.numberOfRemovedArguments() - BooleanUtils.intValue(((DexEncodedMethod)method.getDefinition()).isInstance() && this.isArgumentRemoved(0));
    }

    public boolean hasArgumentInfo(int argumentIndex) {
        return this.argumentInfos.containsKey(argumentIndex);
    }

    public boolean hasArgumentPermutation() {
        return !this.argumentPermutation.isDefault();
    }

    public ArgumentInfo getArgumentInfo(int argumentIndex) {
        return this.argumentInfos.getOrDefault(argumentIndex, ArgumentInfo.NO_INFO);
    }

    public int getNewArgumentIndex(int argumentIndex) {
        return this.getNewArgumentIndex(argumentIndex, this.getNumberOfRemovedArgumentsBefore(argumentIndex));
    }

    public int getNewArgumentIndex(int argumentIndex, int numberOfRemovedArgumentsBefore) {
        int intermediateArgumentIndex = argumentIndex - numberOfRemovedArgumentsBefore;
        return this.argumentPermutation.getNewArgumentIndex(intermediateArgumentIndex);
    }

    public boolean isConvertedToStaticMethod() {
        return this.isConvertedToStaticMethod;
    }

    public int size() {
        assert (!this.isEmpty());
        return this.argumentInfosSize;
    }

    public ArgumentInfoCollection rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens graphLens, GraphLens codeLens) {
        if (this.isEmpty()) {
            return this;
        }
        Builder builder = ArgumentInfoCollection.builder();
        this.forEach((argumentIndex, argumentInfo) -> {
            ArgumentInfo rewrittenArgumentInfo = argumentInfo.rewrittenWithLens(appView, graphLens, codeLens);
            if (rewrittenArgumentInfo != argumentInfo) {
                builder.addArgumentInfo(argumentIndex, rewrittenArgumentInfo);
            }
        });
        if (!builder.isEmpty()) {
            this.forEach((argumentIndex, argumentInfo) -> {
                if (!builder.hasArgumentInfo(argumentIndex)) {
                    builder.addArgumentInfo(argumentIndex, (ArgumentInfo)argumentInfo);
                }
            });
            return builder.setArgumentInfosSize(this.argumentInfosSize).setIsConvertedToStaticMethod(this.isConvertedToStaticMethod()).build();
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArgumentInfoCollection other = (ArgumentInfoCollection)obj;
        return this.argumentInfos.equals(other.argumentInfos) && this.argumentPermutation.equals(other.argumentPermutation) && this.argumentInfosSize == other.argumentInfosSize && this.isConvertedToStaticMethod == other.isConvertedToStaticMethod;
    }

    public int hashCode() {
        return Objects.hash(this.argumentInfos, this.argumentPermutation, this.argumentInfosSize, this.isConvertedToStaticMethod);
    }

    /*
     * WARNING - void declaration
     */
    public ArgumentInfoCollection combine(ArgumentInfoCollection other) {
        void var6_8;
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        Builder builder = ArgumentInfoCollection.builder().addArgumentInfos(this);
        ObjectBidirectionalIterator<Int2ObjectMap.Entry<ArgumentInfo>> iterator2 = this.argumentInfos.int2ObjectEntrySet().iterator();
        int offset = 0;
        for (Int2ObjectMap.Entry entry : other.argumentInfos.int2ObjectEntrySet()) {
            int pendingArgumentIndex = entry.getIntKey();
            ArgumentInfo pendingArgumentInfo = (ArgumentInfo)entry.getValue();
            Int2ObjectMap.Entry<ArgumentInfo> nextCommittedEntry = ArgumentInfoCollection.peekNext(iterator2);
            while (nextCommittedEntry != null && nextCommittedEntry.getIntKey() <= pendingArgumentIndex + offset) {
                Int2ObjectMap.Entry committedEntry = (Int2ObjectMap.Entry)iterator2.next();
                ArgumentInfo committedArgumentInfo = (ArgumentInfo)committedEntry.getValue();
                if (committedArgumentInfo.isRemovedArgumentInfo()) {
                    ++offset;
                }
                nextCommittedEntry = ArgumentInfoCollection.peekNext(iterator2);
            }
            if (nextCommittedEntry != null && nextCommittedEntry.getIntKey() == pendingArgumentIndex + offset) {
                ArgumentInfo committedArgumentInfo = (ArgumentInfo)nextCommittedEntry.getValue();
                assert (!committedArgumentInfo.isRemovedArgumentInfo());
                pendingArgumentInfo = committedArgumentInfo.combine(pendingArgumentInfo);
            }
            builder.addArgumentInfo(pendingArgumentIndex + offset, pendingArgumentInfo);
        }
        ArgumentPermutation.Builder argumentPermutationBuilder = ArgumentPermutation.builder(this.argumentInfosSize);
        boolean bl = false;
        while (var6_8 < this.argumentInfosSize) {
            void defaultNewArgumentIndex;
            int newArgumentIndex;
            int intermediateArgumentIndex;
            if (!this.isArgumentRemoved((int)var6_8) && !other.isArgumentRemoved(intermediateArgumentIndex = this.getNewArgumentIndex((int)var6_8)) && (newArgumentIndex = other.getNewArgumentIndex(intermediateArgumentIndex)) != (defaultNewArgumentIndex = var6_8 - builder.getNumberOfRemovedArgumentsBefore((int)var6_8))) {
                argumentPermutationBuilder.setNewArgumentIndex((int)var6_8, newArgumentIndex);
            }
            ++var6_8;
        }
        assert (BooleanUtils.intValue(this.isConvertedToStaticMethod()) + BooleanUtils.intValue(other.isConvertedToStaticMethod()) <= 1);
        return builder.setArgumentInfosSize(this.argumentInfosSize).setArgumentPermutation(argumentPermutationBuilder.build()).setIsConvertedToStaticMethod(this.isConvertedToStaticMethod() || other.isConvertedToStaticMethod()).build();
    }

    public MethodOptimizationInfoFixer createMethodOptimizationInfoFixer() {
        RewrittenPrototypeDescription prototypeChanges = RewrittenPrototypeDescription.create(Collections.emptyList(), null, this);
        return prototypeChanges.createMethodOptimizationInfoFixer();
    }

    public Consumer<DexEncodedMethod.Builder> createParameterAnnotationsRemover(DexEncodedMethod method) {
        return builder -> builder.rewriteParameterAnnotations(method, this);
    }

    public static class Builder {
        private Int2ObjectSortedMap<ArgumentInfo> argumentInfos = new Int2ObjectRBTreeMap<ArgumentInfo>();
        private int argumentInfosSize = -1;
        private ArgumentPermutation argumentPermutation = ArgumentPermutation.getDefault();
        private boolean isConvertedToStaticMethod;

        public Builder addArgumentInfo(int argumentIndex, ArgumentInfo argInfo) {
            this.argumentInfos.put(argumentIndex, argInfo);
            return this;
        }

        public Builder addArgumentInfos(ArgumentInfoCollection argumentInfoCollection) {
            argumentInfoCollection.forEach(this::addArgumentInfo);
            return this;
        }

        public int getNumberOfRemovedArgumentsBefore(int index) {
            return ArgumentInfoCollection.getNumberOfRemovedArgumentsBefore(index, this.argumentInfos);
        }

        public boolean hasArgumentInfo(int argumentIndex) {
            return this.argumentInfos.containsKey(argumentIndex);
        }

        public boolean isEmpty() {
            return this.argumentInfos.isEmpty() && this.argumentPermutation.isDefault() && !this.isConvertedToStaticMethod;
        }

        public Builder setArgumentInfosSize(int argumentInfosSize) {
            this.argumentInfosSize = argumentInfosSize;
            return this;
        }

        public Builder setArgumentPermutation(ArgumentPermutation argumentPermutation) {
            this.argumentPermutation = argumentPermutation;
            return this;
        }

        public Builder setIsConvertedToStaticMethod() {
            return this.setIsConvertedToStaticMethod(true);
        }

        public Builder setIsConvertedToStaticMethod(boolean isConvertedToStaticMethod) {
            this.isConvertedToStaticMethod = isConvertedToStaticMethod;
            return this;
        }

        public ArgumentInfoCollection build() {
            if (this.isEmpty()) {
                return ArgumentInfoCollection.empty();
            }
            Int2ObjectSortedMap<Object> argumentInfosOrEmpty = this.argumentInfos.isEmpty() ? EMPTY_MAP : this.argumentInfos;
            return new ArgumentInfoCollection(argumentInfosOrEmpty, this.argumentInfosSize, this.argumentPermutation, this.isConvertedToStaticMethod);
        }
    }
}

