/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph.proto;

import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.RewrittenPrototypeDescriptionMethodOptimizationInfoFixer;
import com.android.tools.r8.graph.proto.ArgumentInfo;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.graph.proto.RewrittenTypeInfo;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.TypeAndLocalInfoSupplier;
import com.android.tools.r8.ir.conversion.ExtraParameter;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfoFixer;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class RewrittenPrototypeDescription {
    private static final RewrittenPrototypeDescription NONE = new RewrittenPrototypeDescription();
    private final List<ExtraParameter> extraParameters;
    private final ArgumentInfoCollection argumentInfoCollection;
    private final RewrittenTypeInfo rewrittenReturnInfo;

    private RewrittenPrototypeDescription() {
        this.extraParameters = Collections.emptyList();
        this.rewrittenReturnInfo = null;
        this.argumentInfoCollection = ArgumentInfoCollection.empty();
    }

    private RewrittenPrototypeDescription(List<ExtraParameter> extraParameters, RewrittenTypeInfo rewrittenReturnInfo, ArgumentInfoCollection argumentsInfo) {
        assert (argumentsInfo != null);
        this.extraParameters = extraParameters;
        this.rewrittenReturnInfo = rewrittenReturnInfo;
        this.argumentInfoCollection = argumentsInfo;
        assert (!this.isEmpty());
    }

    public static RewrittenPrototypeDescription create(List<ExtraParameter> extraParameters, RewrittenTypeInfo rewrittenReturnInfo, ArgumentInfoCollection argumentsInfo) {
        return extraParameters.isEmpty() && rewrittenReturnInfo == null && argumentsInfo.isEmpty() ? RewrittenPrototypeDescription.none() : new RewrittenPrototypeDescription(extraParameters, rewrittenReturnInfo, argumentsInfo);
    }

    public static RewrittenPrototypeDescription createForRewrittenTypes(RewrittenTypeInfo returnInfo, ArgumentInfoCollection rewrittenArgumentsInfo) {
        return RewrittenPrototypeDescription.create(Collections.emptyList(), returnInfo, rewrittenArgumentsInfo);
    }

    public static RewrittenPrototypeDescription none() {
        return NONE;
    }

    public Consumer<DexEncodedMethod.Builder> createParameterAnnotationsRemover(DexEncodedMethod method) {
        return this.getArgumentInfoCollection().createParameterAnnotationsRemover(method);
    }

    public MethodOptimizationInfoFixer createMethodOptimizationInfoFixer() {
        return new RewrittenPrototypeDescriptionMethodOptimizationInfoFixer(this);
    }

    public RewrittenPrototypeDescription combine(RewrittenPrototypeDescription other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        ImmutableCollection newExtraParameters = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.getExtraParameters())).addAll(other.getExtraParameters())).build();
        RewrittenTypeInfo newRewrittenTypeInfo = this.hasRewrittenReturnInfo() ? this.getRewrittenReturnInfo().combine(other) : other.getRewrittenReturnInfo();
        ArgumentInfoCollection newArgumentInfoCollection = this.getArgumentInfoCollection().combine(other.getArgumentInfoCollection());
        return new RewrittenPrototypeDescription((List<ExtraParameter>)((Object)newExtraParameters), newRewrittenTypeInfo, newArgumentInfoCollection);
    }

    public boolean isEmpty() {
        return this.extraParameters.isEmpty() && this.rewrittenReturnInfo == null && this.argumentInfoCollection.isEmpty();
    }

    public boolean hasExtraParameters() {
        return !this.extraParameters.isEmpty();
    }

    public List<ExtraParameter> getExtraParameters() {
        return this.extraParameters;
    }

    public int numberOfExtraParameters() {
        return this.extraParameters.size();
    }

    public boolean hasBeenChangedToReturnVoid() {
        return this.rewrittenReturnInfo != null && this.rewrittenReturnInfo.hasBeenChangedToReturnVoid();
    }

    public ArgumentInfoCollection getArgumentInfoCollection() {
        return this.argumentInfoCollection;
    }

    public boolean hasRewrittenReturnInfo() {
        return this.rewrittenReturnInfo != null;
    }

    public boolean requiresRewritingAtCallSite() {
        return this.hasRewrittenReturnInfo() || this.numberOfExtraParameters() > 0 || this.argumentInfoCollection.hasArgumentPermutation() || this.argumentInfoCollection.numberOfRemovedArguments() > 0;
    }

    public RewrittenTypeInfo getRewrittenReturnInfo() {
        return this.rewrittenReturnInfo;
    }

    public Instruction getConstantReturn(AppView<AppInfoWithLiveness> appView, IRCode code, Position position, TypeAndLocalInfoSupplier info) {
        assert (this.rewrittenReturnInfo != null);
        assert (this.rewrittenReturnInfo.hasSingleValue());
        Instruction instruction = this.rewrittenReturnInfo.getSingleValue().createMaterializingInstruction(appView, code, info);
        instruction.setPosition(position);
        return instruction;
    }

    public boolean verifyConstantReturnAccessibleInContext(AppView<AppInfoWithLiveness> appView, ProgramMethod method, GraphLens codeLens) {
        AbstractValue rewrittenSingleValue = this.rewrittenReturnInfo.getSingleValue().rewrittenWithLens((AppView)appView, appView.graphLens(), codeLens);
        assert (((SingleValue)rewrittenSingleValue).isMaterializableInContext(appView, method));
        return true;
    }

    public DexMethod rewriteMethod(ProgramMethod method, DexItemFactory dexItemFactory) {
        if (this.isEmpty()) {
            return (DexMethod)method.getReference();
        }
        DexProto rewrittenProto = this.rewriteProto(method, dexItemFactory);
        return ((DexMethod)method.getReference()).withProto(rewrittenProto, dexItemFactory);
    }

    public DexProto rewriteProto(ProgramMethod method, DexItemFactory dexItemFactory) {
        if (this.isEmpty()) {
            return method.getProto();
        }
        DexType newReturnType = this.rewrittenReturnInfo != null ? this.rewrittenReturnInfo.getNewType() : method.getReturnType();
        DexType[] newParameters = this.rewriteParameters(method, dexItemFactory);
        return dexItemFactory.createProto(newReturnType, newParameters);
    }

    public DexType[] rewriteParameters(ProgramMethod method, DexItemFactory dexItemFactory) {
        DexType[] params = method.getParameters().values;
        if (this.isEmpty()) {
            return params;
        }
        DexType[] newParams = new DexType[params.length - this.argumentInfoCollection.numberOfRemovedNonReceiverArguments(method) + this.extraParameters.size()];
        int offset = ((DexEncodedMethod)method.getDefinition()).getFirstNonReceiverArgumentIndex();
        int newParamIndex = 0;
        for (int oldParamIndex = 0; oldParamIndex < params.length; ++oldParamIndex) {
            ArgumentInfo argInfo = this.argumentInfoCollection.getArgumentInfo(oldParamIndex + offset);
            if (argInfo.isNone()) {
                newParams[newParamIndex++] = params[oldParamIndex];
                continue;
            }
            if (!argInfo.isRewrittenTypeInfo()) continue;
            RewrittenTypeInfo rewrittenTypeInfo = argInfo.asRewrittenTypeInfo();
            assert (params[oldParamIndex] == rewrittenTypeInfo.getOldType());
            newParams[newParamIndex++] = rewrittenTypeInfo.getNewType();
        }
        for (ExtraParameter extraParameter : this.extraParameters) {
            newParams[newParamIndex++] = extraParameter.getType(dexItemFactory);
        }
        return newParams;
    }

    public RewrittenPrototypeDescription rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens graphLens, GraphLens codeLens) {
        ArgumentInfo newRewrittenReturnInfo;
        ArgumentInfoCollection newArgumentInfoCollection = this.argumentInfoCollection.rewrittenWithLens(appView, graphLens, codeLens);
        ArgumentInfo argumentInfo = newRewrittenReturnInfo = this.hasRewrittenReturnInfo() ? this.rewrittenReturnInfo.rewrittenWithLens((AppView)appView, graphLens, codeLens) : null;
        if (newArgumentInfoCollection != this.argumentInfoCollection || newRewrittenReturnInfo != this.rewrittenReturnInfo) {
            return new RewrittenPrototypeDescription(this.extraParameters, (RewrittenTypeInfo)newRewrittenReturnInfo, newArgumentInfoCollection);
        }
        return this;
    }

    public RewrittenPrototypeDescription withRewrittenReturnInfo(RewrittenTypeInfo newRewrittenReturnInfo) {
        if (Objects.equals(this.rewrittenReturnInfo, newRewrittenReturnInfo)) {
            return this;
        }
        return new RewrittenPrototypeDescription(this.extraParameters, newRewrittenReturnInfo, this.argumentInfoCollection);
    }

    public RewrittenPrototypeDescription withExtraParameters(ExtraParameter ... parameters) {
        return this.withExtraParameters(Arrays.asList(parameters));
    }

    public RewrittenPrototypeDescription withExtraParameters(List<? extends ExtraParameter> parameters) {
        if (parameters.isEmpty()) {
            return this;
        }
        ArrayList<ExtraParameter> newExtraParameters = new ArrayList<ExtraParameter>(this.extraParameters.size() + parameters.size());
        newExtraParameters.addAll(this.extraParameters);
        newExtraParameters.addAll(parameters);
        return new RewrittenPrototypeDescription(newExtraParameters, this.rewrittenReturnInfo, this.argumentInfoCollection);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RewrittenPrototypeDescription other = (RewrittenPrototypeDescription)obj;
        return this.extraParameters.equals(other.extraParameters) && Objects.equals(this.rewrittenReturnInfo, other.rewrittenReturnInfo) && this.argumentInfoCollection.equals(other.argumentInfoCollection);
    }

    public int hashCode() {
        return Objects.hash(this.extraParameters, this.rewrittenReturnInfo, this.argumentInfoCollection);
    }
}

