/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeUtils;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMergerGraphLens;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.policies.SameInstanceFields;
import com.android.tools.r8.utils.IterableUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public interface ClassInstanceFieldsMerger {
    public static ClassInstanceFieldsMerger create(AppView<?> appView, HorizontalClassMergerGraphLens.Builder lensBuilder, MergeGroup group) {
        if (appView.hasClassHierarchy()) {
            return new ClassInstanceFieldsMergerImpl(appView.withClassHierarchy(), lensBuilder, group);
        }
        if (!2.$assertionsDisabled && !group.getInstanceFieldMap().isEmpty()) {
            throw new AssertionError();
        }
        appView.options().horizontalClassMergerOptions().isRestrictedToSynthetics();
        return new ClassInstanceFieldsMerger(){

            @Override
            public void setClassIdField(DexEncodedField classIdField) {
                throw new UnsupportedOperationException("No instance field merging in D8");
            }

            @Override
            public DexEncodedField[] merge() {
                return DexEncodedField.EMPTY_ARRAY;
            }
        };
    }

    public static void mapFields(AppView<? extends AppInfoWithClassHierarchy> appView, DexProgramClass source, DexProgramClass target, BiConsumer<DexEncodedField, DexEncodedField> consumer) {
        Map<SameInstanceFields.InstanceFieldInfo, LinkedList<DexEncodedField>> availableFieldsByExactInfo = ClassInstanceFieldsMerger.getAvailableFieldsByExactInfo(target);
        ArrayList<DexEncodedField> needsMerge = new ArrayList<DexEncodedField>();
        for (DexEncodedField oldField : source.instanceFields()) {
            SameInstanceFields.InstanceFieldInfo info = SameInstanceFields.InstanceFieldInfo.createExact(oldField);
            LinkedList<DexEncodedField> availableFieldsWithExactSameInfo = availableFieldsByExactInfo.get(info);
            if (availableFieldsWithExactSameInfo == null || availableFieldsWithExactSameInfo.isEmpty()) {
                needsMerge.add(oldField);
                continue;
            }
            DexEncodedField newField = availableFieldsWithExactSameInfo.removeFirst();
            consumer.accept(oldField, newField);
            if (!availableFieldsWithExactSameInfo.isEmpty()) continue;
            availableFieldsByExactInfo.remove(info);
        }
        Map<SameInstanceFields.InstanceFieldInfo, LinkedList<DexEncodedField>> availableFieldsByRelaxedInfo = ClassInstanceFieldsMerger.getAvailableFieldsByRelaxedInfo(appView, availableFieldsByExactInfo);
        for (DexEncodedField oldField : needsMerge) {
            if (!2.$assertionsDisabled && !oldField.getType().isReferenceType()) {
                throw new AssertionError();
            }
            DexEncodedField newField = availableFieldsByRelaxedInfo.get(SameInstanceFields.InstanceFieldInfo.createRelaxed(oldField, appView.dexItemFactory())).removeFirst();
            if (!2.$assertionsDisabled && newField == null) {
                throw new AssertionError();
            }
            if (!2.$assertionsDisabled && !newField.getType().isReferenceType()) {
                throw new AssertionError();
            }
            consumer.accept(oldField, newField);
        }
    }

    public static Map<SameInstanceFields.InstanceFieldInfo, LinkedList<DexEncodedField>> getAvailableFieldsByExactInfo(DexProgramClass target) {
        LinkedHashMap<SameInstanceFields.InstanceFieldInfo, LinkedList<DexEncodedField>> availableFieldsByInfo = new LinkedHashMap<SameInstanceFields.InstanceFieldInfo, LinkedList<DexEncodedField>>();
        for (DexEncodedField field : target.instanceFields()) {
            availableFieldsByInfo.computeIfAbsent(SameInstanceFields.InstanceFieldInfo.createExact(field), ignore -> new LinkedList()).add(field);
        }
        return availableFieldsByInfo;
    }

    public static Map<SameInstanceFields.InstanceFieldInfo, LinkedList<DexEncodedField>> getAvailableFieldsByRelaxedInfo(AppView<? extends AppInfoWithClassHierarchy> appView, Map<SameInstanceFields.InstanceFieldInfo, LinkedList<DexEncodedField>> availableFieldsByExactInfo) {
        LinkedHashMap<SameInstanceFields.InstanceFieldInfo, LinkedList<DexEncodedField>> availableFieldsByRelaxedInfo = new LinkedHashMap<SameInstanceFields.InstanceFieldInfo, LinkedList<DexEncodedField>>();
        availableFieldsByExactInfo.forEach((info, fields) -> availableFieldsByRelaxedInfo.computeIfAbsent(info.toInfoWithRelaxedType(appView.dexItemFactory()), ignore -> new LinkedList()).addAll(fields));
        return availableFieldsByRelaxedInfo;
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }

    public void setClassIdField(DexEncodedField var1);

    public DexEncodedField[] merge();

    public static class ClassInstanceFieldsMergerImpl
    implements ClassInstanceFieldsMerger {
        private final AppView<? extends AppInfoWithClassHierarchy> appView;
        private final MergeGroup group;
        private final HorizontalClassMergerGraphLens.Builder lensBuilder;
        private DexEncodedField classIdField;

        private ClassInstanceFieldsMergerImpl(AppView<? extends AppInfoWithClassHierarchy> appView, HorizontalClassMergerGraphLens.Builder lensBuilder, MergeGroup group) {
            this.appView = appView;
            this.group = group;
            this.lensBuilder = lensBuilder;
        }

        private DexEncodedField mergeSourceFieldsToTargetField(DexEncodedField targetField, Set<DexEncodedField> sourceFields) {
            DexEncodedField newField;
            this.fixAccessFlags(targetField, sourceFields);
            if (this.needsRelaxedType(targetField, sourceFields)) {
                DexType newFieldType = DexTypeUtils.computeLeastUpperBound(this.appView, Iterables.transform(Iterables.concat(IterableUtils.singleton(targetField), sourceFields), DexEncodedField::getType));
                newField = targetField.toTypeSubstitutedField(this.appView, ((DexField)targetField.getReference()).withType(newFieldType, this.appView.dexItemFactory()));
            } else {
                newField = targetField;
            }
            this.lensBuilder.recordNewFieldSignature(Iterables.transform(IterableUtils.append(sourceFields, targetField), DexEncodedMember::getReference), (DexField)newField.getReference(), (DexField)targetField.getReference());
            return newField;
        }

        private void fixAccessFlags(DexEncodedField newField, Collection<DexEncodedField> oldFields) {
            if (newField.isSynthetic() && Iterables.any(oldFields, oldField -> !oldField.isSynthetic())) {
                newField.getAccessFlags().demoteFromSynthetic();
            }
            if (newField.isFinal() && Iterables.any(oldFields, oldField -> !oldField.isFinal())) {
                newField.getAccessFlags().demoteFromFinal();
            }
        }

        private boolean needsRelaxedType(DexEncodedField targetField, Iterable<DexEncodedField> sourceFields) {
            return Iterables.any(sourceFields, sourceField -> sourceField.getType() != targetField.getType());
        }

        @Override
        public void setClassIdField(DexEncodedField classIdField) {
            this.classIdField = classIdField;
        }

        @Override
        public DexEncodedField[] merge() {
            assert (this.group.hasInstanceFieldMap());
            ArrayList<DexEncodedField> newFields = new ArrayList<DexEncodedField>();
            if (this.classIdField != null) {
                newFields.add(this.classIdField);
            }
            this.group.getInstanceFieldMap().forEachManyToOneMapping((sourceFields, targetField) -> newFields.add(this.mergeSourceFieldsToTargetField((DexEncodedField)targetField, (Set<DexEncodedField>)sourceFields)));
            return newFields.toArray(DexEncodedField.EMPTY_ARRAY);
        }
    }
}

