/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMember;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.horizontalclassmerging.ClassInstanceFieldsMerger;
import com.android.tools.r8.horizontalclassmerging.ClassMethodsBuilder;
import com.android.tools.r8.horizontalclassmerging.ClassStaticFieldsMerger;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMergerGraphLens;
import com.android.tools.r8.horizontalclassmerging.IRCodeProvider;
import com.android.tools.r8.horizontalclassmerging.InstanceInitializerMergerCollection;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.SyntheticArgumentClass;
import com.android.tools.r8.horizontalclassmerging.VirtualMethodMerger;
import com.android.tools.r8.horizontalclassmerging.VirtuallyMergedMethodsKeepInfo;
import com.android.tools.r8.horizontalclassmerging.code.ClassInitializerMerger;
import com.android.tools.r8.horizontalclassmerging.code.SyntheticInitializerConverter;
import com.android.tools.r8.ir.analysis.value.NumberFromIntervalValue;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.utils.SetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class ClassMerger {
    public static final String CLASS_ID_FIELD_NAME = "$r8$classId";
    private static final OptimizationFeedback feedback = OptimizationFeedbackSimple.getInstance();
    private final AppView<?> appView;
    private final HorizontalClassMerger.Mode mode;
    private final MergeGroup group;
    private final DexItemFactory dexItemFactory;
    private final HorizontalClassMergerGraphLens.Builder lensBuilder;
    private final ClassMethodsBuilder classMethodsBuilder = new ClassMethodsBuilder();
    private final Reference2IntMap<DexType> classIdentifiers = new Reference2IntOpenHashMap<DexType>();
    private final ClassInstanceFieldsMerger classInstanceFieldsMerger;
    private final ClassStaticFieldsMerger classStaticFieldsMerger;
    private final ClassInitializerMerger classInitializerMerger;
    private final InstanceInitializerMergerCollection instanceInitializerMergers;
    private final Collection<VirtualMethodMerger> virtualMethodMergers;

    private ClassMerger(AppView<?> appView, IRCodeProvider codeProvider, HorizontalClassMerger.Mode mode, HorizontalClassMergerGraphLens.Builder lensBuilder, MergeGroup group, Collection<VirtualMethodMerger> virtualMethodMergers) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.group = group;
        this.lensBuilder = lensBuilder;
        this.mode = mode;
        this.classStaticFieldsMerger = new ClassStaticFieldsMerger(appView, lensBuilder, group);
        this.classInstanceFieldsMerger = ClassInstanceFieldsMerger.create(appView, lensBuilder, group);
        this.classInitializerMerger = ClassInitializerMerger.create(group);
        this.instanceInitializerMergers = InstanceInitializerMergerCollection.create(appView, this.classIdentifiers, codeProvider, group, lensBuilder, mode);
        this.virtualMethodMergers = virtualMethodMergers;
        this.buildClassIdentifierMap();
    }

    private void mergeAnnotations() {
        assert (this.group.getClasses().stream().filter(DexDefinition::hasAnnotations).count() <= 1L);
        for (DexProgramClass clazz : this.group.getSources()) {
            if (!clazz.hasAnnotations()) continue;
            this.group.getTarget().setAnnotations(clazz.annotations());
            break;
        }
    }

    private void mergeInterfaces() {
        LinkedHashSet<DexType> interfaces = Sets.newLinkedHashSet();
        if (this.group.isInterfaceGroup()) {
            ImmutableSet groupTypes = SetUtils.newImmutableSet(builder -> this.group.forEach(clazz -> builder.accept(clazz.getType())));
            this.group.forEach(clazz -> {
                for (DexType itf : clazz.getInterfaces()) {
                    if (groupTypes.contains(itf)) continue;
                    interfaces.add(itf);
                }
            });
        } else {
            this.group.forEach(clazz -> Iterables.addAll(interfaces, clazz.getInterfaces()));
        }
        this.group.getTarget().setInterfaces(DexTypeList.create(interfaces));
    }

    void buildClassIdentifierMap() {
        this.classIdentifiers.put(this.group.getTarget().getType(), 0);
        this.group.forEachSource(clazz -> this.classIdentifiers.put(clazz.getType(), this.classIdentifiers.size()));
    }

    void mergeDirectMethods(SyntheticArgumentClass syntheticArgumentClass, SyntheticInitializerConverter.Builder syntheticInitializerConverterBuilder) {
        this.mergeInstanceInitializers(syntheticArgumentClass, syntheticInitializerConverterBuilder);
        this.mergeStaticClassInitializers(syntheticInitializerConverterBuilder);
        this.group.forEach(this::mergeDirectMethods);
    }

    void mergeStaticClassInitializers(SyntheticInitializerConverter.Builder syntheticInitializerConverterBuilder) {
        if (this.classInitializerMerger.isEmpty()) {
            return;
        }
        DexMethod newMethodReference = this.dexItemFactory.createClassInitializer(this.group.getTarget().getType());
        DexMethod syntheticMethodReference = newMethodReference.withName("$r8$clinit$synthetic", this.dexItemFactory);
        this.lensBuilder.recordNewMethodSignature(syntheticMethodReference, newMethodReference, true);
        ComputedApiLevel apiReferenceLevel = this.classInitializerMerger.getApiReferenceLevel(this.appView);
        DexEncodedMethod definition = DexEncodedMethod.syntheticBuilder().setMethod(newMethodReference).setAccessFlags(MethodAccessFlags.createForClassInitializer()).setCode(this.classInitializerMerger.getCode(syntheticMethodReference)).setClassFileVersion(this.classInitializerMerger.getCfVersion()).setApiLevelForDefinition(apiReferenceLevel).setApiLevelForCode(apiReferenceLevel).build();
        this.classMethodsBuilder.addDirectMethod(definition);
        if (!definition.getCode().isCfCode()) {
            assert (this.appView.options().isGeneratingDex());
            assert (this.mode.isFinal());
            syntheticInitializerConverterBuilder.addClassInitializer(new ProgramMethod(this.group.getTarget(), definition));
        }
    }

    void mergeDirectMethods(DexProgramClass toMerge) {
        toMerge.forEachProgramDirectMethod(method -> {
            DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
            if (definition.isClassInitializer()) {
                this.lensBuilder.moveMethod((DexMethod)method.getReference(), this.dexItemFactory.createClassInitializer(this.group.getTarget().getType()));
            } else if (!definition.isInstanceInitializer()) {
                DexMethod newMethod = ((DexMethod)method.getReference()).withHolder(this.group.getTarget().getType(), this.dexItemFactory);
                if (!this.classMethodsBuilder.isFresh(newMethod)) {
                    newMethod = this.renameDirectMethod((ProgramMethod)method);
                }
                this.classMethodsBuilder.addDirectMethod(definition.toTypeSubstitutedMethod(newMethod));
                if (definition.getReference() != newMethod) {
                    this.lensBuilder.moveMethod((DexMethod)definition.getReference(), newMethod);
                }
            }
        });
        toMerge.getMethodCollection().clearDirectMethods();
    }

    DexMethod renameDirectMethod(ProgramMethod method) {
        assert (((DexEncodedMethod)method.getDefinition()).belongsToDirectPool());
        return this.dexItemFactory.createFreshMethodNameWithoutHolder(method.getName().toSourceString(), method.getProto(), this.group.getTarget().getType(), this.classMethodsBuilder::isFresh);
    }

    void mergeInstanceInitializers(SyntheticArgumentClass syntheticArgumentClass, SyntheticInitializerConverter.Builder syntheticInitializerConverterBuilder) {
        this.instanceInitializerMergers.forEach(merger -> merger.merge(this.classMethodsBuilder, syntheticArgumentClass, syntheticInitializerConverterBuilder));
    }

    void mergeMethods(SyntheticArgumentClass syntheticArgumentClass, SyntheticInitializerConverter.Builder syntheticInitializerConverterBuilder, Consumer<VirtuallyMergedMethodsKeepInfo> virtuallyMergedMethodsKeepInfoConsumer) {
        this.mergeVirtualMethods(virtuallyMergedMethodsKeepInfoConsumer);
        this.mergeDirectMethods(syntheticArgumentClass, syntheticInitializerConverterBuilder);
        this.classMethodsBuilder.setClassMethods(this.group.getTarget());
    }

    void mergeVirtualMethods(Consumer<VirtuallyMergedMethodsKeepInfo> virtuallyMergedMethodsKeepInfoConsumer) {
        this.virtualMethodMergers.forEach(merger -> merger.merge(this.classMethodsBuilder, this.lensBuilder, this.classIdentifiers, virtuallyMergedMethodsKeepInfoConsumer));
        this.group.forEachSource(clazz -> clazz.getMethodCollection().clearVirtualMethods());
    }

    void appendClassIdField() {
        assert (this.appView.hasLiveness());
        assert (this.mode.isInitial());
        DexEncodedField classIdField = DexEncodedField.syntheticBuilder().setField(this.group.getClassIdField()).setAccessFlags(FieldAccessFlags.createPublicFinalSynthetic()).setApiLevel(this.appView.computedMinApiLevel()).build();
        NumberFromIntervalValue abstractValue = new NumberFromIntervalValue(0L, this.group.size() - 1);
        feedback.recordFieldHasAbstractValue(classIdField, this.appView.withLiveness(), abstractValue);
        this.classInstanceFieldsMerger.setClassIdField(classIdField);
    }

    void fixAccessFlags() {
        if (Iterables.any(this.group.getSources(), Predicates.not(DexClass::isAbstract))) {
            this.group.getTarget().getAccessFlags().demoteFromAbstract();
        }
        if (Iterables.any(this.group.getSources(), Predicates.not(DexClass::isFinal))) {
            this.group.getTarget().getAccessFlags().demoteFromFinal();
        }
    }

    void fixNestMemberAttributes() {
        if (this.group.getTarget().isInANest() && !this.group.getTarget().hasNestMemberAttributes()) {
            for (DexProgramClass clazz : this.group.getSources()) {
                if (!clazz.hasNestMemberAttributes()) continue;
                this.group.getTarget().clearNestHost();
                this.group.getTarget().setNestMemberAttributes(clazz.getNestMembersClassAttributes());
                this.group.getTarget().removeNestMemberAttributes(nestMemberAttribute -> nestMemberAttribute.getNestMember() == this.group.getTarget().getType());
                break;
            }
        }
    }

    void mergeFields(PrunedItems.Builder prunedItemsBuilder) {
        if (this.group.hasClassIdField()) {
            this.appendClassIdField();
        }
        this.mergeInstanceFields(prunedItemsBuilder);
        this.mergeStaticFields();
    }

    void mergeInstanceFields(PrunedItems.Builder prunedItemsBuilder) {
        this.group.forEachSource(clazz -> {
            clazz.forEachInstanceField(field -> prunedItemsBuilder.addRemovedField((DexField)field.getReference()));
            clazz.clearInstanceFields();
        });
        this.group.getTarget().setInstanceFields(this.classInstanceFieldsMerger.merge());
    }

    void mergeStaticFields() {
        this.group.forEachSource(this.classStaticFieldsMerger::addFields);
        this.classStaticFieldsMerger.merge();
        this.group.forEachSource(DexClass::clearStaticFields);
    }

    public void mergeGroup(PrunedItems.Builder prunedItemsBuilder, SyntheticArgumentClass syntheticArgumentClass, SyntheticInitializerConverter.Builder syntheticInitializerConverterBuilder, Consumer<VirtuallyMergedMethodsKeepInfo> virtuallyMergedMethodsKeepInfoConsumer) {
        this.fixAccessFlags();
        this.fixNestMemberAttributes();
        this.mergeAnnotations();
        this.mergeInterfaces();
        this.mergeFields(prunedItemsBuilder);
        this.mergeMethods(syntheticArgumentClass, syntheticInitializerConverterBuilder, virtuallyMergedMethodsKeepInfoConsumer);
        this.group.getTarget().clearClassSignature();
        this.group.getTarget().forEachProgramMember(ProgramMember::clearGenericSignature);
        this.group.forEachSource(clazz -> prunedItemsBuilder.addRemovedClass(clazz.getType()));
    }

    public static class Builder {
        private final AppView<?> appView;
        private final IRCodeProvider codeProvider;
        private final HorizontalClassMerger.Mode mode;
        private final MergeGroup group;

        public Builder(AppView<?> appView, IRCodeProvider codeProvider, MergeGroup group, HorizontalClassMerger.Mode mode) {
            this.appView = appView;
            this.codeProvider = codeProvider;
            this.group = group;
            this.mode = mode;
        }

        private List<VirtualMethodMerger> createVirtualMethodMergers() {
            if (!this.appView.hasClassHierarchy()) {
                assert (this.getVirtualMethodMergerBuilders().isEmpty());
                return Collections.emptyList();
            }
            Map<DexMethodSignature, VirtualMethodMerger.Builder> virtualMethodMergerBuilders = this.getVirtualMethodMergerBuilders();
            if (virtualMethodMergerBuilders.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<VirtualMethodMerger> virtualMethodMergers = new ArrayList<VirtualMethodMerger>(virtualMethodMergerBuilders.size());
            for (VirtualMethodMerger.Builder builder : virtualMethodMergerBuilders.values()) {
                virtualMethodMergers.add(builder.build(this.appView.withClassHierarchy(), this.group));
            }
            return virtualMethodMergers;
        }

        private Map<DexMethodSignature, VirtualMethodMerger.Builder> getVirtualMethodMergerBuilders() {
            LinkedHashMap<DexMethodSignature, VirtualMethodMerger.Builder> virtualMethodMergerBuilders = new LinkedHashMap<DexMethodSignature, VirtualMethodMerger.Builder>();
            this.group.forEach(clazz -> clazz.forEachProgramVirtualMethod(virtualMethod -> virtualMethodMergerBuilders.computeIfAbsent(((DexMethod)virtualMethod.getReference()).getSignature(), ignore -> new VirtualMethodMerger.Builder()).add((ProgramMethod)virtualMethod)));
            return virtualMethodMergerBuilders;
        }

        private void createClassIdField() {
            DexItemFactory dexItemFactory = this.appView.dexItemFactory();
            this.group.setClassIdField(dexItemFactory.createField(this.group.getTarget().getType(), dexItemFactory.intType, ClassMerger.CLASS_ID_FIELD_NAME));
        }

        public ClassMerger build(HorizontalClassMergerGraphLens.Builder lensBuilder) {
            List<VirtualMethodMerger> virtualMethodMergers = this.createVirtualMethodMergers();
            boolean requiresClassIdField = virtualMethodMergers.stream().anyMatch(virtualMethodMerger -> !virtualMethodMerger.isNopOrTrivial());
            if (requiresClassIdField) {
                assert (this.mode.isInitial());
                this.createClassIdField();
            }
            return new ClassMerger(this.appView, this.codeProvider, this.mode, lensBuilder, this.group, virtualMethodMergers);
        }
    }
}

