/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ClassMethodsBuilder {
    private Set<DexMethod> reservedMethods = Sets.newIdentityHashSet();
    private List<DexEncodedMethod> virtualMethods = new ArrayList<DexEncodedMethod>();
    private List<DexEncodedMethod> directMethods = new ArrayList<DexEncodedMethod>();

    public void addVirtualMethod(DexEncodedMethod virtualMethod) {
        this.virtualMethods.add(virtualMethod);
        boolean added = this.reservedMethods.add((DexMethod)virtualMethod.getReference());
        assert (added);
    }

    public void addDirectMethod(DexEncodedMethod directMethod) {
        this.directMethods.add(directMethod);
        boolean added = this.reservedMethods.add((DexMethod)directMethod.getReference());
        assert (added);
    }

    public boolean isFresh(DexMethod method) {
        return !this.reservedMethods.contains(method);
    }

    public void setClassMethods(DexProgramClass clazz) {
        assert (this.virtualMethods.stream().allMatch(method -> method.getHolderType() == clazz.type));
        assert (this.virtualMethods.stream().allMatch(DexEncodedMethod::belongsToVirtualPool));
        assert (this.directMethods.stream().allMatch(method -> method.getHolderType() == clazz.type));
        assert (this.directMethods.stream().allMatch(DexEncodedMethod::belongsToDirectPool));
        clazz.setVirtualMethods(this.virtualMethods);
        clazz.setDirectMethods(this.directMethods);
    }
}

