/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.classmerging.MergedClasses;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneHashMap;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneMap;
import com.android.tools.r8.utils.collections.EmptyBidirectionalOneToOneMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalManyToOneMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class HorizontallyMergedClasses
implements MergedClasses {
    private final BidirectionalManyToOneMap<DexType, DexType> mergedClasses;

    public HorizontallyMergedClasses(BidirectionalManyToOneMap<DexType, DexType> mergedClasses) {
        this.mergedClasses = mergedClasses;
    }

    static Builder builder() {
        return new Builder();
    }

    public static HorizontallyMergedClasses empty() {
        return new HorizontallyMergedClasses(new EmptyBidirectionalOneToOneMap<DexType, DexType>());
    }

    public HorizontallyMergedClasses extend(HorizontallyMergedClasses newHorizontallyMergedClasses) {
        if (this.isEmpty()) {
            return newHorizontallyMergedClasses;
        }
        if (newHorizontallyMergedClasses.isEmpty()) {
            return this;
        }
        Builder builder = HorizontallyMergedClasses.builder();
        this.forEachMergeGroup((sources, target) -> {
            DexType rewrittenTarget = newHorizontallyMergedClasses.getMergeTargetOrDefault((DexType)target);
            sources.forEach(source -> builder.add((DexType)source, rewrittenTarget));
        });
        newHorizontallyMergedClasses.forEachMergeGroup((sources, target) -> sources.forEach(source -> builder.add((DexType)source, (DexType)target)));
        return builder.build();
    }

    @Override
    public void forEachMergeGroup(BiConsumer<Set<DexType>, DexType> consumer) {
        this.mergedClasses.forEachManyToOneMapping(consumer);
    }

    public DexType getMergeTargetOrDefault(DexType type) {
        return this.mergedClasses.getOrDefault(type, type);
    }

    public Set<DexType> getSources() {
        return this.mergedClasses.keySet();
    }

    public Set<DexType> getSourcesFor(DexType type) {
        return this.mergedClasses.getKeys(type);
    }

    public Set<DexType> getTargets() {
        return this.mergedClasses.values();
    }

    @Override
    public boolean hasBeenMergedIntoDifferentType(DexType type) {
        return this.mergedClasses.containsKey(type);
    }

    public boolean isEmpty() {
        return this.mergedClasses.isEmpty();
    }

    @Override
    public boolean isMergeTarget(DexType type) {
        return this.mergedClasses.containsValue(type);
    }

    public boolean hasBeenMergedOrIsMergeTarget(DexType type) {
        return this.hasBeenMergedIntoDifferentType(type) || this.isMergeTarget(type);
    }

    Map<DexType, DexType> getForwardMap() {
        return this.mergedClasses.getForwardMap();
    }

    @Override
    public boolean verifyAllSourcesPruned(AppView<AppInfoWithLiveness> appView) {
        for (DexType source : this.mergedClasses.keySet()) {
            assert (appView.appInfo().wasPruned(source)) : "Expected horizontally merged lambda class `" + source.toSourceString() + "` to be absent";
        }
        return true;
    }

    public static class Builder {
        private final MutableBidirectionalManyToOneMap<DexType, DexType> mergedClasses = BidirectionalManyToOneHashMap.newIdentityHashMap();

        void add(DexType source, DexType target) {
            assert (!this.mergedClasses.containsKey(source));
            this.mergedClasses.put(source, target);
        }

        void addMergeGroup(MergeGroup group) {
            group.forEachSource(clazz -> this.add(clazz.getType(), group.getTarget().getType()));
        }

        Builder addMergeGroups(Iterable<MergeGroup> groups2) {
            groups2.forEach(this::addMergeGroup);
            return this;
        }

        HorizontallyMergedClasses build() {
            return new HorizontallyMergedClasses(this.mergedClasses);
        }
    }
}

