/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.IRCode;

public interface IRCodeProvider {
    public static IRCodeProvider create(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return new IRCodeProviderImpl(appView);
    }

    public static IRCodeProvider createThrowing() {
        return new IRCodeProvider(){

            @Override
            public IRCode buildIR(ProgramMethod method) {
                throw new UnsupportedOperationException("Should never build IR for methods in D8");
            }

            @Override
            public void setGraphLens(GraphLens graphLens) {
            }
        };
    }

    public IRCode buildIR(ProgramMethod var1);

    public void setGraphLens(GraphLens var1);

    public static class IRCodeProviderImpl
    implements IRCodeProvider {
        private final AppView<AppInfo> appViewForConversion;

        private IRCodeProviderImpl(AppView<? extends AppInfoWithClassHierarchy> appView) {
            AppView<AppInfo> appViewForConversion = AppView.createForD8(AppInfo.createInitialAppInfo(appView.appInfo().app()));
            appViewForConversion.setGraphLens(appView.graphLens());
            appViewForConversion.setCodeLens(appView.codeLens());
            this.appViewForConversion = appViewForConversion;
        }

        @Override
        public IRCode buildIR(ProgramMethod method) {
            return ((DexEncodedMethod)method.getDefinition()).getCode().buildIR(method, this.appViewForConversion, method.getOrigin());
        }

        @Override
        public void setGraphLens(GraphLens graphLens) {
            this.appViewForConversion.setGraphLens(graphLens);
        }
    }
}

