/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.horizontalclassmerging.IRCodeProvider;
import com.android.tools.r8.horizontalclassmerging.InstanceInitializerDescription;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfo;
import com.android.tools.r8.utils.WorkList;
import java.util.ArrayList;

public class InstanceInitializerAnalysis {
    public static InstanceInitializerDescription analyze(AppView<? extends AppInfoWithClassHierarchy> appView, IRCodeProvider codeProvider, MergeGroup group, ProgramMethod instanceInitializer) {
        InstanceInitializerDescription.Builder builder = InstanceInitializerDescription.builder(appView, instanceInitializer);
        IRCode code = codeProvider.buildIR(instanceInitializer);
        WorkList<BasicBlock> workList = WorkList.newIdentityWorkList(code.entryBlock());
        while (workList.hasNext()) {
            BasicBlock block = workList.next();
            block7: for (Instruction instruction : block.getInstructions()) {
                switch (instruction.opcode()) {
                    case 5: 
                    case 9: 
                    case 12: 
                    case 15: 
                    case 16: 
                    case 20: 
                    case 56: {
                        break;
                    }
                    case 24: {
                        if (workList.addIfNotSeen(instruction.asGoto().getTarget())) continue block7;
                        return InstanceInitializerAnalysis.invalid();
                    }
                    case 30: {
                        InstancePut instancePut = instruction.asInstancePut();
                        if (!instancePut.object().getAliasedValue().isThis()) {
                            return InstanceInitializerAnalysis.invalid();
                        }
                        DexField fieldReference = instancePut.getField();
                        DexField lensRewrittenFieldReference = appView.graphLens().lookupField(fieldReference);
                        if (lensRewrittenFieldReference.getHolderType() != instanceInitializer.getHolderType()) {
                            return InstanceInitializerAnalysis.invalid();
                        }
                        ProgramField sourceField = instanceInitializer.getHolder().lookupProgramField(lensRewrittenFieldReference);
                        if (sourceField == null) {
                            return InstanceInitializerAnalysis.invalid();
                        }
                        InstanceFieldInitializationInfo initializationInfo = InstanceInitializerAnalysis.getInitializationInfo(appView, instancePut.value());
                        if (initializationInfo == null) {
                            return InstanceInitializerAnalysis.invalid();
                        }
                        ProgramField targetField = group.getTargetInstanceField(sourceField);
                        assert (targetField != null);
                        builder.addInstancePut((DexField)targetField.getReference(), initializationInfo);
                        break;
                    }
                    case 33: {
                        InvokeDirect invoke = instruction.asInvokeDirect();
                        if (!invoke.getReceiver().getAliasedValue().isThis()) {
                            return InstanceInitializerAnalysis.invalid();
                        }
                        DexMethod invokedMethod = invoke.getInvokedMethod();
                        DexMethod lensRewrittenInvokedMethod = (DexMethod)appView.graphLens().lookupInvokeDirect(invokedMethod, instanceInitializer).getReference();
                        if (!lensRewrittenInvokedMethod.isInstanceInitializer(appView.dexItemFactory()) || lensRewrittenInvokedMethod.getHolderType() != group.getSuperType()) {
                            return InstanceInitializerAnalysis.invalid();
                        }
                        ArrayList<InstanceFieldInitializationInfo> arguments = new ArrayList<InstanceFieldInitializationInfo>(invoke.arguments().size() - 1);
                        for (Value argument : Iterables.skip(invoke.arguments(), 1)) {
                            InstanceFieldInitializationInfo initializationInfo = InstanceInitializerAnalysis.getInitializationInfo(appView, argument);
                            if (initializationInfo == null) {
                                return InstanceInitializerAnalysis.invalid();
                            }
                            arguments.add(initializationInfo);
                        }
                        if (builder.addInvokeConstructor(invokedMethod, arguments)) continue block7;
                        return InstanceInitializerAnalysis.invalid();
                    }
                    default: {
                        return InstanceInitializerAnalysis.invalid();
                    }
                }
            }
        }
        return builder.isValid() ? builder.build() : null;
    }

    private static InstanceFieldInitializationInfo getInitializationInfo(AppView<? extends AppInfoWithClassHierarchy> appView, Value value) {
        Value root = value.getAliasedValue();
        if (root.isPhi()) {
            return null;
        }
        Instruction definition = root.getDefinition();
        if (definition.isArgument()) {
            return appView.instanceFieldInitializationInfoFactory().createArgumentInitializationInfo(root.getDefinition().asArgument().getIndex());
        }
        if (definition.isConstNumber()) {
            return appView.abstractValueFactory().createSingleNumberValue(definition.asConstNumber().getRawValue());
        }
        if (definition.isConstString()) {
            return appView.abstractValueFactory().createSingleStringValue(definition.asConstString().getValue());
        }
        return null;
    }

    private static InstanceInitializerDescription invalid() {
        return null;
    }
}

