/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.horizontalclassmerging.IncompleteMergedInstanceInitializerCode;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InstanceInitializerDescription {
    private final Map<DexField, InstanceFieldInitializationInfo> instanceFieldAssignmentsPre;
    private final Map<DexField, InstanceFieldInitializationInfo> instanceFieldAssignmentsPost;
    private final DexMethod parentConstructor;
    private final List<InstanceFieldInitializationInfo> parentConstructorArguments;
    private final DexTypeList relaxedParameters;

    InstanceInitializerDescription(Map<DexField, InstanceFieldInitializationInfo> instanceFieldAssignmentsPre, Map<DexField, InstanceFieldInitializationInfo> instanceFieldAssignmentsPost, DexMethod parentConstructor, List<InstanceFieldInitializationInfo> parentConstructorArguments, DexTypeList relaxedParameters) {
        this.instanceFieldAssignmentsPre = instanceFieldAssignmentsPre;
        this.instanceFieldAssignmentsPost = instanceFieldAssignmentsPost;
        this.parentConstructor = parentConstructor;
        this.parentConstructorArguments = parentConstructorArguments;
        this.relaxedParameters = relaxedParameters;
    }

    public static Builder builder(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod instanceInitializer) {
        return new Builder(appView.dexItemFactory(), instanceInitializer);
    }

    public IncompleteMergedInstanceInitializerCode createCfCode(DexMethod originalMethodReference, DexMethod syntheticMethodReference, MergeGroup group, boolean hasClassId, int extraNulls) {
        return new IncompleteMergedInstanceInitializerCode(hasClassId ? group.getClassIdField() : null, extraNulls, originalMethodReference, syntheticMethodReference, this.instanceFieldAssignmentsPre, this.instanceFieldAssignmentsPost, this.parentConstructor, this.parentConstructorArguments);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceInitializerDescription description = (InstanceInitializerDescription)obj;
        return this.instanceFieldAssignmentsPre.equals(description.instanceFieldAssignmentsPre) && this.instanceFieldAssignmentsPost.equals(description.instanceFieldAssignmentsPost) && this.parentConstructor == description.parentConstructor && this.parentConstructorArguments.equals(description.parentConstructorArguments);
    }

    public int hashCode() {
        return Objects.hash(this.instanceFieldAssignmentsPre, this.instanceFieldAssignmentsPost, this.parentConstructor, this.parentConstructorArguments, this.relaxedParameters);
    }

    public static class Builder {
        private final DexItemFactory dexItemFactory;
        private final DexTypeList relaxedParameters;
        private Map<DexField, InstanceFieldInitializationInfo> instanceFieldAssignmentsPre = new LinkedHashMap<DexField, InstanceFieldInitializationInfo>();
        private Map<DexField, InstanceFieldInitializationInfo> instanceFieldAssignmentsPost = new LinkedHashMap<DexField, InstanceFieldInitializationInfo>();
        private DexMethod parentConstructor;
        private List<InstanceFieldInitializationInfo> parentConstructorArguments;

        Builder(DexItemFactory dexItemFactory, ProgramMethod method) {
            this.dexItemFactory = dexItemFactory;
            this.relaxedParameters = method.getParameters().map(parameter -> parameter.isPrimitiveType() ? parameter : dexItemFactory.objectType);
        }

        public void addInstancePut(DexField field, InstanceFieldInitializationInfo value) {
            if (this.parentConstructor == null) {
                this.instanceFieldAssignmentsPre.put(field, value);
                return;
            }
            if (!(this.parentConstructor != this.dexItemFactory.objectMembers.constructor || value.isArgumentInitializationInfo() && value.asArgumentInitializationInfo().getArgumentIndex() == 0)) {
                this.instanceFieldAssignmentsPre.put(field, value);
                return;
            }
            this.instanceFieldAssignmentsPost.put(field, value);
        }

        public boolean addInvokeConstructor(DexMethod method, List<InstanceFieldInitializationInfo> arguments) {
            if (this.parentConstructor == null) {
                this.parentConstructor = method;
                this.parentConstructorArguments = arguments;
                return true;
            }
            return false;
        }

        public InstanceInitializerDescription build() {
            assert (this.isValid());
            return new InstanceInitializerDescription(this.instanceFieldAssignmentsPre, this.instanceFieldAssignmentsPost, this.parentConstructor, this.parentConstructorArguments, this.relaxedParameters);
        }

        public boolean isValid() {
            return this.parentConstructor != null;
        }
    }
}

