/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeUtils;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.horizontalclassmerging.ClassMethodsBuilder;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMergerGraphLens;
import com.android.tools.r8.horizontalclassmerging.InstanceInitializerDescription;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.SyntheticArgumentClass;
import com.android.tools.r8.horizontalclassmerging.code.ConstructorEntryPointSynthesizedCode;
import com.android.tools.r8.horizontalclassmerging.code.SyntheticInitializerConverter;
import com.android.tools.r8.ir.conversion.ExtraConstantIntParameter;
import com.android.tools.r8.ir.conversion.ExtraParameter;
import com.android.tools.r8.ir.conversion.ExtraUnusedNullParameter;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.structural.Ordered;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class InstanceInitializerMerger {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final Reference2IntMap<DexType> classIdentifiers;
    private final DexItemFactory dexItemFactory;
    private final MergeGroup group;
    private final List<ProgramMethod> instanceInitializers;
    private final InstanceInitializerDescription instanceInitializerDescription;
    private final HorizontalClassMergerGraphLens.Builder lensBuilder;
    private final HorizontalClassMerger.Mode mode;

    InstanceInitializerMerger(AppView<? extends AppInfoWithClassHierarchy> appView, Reference2IntMap<DexType> classIdentifiers, MergeGroup group, List<ProgramMethod> instanceInitializers, HorizontalClassMergerGraphLens.Builder lensBuilder, HorizontalClassMerger.Mode mode) {
        this(appView, classIdentifiers, group, instanceInitializers, lensBuilder, mode, null);
    }

    InstanceInitializerMerger(AppView<? extends AppInfoWithClassHierarchy> appView, Reference2IntMap<DexType> classIdentifiers, MergeGroup group, List<ProgramMethod> instanceInitializers, HorizontalClassMergerGraphLens.Builder lensBuilder, HorizontalClassMerger.Mode mode, InstanceInitializerDescription instanceInitializerDescription) {
        this.appView = appView;
        this.classIdentifiers = classIdentifiers;
        this.dexItemFactory = appView.dexItemFactory();
        this.group = group;
        this.instanceInitializers = instanceInitializers;
        this.instanceInitializerDescription = instanceInitializerDescription;
        this.lensBuilder = lensBuilder;
        this.mode = mode;
        assert (!instanceInitializers.isEmpty());
        assert (instanceInitializers.stream().map(DexClassAndMethod::getProto).distinct().count() == 1L || instanceInitializerDescription != null);
    }

    private CfVersion getNewClassFileVersion() {
        CfVersion classFileVersion = null;
        for (ProgramMethod instanceInitializer : this.instanceInitializers) {
            if (!((DexEncodedMethod)instanceInitializer.getDefinition()).hasClassFileVersion()) continue;
            classFileVersion = Ordered.maxIgnoreNull(classFileVersion, ((DexEncodedMethod)instanceInitializer.getDefinition()).getClassFileVersion());
        }
        return classFileVersion;
    }

    private DexMethod getNewMethodReference(ProgramMethod representative, boolean needsClassId) {
        DexType[] oldParameters = representative.getParameters().values;
        DexType[] newParameters = new DexType[representative.getParameters().size() + BooleanUtils.intValue(needsClassId)];
        System.arraycopy(oldParameters, 0, newParameters, 0, oldParameters.length);
        for (int i = 0; i < oldParameters.length; ++i) {
            int parameterIndex = i;
            Set<DexType> parameterTypes = SetUtils.newIdentityHashSet(builder -> this.instanceInitializers.forEach(instanceInitializer -> builder.accept(instanceInitializer.getParameter(parameterIndex))));
            if (parameterTypes.size() <= 1) continue;
            newParameters[i] = DexTypeUtils.computeLeastUpperBound(this.appView, parameterTypes);
        }
        if (needsClassId) {
            assert (ArrayUtils.last(newParameters) == null);
            newParameters[newParameters.length - 1] = this.dexItemFactory.intType;
        }
        return this.dexItemFactory.createInstanceInitializer(this.group.getTarget().getType(), newParameters);
    }

    private DexMethod getOriginalMethodReference() {
        return this.appView.graphLens().getOriginalMethodSignature((DexMethod)this.getRepresentative().getReference());
    }

    private ProgramMethod getRepresentative() {
        return ListUtils.first(this.instanceInitializers);
    }

    private DexMethod getSyntheticMethodReference(ClassMethodsBuilder classMethodsBuilder, DexMethod newMethodReference) {
        return this.dexItemFactory.createFreshMethodNameWithoutHolder("$r8$init$synthetic", newMethodReference.getProto(), newMethodReference.getHolderType(), classMethodsBuilder::isFresh);
    }

    private Int2ReferenceSortedMap<DexMethod> createClassIdToInstanceInitializerMap() {
        assert (!this.hasInstanceInitializerDescription());
        Int2ReferenceAVLTreeMap<DexMethod> typeConstructorClassMap = new Int2ReferenceAVLTreeMap<DexMethod>();
        for (ProgramMethod instanceInitializer : this.instanceInitializers) {
            typeConstructorClassMap.put(this.classIdentifiers.getInt(instanceInitializer.getHolderType()), this.lensBuilder.getRenamedMethodSignature((DexMethod)instanceInitializer.getReference()));
        }
        return typeConstructorClassMap;
    }

    private boolean hasInstanceInitializerDescription() {
        return this.instanceInitializerDescription != null;
    }

    private DexMethod moveInstanceInitializer(ClassMethodsBuilder classMethodsBuilder, ProgramMethod instanceInitializer) {
        DexMethod method = this.dexItemFactory.createFreshMethodNameWithHolder("$r8$constructor", instanceInitializer.getHolderType(), instanceInitializer.getProto(), this.group.getTarget().getType(), classMethodsBuilder::isFresh);
        DexEncodedMethod encodedMethod = ((DexEncodedMethod)instanceInitializer.getDefinition()).toTypeSubstitutedMethod(method);
        encodedMethod.getMutableOptimizationInfo().markForceInline();
        encodedMethod.getAccessFlags().unsetConstructor();
        encodedMethod.getAccessFlags().unsetPublic();
        encodedMethod.getAccessFlags().unsetProtected();
        encodedMethod.getAccessFlags().setPrivate();
        classMethodsBuilder.addDirectMethod(encodedMethod);
        return method;
    }

    private MethodAccessFlags getNewAccessFlags() {
        return MethodAccessFlags.fromSharedAccessFlags(4097, true);
    }

    private Code getNewCode(DexMethod newMethodReference, DexMethod syntheticMethodReference, boolean needsClassId, int extraNulls) {
        if (this.hasInstanceInitializerDescription()) {
            return this.instanceInitializerDescription.createCfCode(this.getOriginalMethodReference(), syntheticMethodReference, this.group, needsClassId, extraNulls);
        }
        if (this.isSingleton() && !this.group.hasClassIdField()) {
            return ((DexEncodedMethod)this.getRepresentative().getDefinition()).getCode();
        }
        return new ConstructorEntryPointSynthesizedCode(this.createClassIdToInstanceInitializerMap(), newMethodReference, this.group.hasClassIdField() ? this.group.getClassIdField() : null, syntheticMethodReference);
    }

    private boolean isSingleton() {
        return this.instanceInitializers.size() == 1;
    }

    public int getArity() {
        return ((DexMethod)this.instanceInitializers.iterator().next().getReference()).getArity();
    }

    public List<ProgramMethod> getInstanceInitializers() {
        return this.instanceInitializers;
    }

    public int size() {
        return this.instanceInitializers.size();
    }

    void merge(ClassMethodsBuilder classMethodsBuilder, SyntheticArgumentClass syntheticArgumentClass, SyntheticInitializerConverter.Builder syntheticInitializerConverterBuilder) {
        boolean needsClassId;
        ProgramMethod representative = ListUtils.first(this.instanceInitializers);
        boolean bl = needsClassId = this.instanceInitializers.size() > 1 && (!this.hasInstanceInitializerDescription() || this.group.hasClassIdField());
        assert (this.mode.isInitial() || !needsClassId);
        DexMethod newMethodReferenceTemplate = this.getNewMethodReference(representative, needsClassId);
        assert (this.mode.isInitial() || classMethodsBuilder.isFresh(newMethodReferenceTemplate));
        DexMethod newMethodReference = this.dexItemFactory.createInstanceInitializerWithFreshProto(newMethodReferenceTemplate, this.mode.isInitial() ? syntheticArgumentClass.getArgumentClasses() : ImmutableList.of(), classMethodsBuilder::isFresh);
        List<ExtraUnusedNullParameter> extraUnusedNullParameters = ExtraUnusedNullParameter.computeExtraUnusedNullParameters(newMethodReferenceTemplate, newMethodReference);
        assert (this.mode.isInitial() || newMethodReference == newMethodReferenceTemplate);
        if (this.hasInstanceInitializerDescription()) {
            this.lensBuilder.moveMethods(this.instanceInitializers, newMethodReference);
        } else if (this.isSingleton() && !this.group.hasClassIdField()) {
            this.lensBuilder.moveMethod((DexMethod)representative.getReference(), newMethodReference, true);
        } else {
            for (ProgramMethod programMethod : this.instanceInitializers) {
                DexMethod movedInstanceInitializer = this.moveInstanceInitializer(classMethodsBuilder, programMethod);
                this.lensBuilder.mapMethod(movedInstanceInitializer, movedInstanceInitializer);
                this.lensBuilder.recordNewMethodSignature((DexMethod)programMethod.getReference(), movedInstanceInitializer);
            }
        }
        DexMethod syntheticMethodReference = this.getSyntheticMethodReference(classMethodsBuilder, newMethodReference);
        if (!this.isSingleton() || this.group.hasClassIdField()) {
            this.lensBuilder.recordNewMethodSignature(syntheticMethodReference, newMethodReference, true);
        }
        for (ProgramMethod instanceInitializer : this.instanceInitializers) {
            ArrayList<ExtraParameter> extraParameters = new ArrayList<ExtraParameter>();
            if (needsClassId) {
                int classIdentifier = this.classIdentifiers.getInt(instanceInitializer.getHolderType());
                extraParameters.add(new ExtraConstantIntParameter(classIdentifier));
            }
            extraParameters.addAll(extraUnusedNullParameters);
            this.lensBuilder.mapMergedConstructor((DexMethod)instanceInitializer.getReference(), newMethodReference, extraParameters);
        }
        DexEncodedMethod dexEncodedMethod = (DexEncodedMethod)representative.getDefinition();
        DexEncodedMethod newInstanceInitializer = DexEncodedMethod.syntheticBuilder().setMethod(newMethodReference).setAccessFlags(this.getNewAccessFlags()).setCode(this.getNewCode(newMethodReference, syntheticMethodReference, needsClassId, extraUnusedNullParameters.size())).setClassFileVersion(this.getNewClassFileVersion()).setApiLevelForDefinition(dexEncodedMethod.getApiLevelForDefinition()).setApiLevelForCode(dexEncodedMethod.getApiLevelForCode()).build();
        classMethodsBuilder.addDirectMethod(newInstanceInitializer);
        if (this.mode.isFinal()) {
            if (this.appView.options().isGeneratingDex() && !newInstanceInitializer.getCode().isDexCode()) {
                syntheticInitializerConverterBuilder.addInstanceInitializer(new ProgramMethod(this.group.getTarget(), newInstanceInitializer));
            } else assert (this.appView.options().isGeneratingDex() || newInstanceInitializer.getCode().isCfWritableCode() || newInstanceInitializer.getCode().isIncompleteHorizontalClassMergerCode());
        }
    }

    public static class Builder {
        private final AppView<? extends AppInfoWithClassHierarchy> appView;
        private final Reference2IntMap<DexType> classIdentifiers;
        private int estimatedDexCodeSize;
        private final List<List<ProgramMethod>> instanceInitializerGroups = new ArrayList<List<ProgramMethod>>();
        private final HorizontalClassMergerGraphLens.Builder lensBuilder;
        private final HorizontalClassMerger.Mode mode;

        public Builder(AppView<? extends AppInfoWithClassHierarchy> appView, Reference2IntMap<DexType> classIdentifiers, HorizontalClassMergerGraphLens.Builder lensBuilder, HorizontalClassMerger.Mode mode) {
            this.appView = appView;
            this.classIdentifiers = classIdentifiers;
            this.lensBuilder = lensBuilder;
            this.mode = mode;
            this.createNewGroup();
        }

        private void createNewGroup() {
            this.estimatedDexCodeSize = 0;
            this.instanceInitializerGroups.add(new ArrayList());
        }

        public Builder add(ProgramMethod instanceInitializer) {
            int estimatedMaxSizeInBytes = ((DexEncodedMethod)instanceInitializer.getDefinition()).getCode().estimatedDexCodeSizeUpperBoundInBytes();
            if (this.estimatedDexCodeSize + estimatedMaxSizeInBytes > this.appView.options().minimumVerificationSizeLimitInBytes() / 2 && this.estimatedDexCodeSize > 0) {
                this.createNewGroup();
            }
            ListUtils.last(this.instanceInitializerGroups).add(instanceInitializer);
            this.estimatedDexCodeSize += estimatedMaxSizeInBytes;
            return this;
        }

        public Builder addEquivalent(ProgramMethod instanceInitializer) {
            ListUtils.last(this.instanceInitializerGroups).add(instanceInitializer);
            return this;
        }

        public List<InstanceInitializerMerger> build(MergeGroup group) {
            assert (this.instanceInitializerGroups.stream().noneMatch(List::isEmpty));
            return ListUtils.map(this.instanceInitializerGroups, instanceInitializers -> new InstanceInitializerMerger(this.appView, this.classIdentifiers, group, (List<ProgramMethod>)instanceInitializers, this.lensBuilder, this.mode));
        }

        public InstanceInitializerMerger buildSingle(MergeGroup group, InstanceInitializerDescription instanceInitializerDescription) {
            assert (this.instanceInitializerGroups.stream().noneMatch(List::isEmpty));
            assert (this.instanceInitializerGroups.size() == 1);
            List<ProgramMethod> instanceInitializers = ListUtils.first(this.instanceInitializerGroups);
            return new InstanceInitializerMerger(this.appView, this.classIdentifiers, group, instanceInitializers, this.lensBuilder, this.mode, instanceInitializerDescription);
        }
    }
}

