/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicyWithPreprocessing;
import com.android.tools.r8.horizontalclassmerging.SingleClassPolicy;
import java.util.ArrayList;
import java.util.Collection;

public abstract class Policy {
    public int numberOfRemovedClasses;
    public int numberOfRemovedInterfaces;

    public void clear() {
    }

    public abstract String getName();

    public boolean isIdentityForInterfaceGroups() {
        return false;
    }

    public boolean isSingleClassPolicy() {
        return false;
    }

    public SingleClassPolicy asSingleClassPolicy() {
        return null;
    }

    public boolean isMultiClassPolicy() {
        return false;
    }

    public MultiClassPolicy asMultiClassPolicy() {
        return null;
    }

    public boolean isMultiClassPolicyWithPreprocessing() {
        return false;
    }

    public MultiClassPolicyWithPreprocessing<?> asMultiClassPolicyWithPreprocessing() {
        return null;
    }

    public boolean shouldSkipPolicy() {
        return false;
    }

    protected Collection<MergeGroup> removeTrivialGroups(Collection<MergeGroup> groups2) {
        assert (!(groups2 instanceof ArrayList));
        groups2.removeIf(MergeGroup::isTrivial);
        return groups2;
    }

    boolean recordRemovedClassesForDebugging(boolean isInterfaceGroup, int previousGroupSize, Collection<MergeGroup> newGroups) {
        assert (previousGroupSize >= 2);
        int previousNumberOfRemovedClasses = previousGroupSize - 1;
        int newNumberOfRemovedClasses = 0;
        for (MergeGroup newGroup : newGroups) {
            if (!newGroup.isNonTrivial()) continue;
            newNumberOfRemovedClasses += newGroup.size() - 1;
        }
        assert (previousNumberOfRemovedClasses >= newNumberOfRemovedClasses);
        int change = previousNumberOfRemovedClasses - newNumberOfRemovedClasses;
        if (isInterfaceGroup) {
            this.numberOfRemovedInterfaces += change;
        } else {
            this.numberOfRemovedClasses += change;
        }
        return true;
    }
}

