/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ImmediateProgramSubtypingInfo;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.IRCodeProvider;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import com.android.tools.r8.horizontalclassmerging.Policy;
import com.android.tools.r8.horizontalclassmerging.SingleClassPolicy;
import com.android.tools.r8.horizontalclassmerging.policies.AllInstantiatedOrUninstantiated;
import com.android.tools.r8.horizontalclassmerging.policies.CheckAbstractClasses;
import com.android.tools.r8.horizontalclassmerging.policies.CheckSyntheticClasses;
import com.android.tools.r8.horizontalclassmerging.policies.FinalizeMergeGroup;
import com.android.tools.r8.horizontalclassmerging.policies.LimitClassGroups;
import com.android.tools.r8.horizontalclassmerging.policies.LimitInterfaceGroups;
import com.android.tools.r8.horizontalclassmerging.policies.MinimizeInstanceFieldCasts;
import com.android.tools.r8.horizontalclassmerging.policies.NoAnnotationClasses;
import com.android.tools.r8.horizontalclassmerging.policies.NoCheckDiscard;
import com.android.tools.r8.horizontalclassmerging.policies.NoClassAnnotationCollisions;
import com.android.tools.r8.horizontalclassmerging.policies.NoClassInitializerCycles;
import com.android.tools.r8.horizontalclassmerging.policies.NoClassInitializerWithObservableSideEffects;
import com.android.tools.r8.horizontalclassmerging.policies.NoConstructorCollisions;
import com.android.tools.r8.horizontalclassmerging.policies.NoDeadEnumLiteMaps;
import com.android.tools.r8.horizontalclassmerging.policies.NoDeadLocks;
import com.android.tools.r8.horizontalclassmerging.policies.NoDefaultInterfaceMethodCollisions;
import com.android.tools.r8.horizontalclassmerging.policies.NoDefaultInterfaceMethodMerging;
import com.android.tools.r8.horizontalclassmerging.policies.NoDifferentApiReferenceLevel;
import com.android.tools.r8.horizontalclassmerging.policies.NoDirectRuntimeTypeChecks;
import com.android.tools.r8.horizontalclassmerging.policies.NoEnums;
import com.android.tools.r8.horizontalclassmerging.policies.NoFailedResolutionTargets;
import com.android.tools.r8.horizontalclassmerging.policies.NoIllegalInlining;
import com.android.tools.r8.horizontalclassmerging.policies.NoIndirectRuntimeTypeChecks;
import com.android.tools.r8.horizontalclassmerging.policies.NoInnerClasses;
import com.android.tools.r8.horizontalclassmerging.policies.NoInstanceFieldAnnotations;
import com.android.tools.r8.horizontalclassmerging.policies.NoInstanceInitializerMerging;
import com.android.tools.r8.horizontalclassmerging.policies.NoInterfaces;
import com.android.tools.r8.horizontalclassmerging.policies.NoKeepRules;
import com.android.tools.r8.horizontalclassmerging.policies.NoKotlinMetadata;
import com.android.tools.r8.horizontalclassmerging.policies.NoNativeMethods;
import com.android.tools.r8.horizontalclassmerging.policies.NoServiceLoaders;
import com.android.tools.r8.horizontalclassmerging.policies.NoVerticallyMergedClasses;
import com.android.tools.r8.horizontalclassmerging.policies.NoVirtualMethodMerging;
import com.android.tools.r8.horizontalclassmerging.policies.NoWeakerAccessPrivileges;
import com.android.tools.r8.horizontalclassmerging.policies.NotMatchedByNoHorizontalClassMerging;
import com.android.tools.r8.horizontalclassmerging.policies.OnlyClassesWithStaticDefinitions;
import com.android.tools.r8.horizontalclassmerging.policies.OnlyDirectlyConnectedOrUnrelatedInterfaces;
import com.android.tools.r8.horizontalclassmerging.policies.PreserveMethodCharacteristics;
import com.android.tools.r8.horizontalclassmerging.policies.PreventClassMethodAndDefaultMethodCollisions;
import com.android.tools.r8.horizontalclassmerging.policies.RespectPackageBoundaries;
import com.android.tools.r8.horizontalclassmerging.policies.SameFeatureSplit;
import com.android.tools.r8.horizontalclassmerging.policies.SameInstanceFields;
import com.android.tools.r8.horizontalclassmerging.policies.SameMainDexGroup;
import com.android.tools.r8.horizontalclassmerging.policies.SameNestHost;
import com.android.tools.r8.horizontalclassmerging.policies.SameParentClass;
import com.android.tools.r8.horizontalclassmerging.policies.SyntheticItemsPolicy;
import com.android.tools.r8.horizontalclassmerging.policies.VerifyMultiClassPolicyAlwaysSatisfied;
import com.android.tools.r8.horizontalclassmerging.policies.VerifySingleClassPolicyAlwaysSatisfied;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.RuntimeTypeCheckInfo;
import com.android.tools.r8.utils.ListUtils;
import java.util.Collection;
import java.util.List;

public class PolicyScheduler {
    public static List<Policy> getPolicies(AppView<?> appView, IRCodeProvider codeProvider, HorizontalClassMerger.Mode mode, RuntimeTypeCheckInfo runtimeTypeCheckInfo) {
        if (appView.hasClassHierarchy()) {
            return PolicyScheduler.getPoliciesForR8(appView.withClassHierarchy(), codeProvider, mode, runtimeTypeCheckInfo);
        }
        return PolicyScheduler.getPoliciesForD8(appView.withoutClassHierarchy(), mode);
    }

    private static List<Policy> getPoliciesForD8(AppView<AppInfo> appView, HorizontalClassMerger.Mode mode) {
        assert (mode.isFinal());
        Collection<Object> policies = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(PolicyScheduler.getSingleClassPoliciesForD8(appView, mode))).addAll(PolicyScheduler.getMultiClassPoliciesForD8(appView, mode))).build();
        policies = appView.options().testing.horizontalClassMergingPolicyRewriter.apply((List<Policy>)policies);
        assert (PolicyScheduler.verifyPolicyOrderingConstraints((List<Policy>)policies));
        return policies;
    }

    private static List<Policy> getPoliciesForR8(AppView<? extends AppInfoWithClassHierarchy> appView, IRCodeProvider codeProvider, HorizontalClassMerger.Mode mode, RuntimeTypeCheckInfo runtimeTypeCheckInfo) {
        Collection<Object> policies = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(PolicyScheduler.getSingleClassPolicies(appView, mode, runtimeTypeCheckInfo))).addAll(PolicyScheduler.getMultiClassPolicies(appView, codeProvider, mode, runtimeTypeCheckInfo))).build();
        policies = appView.options().testing.horizontalClassMergingPolicyRewriter.apply((List<Policy>)policies);
        assert (PolicyScheduler.verifyPolicyOrderingConstraints((List<Policy>)policies));
        return policies;
    }

    private static List<SingleClassPolicy> getSingleClassPolicies(AppView<? extends AppInfoWithClassHierarchy> appView, HorizontalClassMerger.Mode mode, RuntimeTypeCheckInfo runtimeTypeCheckInfo) {
        AppView<AppInfoWithLiveness> appViewWithLiveness;
        ImmutableList.Builder<SingleClassPolicy> builder = ImmutableList.builder();
        PolicyScheduler.addRequiredSingleClassPolicies(appView, builder);
        if (mode.isInitial()) {
            appViewWithLiveness = appView.withLiveness();
            builder.add(new SingleClassPolicy[]{new NoDeadEnumLiteMaps(appViewWithLiveness, mode), new NoIllegalInlining(appViewWithLiveness, mode), new NoVerticallyMergedClasses(appViewWithLiveness, mode)});
        }
        if (appView.options().horizontalClassMergerOptions().isRestrictedToSynthetics()) {
            assert (PolicyScheduler.verifySingleClassPoliciesIrrelevantForMergingSynthetics(appView, mode, builder));
        } else {
            appViewWithLiveness = appView.withLiveness();
            PolicyScheduler.addSingleClassPoliciesForMergingNonSyntheticClasses(appViewWithLiveness, mode, runtimeTypeCheckInfo, builder);
        }
        return builder.build();
    }

    private static List<SingleClassPolicy> getSingleClassPoliciesForD8(AppView<AppInfo> appView, HorizontalClassMerger.Mode mode) {
        ImmutableCollection.Builder builder = ((ImmutableList.Builder)ImmutableList.builder().add(new CheckSyntheticClasses(appView))).add(new OnlyClassesWithStaticDefinitions());
        assert (PolicyScheduler.verifySingleClassPoliciesIrrelevantForMergingSyntheticsInD8(appView, mode, (ImmutableList.Builder<SingleClassPolicy>)builder));
        return ((ImmutableList.Builder)builder).build();
    }

    private static void addRequiredSingleClassPolicies(AppView<? extends AppInfoWithClassHierarchy> appView, ImmutableList.Builder<SingleClassPolicy> builder) {
        builder.add(new SingleClassPolicy[]{new CheckSyntheticClasses(appView), new NoCheckDiscard(appView), new NoKeepRules(appView), new NoClassInitializerWithObservableSideEffects()});
    }

    private static void addSingleClassPoliciesForMergingNonSyntheticClasses(AppView<AppInfoWithLiveness> appView, HorizontalClassMerger.Mode mode, RuntimeTypeCheckInfo runtimeTypeCheckInfo, ImmutableList.Builder<SingleClassPolicy> builder) {
        builder.add(new SingleClassPolicy[]{new NotMatchedByNoHorizontalClassMerging(appView), new NoAnnotationClasses(), new NoDirectRuntimeTypeChecks(appView, mode, runtimeTypeCheckInfo), new NoEnums(appView), new NoFailedResolutionTargets(appView), new NoInterfaces(appView, mode), new NoInnerClasses(), new NoInstanceFieldAnnotations(), new NoKotlinMetadata(), new NoNativeMethods(), new NoServiceLoaders(appView)});
    }

    private static boolean verifySingleClassPoliciesIrrelevantForMergingSynthetics(AppView<? extends AppInfoWithClassHierarchy> appView, HorizontalClassMerger.Mode mode, ImmutableList.Builder<SingleClassPolicy> builder) {
        ImmutableList<NoServiceLoaders> policies = ImmutableList.of(new NoAnnotationClasses(), new NoDirectRuntimeTypeChecks(appView, mode), new NoEnums(appView), new NoInterfaces(appView, mode), new NoInnerClasses(), new NoInstanceFieldAnnotations(), new NoKotlinMetadata(), new NoNativeMethods(), new NoServiceLoaders(appView));
        policies.stream().map(VerifySingleClassPolicyAlwaysSatisfied::new).forEach(builder::add);
        return true;
    }

    private static boolean verifySingleClassPoliciesIrrelevantForMergingSyntheticsInD8(AppView<AppInfo> appView, HorizontalClassMerger.Mode mode, ImmutableList.Builder<SingleClassPolicy> builder) {
        ImmutableList<NoNativeMethods> policies = ImmutableList.of(new NoAnnotationClasses(), new NoDirectRuntimeTypeChecks(appView, mode), new NoInterfaces(appView, mode), new NoInnerClasses(), new NoInstanceFieldAnnotations(), new NoKotlinMetadata(), new NoNativeMethods());
        policies.stream().map(VerifySingleClassPolicyAlwaysSatisfied::new).forEach(builder::add);
        return true;
    }

    private static List<Policy> getMultiClassPolicies(AppView<? extends AppInfoWithClassHierarchy> appView, IRCodeProvider codeProvider, HorizontalClassMerger.Mode mode, RuntimeTypeCheckInfo runtimeTypeCheckInfo) {
        AppView<AppInfoWithLiveness> appViewWithLiveness;
        ImmutableList.Builder<Policy> builder = ImmutableList.builder();
        PolicyScheduler.addRequiredMultiClassPolicies(appView, mode, runtimeTypeCheckInfo, builder);
        if (!appView.options().horizontalClassMergerOptions().isRestrictedToSynthetics()) {
            appViewWithLiveness = appView.withLiveness();
            PolicyScheduler.addMultiClassPoliciesForMergingNonSyntheticClasses(appViewWithLiveness, builder);
        }
        if (mode.isInitial()) {
            appViewWithLiveness = appView.withLiveness();
            builder.add(new Policy[]{new AllInstantiatedOrUninstantiated(appViewWithLiveness, mode), new PreserveMethodCharacteristics(appViewWithLiveness, mode), new MinimizeInstanceFieldCasts()});
        } else {
            assert (mode.isFinal());
            builder.add(new Policy[]{new NoVirtualMethodMerging(appView, mode), new NoConstructorCollisions(appView, mode)});
        }
        PolicyScheduler.addMultiClassPoliciesForInterfaceMerging(appView, mode, builder);
        builder.add((Object)new LimitClassGroups(appView));
        if (mode.isFinal()) {
            builder.add((Object)new NoInstanceInitializerMerging(appView, codeProvider, mode));
        }
        return ((ImmutableList.Builder)builder.add((Object)new FinalizeMergeGroup(appView, mode))).build();
    }

    private static List<? extends Policy> getMultiClassPoliciesForD8(AppView<AppInfo> appView, HorizontalClassMerger.Mode mode) {
        ImmutableList.Builder<MultiClassPolicy> builder = ImmutableList.builder();
        builder.add(new MultiClassPolicy[]{new CheckAbstractClasses(appView), new SameMainDexGroup(appView), new SameNestHost(appView), new SameParentClass(), new SyntheticItemsPolicy(appView, mode), new NoDifferentApiReferenceLevel(appView), new LimitClassGroups(appView)});
        assert (PolicyScheduler.verifyMultiClassPoliciesIrrelevantForMergingSyntheticsInD8(appView, mode, builder));
        builder.add((Object)new FinalizeMergeGroup(appView, mode));
        return builder.build();
    }

    private static void addRequiredMultiClassPolicies(AppView<? extends AppInfoWithClassHierarchy> appView, HorizontalClassMerger.Mode mode, RuntimeTypeCheckInfo runtimeTypeCheckInfo, ImmutableList.Builder<Policy> builder) {
        ImmediateProgramSubtypingInfo immediateSubtypingInfo = ImmediateProgramSubtypingInfo.create(appView);
        builder.add(new Policy[]{new CheckAbstractClasses(appView), new NoClassAnnotationCollisions(), new SameFeatureSplit(appView), new SameInstanceFields(appView, mode), new SameMainDexGroup(appView), new SameNestHost(appView), new SameParentClass(), new SyntheticItemsPolicy(appView, mode), new RespectPackageBoundaries(appView), new NoDifferentApiReferenceLevel(appView), new NoIndirectRuntimeTypeChecks(appView, runtimeTypeCheckInfo), new NoWeakerAccessPrivileges(appView, immediateSubtypingInfo), new PreventClassMethodAndDefaultMethodCollisions(appView, immediateSubtypingInfo)});
    }

    private static void addMultiClassPoliciesForMergingNonSyntheticClasses(AppView<AppInfoWithLiveness> appView, ImmutableList.Builder<Policy> builder) {
        builder.add(new Policy[]{new NoClassInitializerCycles(appView), new NoDeadLocks(appView)});
    }

    private static void addMultiClassPoliciesForInterfaceMerging(AppView<? extends AppInfoWithClassHierarchy> appView, HorizontalClassMerger.Mode mode, ImmutableList.Builder<Policy> builder) {
        builder.add(new Policy[]{new NoDefaultInterfaceMethodMerging(appView, mode), new NoDefaultInterfaceMethodCollisions(appView, mode), new LimitInterfaceGroups(appView), new OnlyDirectlyConnectedOrUnrelatedInterfaces(appView, mode)});
    }

    private static boolean verifyMultiClassPoliciesIrrelevantForMergingSyntheticsInD8(AppView<AppInfo> appView, HorizontalClassMerger.Mode mode, ImmutableList.Builder<MultiClassPolicy> builder) {
        ImmutableList<SameParentClass> policies = ImmutableList.of(new SyntheticItemsPolicy(appView, mode), new SameParentClass());
        policies.stream().map(VerifyMultiClassPolicyAlwaysSatisfied::new).forEach(builder::add);
        return true;
    }

    private static boolean verifyPolicyOrderingConstraints(List<Policy> policies) {
        int onlyDirectlyConnectedOrUnrelatedInterfacesIndex = ListUtils.lastIndexMatching(policies, policy -> policy instanceof OnlyDirectlyConnectedOrUnrelatedInterfaces);
        if (onlyDirectlyConnectedOrUnrelatedInterfacesIndex >= 0) {
            for (Policy successorPolicy : policies.subList(onlyDirectlyConnectedOrUnrelatedInterfacesIndex + 1, policies.size())) {
                assert (successorPolicy.isIdentityForInterfaceGroups());
            }
        }
        return true;
    }
}

