/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMember;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.horizontalclassmerging.ClassMethodsBuilder;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMergerGraphLens;
import com.android.tools.r8.horizontalclassmerging.IncompleteVirtuallyMergedMethodCode;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.VirtuallyMergedMethodsKeepInfo;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.structural.Ordered;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class VirtualMethodMerger {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final DexItemFactory dexItemFactory;
    private final MergeGroup group;
    private final List<ProgramMethod> methods;
    private final DexMethod superMethod;

    public VirtualMethodMerger(AppView<? extends AppInfoWithClassHierarchy> appView, MergeGroup group, List<ProgramMethod> methods, DexMethod superMethod) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.group = group;
        this.methods = methods;
        this.superMethod = superMethod;
    }

    private DexMethod moveMethod(ClassMethodsBuilder classMethodsBuilder, ProgramMethod oldMethod) {
        DexMethod oldMethodReference = (DexMethod)oldMethod.getReference();
        DexMethod method = this.dexItemFactory.createFreshMethodNameWithHolder(oldMethodReference.name.toSourceString(), oldMethod.getHolderType(), oldMethodReference.proto, this.group.getTarget().getType(), classMethodsBuilder::isFresh);
        DexEncodedMethod encodedMethod = ((DexEncodedMethod)oldMethod.getDefinition()).toTypeSubstitutedMethod(method);
        MethodAccessFlags flags = encodedMethod.getAccessFlags();
        flags.unsetProtected();
        flags.unsetPublic();
        flags.setPrivate();
        classMethodsBuilder.addDirectMethod(encodedMethod);
        return (DexMethod)encodedMethod.getReference();
    }

    private MethodAccessFlags getAccessFlags() {
        Iterable allFlags = Iterables.transform(this.methods, DexClassAndMethod::getAccessFlags);
        MethodAccessFlags result = ((MethodAccessFlags)allFlags.iterator().next()).copy();
        assert (Iterables.all(allFlags, flags -> !flags.isNative()));
        assert (!result.isStrict() || Iterables.all(allFlags, MethodAccessFlags::isStrict));
        assert (!result.isSynchronized() || Iterables.all(allFlags, MethodAccessFlags::isSynchronized));
        if (result.isAbstract() && Iterables.any(allFlags, flags -> !flags.isAbstract())) {
            result.unsetAbstract();
        }
        if (result.isBridge() && Iterables.any(allFlags, flags -> !flags.isBridge())) {
            result.unsetBridge();
        }
        if (result.isFinal() && (this.methods.size() < this.group.size() || Iterables.any(allFlags, flags -> !flags.isFinal()))) {
            result.unsetFinal();
        }
        if (result.isSynthetic() && Iterables.any(allFlags, flags -> !flags.isSynthetic())) {
            result.unsetSynthetic();
        }
        if (result.isVarargs() && Iterables.any(allFlags, flags -> !flags.isVarargs())) {
            result.unsetVarargs();
        }
        result.unsetDeclaredSynchronized();
        return result;
    }

    private DexMethod getNewMethodReference() {
        return ((DexMethod)ListUtils.first(this.methods).getReference()).withHolder(this.group.getTarget(), this.dexItemFactory);
    }

    private boolean isNop() {
        return this.superMethod != null && Iterables.all(this.methods, method -> ((DexEncodedMethod)method.getDefinition()).isAbstract());
    }

    private boolean isTrivial() {
        if (this.superMethod != null) {
            return false;
        }
        if (this.methods.size() == 1) {
            return true;
        }
        int numberOfNonAbstractMethods = Iterables.size(Iterables.filter(this.methods, method -> !((DexEncodedMethod)method.getDefinition()).isAbstract()));
        return numberOfNonAbstractMethods <= 1;
    }

    private void mergeTrivial(ClassMethodsBuilder classMethodsBuilder, HorizontalClassMergerGraphLens.Builder lensBuilder) {
        DexEncodedMethod newMethod;
        DexMethod newMethodReference = this.getNewMethodReference();
        ProgramMethod representative = Iterables.find(this.methods, method -> !((DexEncodedMethod)method.getDefinition()).isAbstract(), null);
        if (representative == null) {
            representative = ListUtils.first(this.methods);
        }
        if (representative.getAccessFlags().isAbstract() && this.superMethod != null) {
            this.methods.forEach(method -> lensBuilder.mapMethod((DexMethod)method.getReference(), newMethodReference));
            return;
        }
        for (ProgramMethod method2 : this.methods) {
            if (method2.getReference() == representative.getReference()) {
                lensBuilder.moveMethod((DexMethod)method2.getReference(), newMethodReference);
                continue;
            }
            lensBuilder.mapMethod((DexMethod)method2.getReference(), newMethodReference);
        }
        if (representative.getHolder() == this.group.getTarget()) {
            newMethod = (DexEncodedMethod)representative.getDefinition();
        } else {
            OptionalBool isLibraryMethodOverride = ((DexEncodedMethod)representative.getDefinition()).isLibraryMethodOverride();
            newMethod = ((DexEncodedMethod)representative.getDefinition()).toTypeSubstitutedMethod(newMethodReference, builder -> builder.setIsLibraryMethodOverrideIfKnown(isLibraryMethodOverride));
        }
        newMethod.getAccessFlags().unsetFinal();
        classMethodsBuilder.addVirtualMethod(newMethod);
    }

    public DexMethod getMethodReference() {
        return (DexMethod)this.methods.iterator().next().getReference();
    }

    public int getArity() {
        return this.getMethodReference().getArity();
    }

    boolean isNopOrTrivial() {
        return this.isNop() || this.isTrivial();
    }

    public void merge(ClassMethodsBuilder classMethodsBuilder, HorizontalClassMergerGraphLens.Builder lensBuilder, Reference2IntMap<DexType> classIdentifiers, Consumer<VirtuallyMergedMethodsKeepInfo> virtuallyMergedMethodsKeepInfoConsumer) {
        assert (!this.methods.isEmpty());
        if (this.isNopOrTrivial()) {
            this.mergeTrivial(classMethodsBuilder, lensBuilder);
            return;
        }
        Int2ReferenceAVLTreeMap<DexMethod> classIdToMethodMap = new Int2ReferenceAVLTreeMap<DexMethod>();
        CfVersion classFileVersion = null;
        DexClassAndMember representative = null;
        for (ProgramMethod method : this.methods) {
            if (((DexEncodedMethod)method.getDefinition()).isAbstract()) continue;
            if (((DexEncodedMethod)method.getDefinition()).hasClassFileVersion()) {
                CfVersion methodVersion = ((DexEncodedMethod)method.getDefinition()).getClassFileVersion();
                classFileVersion = Ordered.maxIgnoreNull(classFileVersion, methodVersion);
            }
            DexMethod newMethod = this.moveMethod(classMethodsBuilder, method);
            lensBuilder.recordNewMethodSignature((DexMethod)method.getReference(), newMethod);
            classIdToMethodMap.put(classIdentifiers.getInt(method.getHolderType()), (DexMethod)method.getReference());
            if (representative != null) continue;
            representative = method;
        }
        assert (representative != null);
        DexMethod originalMethodReference = this.appView.graphLens().getOriginalMethodSignature((DexMethod)representative.getReference());
        DexMethod bridgeMethodReference = this.dexItemFactory.createFreshMethodNameWithoutHolder(originalMethodReference.getName().toSourceString() + "$bridge", originalMethodReference.proto, originalMethodReference.getHolderType(), classMethodsBuilder::isFresh);
        DexEncodedMethod representativeMethod = (DexEncodedMethod)representative.getDefinition();
        DexMethod newMethodReference = this.getNewMethodReference();
        IncompleteVirtuallyMergedMethodCode synthesizedCode = new IncompleteVirtuallyMergedMethodCode(this.group.getClassIdField(), classIdToMethodMap, originalMethodReference, this.superMethod);
        DexEncodedMethod newMethod = DexEncodedMethod.syntheticBuilder().setMethod(newMethodReference).setAccessFlags(this.getAccessFlags()).setCode(synthesizedCode).setClassFileVersion(classFileVersion).setApiLevelForDefinition(representativeMethod.getApiLevelForDefinition()).setApiLevelForCode(representativeMethod.getApiLevelForCode()).build();
        if (!((DexEncodedMethod)representative.getDefinition()).isLibraryMethodOverride().isUnknown()) {
            newMethod.setLibraryMethodOverride(((DexEncodedMethod)representative.getDefinition()).isLibraryMethodOverride());
        }
        VirtuallyMergedMethodsKeepInfo virtuallyMergedMethodsKeepInfo = new VirtuallyMergedMethodsKeepInfo((DexMethod)representative.getReference());
        for (ProgramMethod oldMethod : this.methods) {
            lensBuilder.mapMethod((DexMethod)oldMethod.getReference(), newMethodReference);
            virtuallyMergedMethodsKeepInfo.amendKeepInfo(this.appView.getKeepInfo(oldMethod));
        }
        if (this.superMethod != null) {
            virtuallyMergedMethodsKeepInfo.getKeepInfo().disallowParameterReordering();
        }
        lensBuilder.recordNewMethodSignature(bridgeMethodReference, newMethodReference);
        classMethodsBuilder.addVirtualMethod(newMethod);
        if (!virtuallyMergedMethodsKeepInfo.getKeepInfo().isBottom()) {
            virtuallyMergedMethodsKeepInfoConsumer.accept(virtuallyMergedMethodsKeepInfo);
        }
    }

    public static class Builder {
        private final List<ProgramMethod> methods = new ArrayList<ProgramMethod>();

        private DexMethod superMethod(AppView<? extends AppInfoWithClassHierarchy> appView, MergeGroup group) {
            DexMethod template = (DexMethod)this.methods.iterator().next().getReference();
            MethodResolutionResult.SingleResolutionResult resolutionResult = appView.appInfo().resolveMethodOnClass(template, group.getSuperType()).asSingleResolution();
            if (resolutionResult == null || resolutionResult.getResolvedMethod().isAbstract()) {
                return null;
            }
            if (resolutionResult.getResolvedHolder().isInterface()) {
                return ((DexMethod)resolutionResult.getResolvedMethod().getReference()).withHolder(group.getSuperType(), appView.dexItemFactory());
            }
            return (DexMethod)resolutionResult.getResolvedMethod().getReference();
        }

        public Builder add(ProgramMethod method) {
            this.methods.add(method);
            return this;
        }

        public VirtualMethodMerger build(AppView<? extends AppInfoWithClassHierarchy> appView, MergeGroup group) {
            DexMethod superMethod = this.methods.size() < group.size() ? this.superMethod(appView, group) : null;
            return new VirtualMethodMerger(appView, group, this.methods, superMethod);
        }
    }
}

