/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.horizontalclassmerging.SingleClassPolicy;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.InternalOptions;

public class CheckSyntheticClasses
extends SingleClassPolicy {
    private final InternalOptions.HorizontalClassMergerOptions options;
    private final SyntheticItems syntheticItems;

    public CheckSyntheticClasses(AppView<?> appView) {
        this.options = appView.options().horizontalClassMergerOptions();
        this.syntheticItems = appView.getSyntheticItems();
    }

    @Override
    public boolean canMerge(DexProgramClass clazz) {
        if (!this.options.isSyntheticMergingEnabled() && this.syntheticItems.isSyntheticClass(clazz)) {
            return false;
        }
        return !this.options.isRestrictedToSynthetics() || this.syntheticItems.isSyntheticClass(clazz);
    }

    @Override
    public String getName() {
        return "CheckSyntheticClasses";
    }
}

