/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class LimitClassGroups
extends MultiClassPolicy {
    private final int maxGroupSize;

    public LimitClassGroups(AppView<?> appView) {
        int n = this.maxGroupSize = appView.enableWholeProgramOptimizations() ? appView.options().horizontalClassMergerOptions().getMaxClassGroupSizeInR8() : appView.options().horizontalClassMergerOptions().getMaxClassGroupSizeInD8();
        assert (this.maxGroupSize >= 2);
    }

    private MergeGroup createNewGroup(LinkedList<MergeGroup> newGroups) {
        MergeGroup newGroup = new MergeGroup();
        newGroups.add(newGroup);
        return newGroup;
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group) {
        if (group.size() <= this.maxGroupSize || group.isInterfaceGroup()) {
            return Collections.singletonList(group);
        }
        LinkedList<MergeGroup> newGroups = new LinkedList<MergeGroup>();
        MergeGroup newGroup = this.createNewGroup(newGroups);
        for (DexProgramClass clazz : group) {
            if (newGroup.size() == this.maxGroupSize) {
                newGroup = this.createNewGroup(newGroups);
            }
            newGroup.add(clazz);
        }
        if (newGroup.size() == 1) {
            if (this.maxGroupSize == 2) {
                MergeGroup removedGroup = newGroups.removeLast();
                assert (removedGroup == newGroup);
            } else {
                newGroup.add(newGroups.getFirst().removeLast());
            }
        }
        return newGroups;
    }

    @Override
    public String getName() {
        return "LimitGroups";
    }

    @Override
    public boolean isIdentityForInterfaceGroups() {
        return true;
    }
}

